%{
/**********************************************************************
		SCANNER PER IL LINGUAGGIO DEL PARSER
		    (C) 1998 - VIANO PIERO
 **********************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../../comuni/structs.h"
#include "parser.h"
#ifdef WIN32
#undef WIN32
#include "../../comuni/asksay.h"
#define WIN32
#else
#include "../../comuni/asksay.h"
#endif

#define SC_ERROR -1

#ifdef DEBUG_SCANNER
#define SC_SAY(A) Say(A)
#else
#define SC_SAY(A)
#endif 

extern int yyerror(char*c);
%}

%option caseless
%option yylineno

SPAZIO ([\t\r\n ])
SPAZI ({SPAZIO}*)
LETTER ([a-zA-Z])
DIGIT ([0-9])
F_DIGIT ([1-9])
DECIMALE ({DIGIT}*{F_DIGIT}|0)

HEX ((("0x")|("0X"))([a-fA-F]|{DIGIT})+)
INTERO ({F_DIGIT}{DIGIT}*)
VAR_NAME ((("_")|{LETTER})({LETTER}|{DIGIT}|("_"))*)

COST_STRINGA (\"[^\"\n]*\")

COST_INT_CORTO ({INTERO}|[0])

OP	([-+=*/%():{},<>])

VAR ({VAR_NAME})

COMMENTO (("/*"([^*]*|"*"+[^*/])"*"+\/)|("//".*))

%%
BYTE {SC_SAY("BYTE");return BYTE;}
BIT {SC_SAY("BIT");return BIT;}
BITS {SC_SAY("BIT");return BIT;}
WORD {SC_SAY("WORD");return WORD;}
DWORD {SC_SAY("DWORD");return DWORD;}
AND {SC_SAY("AND");return AND;}
"&&" {SC_SAY("AND");return AND;}
"&" {SC_SAY("AND");return AND;}
OR {SC_SAY("OR");return OR;}
"||" {SC_SAY("OR");return OR;}
"|" {SC_SAY("OR");return OR;}
NOT {SC_SAY("NOT");return NOT;}
"!" {SC_SAY("NOT");return NOT;}
"~" {SC_SAY("NOT");return NOT;}
PROTOCOL {SC_SAY("PROTOCOL");return PROTOCOL;}
VIRTUAL {SC_SAY("VIRTUAL");return VIRTUAL;}
ENDPR {SC_SAY("ENDPR");return ENDPR;}
NOT {SC_SAY("NOT");return NOT;}
SKIP {SC_SAY("SKIP");return SKIP;}
CASE {SC_SAY("CASE");return CASE;}
ELSE {SC_SAY("ELSE");return ELSE;}
"!=" {SC_SAY("NOT_EQ");return NOT_EQ;}
"<=" {SC_SAY("NOT_EQ");return MIU;}
">=" {SC_SAY("NOT_EQ");return MAU;}
"==" {SC_SAY("EQ");return '=';}
MUSTINVERT {SC_SAY("MUSTINVERT");return MUSTINVERT;}
GETVMVAR {SC_SAY("GETVMVAR");return GETVMVAR;}
{HEX} {SC_SAY("NUMERO_H");return NUMERO_H;}
{COST_INT_CORTO} {SC_SAY("NUMERO");return NUMERO;}
{COMMENTO}	{/* Scarta commenti */ }
{OP} {SC_SAY(yytext);return yytext[0];}
{VAR}	{SC_SAY("NOME");return NOME;}
{COST_STRINGA} 	{SC_SAY("STRINGA"); return COST_STRINGA; }


{SPAZIO}+ {SC_SAY("SPAZIO");/*ignora gli spazi*/}

. {char t[200];printf(t,"Scanner error at line %d\n",yylineno);return (-1);}
%%

int yywrap()
{
  return 1;
}

