#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "../../comuni/asksay.h"
#include "../../comuni/vec_cl.h"
#include "../../comuni/structs.h"
#include "../../comuni/protocolvect.h"
#include "../../comuni/protocol.h"
#include "../../comuni/case.h"

#ifdef Say
#undef Say
#define Say(A) printf("%s\n",A)
#endif

#ifndef ENGLISH
#define ERR_WRITE "Errore di scrittura del file di output"
#define ERR_NAMEEX "Nome gi definito in questa struttura"
#define ERR_DESTPR "Protocollo di destinazione non definito"
#define ERR_PRID "Ridefinizione di protocollo"
#define ERR_BITS "Nella definizione dei bits il primo numero deve essere minore o uguale al secondo"
#define ERR_BITS1 "Errore nell'assegnazione dei campi dei bits. Valori errati."
#define ERR_FIELD "Impossibile accedere ad un campo non definito"
#define ERR_UNKDIM "Errore di dimensione non nota"
#define ERR_LINE "Errore alla linea :%d\n%s\n"
#define ERR_PAUSE "Premere invio per continuare"
#define ERR_VMVAR "Variabile della macchina virtuale non definita"
#else
#define ERR_WRITE "Error writing output file"
#define ERR_NAMEEX "Nome gi definito in questa struttura"
#define ERR_DESTPR "Destination protocol not defined"
#define ERR_PRID "Protocol ridefinition"
#define ERR_BITS "In bits definition, first number must be minor or equal to second"
#define ERR_BITS1 "Error assigning bit fields. Wrong values."
#define ERR_FIELD "Unable to access undefined field"
#define ERR_UNKDIM "Unknown dimension"
#define ERR_LINE "Error in line :%d\n%s\n"
#define ERR_PAUSE "Press a key to continue"
#define ERR_VMVAR "Virtual machine variable not defined"
#endif

vector <p_struct> p_str;
vector <istruzione> ist;
ProtocolVect prot;
vector <nome> name;
CCase cc;

int p_ind;
int i_ind;
int n_ind;
int np=0;
int hasErrors;

extern FILE* out;
extern char* yytext;
extern int yylex();
int yyerror (const char* c);

const char* agg_nome(char* t)
{
	int l,i;
	l=strlen(yytext);
	for (i=0;i<l;i++)
	 if (yytext[i]>='a' && yytext[i]<='z')
	  { yytext[i]= yytext[i]+ 'A'-'a';}
	if (strlen(t)>50) t[49]='\0';
	return t;
}

static int i;

inline void OUTPUT(int k) 
{
 if(fwrite(&k,sizeof(int),1,out)==0) 
 {
  yyerror(ERR_WRITE /*Errore di scrittura del file di output*/);
  return;
 }
}

inline void SEEK(int k) 
{
	fseek(out,k,SEEK_SET);
}

int checkexisting(const char* c)
{
	int i;
	for(i=0;i<p_ind;i++)
	 if(strcmp(c,p_str[i].nome)==0) 
		 {
		  yyerror(ERR_NAMEEX /*Nome gi definito in questa struttura*/);
		  return 1;
		 }
	return 0;
}

typedef union {
	 nome n;
	 intero i;
	} YYSTYPE;
#define PROTOCOL 257
#define VIRTUAL 258
#define ENDPR 259
#define BYTE 260
#define WORD 261
#define DWORD 262
#define BIT 263
#define MUSTINVERT 264
#define NOME 265
#define NUMERO 266
#define NUMERO_H 267
#define CASE 268
#define ELSE 269
#define SKIP 270
#define GETVMVAR 271
#define COST_STRINGA 272
#define OR 273
#define AND 274
#define NOT_EQ 275
#define MIU 276
#define MAU 277
#define NOT 278
#define MENO_UNARIO 279
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,   10,   10,    2,    2,    2,    2,   12,   11,   11,
   13,   13,   14,   14,    3,    3,    4,    4,    5,    5,
    6,    6,    6,    1,    7,    7,    9,    8,    8,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    8,
    8,    8,    8,    8,    8,    8,
};
short yylen[] = {                                         2,
    1,    2,    3,    4,    3,    5,    4,    3,    2,    1,
    2,    3,    4,    5,    3,    2,    3,    0,    7,    8,
    2,    2,    2,    1,    1,    1,    1,    1,    1,    3,
    4,    3,    3,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    2,    2,
};
short yydefred[] = {                                      0,
    0,    0,    0,    0,    0,   24,    0,    0,    0,    0,
    0,    2,    0,   10,    0,    0,    5,    0,    0,    0,
    0,    0,    0,   25,   26,    0,    0,    0,    0,   28,
   29,    0,   11,    0,    9,    0,    0,    3,   21,   22,
   23,    4,    0,    0,   16,    7,    0,    0,    0,   46,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   12,   15,    0,
    0,    6,   27,    0,   30,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   42,   43,   44,   13,    0,
    0,    0,   17,   31,   14,    0,    0,    0,    0,    0,
    0,    0,    0,   19,    0,   20,
};
short yydgoto[] = {                                       3,
   30,    4,   21,   45,   71,   22,   31,   32,   74,    5,
   12,   13,   14,   15,
};
short yysindex[] = {                                   -203,
 -263, -243,    0, -250, -203,    0, -142, -263,  -36, -263,
  -42,    0, -191,    0, -185, -250,    0, -263, -263, -263,
 -132, -101, -110,    0,    0,   -3,  -36,  -36,  -36,    0,
    0,  -37,    0,  -36,    0,  -36, -263,    0,    0,    0,
    0,    0, -101, -237,    0,    0,  -98, -233,   28,    0,
  -30,  -36,  -36,  -36,  -36,  -36,  -36,  -36,  -36,  -36,
  -36,  -36,  -36,  -36, -263,   -2,   -9,    0,    0, -263,
 -124,    0,    0,    1,    0,   19,   26,  139,  139,  139,
  139,  139,  139,   28,   28,    0,    0,    0,    0, -263,
   17, -263,    0,    0,    0, -157,   45,   46, -157, -157,
   51,   56, -157,    0,   59,    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,  105,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -50,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  -50,    0,    0,    0,    0,    0,   31,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -137,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  119,    9,  -14,   41,   75,
   85,   97,  107,   53,   63,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,
};
short yygindex[] = {                                      0,
  385,  102,   99,   69,    0,  -18,   89,  144,    0,    0,
  118,    0,  127,    0,
};
#define YYTABLESIZE 477
short yytable[] = {                                      64,
   93,    6,   43,   29,   62,   60,   64,   61,   27,   63,
   75,   62,   60,    8,   61,   34,   63,    9,   10,   11,
   65,   44,   58,   54,   59,   70,   38,   64,   43,   58,
   54,   59,   62,   60,   64,   61,   48,   63,   73,   62,
   60,   94,   61,   38,   63,   38,   38,   38,   90,   39,
   58,   54,   59,    1,    2,   64,   96,   58,   54,   59,
   62,   60,   64,   61,   64,   63,   39,   62,   60,   62,
   61,   45,   63,   45,   63,   45,    9,   10,   58,   54,
   59,   33,   36,   37,   99,   58,   54,   59,   45,  100,
   45,   45,   45,   32,  103,   32,  104,   32,   33,  106,
   33,   33,   33,   41,    1,   41,   16,   41,   24,   25,
   32,   69,   32,   32,   32,   34,   17,   18,   19,   20,
   41,   47,   41,   41,   41,   35,   42,   18,   19,   20,
    8,    8,   34,   38,   34,   34,   34,   36,   92,   35,
    0,    0,   35,    0,   35,   35,   35,   37,   46,   18,
   19,   20,    0,    0,   36,    0,   36,   36,   36,   40,
   72,   18,   19,   20,   37,    0,   37,   37,   37,    0,
   49,   50,   51,    0,    0,   64,   40,   66,    0,   67,
   62,   60,    0,   61,   98,   63,    0,  101,  102,    0,
    0,  105,    0,    0,    0,   76,   77,   78,   79,   80,
   81,   82,   83,   84,   85,   86,   87,   88,   18,   18,
   18,   18,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    6,   24,
   25,    0,    0,    0,   26,   52,   53,   55,   56,   57,
    0,   28,   52,   53,   55,   56,   57,    0,    0,    0,
    0,    0,    0,   38,   38,    0,    0,    0,   38,   38,
   38,   38,   38,   52,   53,   55,   56,   57,    0,    0,
   52,   53,   55,   56,   57,    0,   39,   39,    0,    0,
    0,   39,   39,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   53,   55,   56,   57,    0,    0,   45,   45,
   55,   56,   57,   45,   45,   45,   45,   45,   33,   33,
    0,    0,    0,   33,   33,   33,   33,   33,    0,    0,
   32,   32,    0,    0,    0,   32,   32,   32,   32,   32,
   41,   41,    0,    0,    0,   41,   41,   41,   41,   41,
    0,    0,   34,   34,    0,    0,    0,   34,   34,   34,
   34,   34,   35,   35,    0,    0,    0,   35,   35,   35,
   35,   35,    0,    0,   36,   36,    0,    0,    0,   36,
   36,   36,   36,   36,   37,   37,    0,    0,    0,   37,
   37,   37,   37,   37,    0,    7,   40,   40,    0,    0,
    0,   40,   23,    0,   33,    0,    0,    0,    0,    0,
    0,    0,   39,   40,   41,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   68,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   89,
    0,    0,    0,    0,   91,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   95,    0,   97,
};
short yycheck[] = {                                      37,
  125,  265,   21,   40,   42,   43,   37,   45,   45,   47,
   41,   42,   43,  257,   45,   58,   47,  268,  269,  270,
   58,  123,   60,   61,   62,  263,   41,   37,   47,   60,
   61,   62,   42,   43,   37,   45,   40,   47,  272,   42,
   43,   41,   45,   58,   47,   60,   61,   62,   58,   41,
   60,   61,   62,  257,  258,   37,   40,   60,   61,   62,
   42,   43,   37,   45,   37,   47,   58,   42,   43,   42,
   45,   41,   47,   43,   47,   45,  268,  269,   60,   61,
   62,   41,  268,  269,   40,   60,   61,   62,   58,   44,
   60,   61,   62,   41,   44,   43,   41,   45,   58,   41,
   60,   61,   62,   41,    0,   43,    5,   45,  266,  267,
   58,   43,   60,   61,   62,   41,  259,  260,  261,  262,
   58,   23,   60,   61,   62,   41,  259,  260,  261,  262,
  268,  269,   58,   16,   60,   61,   62,   41,  263,   13,
   -1,   -1,   58,   -1,   60,   61,   62,   41,  259,  260,
  261,  262,   -1,   -1,   58,   -1,   60,   61,   62,   41,
  259,  260,  261,  262,   58,   -1,   60,   61,   62,   -1,
   27,   28,   29,   -1,   -1,   37,   58,   34,   -1,   36,
   42,   43,   -1,   45,   96,   47,   -1,   99,  100,   -1,
   -1,  103,   -1,   -1,   -1,   52,   53,   54,   55,   56,
   57,   58,   59,   60,   61,   62,   63,   64,  259,  260,
  261,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  265,  266,
  267,   -1,   -1,   -1,  271,  273,  274,  275,  276,  277,
   -1,  278,  273,  274,  275,  276,  277,   -1,   -1,   -1,
   -1,   -1,   -1,  268,  269,   -1,   -1,   -1,  273,  274,
  275,  276,  277,  273,  274,  275,  276,  277,   -1,   -1,
  273,  274,  275,  276,  277,   -1,  268,  269,   -1,   -1,
   -1,  273,  274,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  274,  275,  276,  277,   -1,   -1,  268,  269,
  275,  276,  277,  273,  274,  275,  276,  277,  268,  269,
   -1,   -1,   -1,  273,  274,  275,  276,  277,   -1,   -1,
  268,  269,   -1,   -1,   -1,  273,  274,  275,  276,  277,
  268,  269,   -1,   -1,   -1,  273,  274,  275,  276,  277,
   -1,   -1,  268,  269,   -1,   -1,   -1,  273,  274,  275,
  276,  277,  268,  269,   -1,   -1,   -1,  273,  274,  275,
  276,  277,   -1,   -1,  268,  269,   -1,   -1,   -1,  273,
  274,  275,  276,  277,  268,  269,   -1,   -1,   -1,  273,
  274,  275,  276,  277,   -1,    1,  268,  269,   -1,   -1,
   -1,  273,    8,   -1,   10,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   18,   19,   20,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   37,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   65,
   -1,   -1,   -1,   -1,   70,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   90,   -1,   92,
};
#define YYFINAL 3
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 279
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"'%'",0,0,"'('","')'","'*'","'+'","','","'-'",0,"'/'",0,0,0,0,0,0,0,0,0,0,
"':'",0,"'<'","'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,"PROTOCOL","VIRTUAL","ENDPR","BYTE","WORD","DWORD","BIT",
"MUSTINVERT","NOME","NUMERO","NUMERO_H","CASE","ELSE","SKIP","GETVMVAR",
"COST_STRINGA","OR","AND","NOT_EQ","MIU","MAU","NOT","MENO_UNARIO",
};
char *yyrule[] = {
"$accept : file",
"file : protocol_list",
"protocol_list : pheader ptrailer",
"protocol_list : protocol_list pheader ptrailer",
"pheader : PROTOCOL nome structs ENDPR",
"pheader : PROTOCOL nome ENDPR",
"pheader : VIRTUAL PROTOCOL nome structs ENDPR",
"pheader : VIRTUAL PROTOCOL nome ENDPR",
"skip : SKIP ':' espressione",
"ptrailer : skip next_protocol",
"ptrailer : next_protocol",
"next_protocol : ELSE nome",
"next_protocol : n_protocol ELSE nome",
"n_protocol : CASE espressione ':' nome",
"n_protocol : n_protocol CASE espressione ':' nome",
"structs : structs def bit_defs",
"structs : def bit_defs",
"bit_defs : '{' b_defs '}'",
"bit_defs :",
"b_defs : BIT nome '(' numero ',' numero ')'",
"b_defs : b_defs BIT nome '(' numero ',' numero ')'",
"def : BYTE nome",
"def : WORD nome",
"def : DWORD nome",
"nome : NOME",
"numero : NUMERO",
"numero : NUMERO_H",
"stringa : COST_STRINGA",
"espressione : nome",
"espressione : numero",
"espressione : '(' espressione ')'",
"espressione : GETVMVAR '(' stringa ')'",
"espressione : espressione '+' espressione",
"espressione : espressione NOT_EQ espressione",
"espressione : espressione MIU espressione",
"espressione : espressione MAU espressione",
"espressione : espressione '<' espressione",
"espressione : espressione '>' espressione",
"espressione : espressione '=' espressione",
"espressione : espressione AND espressione",
"espressione : espressione OR espressione",
"espressione : espressione '-' espressione",
"espressione : espressione '*' espressione",
"espressione : espressione '/' espressione",
"espressione : espressione '%' espressione",
"espressione : '-' espressione",
"espressione : NOT espressione",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE

extern int yylineno;

int yyerror (const char* c)
{
 hasErrors=1;
 printf(ERR_LINE /*Errore alla linea :%d\n%s\n*/,yylineno,c);
#ifdef DEBUG
 Ask(ERR_PAUSE /*Premere invio per continuare*/);
#endif
 return 0;
}
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv(const char*);

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
{
			    int j,found;
				const char *a,*b;
				for(j=0;j<n_ind;j++)
				{
				 found=0;
			     for(i=0;i<np;i++)
				  {
				     a=prot[i].GetName();
					 b=name[j].nome;
					 if (a==NULL) break;
					 if (strcmp(a,b)==0) {found=1;break;}
				  }
				 if(!found && strcmp(b,"DATA")==0 ) found=1;
				 if(!found) yyerror(ERR_DESTPR /*Protocollo di destinazione non definito*/);
				}
				if(!hasErrors) 
				{
				i=MAGIC_PDF;
				fwrite(&i,sizeof(int),1,out);
				time_t current_time;
				time(&current_time);
				fwrite(&current_time,sizeof(time_t),1,out);
				srand((unsigned int)current_time);
				i=rand();
				fwrite(&i,sizeof(int),1,out);
				fwrite(&np,sizeof(int),1,out);
				 for(i=0;i<np;i++)
				 {
				    prot[i].Serialize(0,out);
				 }
				}
			   }
break;
case 2:
{}
break;
case 3:
{}
break;
case 4:
{
				 yyval.i.i=yyvsp[-1].i.i;
				 for(i=0;i<np;i++) 
					if (strcmp(yyvsp[-2].n.nome,prot[i].GetName())==0)
					   {
						yyerror(ERR_PRID /*Ridefinizione di protocollo*/);
						strcpy(yyvsp[-2].n.nome,"!!!");
						break;
					   }
				 prot[np].SetNome(yyvsp[-2].n.nome);
				 prot[np].RiempiCampi(p_str,p_ind);
				 cc.ClearAll();
				}
break;
case 5:
{
				 yyval.i.i=0;
				 for(i=0;i<np;i++) 
					if (strcmp(yyvsp[-1].n.nome,prot[i].GetName())==0)
					   {
						yyerror(ERR_PRID /*Ridefinizione di protocollo*/);
						strcpy(yyvsp[-1].n.nome,"!!!");
						break;
					   }
				 prot[np].SetNome(yyvsp[-1].n.nome);
				 prot[np].RiempiCampi(p_str,p_ind);
				 cc.ClearAll();
				}
break;
case 6:
{
				 yyval.i.i=yyvsp[-1].i.i;
				 for(i=0;i<np;i++) 
					if (strcmp(yyvsp[-2].n.nome,prot[i].GetName())==0)
					   {
						yyerror(ERR_PRID /*Ridefinizione di protocollo*/);
						strcpy(yyvsp[-2].n.nome,"!!!");
						break;
					   }
				 prot[np].SetNome(yyvsp[-2].n.nome);
				 prot[np].SetVirt(1);
				 prot[np].RiempiCampi(p_str,p_ind);
				 cc.ClearAll();
				}
break;
case 7:
{
				 yyval.i.i=0;
				 for(i=0;i<np;i++) 
					if (strcmp(yyvsp[-1].n.nome,prot[i].GetName())==0)
					   {
						yyerror(ERR_PRID /*Ridefinizione di protocollo*/);
						strcpy(yyvsp[-1].n.nome,"!!!");
						break;
					   }
				 prot[np].SetNome(yyvsp[-1].n.nome);
				 prot[np].SetVirt(1);
				 prot[np].RiempiCampi(p_str,p_ind);
				 cc.ClearAll();
				}
break;
case 8:
{
				prot[np].RiempiSkip(ist,i_ind);
				i_ind=0;
			   }
break;
case 9:
{
				p_ind=0;
			    np++;
			   }
break;
case 10:
{
				prot[np].RiempiSkip(NULL,0);
				i_ind=0;
				p_ind=0;
			    np++;
			   }
break;
case 11:
{
			     ist[0].ist_number=I_PUSH;
			     ist[0].p1=1;
				 cc.RiempiCase(ist,1,yyvsp[0].n.nome);
				 prot[np].AddCase(cc);
				 cc.ClearAll();
				 i_ind=0;
				 strcpy (name[n_ind].nome,yyvsp[0].n.nome);
				 n_ind++;
				}
break;
case 12:
{
			     ist[0].ist_number=I_PUSH;
			     ist[0].p1=1;
				 cc.RiempiCase(ist,1,yyvsp[0].n.nome);
				 prot[np].AddCase(cc);
				 cc.ClearAll();
				 i_ind=0;
				 strcpy (name[n_ind].nome,yyvsp[0].n.nome);
				 n_ind++;
				}
break;
case 13:
{
				 cc.RiempiCase(ist,i_ind,yyvsp[0].n.nome);
				 prot[np].AddCase(cc);
				 cc.ClearAll();
				 i_ind=0;
				 strcpy (name[n_ind].nome,yyvsp[0].n.nome);
				 n_ind++;
				}
break;
case 14:
{
				 cc.RiempiCase(ist,i_ind,yyvsp[0].n.nome);
				 prot[np].AddCase(cc);
				 cc.ClearAll();
				 i_ind=0;
				 strcpy (name[n_ind].nome,yyvsp[0].n.nome);
				 n_ind++;
				}
break;
case 15:
{yyval.i.i=yyvsp[-2].i.i+yyvsp[-1].i.i;}
break;
case 16:
{yyval.i.i=yyvsp[-1].i.i;}
break;
case 17:
{yyval.i.i=yyvsp[-1].i.i;}
break;
case 18:
{yyval.i.i=0;}
break;
case 19:
{
				 yyval.i.i=0;p_str[p_ind].size=0;
				 p_str[p_ind].offset=p_str[p_ind-1].offset;
				 p_str[p_ind].bs=yyvsp[-3].i.i;
				 p_str[p_ind].be=yyvsp[-1].i.i;
				 p_str[p_ind].ref=p_ind-1;
				 if (yyvsp[-3].i.i>yyvsp[-1].i.i) 
				  yyerror(ERR_BITS /*Nella definizione dei bits il primo numero deve essere minore o uguale al secondo*/);
				 if ((yyvsp[-3].i.i>>3)>p_str[p_ind-1].size || 
					 (yyvsp[-1].i.i>>3)>p_str[p_ind-1].size || 
					 yyvsp[-3].i.i<0 || yyvsp[-1].i.i<0)
				  yyerror(ERR_BITS1 /*Errore nell'assegnazione dei campi dei bits. Valori errati.*/);
				 strcpy(p_str[p_ind].nome, agg_nome(yyvsp[-5].n.nome));
				 checkexisting(yyvsp[-5].n.nome);
				 p_ind++;
				}
break;
case 20:
{
				 yyval.i.i=0;p_str[p_ind].size=0;
				 p_str[p_ind].offset=p_str[p_ind-1].offset;
				 p_str[p_ind].bs=yyvsp[-3].i.i;
				 p_str[p_ind].be=yyvsp[-1].i.i;
				 p_str[p_ind].ref=p_str[p_ind-1].ref;
				 if (yyvsp[-3].i.i>yyvsp[-1].i.i) 
				  yyerror(ERR_BITS /*Nella definizione dei bits il primo numero deve essere minore o uguale al secondo*/);
				 if ((yyvsp[-3].i.i>>3)>p_str[p_str[p_ind-1].ref].size || 
					 (yyvsp[-1].i.i>>3)>p_str[p_str[p_ind-1].ref].size || 
					 yyvsp[-3].i.i<0 || yyvsp[-1].i.i<0)
				  yyerror(ERR_BITS1 /*Errore nell'assegnazione dei campi dei bits. Valori errati.*/);
				 strcpy(p_str[p_ind].nome, agg_nome(yyvsp[-5].n.nome));
				 checkexisting(yyvsp[-5].n.nome);
				 p_ind++;
				}
break;
case 21:
{
				 yyval.i.i=1;p_str[p_ind].size=1;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else 
				  {
				   i=p_str[p_ind-1].size;
				   if (i==0) i=p_str[p_str[p_ind-1].ref].size;
				   p_str[p_ind].offset=p_str[p_ind-1].offset+i;
				  }
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
break;
case 22:
{
				 yyval.i.i=2;p_str[p_ind].size=2;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else 
				  {
				   i=p_str[p_ind-1].size;
				   if (i==0) i=p_str[p_str[p_ind-1].ref].size;
				   p_str[p_ind].offset=p_str[p_ind-1].offset+i;
				  }
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
break;
case 23:
{
				 yyval.i.i=4;p_str[p_ind].size=4;
				 if (p_ind==0) p_str[p_ind].offset=0; 
				  else 
				  {
				   i=p_str[p_ind-1].size;
				   if (i==0) i=p_str[p_str[p_ind-1].ref].size;
				   p_str[p_ind].offset=p_str[p_ind-1].offset+i;
				  }
				 strcpy(p_str[p_ind].nome, agg_nome(yytext));
				 checkexisting(yytext);
				 p_ind++;
				}
break;
case 24:
{
			   strcpy(yyval.n.nome,agg_nome(yytext));
			  }
break;
case 25:
{
			   int num;
			   sscanf(yytext,"%d",&num);
			   yyval.i.i=num;
			  }
break;
case 26:
{
			   int num;
			   sscanf(yytext+2,"%x",&num);
			   yyval.i.i=num;
			  }
break;
case 27:
{
				 yytext[strlen(yytext)-1]='\0';
				 if (strcmp(yytext+1,"FrameAvail")==0) yyval.i.i=0;
				 else if (strcmp(yytext+1,"FrameSize")==0) yyval.i.i=1;
				 else if (strcmp(yytext+1,"ItemNumber")==0) yyval.i.i=2;
				 else if (strcmp(yytext+1,"FrameSecs")==0) yyval.i.i=3;
				 else if (strcmp(yytext+1,"FrameUSecs")==0) yyval.i.i=4;
				 else if (strcmp(yytext+1,"Written")==0) yyval.i.i=5;
				 else if (strcmp(yytext+1,"Discarded")==0) yyval.i.i=6;
				 else if (strcmp(yytext+1,"FrameType")==0) yyval.i.i=7;
				 else if (strcmp(yytext+1,"SizeNotInt")==0) yyval.i.i=8;
				 else if (strcmp(yytext+1,"SizeInt")==0) yyval.i.i=9;
				 else if (strcmp(yytext+1,"Position")==0) yyval.i.i=10;
				 else {yyerror(ERR_VMVAR /*Variabile della macchina virtuale non definita*/);}
			  }
break;
case 28:
{
			   int indice;
			   const char* ct=agg_nome(yytext);
			   for(indice=0;indice<p_ind;indice++)
			    if (strcmp(yytext,p_str[indice].nome)==0) {ct=NULL;break;}
			   if (ct!=NULL) yyerror(ERR_FIELD /*Impossibile accedere ad un campo non definito*/);
			   else 
			   {
			    switch (p_str[indice].size)
				{
				 case 0:
				  i=p_str[indice].ref;
					if(p_str[i].size==1)ist[i_ind].ist_number=I_PUSH_BYTE;
					else if(p_str[i].size==2)ist[i_ind].ist_number=I_PUSH_WORD;
					else if(p_str[i].size==4)ist[i_ind].ist_number=I_PUSH_DWORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  i_ind++;
			      ist[i_ind].ist_number=I_PUSH_BITS;
			      ist[i_ind].p1=((p_str[indice].bs)&0xFF)+(((p_str[indice].be)<<8)&0xFF00);
				  break;
				 case 1:
			      ist[i_ind].ist_number=I_PUSH_BYTE;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 case 2:
			      ist[i_ind].ist_number=I_PUSH_WORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 case 4:
			      ist[i_ind].ist_number=I_PUSH_DWORD;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				 default:
				  yyerror(ERR_UNKDIM /*Errore di dimensione non nota*/);
			      ist[i_ind].ist_number=I_PUSH_BYTE;
			      ist[i_ind].p1=p_str[indice].offset;
				  break;
				}
				i_ind++;
			   }
			  }
break;
case 29:
{
			   int num=yyvsp[0].i.i;
			   ist[i_ind].ist_number=I_PUSH;
			   ist[i_ind].p1=num;
			   i_ind++;
			  }
break;
case 30:
{ }
break;
case 31:
{
				 ist[i_ind].ist_number=I_GETVMVAR;
			     ist[i_ind].p1=yyvsp[-1].i.i;
				 i_ind++;
				}
break;
case 32:
{
			   ist[i_ind].ist_number=I_PLUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 33:
{
			   ist[i_ind].ist_number=I_NOT_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 34:
{
			   ist[i_ind].ist_number=I_MIN_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 35:
{
			   ist[i_ind].ist_number=I_MAG_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 36:
{
			   ist[i_ind].ist_number=I_MIN;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 37:
{
			   ist[i_ind].ist_number=I_MAG;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 38:
{
			   ist[i_ind].ist_number=I_EQUAL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 39:
{
			   ist[i_ind].ist_number=I_AND;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 40:
{
			   ist[i_ind].ist_number=I_OR;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 41:
{
			   ist[i_ind].ist_number=I_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 42:
{
			   ist[i_ind].ist_number=I_MUL;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 43:
{
			   ist[i_ind].ist_number=I_DIV;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 44:
{
			   ist[i_ind].ist_number=I_MOD;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 45:
{
			   ist[i_ind].ist_number=I_UN_MINUS;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
case 46:
{
			   ist[i_ind].ist_number=I_NOT;
			   ist[i_ind].p1=0;
			   i_ind++;
			  }
break;
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
