// CLogDocument.h : header file
//

#ifndef _CLOGDOCUMENT
#define _CLOGDOCUMENT

#ifdef _CONSOLE
#ifndef CONSOLE
#define CONSOLE
#endif
#endif

#if defined WIN32 && !defined CONSOLE
#include "../Win32-Interface/stdafx.h"
#include "../Win32-Interface/Querydlg.h"
#endif

#include "../comuni/linecol.h"
#include "../vm/filed/lfreader.h"
#include "../vm/filed/savefile.h"
#include "reporter.h"
#include "../comuni/string_l.h"

#include "../comuni/cmdline.h"
#include "..\COMUNI\STRING_L.H"	// Added by ClassView
extern processCmdLine *p;
#if defined WIN32 && !defined CONSOLE
class CIniProcesser ;
#endif

class Query;

class CLogDocument
{

 public:
	 int GetPacketsFiltered(string & s);
	 int OnLogNew(string & s);
	 int OnLogCopyDel(string& s, int IsCopy);
	 int OnLogCopy(string& s);
	 int Str2VecInt(string& s, vector<int> &dels);
	 int OnLogMerge(string& s);
	 int OnCapOpen(string& s);
	 void OnClose();
	 int OnLogDel(string& s);
	 int OnLogItem();
	 int OnHelp();
	 int OnLogMacro(const char* c);
	 int OnWCapAdd();
	 int OnWCapClose();
	 int OnWCapOpen(const char* s);
	 int OnGetItemNr();
	 int OnLogJump(string&f);
	 int OpenLfo (const char* s);
	 int OpenPfo (const char* s);
	 int OpenDfo (const char* s);
	 int OpenIfo (const char* s);
	 int OnLogPos();
	 int OpenIni(const char* iniName);
	 int IndexConsole;
	 string cmdIndex;
	 string lfoFileName;
	 string dfoFileName;
	 string ifoFileName;
	 string pfoFileName;
	 int ParseCommand(string & command);
    CLogDocument();            // protected constructor used by dynamic creation
    virtual ~CLogDocument();
	int AddData;
	int AddParsed;
	int MacroMode;
    int OnLogFilter(string &f);
    int OnLogFirst();
    int OnLogLast();
    int OnLogNext();
    int OnLogNextf();
    int OnLogPrev();
    int OnLogPrevf();
    int OnLogQuery(string& f);
    int OnRepOpen(string &s);
    int OnRepClose();
    int OnRepAdd();
    int OnLogThis();
    int OnOpen(string &s);
	void PutOutput(LineCollection* lc=NULL);
	LineCollection *GetLc() {return lc;}
	 int erroropening;
#ifdef WIN32
#ifndef CONSOLE
	 CEdit* edit;
	CQueryDlg *dlg;
#endif
#endif

 private:
	 char CsvSep;
	 FILE* macro_rec;
	 string GetFileNameFromString(string& s, int& IsTemp);
	 int ReOpenCap(string& fileName, int IsTemp=1);
	 FILE* GetTempFile(string &File);
	 CSaveCap* scap;
	 int RapNum;
	 FILE* RepFile;
    LineCollection* lc;
	Reporter *reporter;
	Query* qry;
};

/////////////////////////////////////////////////////////////////////////////

#include "../comuni/asksay.h"

#endif
