// CLogDocument.cpp : implementation file
//

#ifdef _CONSOLE
#ifndef CONSOLE
#define CONSOLE
#endif
#endif

#ifndef ENGLISH
#define ERR_NONAME "Impossibile aprire un file senza nome"
#define ERR_MEM "Memoria esaurita"
#define ERR_LFO "Il file Lfo e' errato o mancante"
#define ERR_PDO "Warning: Il file PDO e' errato o mancante. Impossibile effettuare analisi"
#define ERR_DFO "Warning: Il file DFO e' errato o mancante. Impossibile effettuare analisi"
#define ERR_IFO "Warning: Il file IFO e' errato o mancante. Impossibile creare un indice dei pacchetti"
#define ERR_LOG "Il file delle catture e' errato o mancante."
#define ERR_CAPNO "Cattura non aperta"
#define ERR_FILERNAME "Impossibile aprire un file senza nome"
#define ERR_STATS "Impossibile elaborare le Statistiche"
#define ERR_OUT "Impossibile aprire il file di output"
#define ERR_REP1 "Un rapporto e' gia' aperto. Se ne vuole aprire un altro chiudendo l'attuale?"
#define ERR_REP2 "Rapporto non aperto"
#define ERR_RUNTIME "Runtime Error"
#define ERR_TIME "Questo comando puo' richiedere molto tempo"
#define ERR_MACREC "Registrazione macro in corso"
#define ERR_NOCAP "Aprire prima un file di catture"
#define ERR_PROTO "Il protocollo non  valido"
#define ERR_NFP "Nessun primo protocollo impostato"
#define ERR_FP "Il primo protocollo : %s"
#define ERR_CMD "Comando non supportato"
#define ERR_POS "Posizione corrente: %d"
#define ERR_FNE "Il file specificato non esiste"
#define ERR_FNE1 "Il file specificato non e' accessibile oppure non esiste"
#define ERR_NEXT "Il file verra' utilizzato per il prossimo file di catture aperto"
#define ERR_OKLFO "File LFO aperto con successo"
#define ERR_OKPDO "File PDO aperto con successo"
#define ERR_OKDFO "File DFO aperto con successo"
#define ERR_OKIFO "File IFO aperto con successo"
#define ERR_JMP "Parametro errato per il salto"
#define ERR_PCK "Il numero di Pacchetti e': %d"
#define ERR_OCAP "Errore di apertura del file cap. Aprire prima un file di catture."
#define ERR_NOOCAP "File di cattura/rapporto non aperto"
#define ERR_MACV "Il file di macro non e' valido"
#define ERR_EMAC "Problemi nell'esecuzione della macro"
#define ERR_MERGE "Il merge  impossibile in quanto il file destinazione non  accessibile"
#define ERR_LINK "Il tipo di rete da cui i pacchetti sono stati catturati  diverso. Si vuole continuare?"
#define ERR_S1 "Non  stato possibile rimuovere il file: "
#define ERR_S2 ". Il nuovo file di catture ha la seguente path: "
#define ERR_S3 ". Assicurarsi di rinominarlo o rimuoverlo dopo l'uso."
#define ERR_S4 "E' stato creato il file: "
#define ERR_S5 ". Assicurarsi di rinominarlo o rimuoverlo dopo l'uso."
#define ERR_PCKS "Non sono stati specificati pacchetti validi"
#define ESS_SS1 "E' stato creato il file: "
#define ERR_SS2 ". Assicurarsi di rinominarlo o eliminarlo dopo l'uso."
#else
#define ERR_NONAME "Unable to open a file without name"
#define ERR_MEM "Out of Memory"
#define ERR_LFO "Lfo file missing or wrong"
#define ERR_PDO "Warning: PDO file missing or wrong."
#define ERR_DFO "Warning: DFO file missing or wrong."
#define ERR_IFO "Warning: file missing or wrong."
#define ERR_LOG "Capture file missing or wrong."
#define ERR_CAPNO "Capture not opened"
#define ERR_FILERNAME "Unable to open a file without name"
#define ERR_STATS "Unable to evaluate Statistics"
#define ERR_OUT "Unable to open output file"
#define ERR_REP1 "A report is already open. Do you wish to open another?"
#define ERR_REP2 "Report not opened"
#define ERR_RUNTIME "Runtime Error"
#define ERR_TIME "This command may require many time. Please wait..."
#define ERR_MACREC "Registering macro..."
#define ERR_NOCAP "Please open a capture file..."
#define ERR_PROTO "Invalid protocol"
#define ERR_NFP "No first protocol set"
#define ERR_FP "First protocol is: %s"
#define ERR_CMD "Command not supported"
#define ERR_POS "Current position: %d"
#define ERR_FNE "File does not exists"
#define ERR_FNE1 "File does not exists"
#define ERR_NEXT "This file will be used on next opened capture"
#define ERR_OKLFO "LFO file opened succesfully"
#define ERR_OKPDO "PDO file opened succesfully"
#define ERR_OKDFO "DFO file opened succesfully"
#define ERR_OKIFO "IFO file opened succesfully"
#define ERR_JMP "Wrong jump parameter"
#define ERR_PCK "Packet number is: %d"
#define ERR_OCAP "Error opening cap file."
#define ERR_NOOCAP "Capture or report not opened"
#define ERR_MACV "Macro file is invalid"
#define ERR_EMAC "Problems executing macro"
#define ERR_MERGE "Merge is impossibile when destination file is not accessible"
#define ERR_LINK "Link type in current capture is different. Do you wish to continue?"
#define ERR_S1 "Unable to remove file: "
#define ERR_S2 ". New capture file has the following path: "
#define ERR_S3 ". Rename or remove it after use."
#define ERR_S4 "A file was created: "
#define ERR_S5 ". Rename or remove it after use."
#define ERR_PCKS "No valid packet specified"
#define ESS_SS1 "A file was created: "
#define ERR_SS2 ". Rename or remove it after use."
#endif

#if defined WIN32 && !defined CONSOLE
#include "../Win32-Interface/stdafx.h"
#include "../Win32-Interface/Query.h"
#include "../Win32-Interface/DlgProxy.h"
#endif

#if defined WIN32 && defined CONSOLE
#include <windows.h>
#endif

#include "clogdocument.h"

#include "messages.h"
#include "../comuni/cmdline.h"
#include "../iniprocessor/iniprocesser.h"
#include "qparser/query.h"

extern processCmdLine *p;
extern int silent;
extern int oldp;

#if defined WIN32 && !defined CONSOLE
extern CQueryDlg* cdlg;
#endif

processCmdLine *p;

/////////////////////////////////////////////////////////////////////////////
// CLogDocument


CLogDocument::CLogDocument()
{
    lc=NULL;
	RepFile=NULL;
	reporter=NULL;
	AddData=1;
	AddParsed=1;
	MacroMode=0;
	scap=NULL;
#if defined WIN32 && !defined CONSOLE
	edit=NULL;
#endif
	erroropening=FALSE;
	macro_rec=0;
	OpenIni("query.ini");
	if(p)
	{
		if(p->lfoName!="") lfoFileName=p->lfoName;
		if(p->dfoName!="") dfoFileName=p->dfoName;
		if(p->ifoName!="") ifoFileName=p->ifoName;
		if(p->pfoName!="") pfoFileName=p->pfoName;
		if(p->lfName!="") OnOpen(p->lfName);
		if(p->qfName!="") OnLogQuery(p->qfName);
		if(p->filter!="") OnLogFilter(p->filter);
	}
	if(lfoFileName=="")
	 lfoFileName="default.lfo";
	if(dfoFileName=="")
	 dfoFileName="default.dfo";
	if(ifoFileName=="")
	 ifoFileName="default.ifo";
	if(pfoFileName=="")
	 pfoFileName="default.pdo";
	CsvSep=';';
}


CLogDocument::~CLogDocument()
{
    lc=NULL;
	RepFile=NULL;
	if(reporter) delete reporter;
	if(lc) delete lc;
	if (scap) delete scap;
	if (macro_rec) 
	{
		fprintf(macro_rec,"}\n");
		fclose (macro_rec);
	}
}

/////////////////////////////////////////////////////////////////////////////
// CLogDocument serialization

int CLogDocument::OnOpen(string &s)
{
	if(s=="") {Say(ERR_NONAME /*Impossibile aprire un file senza nome*/);return 0;}
	erroropening=FALSE;
	OnClose();
      if (pfoFileName=="")
	   {Say(E_PDFNOTOPENED);erroropening=TRUE;return 0;}
      reporter=new Reporter((const char*)lfoFileName,(const char*)pfoFileName,
							(char*)(const char*)dfoFileName,(char*)(const char*)ifoFileName,
							(char*)(const char*)s,(char*)(const char*)p->filter);
	  if (reporter==NULL) {Say(ERR_MEM /*Memoria esaurita*/);return 0;} 
	  switch(reporter->getErrorCode())
	  {
	  case freOK:
		  break;
	  case freBadLFO:
		  Say(ERR_LFO /*Il file Lfo e' errato o mancante*/);
		  delete reporter; reporter=NULL; erroropening=TRUE; return 0;
	  case freBadPDO:
		  Say(ERR_PDO /*Warning: Il file PDO e' errato o mancante. Impossibile effettuare analisi*/);
		  break;
	  case freBadDFO:
		  Say(ERR_DFO /*Warning: Il file DFO e' errato o mancante. Impossibile effettuare analisi*/);
		  break;
	  case freBadIFO:
		  Say(ERR_IFO /*Warning: Il file IFO e' errato o mancante. Impossibile creare un indice dei pacchetti*/);
		  break;
	  case freBadLOG:
		  Say(ERR_LOG /*Il file delle catture e' errato o mancante.*/);
		  delete reporter; reporter=NULL; erroropening=TRUE; return 0;
	  default:
		  break;
	  }
	  if (reporter->Current()==NULL)
      {Say(reporter->getError());
       delete reporter;
       reporter=NULL;
       erroropening=TRUE;
       return 0;}
	  else
	  {
		OnLogFirst();
		p->lfName=s;
		erroropening=FALSE;
	  }
	  return 1;
}

int CLogDocument::OnLogFilter(string &f)
{
	p->filter=f;
	if(reporter) {reporter->setFilter((char*)(const char*)f);return 1;}
	return 0;
}


int CLogDocument::OnLogThis()
    {
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
	if (reporter->GetNItems()==0)OnLogFirst();
	else
     if (!reporter->current())
      if (reporter->GetPos()<=1)OnLogFirst();
       else OnLogLast();
	PutOutput();
	return 1;
    }

int CLogDocument::OnLogNext()
{
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
    if (!reporter->next())
	{Say(reporter->getError());	return 0;}
	PutOutput();
	return reporter->GetPos();
}


int CLogDocument::OnLogNextf()
{
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
    if (!reporter->nextf())
	{Say(reporter->getError());	return 0;}
	PutOutput();
	return reporter->GetPos();
}


int CLogDocument::OnLogPrev()
{
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
    if (!reporter->prev())
	{Say(reporter->getError());	return 0;}
	PutOutput();
	return reporter->GetPos();
}


int CLogDocument::OnLogPrevf()
{
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
    if (!reporter->prevf())
	{Say(reporter->getError());	return 0;}
	PutOutput();
	return reporter->GetPos();
}


int CLogDocument::OnLogFirst()
{
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
    if (!reporter->First())
	{Say(reporter->getError());	return 0;}
	PutOutput();
	return 1;
}


int CLogDocument::OnLogLast()
{
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
    if (!reporter->Last())
	{Say(reporter->getError());	return 0;}
	PutOutput();
	return 3;
}

Query* readQuery(const char* fileName,const char* out ,LineCollection* errorReport,CPacketDescriber&);

int CLogDocument::OnLogQuery(string& f)
{
 string out;
 int i=0;
 int csv=0;
 if(f[0]=='-' && f[1]=='t') 
 {
	 csv=1;i=2;
	 for(;i<(signed)strlen(f)&&f[i]==' ';i++);
	 for(int te=i;te<=(signed)strlen(f);te++)
				f[te-i]=f[te]; 
 }
 if(f[0]=='-' && f[1]=='f')
 {
	int s,e;
	i+=2;
	if (f[2]==' ') i=3;
	char c=' ';
	if (f[i]=='"') {c='"';i++;}
	for(s=i;i<(signed)strlen(f);i++)
	{
		if (f[i]==c) 
		{
			for(e=s;e<i;e++)
				out[e-s]=f[e]; 
			out[i-s]='\0';
			for(i++;i<(signed)strlen(f)&&f[i]==' ';i++);
			for(e=i;e<=(signed)strlen(f);e++)
				f[e-i]=f[e]; 
			break;
		}
	}
 }
 if(f=="") {Say(ERR_FILERNAME /*Impossibile aprire un file senza nome*/);return 0;}
 if (reporter==NULL || reporter->GetPdoName()==NULL || reporter->GetNItems()==0) 
	{Say(ERR_STATS /*Impossibile elaborare le Statistiche*/);return 0;}
 LineCollection lc;
 if (f[0]!='\0')
 {
  p->qfName=f;
  qry=readQuery(p->qfName,out,&lc,reporter->pdesc);
  if(qry==NULL)
     {
     PutOutput(&lc);
     return 0;
     }
  else
  lc.clear();
  if (csv) qry->SetCsv();
  qry->m_CsvSep=CsvSep;
  if (out!="")
  {
	  qry->analyze(p->lfName,*reporter,NULL,reporter->pdesc);
  }
  else
   qry->analyze(p->lfName,*reporter,&lc,reporter->pdesc);
  delete qry;
  qry=NULL;
  PutOutput(&lc);
  return 1;
 }
 return 0;
}

int CLogDocument::OnRepOpen(string &s)
    {
		if(RepFile) 
		{
			if(Ask(ERR_REP1 /*Un rapporto e' gia' aperto. Se ne vuole aprire un altro chiudendo l'attuale?*/)==IDYES)
				{OnRepClose();RepFile=NULL;}
		}
        if(!RepFile) RepFile=fopen(s,"w");
		if (!RepFile) {Say(E_REPOPEN); return 0;}
        RapNum=0;
		return 1;
    }

int CLogDocument::OnRepClose()
    {
        
	if (RepFile) {fclose(RepFile);return 1;}
          else {Say(E_REPCLOSE);return 0;}
    }

int CLogDocument::OnRepAdd()
    {
	 if(!RepFile) {Say(ERR_REP2 /*Rapporto non aperto*/); return 0;}
     else
	 {
       RapNum++;

       fprintf(RepFile,"%s\n",R_RAPLOG);
       fprintf(RepFile,"%s\n",reporter->GetLfName());
       fprintf(RepFile,R_RAPNUM,RapNum);
       if(AddData || AddParsed) 
		fprintf(RepFile,M_SEPARATOR1);
       string Up;
	   int mode=0;
	   if(AddParsed) mode|=ANALIZE;
       if(AddData) mode|=DUMP_HEX;
       if (!reporter->AnalyzeCurrent(mode)) return 0;
       LineCollection* up=(LineCollection*)reporter->GetLines();
       Lc2String(*up,Up,0,1);
	   fprintf(RepFile,Up);
       fprintf(RepFile,"\n+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=+=\n\n");
	   return 1;
	 } 
    }

extern void pr(LineCollection* lc);

void CLogDocument::PutOutput(LineCollection* lc)
{

 if(RepFile==NULL || MacroMode==0)
 {
#if defined WIN32 && !defined CONSOLE
	string Up;
	if (lc!=NULL) Lc2String(*lc,Up);
	else
	{
		if (reporter==NULL) {Say(ERR_RUNTIME /*Runtime Error*/);return;}
		Lc2String(*(reporter->GetLines()),Up);
	}
	CQueryApp* app=(CQueryApp*)AfxGetApp();
	if (app->c!=NULL) app->Proxy->result=Up;
	else
	if (edit) edit->SetWindowText(Up);
#else
 	if (lc!=NULL)pr(lc);
	else
	{
		if (reporter==NULL) {Say(ERR_RUNTIME /*Runtime Error*/);return;}
		pr(reporter->GetLines());
	}
#endif
 }
 else
 {
	string Up;
	if (lc!=NULL) Lc2String(*lc,Up);
	else
	{
		if (reporter==NULL) {Say(ERR_RUNTIME /*Runtime Error*/);return;}
		Lc2String(*(reporter->GetLines()),Up);
		Up+="\n";
	}
	fputs(Up,RepFile);
 }
}

#if (defined WIN32 && defined CONSOLE) || !defined WIN32
extern int likemore,rows,cols;
#endif

int CLogDocument::ParseCommand(string & command)
{
	string Parameters;
	int result;
	int i,l,j;
	if (macro_rec)
	{
		if (command!="stoprec")
		fprintf(macro_rec,"\tcommand(\"%s\");\n",(const char*)command);
	}
		l=command.GetLength();
		for(i=0;i<l;i++)
			if(command[i]==' ')
			{
				Parameters=&(command[i]);
				Parameters.TrimLeft();
				command=command.Left(i);
				command.MakeLower();
				break;
			}
		string s;
		s=Parameters;

		if(reporter) reporter->GetLines()->clear();

#if defined WIN32 && !defined CONSOLE
		CQueryApp* app=(CQueryApp*)AfxGetApp();
		if (app->c!=NULL) app->Proxy->result.Empty();
#endif

		if (command=="logopen")
		{
#if defined WIN32 
#if !defined CONSOLE
			silent=0;
			dlg->ShowWindow(SW_SHOW);
			::SetWindowPos(dlg->m_hWnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
			cdlg=dlg;
			dlg->m_Progress.SendMessage(WM_PAINT,0,0);
#endif
#else 
			Say(ERR_TIME /*Questo comando puo' richiedere molto tempo*/);
#endif
			result=OnOpen(s);
#if defined WIN32 && !defined CONSOLE
			cdlg=NULL;
			silent=1;
			dlg->ShowWindow(SW_HIDE);
#endif
		}
		else if (command=="capopen")
		{
#if defined WIN32 
#if !defined CONSOLE
			silent=0;
			dlg->ShowWindow(SW_SHOW);
			::SetWindowPos(dlg->m_hWnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
			cdlg=dlg;
			dlg->m_Progress.SendMessage(WM_PAINT,0,0);
#endif
#else 
			Say(ERR_TIME /*Questo comando puo' richiedere molto tempo*/);
#endif
			string df=lfoFileName;
			lfoFileName="";
			result=OnOpen(s);
			lfoFileName=df;
#if defined WIN32 && !defined CONSOLE
			cdlg=NULL;
			silent=1;
			dlg->ShowWindow(SW_HIDE);
#endif
		}
		else if (command=="iniopen")
			result=OpenIni(s);
		else if (command=="lfoopen")
			result=OpenLfo(s);
		else if (command=="pfoopen")
			result=OpenPfo(s);
		else if (command=="dfoopen")
			result=OpenDfo(s);
		else if (command=="ifoopen")
			result=OpenIfo(s);
		else if (command=="macro")
			result=OnLogMacro(s);
		else if (command=="repopen")
		{
			AddData=1;
			AddParsed=1;
			if (s[0]=='-' && s[1]=='d')
			{
				AddData=1;
				AddParsed=0;
				s=((const char*)s)+3;
			}
			if (s[0]=='-' && s[1]=='p')
			{
				AddData=0;
				AddParsed=1;
				s=((const char*)s)+3;
			}
			if (s[0]=='-' && s[1]=='a')
			{
				AddData=1;
				AddParsed=1;
				s=((const char*)s)+3;
			}
			if (s[0]=='-' && s[1]=='n')
			{
				AddData=0;
				AddParsed=0;
				s=((const char*)s)+3;
			}
			result=OnRepOpen(s);
		}
		else if (command=="repclose")
			result=OnRepClose();
#ifdef WIN32
		else if (command=="command")
			{system("command");result=1;}
#endif
		else if (command=="maccompile")
			{
#ifndef ENGLISH
			 s=string("ddreader ")+s;if(system(s)) return 0;
#else
			 s=string("ddreader_e ")+s;if(system(s)) return 0;
#endif
			 result=1;
			}
		else if (command=="lffcompile")
#ifndef ENGLISH
			{s=string("fdreader ")+s;if(system(s)) return 0;result=1;}
#else
			{s=string("fdreader_e ")+s;if(system(s)) return 0;result=1;}
#endif
		else if (command=="pdfcompile")
#ifndef ENGLISH
			{s=string("pdreader ")+s;if(system(s)) return 0;result=1;}
#else
			{s=string("pdreader_e ")+s;if(system(s)) return 0;result=1;}
#endif
		else if (command=="ddfcompile")
#ifndef ENGLISH
			{s=string("ddreader ")+s+" "+pfoFileName;if(system(s)) return 0;result=1;}
#else
			{s=string("ddreader_e ")+s+" "+pfoFileName;if(system(s)) return 0;result=1;}
#endif
#if (defined WIN32 && defined CONSOLE) || !defined WIN32
		else if (command=="setmore")
			{if (s[0]=='y' || s[0]=='Y')likemore=1; else likemore=0;}
#endif
		else if (command=="help")
			result=OnHelp();
#ifdef WIN32
		else if (command=="chdir")
			result=SetCurrentDirectory(s);
#endif
		else if (command=="new")
			result=OnLogNew(s);
		else if (command=="macrorec")
		{
			if (macro_rec) 
			{
				Say(ERR_MACREC /*Registrazione macro in corso*/);
				return FALSE;
			}
			macro_rec=fopen(s,"w");
			if (!macro_rec) 
			{
				Say(ERR_OUT /*Impossibile aprire il file destinazione*/);
				return FALSE;
			}
			fprintf(macro_rec,"DWORD MacroMain()\n{\n");
		}
		else if (command=="stoprec")
		{
			if (macro_rec) 
			{
				fprintf(macro_rec,"}\n");
				fclose (macro_rec);
				return TRUE;
			}
		}

// Comandi per i quali bisogna prima aprire un file di log		
		else if(erroropening || !reporter) 
		{
			Say(ERR_NOCAP /*Aprire prima un file di catture*/);
			return FALSE;
		}
		else if (command=="repadd")
			result=OnRepAdd();
		else if (command=="wcapopen")
			result=OnWCapOpen(s);
		else if (command=="wcapclose")
			result=OnWCapClose();
		else if (command=="wcapadd")
			result=OnWCapAdd();
		else if (command=="this")
			result=OnLogThis();
		else if (command=="first")
			result=OnLogFirst();
		else if (command=="last")
			result=OnLogLast();
		else if (command=="prev")
			result=OnLogPrev();
		else if (command=="next")
			result=OnLogNext();
		else if (command=="prevf")
			result=OnLogPrevf();
		else if (command=="nextf")
			result=OnLogNextf();
		else if (command=="filter")
			result=OnLogFilter(s);
		else if (command=="jump")
			{
			 result=OnLogJump(s);
			}
		else if (command=="getpos")
			result=OnLogPos();
		else if (command=="getitem")
			result=OnLogItem();
		else if (command=="getitemnr")
			{
			  result=OnGetItemNr();
			}
		else if (command=="getprotos")
			{
			  LineCollection lc;
			  if (s=="" || s=="-a")
				result=reporter->GetProtocols(lc);
			  else if (s=="-av")
				result=reporter->GetProtocols(lc,1);
			  else if (s=="-s")
				result=reporter->GetProtocolsShort(lc);
			  else if (s=="-sv")
				result=reporter->GetProtocolsShort(lc,1);
			  PutOutput(&lc);
			}
		else if (command=="getlinktype")
			{
			  LineCollection lc;
			  lc.insert("Link Type: %d",reporter->GetLinkType());
			  PutOutput(&lc);
			}
		else if (command=="query")
		{
#if defined WIN32 
#if !defined CONSOLE
			silent=0;
			dlg->ShowWindow(SW_SHOW);
			::SetWindowPos(dlg->m_hWnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_SHOWWINDOW);
			cdlg=dlg;
			dlg->m_Progress.SendMessage(WM_PAINT,0,0);
#endif
#else 
			Say(ERR_TIME /*Questo comando puo' richiedere molto tempo*/);
#endif
			result=OnLogQuery(s);
#if defined WIN32 && !defined CONSOLE
			cdlg=NULL;
			silent=1;
			dlg->ShowWindow(SW_HIDE);
#endif
		}
		else if (command=="index")
			{
			s.TrimLeft();
			j=sscanf(s,"%d %d", &i,&l);
			if(j<=1) l=-1;
			if(j<=0) i=-1;
			if(reporter && !reporter->AnalyzeShort(i,l)) {PutOutput();result=1;}
			 else result=0;
			}
		else if (command=="findex")
			{
			s.TrimLeft();
			FILE* file=fopen (s,"w");
			if (file==NULL) {Say(ERR_OUT /*Impossibile aprire il file di output*/);result=0;}
			else
			if(reporter && !reporter->AnalyzeShort(-1,-1,file)) {PutOutput();result=1;}
			 else result=0;
			if (file) fclose(file);
			}
		else if (command=="delete")
			result=OnLogDel(s);
		else if (command=="copy")
			result=OnLogCopy(s);
		else if (command=="merge")
			result=OnLogMerge(s);
		else if (command=="close")
			{OnClose();return 1;}
		else if (command=="getfltpck")
			result=GetPacketsFiltered(s);
		else if (command=="setfirstpr")
			{
			 s.TrimLeft();
			 if(reporter && reporter->pdesc.SetFirstDumpProtocol(s)) 
				{Say(ERR_PROTO /*Il protocollo non  valido*/);result=0;}
			  else result=1;
			}
		else if (command=="getfirstpr")
			{
			 if(reporter && reporter->pdesc.GetFirstDumpProtocol(s)) 
				{Say(ERR_PROTO /*Il protocollo non  valido*/);result=0;}
			  else 
			  {
				  LineCollection lc; 
				  if (s=="") lc.insert1 (ERR_NFP /*Nessun primo protocollo impostato*/);
				  else
					lc.insert(ERR_FP /*Il primo protocollo : %s*/,(const char*)s); 
				  PutOutput(&lc); 
				  result=1;
			  }
			}
		else 
		{
			Say(ERR_CMD /*Comando non supportato*/);
			return FALSE;
		}
	return result;
}

string IniName;

int CLogDocument::OpenIni(const char * iniName)
{
	CIniProcesser ini(iniName);
	int r=ini.GetIniOpened();
	IniName=iniName;
	string s;
#if defined WIN32 && !defined CONSOLE
    char directory[1000];
	if (!r) 
	{
	 if (strlen(__argv[0])<999)
	 {
		 strcpy(directory,__argv[0]);
		 for(int i=strlen(__argv[0])-1;i>=0;i--)
			 if (directory[i]=='\\' || directory[i]=='/') {directory[i+1]=='\0'; break;}
		 if (i>=0 && strlen(__argv[0])<990) 
			 {
			  strcpy (directory,iniName);
			  r=ini.GetIniOpened();
			 }
	 }
	}
	if (!ini.GetIniOpened()) 
	{
    GetWindowsDirectory(directory,990);
	 if(directory[strlen(directory)-1]!='\\')
	 {
	  strcpy(directory+strlen(directory),"\\");
	  strcpy(directory+strlen(directory),iniName);
	 }
	 else strcpy(directory+strlen(directory),iniName);
	 ini.OpenIni(directory);
	 IniName=directory;
	}
#endif
	if (!ini.GetIniOpened()) return 0;
	int val;
	if (p)
	{
		s=ini.Search("Settings","lfoName");
		if(s!="") lfoFileName=s;
		s=ini.Search("Settings","pfoName"); 
		if(s!="") pfoFileName=s;
		s=ini.Search("Settings","dfoName");
		if(s!="") dfoFileName=s;
		s=ini.Search("Settings","ifoName");
		if(s!="") ifoFileName=s;
		s=ini.Search("Settings","lfName");
		if(s!="") OnOpen(s);
		s=ini.Search("Settings","qfName");
		if(s!="") OnLogQuery(s);
		s=ini.Search("Settings","filter");
		if(s!="") OnLogFilter(s);
		s=ini.Search("Settings","CsvSep");
		if(s!="" && sscanf(s,"%x",&val)==1) CsvSep=(char)val; else CsvSep=';';
	}
		s=ini.Search("Settings","MaxItemSize");
		if(s!="") sscanf(s,"%d",&MaxItemSize);
#if (defined WIN32 && defined CONSOLE) || !defined WIN32
		s=ini.Search("Settings","rows");
		if(s!="") sscanf(s,"%d",&rows);
		s=ini.Search("Settings","cols");
		if(s!="") sscanf(s,"%d",&cols);
#endif
	return 1;
}

int CLogDocument::OnLogPos()
{
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
    int p= reporter->GetItemNumber();
	LineCollection lc;
	lc.insert (ERR_POS /*Posizione corrente: %d*/,p);
	PutOutput(&lc);
	return 1;
}

int checkfile (const char*& s)
{
		string str;
		int silent=0;
		if (s==NULL|| s[0]=='\0') {Say(ERR_FNE /*Il file specificato non esiste*/); return 1;}
		if (s[0]=='$') {silent=1;s++;}
	    FILE* f=fopen (s,"r");
		if (!f) 
		{
			if (!silent)
				Say(ERR_FNE1 /*Il file specificato non e' accessibile oppure non esiste*/); 
			return 1;
		}
		else 
		{
			if (!silent)
				Say(ERR_NEXT /*Il file verra' utilizzato per il prossimo file di catture aperto*/);
		}
		return 0;
}

int CLogDocument::OpenLfo(const char * s)
{
		if (checkfile(s)) return 0;
		lfoFileName=s;
		LineCollection lc(2,100);
		lc.insert (ERR_OKLFO /*File LFO aperto con successo*/);
		PutOutput(&lc);
		return 1;
}

int CLogDocument::OpenPfo(const char * s)
{
		if (checkfile(s)) return 0;
		pfoFileName=s;
		LineCollection lc(2,100);
		lc.insert (ERR_OKPDO /*File PDO aperto con successo*/);
		PutOutput(&lc);
		return 1;
}

int CLogDocument::OpenDfo(const char * s)
{
		if (checkfile(s)) return 0;
		dfoFileName=s;
		LineCollection lc(2,100);
		lc.insert (ERR_OKDFO /*File DFO aperto con successo*/);
		PutOutput(&lc);
		return 1;
}

int CLogDocument::OpenIfo(const char * s)
{
		if (checkfile(s)) return 0;
		ifoFileName=s;
		LineCollection lc(2,100);
		lc.insert (ERR_OKIFO /*File IFO aperto con successo*/);
		PutOutput(&lc);
		return 1;
}

int CLogDocument::OnLogJump(string & f)
{
	int n;
	if (sscanf(f,"%d",&n)!=1) {Say(ERR_JMP /*Parametro errato per il salto*/);return 0;}
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
    if (!reporter->Jump(n))
		{Say(reporter->getError());	return 0;}
	PutOutput();
	return reporter->GetPos();
}

int CLogDocument::OnGetItemNr()
{
	 LineCollection lc;
	 char tttm[50]; 
	 sprintf(tttm,ERR_PCK /*Il numero di Pacchetti e': %d*/,reporter->GetNItems());
	 lc.insert1(tttm);
	 PutOutput(&lc);
	 return 1;
}

int CLogDocument::OnWCapOpen(const char * s)
{
	if (scap) delete scap;
	if (!reporter) {Say(ERR_OCAP /*Errore di apertura del file cap. Aprire prima un file di catture.*/);return 0;}
	scap=new CSaveCap(reporter->getCrt());
	if (!scap->pcap_dump_open(s)) return 0;
	return 1;
}

int CLogDocument::OnWCapClose()
{
	if (scap) delete scap;
	scap=NULL;
	return 1;
}

int CLogDocument::OnWCapAdd()
{
	if (!scap) {Say(ERR_NOOCAP /*File di cattura/rapporto non aperto*/);return 0;}
	if (!scap->pcap_dump(reporter->getCrt())) return 1;
	return 0;
}

int CLogDocument::OnLogMacro(const char * c)
{
	CCodeVm mvm;
	LineCollection lc;
	mvm.SetLineCollection(&lc);
	MacroMode=1;
	mvm.SetLogDoc(this);
	if (mvm.OpenCode(c,1)) 
	{
		LineCollection lc; 
		lc.insert1(ERR_MACV /*Il file di macro non e' valido*/); 
		Say(ERR_EMAC /*Problemi nell'esecuzione della macro*/);
		PutOutput(&lc);
		MacroMode=0;
		return 0;
	}
	if (mvm.ExecuteProgram("MACROMAIN"))
	{
		MacroMode=0;
		return 0;
	}
	MacroMode=0;
	return 1;
}

int CLogDocument::OnHelp()
{
 LineCollection lc;
#ifndef ENGLISH 
 lc.insert1("I comandi supportati dall'analizzatore di protocolli si possono dividere in due categorie:");
 lc.insert1("1) Comandi che possono essere eseguiti sempre");
 lc.insert1(" logopen NOMEFILE");
 lc.insert1("   Apre il file NOMEFILE e lo utilizza come file di catture secondo quanto impostato nel file LFO attuale.");
 lc.insert1(" capopen NOMEFILE");
 lc.insert1("   Apre il file NOMEFILE e lo utilizza come file di catture nel formato CAP.");
 lc.insert1(" iniopen NOMEFILE");
 lc.insert1("   Apre il file NOMEFILE e lo utilizza come file INI dell'analizzatore di protocolli.");
 lc.insert1(" lfoopen NOMEFILE");
 lc.insert1("   Apre il file NOMEFILE e lo utilizza come file LFO. Tale file verra' usato per leggere i file di catture.");
 lc.insert1(" pfoopen NOMEFILE");
 lc.insert1("   Apre il file NOMEFILE e lo utilizza come file PDO. Tale file contiene la descrizione dei protocolli supportati.");
 lc.insert1(" dfoopen NOMEFILE");
 lc.insert1("   Apre il file NOMEFILE e lo utilizza come file DFO. Tale file verra' usato per stampare a video il dump dei pacchetti analizzati.");
 lc.insert1(" ifoopen NOMEFILE");
 lc.insert1("   Apre il file NOMEFILE e lo utilizza come file DFO. Tale file verra' usato per stampare a video l'indice dei pacchetti.");
 lc.insert1(" macro NOMEFILE");
 lc.insert1("   Esegue la macro nontenuta nel file NOMEFILE.");
 lc.insert1(" repopen NOMEFILE OPZIONI");
 lc.insert1("   Apre il file NOMEFILE e lo utilizza come file di rapporto testuale. Le opzioni possibili sono:");
 lc.insert1("    -d: Aggiunge al rapporto solo il dump esedecimale del pacchetto");
 lc.insert1("    -p: Aggiunge al rapporto solo l'analisi del pacchetto");
 lc.insert1("    -a: Aggiunge al rapporto sia l'analisi che il dump esedecimale del pacchetto");
 lc.insert1("    -n: Aggiunge al rapporto solo un breve commento sul pacchetto");
 lc.insert1(" repclose");
 lc.insert1("   Chiude il file di rapporto attualmente aperto.");
#ifdef WIN32
 lc.insert1(" command STRINGHE");
 lc.insert1("   Esegue il comando composto da STRINGHE utilizzando la shell di sistema.");
 lc.insert1(" chdir NOMEDIRECTORY");
 lc.insert1("   Cambia la directory corrente a NOMEDIRECTORY.");
#endif
 lc.insert1(" maccompile NOMEFILE1 NOMEFILE2");
 lc.insert1("   Compila la macro contenuta nel file NOMEFILE1 generando il file oggetto NOMEFILE2.");
 lc.insert1(" lffcompile NOMEFILE1 NOMEFILE2");
 lc.insert1("   Compila il file LFF contenuto nel file NOMEFILE1 generando il file oggetto NOMEFILE2.");
 lc.insert1(" pdfcompile NOMEFILE1 NOMEFILE2");
 lc.insert1("   Compila il file PDF contenuto nel file NOMEFILE1 generando il file oggetto NOMEFILE2.");
 lc.insert1(" ddfcompile NOMEFILE1 NOMEFILE2");
 lc.insert1("   Compila il file DFF (o il file IFF) contenuto nel file NOMEFILE1 generando il file oggetto NOMEFILE2.");
 lc.insert1(" new NOMEFILE");
 lc.insert1("   Crea un nuovo file di catture il cui nome  NOMEFILE");
#if (defined WIN32 && defined CONSOLE) || !defined WIN32
 lc.insert1(" setmore y|n");
 lc.insert1("   Imposta o rimuove la modalita' di stampa su video in modo che dopo che lo schermo e' stato riempito");
 lc.insert1("   viene chiesto all'utente di premere un tasto per continuare.");
#endif
 lc.insert1(" help");
 lc.insert1("   Visualizza l'aiuto sui comandi impartibili.");
 lc.insert1("2) Comandi che possono essere eseguiti solo quando e' stato aperto un file di catture");
 lc.insert1(" repadd");
 lc.insert1("   Aggiunge al file di rapporto attuale l'analisi del pacchetto corrente.");
 lc.insert1(" wcapopen NOMEFILE");
 lc.insert1("   Apre il file NOMEFILE e lo utilizza come file di rapporto di tipo CAP.");
 lc.insert1(" wcapclose");
 lc.insert1("   Chiude il file CAP attualmente aperto.");
 lc.insert1(" wcapadd");
 lc.insert1("   Aggiunge al file CAP attuale il pacchetto corrente.");
 lc.insert1(" this");
 lc.insert1("   Visualizza l'analisi del pacchetto corrente.");
 lc.insert1(" first");
 lc.insert1("   Visualizza l'analisi del primo pacchetto.");
 lc.insert1(" last");
 lc.insert1("   Visualizza l'analisi dell'ultimo pacchetto.");
 lc.insert1(" prev");
 lc.insert1("   Visualizza l'analisi del pacchetto precedente.");
 lc.insert1(" next");
 lc.insert1("   Visualizza l'analisi del pacchetto seguente.");
 lc.insert1(" prevf");
 lc.insert1("   Visualizza l'analisi del pacchetto precedente che soddisfa il filtro impostato.");
 lc.insert1(" nextf");
 lc.insert1("   Visualizza l'analisi del pacchetto seguente che soddisfa il filtro impostato.");
 lc.insert1(" filter STRINGA");
 lc.insert1("   Imposta il filtro di navigazione nel file di catture a STRINGA.");
 lc.insert1(" jump N1");
 lc.insert1("   Visualizza l'analisi del pacchetto di numero N1 (se disponibile).");
 lc.insert1(" getpos");
 lc.insert1("   Visualizza la posizione (il numero) del pacchetto nel file di cattura.");
 lc.insert1(" getitemnr");
 lc.insert1("   Visualizza il numero di pacchetti nel file di cattura.");
 lc.insert1(" getprotos [OPZIONE]");
 lc.insert1("   Visualizza i protocolli supportati dal file PDO attuale.");
 lc.insert1("   Se  presente una opzione vengono solo visualizzati i nomi dei protocolli.");
 lc.insert1(" query NOMEFILE");
 lc.insert1("   Esegue il file di Statistiche NOMEFILE e ne visualizza i risultati.");
 lc.insert1(" index [N1 [N2]]");
 lc.insert1("   Crea l'indice dei pacchetti contenuti nel file di catture.");
 lc.insert1("   N1 e' il pacchetto da cui l'indice iniziera'.");
 lc.insert1("   N2 e' il numero di pacchetti per cui verra' generato l'indice.");
 lc.insert1("   Se manca N1 ed N2 l'indice verra' creato per tutti i pacchetti.");
 lc.insert1("   Se manca N2 l'indice verra' creato per tutti i pacchetti dopo N1.");
 lc.insert1(" setfirstpr [NOMEPROTOCOLLO]");
 lc.insert1("   Fa in modo che il dump dei protocolli parta dal protocollo NOMEPROTOCOLLO.");
 lc.insert1("   Se tale parametro e' assente si fa in modo che il dump parta da qualunque protocollo.");
 lc.insert1(" getlinktype");
 lc.insert1("   Visualizza il numero che rappresenta il campo 'link type' contenuto ");
 lc.insert1("   nell'intestazione dei file di cattura nel formato CAP o il risultato ");
 lc.insert1("   dell'espressione seguente la parola chiave LINKTYPE contenuta nel file LFF ");
 lc.insert1("   da cui deriva il file LFO utilizzato.");
 lc.insert1(" delete N1 N2 ...");
 lc.insert1("   Cancella dal file di cattura attuale i pacchetti numero N1, N2, ...");
 lc.insert1(" copy \"NOMEFILE\" N1 N2 ...");
 lc.insert1("   Copia nel file di catture NOMEFILE (che se presente sovrascrive) i pacchetti ");
 lc.insert1("   numero N1, N2, ... contenuti nel file di cattura attuale");
 lc.insert1(" merge NOMEFILE");
 lc.insert1("   Unisce i pacchetti contenuti nel file di cattura attuale con quelli contenuti ");
 lc.insert1("   nel file di cattura di nome NOMEFILE. L'unione  fatta rispettando le informazioni");
 lc.insert1("   temporali dei singoli pacchetti.");
 lc.insert1(" getfltpck");
 lc.insert1("   Restituisce una lista dei pacchetti contenuti nel file di catture attuale che ");
 lc.insert1("   soddisfano il filtro impostato.");
#else
 lc.insert1("Commands suported by analysis engine may be divided in two categories:");
 lc.insert1("1) Commands you may execute always");
 lc.insert1(" logopen FILENAME");
 lc.insert1("   Opens file FILENAME and uses it like capture file. Capture format is specified in current LFO file");
 lc.insert1(" capopen FILENAME");
 lc.insert1("   Opens file FILENAME and uses it like capture file. Capture format is CAP");
 lc.insert1(" iniopen FILENAME");
 lc.insert1("   Opens file FILENAME and uses it like INI file.");
 lc.insert1(" lfoopen FILENAME");
 lc.insert1("   Opens file FILENAME and uses it like LFO file. This file will be used to read capture files.");
 lc.insert1(" pfoopen FILENAME");
 lc.insert1("   Opens file FILENAME and uses it like PDO file. This file contains protocols definition.");
 lc.insert1(" dfoopen FILENAME");
 lc.insert1("   Opens file FILENAME and uses it like DFO file. This file will be used to print packets analysis.");
 lc.insert1(" ifoopen FILENAME");
 lc.insert1("   Opens file FILENAME and uses it like IFO file. This file will be used to print packets index.");
 lc.insert1(" macro FILENAME");
 lc.insert1("   Executes macro contained in file FILENAME.");
 lc.insert1(" repopen FILENAME OPTIONS");
 lc.insert1("   Opens file FILENAME uses it like textual report. Options are:");
 lc.insert1("    -d: Adds to report only packet exadecimal dump");
 lc.insert1("    -p: Adds to report only packet analysis");
 lc.insert1("    -a: Adds to report packet analysis and exadecimal dump");
 lc.insert1("    -n: Adds to report only packet number");
 lc.insert1(" repclose");
 lc.insert1("   Closes file di rapporto attualmente aperto.");
#ifdef WIN32
 lc.insert1(" command STRINGS");
 lc.insert1("   Execute command STRINGS usyng system shell.");
 lc.insert1(" chdir DIRECTORY");
 lc.insert1("   Changes current directory to DIRECTORY.");
#endif
 lc.insert1(" maccompile FILENAME1 FILENAME2");
 lc.insert1("   Compiles macro file FILENAME1 and creates object file FILENAME2.");
 lc.insert1(" lffcompile FILENAME1 FILENAME2");
 lc.insert1("   Compiles LFF file whoose name is FILENAME1 and creates object file FILENAME2.");
 lc.insert1(" pdfcompile FILENAME1 FILENAME2");
 lc.insert1("   Compiles PDF file whoose name is FILENAME1 and creates object file FILENAME2.");
 lc.insert1(" ddfcompile FILENAME1 FILENAME2");
 lc.insert1("   Compiles DFF file (or IFF file) whoose name is FILENAME1 and creates object file FILENAME2.");
 lc.insert1(" new FILENAME");
 lc.insert1("   Creates  a new capture whoose name is FILENAME");
#if (defined WIN32 && defined CONSOLE) || !defined WIN32
 lc.insert1(" setmore y|n");
 lc.insert1("   Sets or removes screen paging mode.");
#endif
 lc.insert1(" help");
 lc.insert1("   Shows this message.");
 lc.insert1("2) Commands you can execute only when a capture file is opened");
 lc.insert1(" repadd");
 lc.insert1("   Adds to report current packet analysis.");
 lc.insert1(" wcapopen FILENAME");
 lc.insert1("   Opens file FILENAME and uses it like binary report.");
 lc.insert1(" wcapclose");
 lc.insert1("   Closes current binary report file.");
 lc.insert1(" wcapadd");
 lc.insert1("   Adds to current bynary report file current packet.");
 lc.insert1(" this");
 lc.insert1("   Shows current packet analysis.");
 lc.insert1(" first");
 lc.insert1("   Shows first packet analysis.");
 lc.insert1(" last");
 lc.insert1("   Shows last packet analysis.");
 lc.insert1(" prev");
 lc.insert1("   Shows previous packet analysis.");
 lc.insert1(" next");
 lc.insert1("   Shows next packet analysis.");
 lc.insert1(" prevf");
 lc.insert1("   Shows previous packet analysis wich satisfy current filter.");
 lc.insert1(" nextf");
 lc.insert1("   Shows next packet analysis wich satisfy current filter.");
 lc.insert1(" filter STRING");
 lc.insert1("   Sets current filter to STRING.");
 lc.insert1(" jump N1");
 lc.insert1("   Shows N1 packet analysis (if available).");
 lc.insert1(" getpos");
 lc.insert1("   Shows current position in capture file.");
 lc.insert1(" getitemnr");
 lc.insert1("   Shows packet number.");
 lc.insert1(" getprotos [OPTIONS]");
 lc.insert1("   Shows supported protocols.");
 lc.insert1("   If an option is present only protocol names are visualyzed.");
 lc.insert1(" query [-t] [-o:OUTFILE] FILENAME");
 lc.insert1("   Evaluate Statistics contained in file FILENAME and shows results.");
 lc.insert1(" index [N1 [N2]]");
 lc.insert1("   Shows packets index.");
 lc.insert1("   N1 is the start packet (where index begins).");
 lc.insert1("   N2 il end packet (where index ends).");
 lc.insert1("   If N1 and N2 are not present, index will be created on every packet.");
 lc.insert1("   If N2 is not present, index will be created starting from packet N1.");
 lc.insert1(" setfirstpr [PROTOCOL]");
 lc.insert1("   Sets first protocol for packet analysis to PROTOCOL.");
 lc.insert1("   If this parameter is not present first protocol is every protocol.");
 lc.insert1(" getlinktype");
 lc.insert1("   Shows value of the field 'link type' contained in capture header");
 lc.insert1("   or defined in current LFF file.");
 lc.insert1(" delete N1 N2 ...");
 lc.insert1("   Deletes packets number N1, N2, ... in current capture");
 lc.insert1(" copy \"FILENAME\" N1 N2 ...");
 lc.insert1("   Copyes packets N1, N2, ... from current capture in file FILENAME");
 lc.insert1(" merge FILENAME");
 lc.insert1("   Merges packets in current capture with packets in capture file FILENAME.");
 lc.insert1(" getfltpck");
 lc.insert1("   Shows packets satisfying current filter");
#endif
 PutOutput(&lc);
 return 1;
}

int CLogDocument::OnLogItem()
{
	if (reporter==NULL) {Say(ERR_CAPNO /*Logfile non aperto*/);return 0;}
    if (!reporter->GetCurItem())
	{Say(reporter->getError());	return 0;}
	PutOutput();
	return 1;
}

FILE* CLogDocument::GetTempFile(string &File)
{
	FILE* f=NULL;
	if (File=="")
	{
		int i;
		const char* c=getenv("TEMP");
		string s;
		if (c!=NULL) s=c; else s="\\";
		if (s[s.GetLength()-1]!='\\' || s[s.GetLength()-1]!='/') s+="\\";
		for (i=0;i<1000;i++)
		{
			char t[20];
			sprintf(t,"TMP%d.cap",i);
			File=s+t; 
			f=fopen(File,"r");
			if (f==NULL) break; else {fclose(f);}
		}
		if (f!=NULL) return NULL;
	}
	f=fopen(File,"wb");
	return f;
}

int compare( const void *arg1, const void *arg2 )
{
   if (*(int*)arg1<*(int*)arg2) return -1;
   if (*(int*)arg1==*(int*)arg2) return 0;
   return 1;
}

void CLogDocument::OnClose()
{
	p->filter="TRUE";
	if (reporter!=NULL)delete reporter;
      reporter=NULL;
}

int CLogDocument::OnCapOpen(string & fileName)
{
	string str;
	str=lfoFileName;
	lfoFileName="";
	int ret=OnOpen(fileName);
	lfoFileName=str;
	return ret;
}

int CLogDocument::OnLogMerge(string & s)
{

	string fileName;
	int IsTemp=1;
	fileName=GetFileNameFromString(s,IsTemp);
	FILE* f=GetTempFile(fileName);
	CSaveCap save(NULL);
	int lt=reporter->GetLinkType();
#ifndef WIN32
	save.pcap_dump_open(f,lt);
#else
	fclose(f);
	f=NULL;
	if (save.pcap_dump_open(fileName,lt)==NULL) 
	{
		Say(ERR_MERGE /*Il merge  impossibile in quanto il file destinazione non  accessibile*/);
		return 0;
	}
#endif
	int ni=reporter->GetNItems();
	reporter->First();
	item *ir=reporter->getCrt();
	item imm,*im=&imm;
	CCap merge(im);
#ifndef WIN32
	FILE* f2=fopen (s,"rb");
	if (f2==NULL) 
	{
		Say(ERR_MERGE /*Il merge  impossibile in quanto il file destinazione non  accessibile*/);
		return 0;
	}
	merge.pcap_open_offline(f2);
#else
	if (merge.pcap_open_offline(s)==NULL)
	{
		Say(ERR_MERGE /*Il merge  impossibile in quanto il file destinazione non  accessibile*/);
		return 0;
	}
#endif
	if (merge.GetLinkType()!=lt)
	{
		if(Ask(ERR_LINK /*Il tipo di rete da cui i pacchetti sono stati catturati  diverso. Si vuole continuare?*/)==IDNO) 
			return 1; 
	}
	int c1,i;
	if(!merge.pcap_next_packet())
		c1=1; else c1=0;
	for (i=0;i<ni || c1;)
	{
		if (i<ni && c1)
		{
			if (ir->secs<im->secs || (ir->secs==im->secs && ir->usecs<im->usecs))
			{
				save.pcap_dump(ir);
				if(reporter->nextItem()) i++;
				else i=ni;
			}
			else
			{
				save.pcap_dump(im);
				if(!merge.pcap_next_packet()) c1=1; 
				else c1=0;
			}
			
		}
		else if (c1)
		{
			save.pcap_dump(im);
			if(!merge.pcap_next_packet()) c1=1; 
			else c1=0;
		}
		else
		{
			save.pcap_dump(ir);
			if(reporter->nextItem()) i++;
			else i=ni;
		}
	}
	merge.pcap_close();
	save.pcap_dump_close();
	return ReOpenCap(fileName,IsTemp);
}

int CLogDocument::ReOpenCap(string & fileName, int IsTemp)
{
	if (IsTemp)
	{
		if (reporter && reporter->IsCap())
		{
			string str=(char*)reporter->GetLogName();
			OnClose();
			if (remove(str) || rename(fileName,str))
			{
				str=(string) ERR_S1 /*Non  stato possibile rimuovere il file: */
					+ str+ 
					(string) ERR_S2 /*. Il nuovo file di catture ha la seguente path: */
					+ fileName +
					(string) ERR_S3 /*. Assicurarsi di rinominarlo o rimuoverlo dopo l'uso.*/;
				Say(str);
				return OnCapOpen(fileName); 
			};
			return OnCapOpen(str);
		}
		else 
		{
			OnClose();
			string str;
			str=(string) ERR_S4 /*E' stato creato il file: */
				+ fileName+ 
				(string) ERR_S5 /*. Assicurarsi di rinominarlo o rimuoverlo dopo l'uso.*/;
			Say(str);
			int ret=OnCapOpen(fileName);
			return ret;
		}
	}
	else
	{
			OnClose();
			return OnCapOpen(fileName);
	}
}

int CLogDocument::Str2VecInt(string & s, vector<int> &dels)
{
	int i,j,l,found,n;
	l=strlen(s);
	found=0;
	n=0;
	for (i=0,j=0;i<l;i++)
	{
		if (s[i]<'0' && s[i]>9) 
		{
			if (found) 
				if (sscanf(((const char*)s)+j,"%d",&dels[n])) 
					n++; 
			j=i+1; 
			found=0;
		}
		else found=1;
	}
	if (found) 
		if (sscanf(((const char*)s)+j,"%d",&dels[n])) n++; 
	if (n==0) {Say(ERR_PCKS /*Non sono stati specificati pacchetti validi*/);return 0;}
	else
	{
	  qsort( (void *)(int*)dels, n, sizeof(int), compare );
	}
	return 1;
}

string CLogDocument::GetFileNameFromString(string & s, int& IsTemp)
{
	string fileName;
	int i;
	s.TrimLeft();
	IsTemp=1;
	if (s[0]=='-' && s[1]=='f')
	{
		if (s[2]=='"')
		{
			for(i=3;i<s.GetLength();i++)
				if (s[i]=='"') 
				{
					fileName=s.Left(i);
					fileName=((const char*) fileName)+3;
					IsTemp=0;
					break;
				}
		}
		else
		{
			for(i=2;i<s.GetLength();i++)
				if (s[i]==' ')
				{
					fileName=s.Left(i);
					fileName=((const char*) fileName)+2;
					IsTemp=0;
					break;
				}
		}
		s=((char*)s)+i+1;
	}
	return fileName;
}

int CLogDocument::OnLogDel(string & s)
{
	return OnLogCopyDel(s,0);
}

int CLogDocument::OnLogCopy(string & s)
{
	return OnLogCopyDel(s,1);
}

int CLogDocument::OnLogCopyDel(string & s,int IsCopy)
{
	vector<int> dels;
	int i,j,n,IsTemp=1;

	string fileName;
	fileName=GetFileNameFromString(s,IsTemp);
	FILE* f=GetTempFile(fileName);
	if(!Str2VecInt(s,dels)) return 0;
	n=dels.get_n_el();
	CSaveCap save(reporter->getCrt());
	int lt=reporter->GetLinkType();
#ifndef WIN32
	save.pcap_dump_open(f,lt);
#else
	fclose(f);
	f=NULL;
	if (save.pcap_dump_open(fileName,lt)==NULL) 
	{
		Say(ERR_MERGE /*Il merge  impossibile in quanto il file destinazione non  accessibile*/);
		return 0;
	}
#endif
	int ni=reporter->GetNItems();
	reporter->First();
	j=0;
	item* it=reporter->getCrt();
	while (dels[j]<=0) {j++;if (j>=n) break;}
	if (IsCopy && dels[j]==1) {save.pcap_dump(it);j++;}
	else if (!IsCopy && dels[j]!=1) {save.pcap_dump(it);}
	else if (!IsCopy) j++;
	for(i=2;i<=ni;i++)
	{
		if(!reporter->nextItem()) it=NULL;
		if (IsCopy && dels[j]==i) 
		{
			save.pcap_dump(it);
			j++;
			if (j>=n) dels[j]=-1;
		}
		else if (!IsCopy && dels[j]!=i)
		{
			save.pcap_dump(it);
		}
		else if (!IsCopy) 
		{
			j++;
			if (j>=n) dels[j]=-1;
		}
	}
	save.pcap_dump_close();
	if (IsCopy) 
	{
		if (IsTemp) {s=
			(string) ESS_SS1 /*E' stato creato il file: */
			+ fileName + 
			(string) ERR_SS2 /*. Assicurarsi di rinominarlo o eliminarlo dopo l'uso.*/;
			Say (s);}
		return 1;
	}
	return ReOpenCap(fileName,IsTemp);
}

int CLogDocument::OnLogNew(string & s)
{
	vector<int> dels;
	int IsTemp=1;

	string fileName;
	fileName=GetFileNameFromString(s,IsTemp);
	FILE* f=GetTempFile(fileName);
	CSaveCap save(NULL);
#ifndef WIN32
	save.pcap_dump_open(f,1);
#else
	fclose(f);
	f=NULL;
	if (save.pcap_dump_open(fileName,1)==NULL) 
	{
		Say(ERR_MERGE /*Il merge  impossibile in quanto il file destinazione non  accessibile*/);
		return 0;
	}
#endif
	save.pcap_dump_close();
	return ReOpenCap(fileName,IsTemp);
}

int CLogDocument::GetPacketsFiltered(string &s)
{
  FILE* f;
  if (s!="")
  {
	if (s=="-") f=stdout;
	else f=fopen(s,"w");
	if (f==NULL)
	{
		Say(ERR_OUT /*Impossibile aprire il file destinazione*/);
		return 0;
	}
    int p= reporter->GetItemNumber();
	vector<int> v;
	int n;
	n=reporter->GetFilteredPackets(v);
	if (n<0) return 0;
	int j=0;
	for (int i=0;i<n;i++,j++)
	{
		fprintf(f,"%d ",v[i]);
		if (j==9)
		{
			fprintf(f,"\n");
			j=-1;
		}
	}
	fprintf(f,"\n");
	if (f!=stdout) fclose(f);
		else fflush(stdout);
	return 1;
  }
  else
  {
    int p= reporter->GetItemNumber();
	LineCollection lc;
	vector<int> v;
	int n;
	n=reporter->GetFilteredPackets(v);
	if (n<0) return 0;
	string s="";
	char t[20];
	int j=0;
	for (int i=0;i<n;i++,j++)
	{
		sprintf(t,"%d ",v[i]);
		s+=t;
		if (j==9)
		{
			lc.insert1(s);
			j=-1;
			s="";
		}
	}
	lc.insert1(s);
	PutOutput(&lc);
	return 1;
  }
}
