/****************************************************************************
			      PACKET PARSER - PARSER
				  (C) 1998 by VIANO PIERO
 ****************************************************************************/

%{
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "../../comuni/vec_cl.h"
#include "../../comuni/stack_cl.h"
#include "../../comuni/protocol.h"
#include "../../comuni/protocolvect.h"
#include "l_structs.h"
#include "../../comuni/codeprocessor.h"
#include "../../comuni/asksay.h"

#ifndef ENGLISH
#define ERR_NTL "Nome troppo lungo"
#define ERR_PRUNDEF "Protocollo non definito"
#define ERR_IP "Nella notazione XXX.XXX.XXX.XXX i numeri devono errere compresi tra 0 e 255"
#define ERR_FIELD "Impossibile accedere ad un campo non definito"
#define ERR_VAR "Impossibile accedere ad una variabile non definita"
#define ERR_PROTO "Impossibile accedere ad un protocollo non definito"
#define ERR_LINE "Errore alla linea %d: %s"
#define ERR_LINE1 "Errore di analisi del sorgente alla linea %d\n%s\n"
#define ERR_WARN "Warning alla linea %d: %s"
#define ERR_WARN1 "Warning alla linea %d\n%s\n"
#else
#define ERR_NTL "Name too long"
#define ERR_PRUNDEF "Protocol not defined"
#define ERR_IP "In XXX.XXX.XXX.XXX notation, numbers must be from 0 and 255"
#define ERR_FIELD "Field not defined"
#define ERR_VAR "Variable not defined"
#define ERR_PROTO "Protocol not defined"
#define ERR_LINE "Error in line %d: %s"
#define ERR_LINE1 "Error in line %d\n%s\n"
#define ERR_WARN "Warning in line %d: %s"
#define ERR_WARN1 "Warning in line %d\n%s\n"
#endif

#ifndef max
#define max(a,b) ((a)>(b))?(a):(b)
#endif
extern void EndParsing();
extern int yylex();
extern char* yytext;
int genvars;
vector <Cost> *costanti;
int nc=0;
vector <istruzione> *ist;
int i_ind=0;
vector <int> *crea_vars;
int c_ind=0;
LineCollection* lcp=NULL;
int yyerror(char*);

int errorflag=0;
ProtocolVect *proto;


char* agg_nome(char* c)
{
	if (strlen(c)>=MAXSTRING) 
	{
		c[MAXSTRING-1]='\0';
		Say(ERR_NTL /*Nome troppo lungo*/);
	}
	for(int i=0;i<(signed)strlen(c);i++)
		if(c[i]>='a' && c[i]<='z') c[i]+='A'-'a';
	return c;
}

int FindProto(const char* nome)
{
	int i;
	int num_pr=proto->GetSize();
	for(i=0;i<num_pr;i++)
		if (strcmp(nome,(*proto)[i].GetName())==0) return i;
	return -1;
}

p_struct * FindPrVar(const char* p, const char* v, int& pr)
{
	int num_var_pr;
	if(!p||!v) return NULL;
	pr=FindProto(p);
	if(pr<0) return NULL;
	p_struct * ps= (*proto)[pr].GetPS(num_var_pr);
	for(pr=0;pr<num_var_pr;pr++)
	 if(strcmp(ps[pr].nome,v)==0)
	 {
	  return ps;
	 }
    return NULL;
}

%}

%token NOME
%token LIT_CH
%token SIZEOF
%token OFFSETOF
%token GETVMVAR
%token CONTAINHEX
%token CONTAINASCII
%token GETDATALEN
%token NUMERO
%token COST_STRINGA
%token C_H_NUM
%token C_O_NUM
%token TOK_TRUE
%token TOK_FALSE
%token TOK_CANTTELL

%start espressione

%left OR
%left AND
%left '=',NOT_EQ,'<','>',MIU,MAU
%left LSHIFT,RSHIFT
%left '+','-'
%left '*','/','%'
%right NOT,MENO_UNARIO

%union {
	 prnome pn;
	 nome n;
	 intero i;
	}

%type <i> espressione, numero, num, cost_str
%type <n> nome
%type <pn> campo

%%
	/* DEFINIZIONI GENERALI */

nome		: NOME
			  {
			   strcpy($$.nome,agg_nome(yytext));
			   genvars=1;
			  }
			  ;
campo		: nome '.' nome
			  {
			   int i=FindProto($1.nome);
			   if (i<0) yyerror(ERR_PRUNDEF /*Protocollo non definito*/);
			   else
			   {
				 (*crea_vars)[c_ind]=i;
				 c_ind++;
			   }
			   strcpy($$.prnome,$1.nome);
			   strcpy($$.nome,$3.nome);
			  }
cost_str	: COST_STRINGA 
				{
				 yytext[strlen(yytext)-1]='\0';
				 (*costanti)[nc]=yytext+1;
				 $$.i=nc;
				 nc++;
				}
				;
num			: NUMERO 
			  {
			   int num;
			   sscanf(yytext,"%d",&num);
			   $$.i=num;
			   if (num<=0xFF) $$.s=1;
			   else if (num<=0xFFFF) $$.s=2;
			   else $$.s=4;
			  };
numero		: num 
			  {
			    $$.i=$1.i;
				$$.s=$1.s;
			  }
			| num '.' num '.' num '.' num
			  {
			    $$.s=4;
				if ($1.s>1 || $3.s>1 || $5.s>1 || $7.s>1)
				yyerror (ERR_IP /*Nella notazione XXX.XXX.XXX.XXX i numeri devono errere compresi tra 0 e 255*/);
				$$.i=($1.i<<24)+($3.i<<16)+($5.i<<8)+$7.i;
			  }
			| C_H_NUM 
			  {
			   int num;
			   sscanf(yytext+2,"%x",&num);
			   $$.i=num;
			   if (num<=0xFF) $$.s=1;
			   else if (num<=0xFFFF) $$.s=2;
			   else $$.s=4;
			  }
			| C_O_NUM 
			  {
			   int num;
			   sscanf(yytext+1,"%o",&num);
			   $$.i=num;
			   if (num<=0xFF) $$.s=1;
			   else if (num<=0xFFFF) $$.s=2;
			   else $$.s=4;
			  }
			| LIT_CH
			  {
			   $$.i = yytext[1]; 
			   $$.s=1;
			  }
			;
espressione : campo
			  {
			   int indice;
			   const char* ct=$1.nome;
				  p_struct* p_str;
				  p_str=FindPrVar($1.prnome,$1.nome,indice);
				  if (p_str!=NULL)
				  {
				   (*ist)[i_ind].ist_number=I_PUSH;
				   (*ist)[i_ind].p1=FindProto($1.prnome);
				   i_ind++;
				   (*ist)[i_ind].ist_number=I_PUSH_VAR;
				   (*ist)[i_ind].p1=indice;
				   i_ind++;
				   $$.i=indice;
				   ct=NULL;
				  }
			   if (ct!=NULL) 
			    yyerror(ERR_FIELD /*Impossibile accedere ad un campo non definito*/);
			  }
			| numero
			  {
			   int num=$1.i;
			   (*ist)[i_ind].ist_number=I_PUSH;
			   (*ist)[i_ind].p1=num;
			   i_ind++;
			   $$.s=$1.s;
			   $$.i=-1;
			  }
			| TOK_TRUE
			  {
			   (*ist)[i_ind].ist_number=I_PUSH;
			   (*ist)[i_ind].p1=0xFFFFFFFF;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| TOK_FALSE
			  {
			   (*ist)[i_ind].ist_number=I_PUSH;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| TOK_CANTTELL
			  {
			   (*ist)[i_ind].ist_number=I_CANTTELL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| '(' espressione ')' 
			  {
			   $$.s=$2.s;
			   $$.i=-1;
			  }
			| espressione '+' espressione 
			  {
			   (*ist)[i_ind].ist_number=I_PLUS;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| espressione LSHIFT espressione 
			  {
			   (*ist)[i_ind].ist_number=I_LSHIFT;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=($1.s);
			   $$.i=-1;
			  }
			| espressione RSHIFT espressione 
			  {
			   (*ist)[i_ind].ist_number=I_RSHIFT;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=($1.s);
			   $$.i=-1;
			  }
			| espressione NOT_EQ espressione 
			  {
			   (*ist)[i_ind].ist_number=I_NOT_EQUAL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione MIU espressione 
			  {
			   (*ist)[i_ind].ist_number=I_MIN_EQUAL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione MAU espressione 
			  {
			   (*ist)[i_ind].ist_number=I_MAG_EQUAL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione '<' espressione 
			  {
			   (*ist)[i_ind].ist_number=I_MIN;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione '>' espressione 
			  {
			   (*ist)[i_ind].ist_number=I_MAG;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione '=' espressione 
			  {
			   (*ist)[i_ind].ist_number=I_EQUAL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione AND espressione 
			  {
			   (*ist)[i_ind].ist_number=I_AND;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione OR espressione 
			  {
			   (*ist)[i_ind].ist_number=I_OR;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| espressione '-' espressione 
			  {
			   (*ist)[i_ind].ist_number=I_MINUS;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| espressione '*' espressione 
			  {
			   (*ist)[i_ind].ist_number=I_MUL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| espressione '/' espressione 
			  {
			   (*ist)[i_ind].ist_number=I_DIV;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| espressione '%' espressione 
			  {
			   (*ist)[i_ind].ist_number=I_MOD;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=max($1.s,$3.s);
			   $$.i=-1;
			  }
			| '-' espressione 
			  {
			   (*ist)[i_ind].ist_number=I_UN_MINUS;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=$2.s;
			   $$.i=-1;
			  }
			| NOT espressione
			  {
			   (*ist)[i_ind].ist_number=I_NOT;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   $$.s=4;
			   $$.i=-1;
			  }
			| SIZEOF '(' campo ')'
			  {
			   int indice;
			   const char* ct=$3.nome;
			    {
				  p_struct* p_str;
				  p_str=FindPrVar($3.prnome,$3.nome,indice);
				  if (p_str!=NULL)
				    {
					(*ist)[i_ind].ist_number=I_PUSH;
					(*ist)[i_ind].p1=p_str->size;
					i_ind++;
					ct=NULL;
					}
				}
			   if (ct!=NULL) 
			    yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			  }
			| nome
			  {
				  int i=FindProto($1.nome);
				  if (i>=0)
				    {
						(*ist)[i_ind].ist_number=I_P_VISITED;
						(*ist)[i_ind].p1=i;
						i_ind++;
					}
					else yyerror(ERR_PROTO /*Impossibile accedere ad un protocollo non definito*/);
			  }
			| GETDATALEN '(' nome ')'
			  {
				  int i=FindProto($3.nome);
				  if (i>=0)
				    {
						(*ist)[i_ind].ist_number=I_GETDATALEN;
						(*ist)[i_ind].p1=i;
						i_ind++;
					}
					else yyerror(ERR_PROTO /*Impossibile accedere ad un protocollo non definito*/);
			  }
			| SIZEOF '(' nome ')'
			  {
				  int i=FindProto($3.nome);
				  if (i>=0)
				    {
						(*ist)[i_ind].ist_number=I_PUSH;
						(*ist)[i_ind].p1=(*proto)[i].GetSize();
						i_ind++;
					}
					else yyerror(ERR_PROTO /*Impossibile accedere ad un protocollo non definito*/);
			  }
			| GETVMVAR '(' cost_str ')'
			  {
			   (*ist)[i_ind].ist_number=I_E_GETVMVAR;
			   (*ist)[i_ind].p1=$3.i;
			   i_ind++;
			  }
			| CONTAINHEX '(' cost_str ')'
			  {
			   (*ist)[i_ind].ist_number=I_E_CONTAINHEX;
			   (*ist)[i_ind].p1=$3.i;
			   i_ind++;
			  }
			| CONTAINASCII '(' cost_str ')'
			  {
			   (*ist)[i_ind].ist_number=I_E_CONTAINASCII;
			   (*ist)[i_ind].p1=$3.i;
			   i_ind++;
			  }
			;

%%

extern int yylineno;
int yylineno_offset;

int yyerror(char* s)
{
 char t[1000];
 if (lcp) lcp->insert(ERR_LINE /*Errore alla linea %d: %s*/,yylineno+yylineno_offset,s);
 else 
 {
  sprintf(t,ERR_LINE1 /*Errore di analisi del sorgente alla linea %d\n%s\n*/,yylineno+yylineno_offset,s);
  Say(t);
 }
 if(strcmp(s,"syntax error")==0) EndParsing();
 errorflag=1;
 return 1;
}

int yywarn(char* s)
{
 char t[1000];
 if (s==NULL) s="";
 if (lcp) lcp->insert(ERR_WARN /*Warning alla linea %d: %s*/,yylineno+yylineno_offset,s);
 else 
 {
  sprintf(t,ERR_WARN1 /*Warning alla linea %d\n%s\n*/,yylineno+yylineno_offset,s);
  Say(t);
 }
 return 1;
}
