%{
/**********************************************************************
		SCANNER PER IL LINGUAGGIO DEL PARSER
		    (C) 1998 - VIANO PIERO
 **********************************************************************/

#include <stdio.h>
#include <string.h>
#include "l_structs.h"
#include "parser.h"
#include "../../comuni/asksay.h"

#ifdef WIN32
#define YY_NEVER_INTERACTIVE 1
#endif

#ifdef CHECK_L
#ifdef CHECK_L_C
#define CHSAY(A) printf("%s\n",A);
#else
#define CHSAY(A) Say(A)
#endif
#else 
#define CHSAY(A) 
#endif

#define SC_ERROR -1

char* TextToParse;
static int current=0;

void GetLine(char* buf,int &result,int max_size)
{
	result=YY_NULL;
	int i;
	if(TextToParse==NULL||current>=(signed)strlen(TextToParse)) 
	 {result=0;YY_FLUSH_BUFFER;buf[0]=EOF;return;}
	else if(current<(signed)strlen(TextToParse)) 
	{
		for(i=0;i<max_size&&i<=(signed)strlen(TextToParse)-current;i++)
		buf[i]=TextToParse[current+i];
		result=i;
		current+=max_size;
	}
}

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) GetLine(buf,result,max_size)

%}

%option yylineno
%option caseless

SPAZIO ([\t\r\n ])
SPAZI ({SPAZIO}*)
LETTER ([a-zA-Z])
DIGIT ([0-9])
F_DIGIT ([1-9])
DECIMALE ({DIGIT}*{F_DIGIT}|0)
FINO_FINE ([^\n]*)
R_REM (\/\/)

HEX ((("0x")|("0X"))([a-fA-F]|{DIGIT})+)
OCT (("0")([0-7])+)
INTERO ({F_DIGIT}{DIGIT}*)
VAR_NAME ((("_")|{LETTER})({LETTER}|{DIGIT}|("_"))*)

COST_STRINGA (\"[^\"\n]*\")
COST_INT_CORTO ({INTERO}|[0])

QUOTE	\'([^\\']|\\[^'\\]+|\\\\)\'
OP	([-+=*/<>(),.%])

VAR ({VAR_NAME})

COMMENTO ("/*"([^*]*|"*"+[^*/])"*"+\/)
COMMENTO_L ("//".*)
COMMENTO_P (";".*)

%%
\xd	/* Scarta LF*/
{COMMENTO}	{ CHSAY("Commenti");/* Scarta commenti */ }
{COMMENTO_L}	{ CHSAY("Commenti_L");/* Scarta commenti */ }
{COMMENTO_P}	{ CHSAY("Commenti_P");/* Scarta commenti */ }

sizeof	{CHSAY("SIZEOF");return SIZEOF; }
offsetof	{CHSAY("OFFSETOF");return OFFSETOF; }
getvmvar	{CHSAY("GETVMVAR");return GETVMVAR; }
containhex	{CHSAY("CONTAINHEX");return CONTAINHEX; }
containascii	{CHSAY("CONTAINASCII");return CONTAINASCII; }
getdatalen	{CHSAY("GETDATALEN");return GETDATALEN; }
{COST_INT_CORTO}	{CHSAY("N_IC"); return NUMERO; }
{COST_STRINGA}	{CHSAY("COST_STRINGA"); return COST_STRINGA; }
{HEX}	{CHSAY("N_HEX"); return C_H_NUM; }
{OCT}	{CHSAY("N_OCT"); return C_O_NUM; }
{QUOTE}	{CHSAY("CHARACT"); return LIT_CH; }
AND {CHSAY("AND");return AND;}
"&" {CHSAY("AND");return AND;}
"&&" {CHSAY("AND");return AND;}
OR {CHSAY("OR");return OR;}
"|" {CHSAY("OR");return OR;}
"||" {CHSAY("OR");return OR;}
NOT {CHSAY("NOT");return NOT;}
"!" {CHSAY("NOT");return NOT;}
"~" {CHSAY("NOT");return NOT;}
TRUE {CHSAY("TRUE");return TOK_TRUE;}
FALSE {CHSAY("FALSE");return TOK_FALSE;}
CANTTELL {CHSAY("CANTTELL");return TOK_CANTTELL;}
{OP}	{CHSAY(yytext); return *yytext; }
"=="	{CHSAY("=="); return '='; }
"!="	{CHSAY("!="); return NOT_EQ; }
">="	{CHSAY(">="); return MAU; }
"<="	{CHSAY("<="); return MIU; }
"<<"	{CHSAY("<<"); return LSHIFT; }
">>"	{CHSAY(">>"); return RSHIFT; }
{VAR}	{CHSAY("NOME");return NOME;}


{SPAZIO}+ {/*ignora gli spazi*/}

. {/*Ignora tutto il resto*/}
%%

extern int nc,errorflag;
extern int i_ind,c_ind;

void EndParsing()
{
	YY_FLUSH_BUFFER;
	//nc=0;
	if(errorflag) {c_ind=0;i_ind=0;}
	errorflag=0;
	current=0;
	TextToParse=NULL;
}

extern int yyparse();
extern vector <int> *crea_vars;

int BeginParsing()
{
	nc=0;
	current=0;
	errorflag=0;
	i_ind =0;
	for(;c_ind>=0;c_ind--) (*crea_vars)[c_ind]=0;
	c_ind=0;
	return yyparse();
}

int yywrap()
{
 YY_FLUSH_BUFFER;
 //nc=0;
 TextToParse=NULL;
 current=0;
 return 1;
}

