#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include "../../comuni/vec_cl.h"
#include "../../comuni/stack_cl.h"
#include "../../comuni/protocol.h"
#include "../../comuni/protocolvect.h"
#include "l_structs.h"
#include "../../comuni/codeprocessor.h"
#include "../../comuni/asksay.h"

#ifndef ENGLISH
#define ERR_NTL "Nome troppo lungo"
#define ERR_PRUNDEF "Protocollo non definito"
#define ERR_IP "Nella notazione XXX.XXX.XXX.XXX i numeri devono errere compresi tra 0 e 255"
#define ERR_FIELD "Impossibile accedere ad un campo non definito"
#define ERR_VAR "Impossibile accedere ad una variabile non definita"
#define ERR_PROTO "Impossibile accedere ad un protocollo non definito"
#define ERR_LINE "Errore alla linea %d: %s"
#define ERR_LINE1 "Errore di analisi del sorgente alla linea %d\n%s\n"
#define ERR_WARN "Warning alla linea %d: %s"
#define ERR_WARN1 "Warning alla linea %d\n%s\n"
#else
#define ERR_NTL "Name too long"
#define ERR_PRUNDEF "Protocol not defined"
#define ERR_IP "In XXX.XXX.XXX.XXX notation, numbers must be from 0 and 255"
#define ERR_FIELD "Field not defined"
#define ERR_VAR "Variable not defined"
#define ERR_PROTO "Protocol not defined"
#define ERR_LINE "Error in line %d: %s"
#define ERR_LINE1 "Error in line %d\n%s\n"
#define ERR_WARN "Warning in line %d: %s"
#define ERR_WARN1 "Warning in line %d\n%s\n"
#endif

#ifndef max
#define max(a,b) ((a)>(b))?(a):(b)
#endif
extern void EndParsing();
extern int yylex();
extern char* yytext;
int genvars;
vector <Cost> *costanti;
int nc=0;
vector <istruzione> *ist;
int i_ind=0;
vector <int> *crea_vars;
int c_ind=0;
LineCollection* lcp=NULL;
int yyerror(char*);

int errorflag=0;
ProtocolVect *proto;


char* agg_nome(char* c)
{
	if (strlen(c)>=MAXSTRING) 
	{
		c[MAXSTRING-1]='\0';
		Say(ERR_NTL /*Nome troppo lungo*/);
	}
	for(int i=0;i<(signed)strlen(c);i++)
		if(c[i]>='a' && c[i]<='z') c[i]+='A'-'a';
	return c;
}

int FindProto(const char* nome)
{
	int i;
	int num_pr=proto->GetSize();
	for(i=0;i<num_pr;i++)
		if (strcmp(nome,(*proto)[i].GetName())==0) return i;
	return -1;
}

p_struct * FindPrVar(const char* p, const char* v, int& pr)
{
	int num_var_pr;
	if(!p||!v) return NULL;
	pr=FindProto(p);
	if(pr<0) return NULL;
	p_struct * ps= (*proto)[pr].GetPS(num_var_pr);
	for(pr=0;pr<num_var_pr;pr++)
	 if(strcmp(ps[pr].nome,v)==0)
	 {
	  return ps;
	 }
    return NULL;
}

typedef union {
	 prnome pn;
	 nome n;
	 intero i;
	} YYSTYPE;
#define NOME 257
#define LIT_CH 258
#define SIZEOF 259
#define OFFSETOF 260
#define GETVMVAR 261
#define CONTAINHEX 262
#define CONTAINASCII 263
#define GETDATALEN 264
#define NUMERO 265
#define COST_STRINGA 266
#define C_H_NUM 267
#define C_O_NUM 268
#define TOK_TRUE 269
#define TOK_FALSE 270
#define TOK_CANTTELL 271
#define OR 272
#define AND 273
#define NOT_EQ 274
#define MIU 275
#define MAU 276
#define LSHIFT 277
#define RSHIFT 278
#define NOT 279
#define MENO_UNARIO 280
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    4,    5,    3,    2,    1,    1,    1,    1,    1,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
short yylen[] = {                                         2,
    1,    3,    1,    1,    1,    7,    1,    1,    1,    1,
    1,    1,    1,    1,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
    2,    2,    4,    1,    4,    4,    4,    4,    4,
};
short yydefred[] = {                                      0,
    1,    9,    0,    0,    0,    0,    0,    4,    7,    8,
   12,   13,   14,    0,    0,    0,    0,   11,    0,    0,
   10,    0,    0,    0,    0,    0,    0,   32,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    3,    0,
    0,    0,    0,   15,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   28,   29,   30,    0,
    2,   36,   33,   37,   38,   39,   35,    0,    0,    0,
    6,
};
short yydgoto[] = {                                      17,
   18,   19,   50,   20,   21,
};
short yysindex[] = {                                    154,
    0,    0,  -34,  -29,  -27,  -23,   -8,    0,    0,    0,
    0,    0,    0,  154,  154,  154,  -33,    0,  -39,  -28,
    0, -238, -232, -232, -232, -238,  -12,    0,  -21,  154,
  154,  154,  154,  154,  154,  154,  154,  154,  154,  154,
  154,  154,  154,  154, -229, -238,  -41,   11,    0,   16,
   18,   25,   32,    0,  122,  129,  150,  150,  150,  150,
  150,  150,  161,  161,  -12,  -12,    0,    0,    0,   35,
    0,    0,    0,    0,    0,    0,    0, -229,   40, -229,
    0,
};
short yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    1,    8,
    0,    0,    0,    0,    0,    0,   15,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   33,   31,   65,   71,   79,   87,
   93,  101,   23,   54,   37,   47,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,
};
short yygindex[] = {                                    186,
    0,   22,  -22,   91,   67,
};
#define YYTABLESIZE 433
short yytable[] = {                                      72,
    5,   51,   52,   44,   46,   22,   45,   34,   42,   40,
   23,   41,   24,   43,   31,   44,   25,   46,    1,   54,
   42,   40,   17,   41,   44,   43,   34,   32,   35,   42,
   25,   26,   26,   49,   43,    8,   16,    5,   34,   32,
   35,    5,    5,    5,   34,    5,   27,    5,   34,   34,
   34,   73,   34,   18,   34,   31,   74,   31,   75,   31,
    5,    5,    5,   17,   24,   76,   70,   34,   34,   34,
   19,   25,   77,   26,   31,   31,   31,   16,   22,   16,
   78,   16,   17,   17,   17,   80,   23,   27,   48,   27,
    0,   27,   20,    0,   18,    0,   16,   16,   16,   79,
   21,   81,    0,    0,    0,   24,   27,   27,   27,    0,
    0,   19,   47,   18,   18,   18,   53,    0,    0,   22,
    0,    0,    0,    0,   24,   24,   24,   23,    0,    0,
   19,   19,   19,   20,    0,    0,   71,    0,   22,   22,
   22,   21,    0,    0,    0,    0,   23,   23,   23,    0,
    0,    0,   20,   20,   20,    0,    0,    0,   44,    0,
   21,   21,   21,   42,   40,   44,   41,    0,   43,    0,
   42,   40,    0,   41,    0,   43,    0,    0,    0,    0,
    0,   34,   32,   35,    0,    0,   44,    0,   34,   32,
   35,   42,   40,   16,   41,    0,   43,   44,   14,   27,
   28,   29,   42,   40,    0,   41,    0,   43,    0,    0,
    0,    0,    0,    0,    0,   55,   56,   57,   58,   59,
   60,   61,   62,   63,   64,   65,   66,   67,   68,   69,
    0,    0,    0,    0,    0,    0,    0,    0,   30,   31,
   33,   36,   37,   38,   39,    0,    0,    0,    0,    0,
   30,   31,   33,   36,   37,   38,   39,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    5,    5,    5,    5,    5,    5,    5,   34,
   34,   34,   34,   34,   34,   34,   31,   31,   31,   31,
   31,   31,   31,    0,   17,   17,   17,   17,   17,   17,
   17,    0,   25,   25,   26,    0,    0,    0,   16,   16,
   16,   16,   16,   16,   16,    0,    0,    0,   27,   27,
   27,   27,   27,   27,   27,   18,   18,   18,   18,   18,
   18,   18,    0,    0,    0,    0,   24,   24,   24,   24,
   24,    0,   19,   19,   19,   19,   19,    0,    0,    0,
   22,   22,   22,   22,   22,    0,    0,    0,   23,   23,
   23,   23,   23,    0,   20,   20,   20,   20,   20,    0,
    0,    0,   21,   21,   21,   21,   21,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   31,   33,   36,   37,   38,   39,
    0,    0,   33,   36,   37,   38,   39,    0,    0,    0,
    1,    2,    3,    0,    4,    5,    6,    7,    8,    0,
    9,   10,   11,   12,   13,    0,   38,   39,    0,    0,
    0,    0,   15,
};
short yycheck[] = {                                      41,
    0,   24,   25,   37,   46,   40,   46,    0,   42,   43,
   40,   45,   40,   47,    0,   37,   40,   46,  257,   41,
   42,   43,    0,   45,   37,   47,   60,   61,   62,   42,
    0,   40,    0,  266,   47,  265,    0,   37,   60,   61,
   62,   41,   42,   43,   37,   45,    0,   47,   41,   42,
   43,   41,   45,    0,   47,   41,   41,   43,   41,   45,
   60,   61,   62,   41,    0,   41,   45,   60,   61,   62,
    0,   41,   41,   41,   60,   61,   62,   41,    0,   43,
   46,   45,   60,   61,   62,   46,    0,   41,   22,   43,
   -1,   45,    0,   -1,   41,   -1,   60,   61,   62,   78,
    0,   80,   -1,   -1,   -1,   41,   60,   61,   62,   -1,
   -1,   41,   22,   60,   61,   62,   26,   -1,   -1,   41,
   -1,   -1,   -1,   -1,   60,   61,   62,   41,   -1,   -1,
   60,   61,   62,   41,   -1,   -1,   46,   -1,   60,   61,
   62,   41,   -1,   -1,   -1,   -1,   60,   61,   62,   -1,
   -1,   -1,   60,   61,   62,   -1,   -1,   -1,   37,   -1,
   60,   61,   62,   42,   43,   37,   45,   -1,   47,   -1,
   42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1,   -1,
   -1,   60,   61,   62,   -1,   -1,   37,   -1,   60,   61,
   62,   42,   43,   40,   45,   -1,   47,   37,   45,   14,
   15,   16,   42,   43,   -1,   45,   -1,   47,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   30,   31,   32,   33,   34,
   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  272,  273,
  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,
  272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  272,  273,  274,  275,  276,  277,  278,  272,
  273,  274,  275,  276,  277,  278,  272,  273,  274,  275,
  276,  277,  278,   -1,  272,  273,  274,  275,  276,  277,
  278,   -1,  272,  273,  272,   -1,   -1,   -1,  272,  273,
  274,  275,  276,  277,  278,   -1,   -1,   -1,  272,  273,
  274,  275,  276,  277,  278,  272,  273,  274,  275,  276,
  277,  278,   -1,   -1,   -1,   -1,  272,  273,  274,  275,
  276,   -1,  272,  273,  274,  275,  276,   -1,   -1,   -1,
  272,  273,  274,  275,  276,   -1,   -1,   -1,  272,  273,
  274,  275,  276,   -1,  272,  273,  274,  275,  276,   -1,
   -1,   -1,  272,  273,  274,  275,  276,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  273,  274,  275,  276,  277,  278,
   -1,   -1,  274,  275,  276,  277,  278,   -1,   -1,   -1,
  257,  258,  259,   -1,  261,  262,  263,  264,  265,   -1,
  267,  268,  269,  270,  271,   -1,  277,  278,   -1,   -1,
   -1,   -1,  279,
};
#define YYFINAL 17
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 280
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,"'%'",0,0,"'('","')'","'*'","'+'",0,"'-'","'.'","'/'",0,0,0,0,0,0,0,0,0,0,
0,0,"'<'","'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,"NOME","LIT_CH","SIZEOF","OFFSETOF","GETVMVAR","CONTAINHEX",
"CONTAINASCII","GETDATALEN","NUMERO","COST_STRINGA","C_H_NUM","C_O_NUM",
"TOK_TRUE","TOK_FALSE","TOK_CANTTELL","OR","AND","NOT_EQ","MIU","MAU","LSHIFT",
"RSHIFT","NOT","MENO_UNARIO",
};
char *yyrule[] = {
"$accept : espressione",
"nome : NOME",
"campo : nome '.' nome",
"cost_str : COST_STRINGA",
"num : NUMERO",
"numero : num",
"numero : num '.' num '.' num '.' num",
"numero : C_H_NUM",
"numero : C_O_NUM",
"numero : LIT_CH",
"espressione : campo",
"espressione : numero",
"espressione : TOK_TRUE",
"espressione : TOK_FALSE",
"espressione : TOK_CANTTELL",
"espressione : '(' espressione ')'",
"espressione : espressione '+' espressione",
"espressione : espressione LSHIFT espressione",
"espressione : espressione RSHIFT espressione",
"espressione : espressione NOT_EQ espressione",
"espressione : espressione MIU espressione",
"espressione : espressione MAU espressione",
"espressione : espressione '<' espressione",
"espressione : espressione '>' espressione",
"espressione : espressione '=' espressione",
"espressione : espressione AND espressione",
"espressione : espressione OR espressione",
"espressione : espressione '-' espressione",
"espressione : espressione '*' espressione",
"espressione : espressione '/' espressione",
"espressione : espressione '%' espressione",
"espressione : '-' espressione",
"espressione : NOT espressione",
"espressione : SIZEOF '(' campo ')'",
"espressione : nome",
"espressione : GETDATALEN '(' nome ')'",
"espressione : SIZEOF '(' nome ')'",
"espressione : GETVMVAR '(' cost_str ')'",
"espressione : CONTAINHEX '(' cost_str ')'",
"espressione : CONTAINASCII '(' cost_str ')'",
};
#endif
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE

extern int yylineno;
int yylineno_offset;

int yyerror(char* s)
{
 char t[1000];
 if (lcp) lcp->insert(ERR_LINE /*Errore alla linea %d: %s*/,yylineno+yylineno_offset,s);
 else 
 {
  sprintf(t,ERR_LINE1 /*Errore di analisi del sorgente alla linea %d\n%s\n*/,yylineno+yylineno_offset,s);
  Say(t);
 }
 if(strcmp(s,"syntax error")==0) EndParsing();
 errorflag=1;
 return 1;
}

int yywarn(char* s)
{
 char t[1000];
 if (s==NULL) s="";
 if (lcp) lcp->insert(ERR_WARN /*Warning alla linea %d: %s*/,yylineno+yylineno_offset,s);
 else 
 {
  sprintf(t,ERR_WARN1 /*Warning alla linea %d\n%s\n*/,yylineno+yylineno_offset,s);
  Say(t);
 }
 return 1;
}
#define YYABORT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv(const char*);

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, reading %d (%s)\n", yystate,
                    yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: state %d, shifting to state %d\n",
                    yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: state %d, error recovery shifting\
 to state %d\n", *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("yydebug: error recovery discarding state %d\n",
                            *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("yydebug: state %d, error recovery discards token %d (%s)\n",
                    yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("yydebug: state %d, reducing by rule %d (%s)\n",
                yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 1:
{
			   strcpy(yyval.n.nome,agg_nome(yytext));
			   genvars=1;
			  }
break;
case 2:
{
			   int i=FindProto(yyvsp[-2].n.nome);
			   if (i<0) yyerror(ERR_PRUNDEF /*Protocollo non definito*/);
			   else
			   {
				 (*crea_vars)[c_ind]=i;
				 c_ind++;
			   }
			   strcpy(yyval.pn.prnome,yyvsp[-2].n.nome);
			   strcpy(yyval.pn.nome,yyvsp[0].n.nome);
			  }
break;
case 3:
{
				 yytext[strlen(yytext)-1]='\0';
				 (*costanti)[nc]=yytext+1;
				 yyval.i.i=nc;
				 nc++;
				}
break;
case 4:
{
			   int num;
			   sscanf(yytext,"%d",&num);
			   yyval.i.i=num;
			   if (num<=0xFF) yyval.i.s=1;
			   else if (num<=0xFFFF) yyval.i.s=2;
			   else yyval.i.s=4;
			  }
break;
case 5:
{
			    yyval.i.i=yyvsp[0].i.i;
				yyval.i.s=yyvsp[0].i.s;
			  }
break;
case 6:
{
			    yyval.i.s=4;
				if (yyvsp[-6].i.s>1 || yyvsp[-4].i.s>1 || yyvsp[-2].i.s>1 || yyvsp[0].i.s>1)
				yyerror (ERR_IP /*Nella notazione XXX.XXX.XXX.XXX i numeri devono errere compresi tra 0 e 255*/);
				yyval.i.i=(yyvsp[-6].i.i<<24)+(yyvsp[-4].i.i<<16)+(yyvsp[-2].i.i<<8)+yyvsp[0].i.i;
			  }
break;
case 7:
{
			   int num;
			   sscanf(yytext+2,"%x",&num);
			   yyval.i.i=num;
			   if (num<=0xFF) yyval.i.s=1;
			   else if (num<=0xFFFF) yyval.i.s=2;
			   else yyval.i.s=4;
			  }
break;
case 8:
{
			   int num;
			   sscanf(yytext+1,"%o",&num);
			   yyval.i.i=num;
			   if (num<=0xFF) yyval.i.s=1;
			   else if (num<=0xFFFF) yyval.i.s=2;
			   else yyval.i.s=4;
			  }
break;
case 9:
{
			   yyval.i.i = yytext[1]; 
			   yyval.i.s=1;
			  }
break;
case 10:
{
			   int indice;
			   const char* ct=yyvsp[0].pn.nome;
				  p_struct* p_str;
				  p_str=FindPrVar(yyvsp[0].pn.prnome,yyvsp[0].pn.nome,indice);
				  if (p_str!=NULL)
				  {
				   (*ist)[i_ind].ist_number=I_PUSH;
				   (*ist)[i_ind].p1=FindProto(yyvsp[0].pn.prnome);
				   i_ind++;
				   (*ist)[i_ind].ist_number=I_PUSH_VAR;
				   (*ist)[i_ind].p1=indice;
				   i_ind++;
				   yyval.i.i=indice;
				   ct=NULL;
				  }
			   if (ct!=NULL) 
			    yyerror(ERR_FIELD /*Impossibile accedere ad un campo non definito*/);
			  }
break;
case 11:
{
			   int num=yyvsp[0].i.i;
			   (*ist)[i_ind].ist_number=I_PUSH;
			   (*ist)[i_ind].p1=num;
			   i_ind++;
			   yyval.i.s=yyvsp[0].i.s;
			   yyval.i.i=-1;
			  }
break;
case 12:
{
			   (*ist)[i_ind].ist_number=I_PUSH;
			   (*ist)[i_ind].p1=0xFFFFFFFF;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 13:
{
			   (*ist)[i_ind].ist_number=I_PUSH;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 14:
{
			   (*ist)[i_ind].ist_number=I_CANTTELL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 15:
{
			   yyval.i.s=yyvsp[-1].i.s;
			   yyval.i.i=-1;
			  }
break;
case 16:
{
			   (*ist)[i_ind].ist_number=I_PLUS;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 17:
{
			   (*ist)[i_ind].ist_number=I_LSHIFT;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=(yyvsp[-2].i.s);
			   yyval.i.i=-1;
			  }
break;
case 18:
{
			   (*ist)[i_ind].ist_number=I_RSHIFT;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=(yyvsp[-2].i.s);
			   yyval.i.i=-1;
			  }
break;
case 19:
{
			   (*ist)[i_ind].ist_number=I_NOT_EQUAL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 20:
{
			   (*ist)[i_ind].ist_number=I_MIN_EQUAL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 21:
{
			   (*ist)[i_ind].ist_number=I_MAG_EQUAL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 22:
{
			   (*ist)[i_ind].ist_number=I_MIN;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 23:
{
			   (*ist)[i_ind].ist_number=I_MAG;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 24:
{
			   (*ist)[i_ind].ist_number=I_EQUAL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 25:
{
			   (*ist)[i_ind].ist_number=I_AND;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 26:
{
			   (*ist)[i_ind].ist_number=I_OR;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 27:
{
			   (*ist)[i_ind].ist_number=I_MINUS;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 28:
{
			   (*ist)[i_ind].ist_number=I_MUL;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 29:
{
			   (*ist)[i_ind].ist_number=I_DIV;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 30:
{
			   (*ist)[i_ind].ist_number=I_MOD;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=max(yyvsp[-2].i.s,yyvsp[0].i.s);
			   yyval.i.i=-1;
			  }
break;
case 31:
{
			   (*ist)[i_ind].ist_number=I_UN_MINUS;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=yyvsp[0].i.s;
			   yyval.i.i=-1;
			  }
break;
case 32:
{
			   (*ist)[i_ind].ist_number=I_NOT;
			   (*ist)[i_ind].p1=0;
			   i_ind++;
			   yyval.i.s=4;
			   yyval.i.i=-1;
			  }
break;
case 33:
{
			   int indice;
			   const char* ct=yyvsp[-1].pn.nome;
			    {
				  p_struct* p_str;
				  p_str=FindPrVar(yyvsp[-1].pn.prnome,yyvsp[-1].pn.nome,indice);
				  if (p_str!=NULL)
				    {
					(*ist)[i_ind].ist_number=I_PUSH;
					(*ist)[i_ind].p1=p_str->size;
					i_ind++;
					ct=NULL;
					}
				}
			   if (ct!=NULL) 
			    yyerror(ERR_VAR /*Impossibile accedere ad una variabile non definita*/);
			  }
break;
case 34:
{
				  int i=FindProto(yyvsp[0].n.nome);
				  if (i>=0)
				    {
						(*ist)[i_ind].ist_number=I_P_VISITED;
						(*ist)[i_ind].p1=i;
						i_ind++;
					}
					else yyerror(ERR_PROTO /*Impossibile accedere ad un protocollo non definito*/);
			  }
break;
case 35:
{
				  int i=FindProto(yyvsp[-1].n.nome);
				  if (i>=0)
				    {
						(*ist)[i_ind].ist_number=I_GETDATALEN;
						(*ist)[i_ind].p1=i;
						i_ind++;
					}
					else yyerror(ERR_PROTO /*Impossibile accedere ad un protocollo non definito*/);
			  }
break;
case 36:
{
				  int i=FindProto(yyvsp[-1].n.nome);
				  if (i>=0)
				    {
						(*ist)[i_ind].ist_number=I_PUSH;
						(*ist)[i_ind].p1=(*proto)[i].GetSize();
						i_ind++;
					}
					else yyerror(ERR_PROTO /*Impossibile accedere ad un protocollo non definito*/);
			  }
break;
case 37:
{
			   (*ist)[i_ind].ist_number=I_E_GETVMVAR;
			   (*ist)[i_ind].p1=yyvsp[-1].i.i;
			   i_ind++;
			  }
break;
case 38:
{
			   (*ist)[i_ind].ist_number=I_E_CONTAINHEX;
			   (*ist)[i_ind].p1=yyvsp[-1].i.i;
			   i_ind++;
			  }
break;
case 39:
{
			   (*ist)[i_ind].ist_number=I_E_CONTAINASCII;
			   (*ist)[i_ind].p1=yyvsp[-1].i.i;
			   i_ind++;
			  }
break;
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("yydebug: after reduction, shifting from state %d \
to state %d\n", *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
