// ExpVM.cpp: implementation of the CExpVM class.
//
//////////////////////////////////////////////////////////////////////

#include "expvm.h"
#include "../eparser/l_structs.h"
#include "../../comuni/asksay.h"
#include "../../comuni/vec_cl.h"

#ifndef ENGLISH
#define ERR_VMVAR "Variabile della macchina virtuale non definita"
#define ERR_IST "Istruzione non supportata"
#else
#define ERR_VMVAR "Virtual machine variable not defined"
#define ERR_IST "Instruction not supported"
#endif
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CExpVM::CExpVM(CPacketDescriber &pdesc)
{
	pd=&pdesc;
}

CExpVM::~CExpVM()
{

}

vector<int> &StrToHex(char const * s,vector<int> &dest)
    {
        int i,l=strlen(s),indice=0;
        int t,n=0;

        dest.empty();
        for (i=0;i<l;i++)
         {
          if ((s[i]>='0' && s[i]<='9') ||
              (s[i]>='a' && s[i]<='f') ||
              (s[i]>='A' && s[i]<='F'))
           continue;
          if (indice!=i)
           {sscanf(s+indice,"%x",&t);
            t &=0xFF;
            dest[n]=t;
            n++;
            }
          indice=i+1;
         }
        if ((indice<i)&&(i!=0))
           {sscanf(s+indice,"%x",&t);
            t &=0xFF;
            dest[n]=t;
            n++;
            }
        return dest;
    }

string &HexToStr(vector<int>& s,string &d)
    {
        int l=s.get_n_el(),y;
        d.Empty();
        char t[20];
        for(int i=0;i<l;i++)
         {
         y=s[i];
         sprintf(t,"%x ",y);
         d+=t;
         }
        return d;
    }

int hexcmp(const char* hex,const unsigned char* str)
{
	vector<int> v;
	StrToHex(hex,v);
	int i,l=v.get_n_el();
	for(i=0;i<l;i++)
		if ((unsigned)v[i]<(unsigned)str[i]) return -1;
		else if ((unsigned)v[i]>(unsigned)str[i]) return 1;
	return 0;
}

int hexcmp(vector<int> & v,const unsigned char* str)
{
	int i,l=v.get_n_el();
	for(i=0;i<l;i++)
		if ((unsigned)v[i]<(unsigned)str[i]) return -1;
		else if ((unsigned)v[i]>(unsigned)str[i]) return 1;
	return 0;
}

ExpVal CExpVM::ExecuteProgram(const istruzione * ist, int ni,const Cost* stringhe, int ns, item* cItem)
{
	ExpVal a,b,r;
	int t,j;
	for (int i=0;i<ni;i++)
	{
		switch(ist[i].ist_number)
		{
		  case I_PUSH:
			 r.valid=1;
			 r.val=ist[i].p1;
			 s.push(r);
			 break;
		  case I_CANTTELL:
			 r.valid=0;
			 r.val=ist[i].p1;
			 s.push(r);
			 break;
		  case I_POP:
			 s.pop();
			 break;
		  case I_PLUS:
			 a=s.pop();
			 b=s.pop();
			 r.val=a.val+b.val;
			 r.valid=a.valid&&b.valid;
			 s.push(r);
			 break;
		  case I_MINUS:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 a=s.pop();
			 b=s.pop();
			 r.val=b.val-a.val;
			 r.valid=a.valid&&b.valid;
			 s.push(r);
			 break;
		  case I_MUL:
			 a=s.pop();
			 b=s.pop();
			 r.val=b.val*a.val;
			 r.valid=a.valid&&b.valid;
			 s.push(r);
			 break;
		  case I_DIV:
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 r.val=b.val/a.val;
			 if (b.val==0) r.valid=0;
			 s.push(r);
			 break;
		  case I_MOD:
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 r.val=b.val%a.val;
			 if (b.val==0) r.valid=0;
			 s.push(r);
			 break;
		  case I_AND:
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 r.val=b.val&a.val;
			 if ((a.valid&&!a.val)||(b.valid&&!b.val)) 
			 {r.valid=1;}
			 s.push(r);
			 break;
		  case I_OR:
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 r.val=b.val|a.val;
			 if ((a.valid&&a.val)||(b.valid&&b.val)) 
			 {r.valid=1;}
			 s.push(r);
			 break;
		  case I_UN_MINUS:
			 r=s.pop();
			 r.val=-r.val;
			 s.push(r);
			 break;
		  case I_NOT:
			 r=s.pop();
			 r.val=~r.val;
			 s.push(r);
			 break;
		  case I_EQUAL:
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 if (b.val==a.val) r.val=0xFFFFFFFF; else r.val=0;
			 if (!r.valid) {r.val=0;r.valid=1;}
			 if (!a.valid && !b.valid) {r.val=0xFFFFFFFF;r.valid=1;}
			 s.push(r);
			 break;
		  case I_NOT_EQUAL:
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 if (b.val!=a.val) r.val=0xFFFFFFFF; else r.val=0;
			 if (!r.valid) {r.val=0xFFFFFFFF;r.valid=1;}
			 if (!a.valid && !b.valid) {r.val=0;r.valid=1;}
			 s.push(r);
			 break;
		  case I_MIN_EQUAL:		
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 if (b.val<=a.val) r.val=0xFFFFFFFF; else r.val=0;
			 if (!a.valid && !b.valid) {r.val=0xFFFFFFFF;r.valid=1;}
			 s.push(r);
			 break;
		  case I_MAG_EQUAL:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 if (b.val>=a.val) r.val=0xFFFFFFFF; else r.val=0;
			 if (!a.valid && !b.valid) {r.val=0xFFFFFFFF;r.valid=1;}
			 s.push(r);
			 break;
		  case I_MIN:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 if (b.val<a.val) r.val=0xFFFFFFFF; else r.val=0;
			 s.push(r);
			 break;
		  case I_MAG:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 if (b.val>a.val) r.val=0xFFFFFFFF; else r.val=0;
			 s.push(r);
			 break;
		  case I_LSHIFT:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 r.val=b.val<<a.val;
			 s.push(r);
			 break;
		  case I_RSHIFT:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 a=s.pop();
			 b=s.pop();
			 r.valid=a.valid&&b.valid;
			 t=0;
			 for(i=0;i<32-a.val;i++) t+=1<<i;
			 r.val=(b.val>>a.val)&t;
			 s.push(r);
			 break;
		  case I_PUSH_VAR:
			 a=s.pop();
			 if (cItem==NULL) {r.valid=0;}
			 else if (pd->proto[a.val].GetVisited()) 
			 {
				 r.valid=1;
				 r.val=pd->proto[a.val].GetVar(ist[i].p1);
			 }
			 else {r.valid=0;}
			 s.push(r);
			 break;
		  case I_GETDATALEN:
			 t=ist[i].p1;
			 if (cItem==NULL) {r.valid=0;}
			 else if (pd->proto[t].GetVisited()) 
			 {
				 r.valid=1;
				 r.val=cItem->truesize-pd->proto[t].GetDataOffset();
			 }
			 else {r.valid=0;}
			 s.push(r);
			 break;
		  case I_E_GETVMVAR:
			 t=ist[i].p1;
			 r.valid=1;
			 if (t>=ns) {r.valid=0;}
			 else if (cItem==NULL) {r.valid=0;}
			 else if (strcmp(stringhe[t].s,"FrameAvail")==0) r.val=cItem->size;
			 else if (strcmp(stringhe[t].s,"FrameSize")==0) r.val=cItem->truesize;
			 else if (strcmp(stringhe[t].s,"ItemNumber")==0) r.val=cItem->itemNr;
			 else if (strcmp(stringhe[t].s,"FrameSecs")==0) r.val=cItem->secs;
			 else if (strcmp(stringhe[t].s,"FrameUSecs")==0) r.val=cItem->usecs;
			 else if (strcmp(stringhe[t].s,"FrameType")==0) r.val=cItem->type;
			 else if (strcmp(stringhe[t].s,"Written")==0) r.val=(cItem->written);
			 else if (strcmp(stringhe[t].s,"Discarded")==0) r.val=(cItem->discarded);
			 else if (strcmp(stringhe[t].s,"SizeNotInt")==0) r.val=0;
			 else if (strcmp(stringhe[t].s,"Position")==0) r.val=cItem->posIndicator;
			 else {Say(ERR_VMVAR /*Variabile della macchina virtuale non definita*/);r.valid=0;}
			 s.push(r);
			 break;
		  case I_P_VISITED:
			 r.valid=1;
			 t=ist[i].p1;
			 if (cItem==NULL) {r.valid=0;}
			 else if (pd->proto[t].GetVisited()) 
				 r.val=0xFFFFFFFF; 
			 else
			 {
				 r.val=0;
				 if (cItem->size!=cItem->truesize)
				 if (pd->IsVisitable(pd->GetLastVisitedProtocol(),pd->proto[t].GetName()))
					 r.valid=0;  
			 }
			 s.push(r);
			 break;
		  case I_E_CONTAINHEX:
			 r.valid=1;
			 r.val=0; 
			 t=ist[i].p1;
			 r.valid=1;
			 if (t>=ns) {r.valid=0;s.push(r);break;}
			 else if (cItem==NULL) {r.valid=0;s.push(r);break;}
			 else
			 {
				 int l;
				 vector<int> v;
				 StrToHex(stringhe[t].s,v);
				 l=v.get_n_el();
				 for(j=0;j<(signed)cItem->size-l;j++)
				 if (hexcmp(v,((const unsigned char*)(cItem->data))+j)==0) 
				 {
					 r.val=0xFFFFFFFF;
					 s.push(r);
					 break;
				 }
				 if (r.val!=0) break;
				 if (cItem->truesize-cItem->size>=(unsigned)l) {r.valid=0;s.push(r);break;}
				 r.val=0;
			 }
			 s.push(r);
			 break;
		  case I_E_CONTAINASCII:
			 r.valid=1;
			 r.val=0; 
			 t=ist[i].p1;
			 r.valid=1;
			 if (t>=ns) {r.valid=0;s.push(r);break;}
			 else if (cItem==NULL) {r.valid=0;s.push(r);break;}
			 else
			 {
				 int l;
				 l=strlen(stringhe[t].s);
				 for(j=0;j<(signed)cItem->size-l;j++)
				 if (strncmp(stringhe[t].s,(const char*)(cItem->data)+j,l)==0) 
				 {
					 r.val=0xFFFFFFFF;
					 s.push(r);
					 break;
				 }
				 if (r.val!=0) break;
				 if (cItem->truesize-cItem->size>=(unsigned)l) {r.valid=0;s.push(r);break;}
				 r.val=0;
			 }
			 s.push(r);
			 break;
		  default:
			 Say(ERR_IST /*Istruzione non supportata*/);
			 r.val=0;
			 r.valid=0;
			 return r;
			 break;
		}
	}
	int y=s.n_max_el();
	if(y>=0) 
	{	
		r=s.pop();
	}
	else r.valid=0;
	return r;
}
