// ProtocolGraph.cpp: implementation of the CProtocolGraph class.
//
//////////////////////////////////////////////////////////////////////

#include "protocolgraph.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#ifdef LINUX	
GraphNode* alloca_graphnode (int i)
{
	 return new GraphNode[i];
}
#endif

CProtocolGraph::CProtocolGraph(ProtocolVect &p)
{
	int j,k,l,i=p.GetSize();
#ifndef LINUX	
	vect=new GraphNode[i];
#else
	vect=alloca_graphnode (i);
#endif
	nv=i;
	for(l=0;l<i;l++)
	{
		vect[l].nome=p[l].GetName();
		vect[l].visitato=0;
		vect[l].nn=p[l].GetCaseNumber();
		vect[l].next=new GraphNode*[vect[l].nn];
		for(k=0;k<vect[l].nn;k++)
		 for(j=0;j<i;j++)
			 if (strcmp(p[j].GetName(),p[l].GetCase(k)->GetNextProtocol())==0)
			  {
				vect[l].next[k]=vect+j;
				break;
			  }
	}
	for(l=0;l<i;l++)
	{
		for(k=0;k<vect[l].nn;k++)
		vect[l].next[k]->visitato=1;
	}
	for(l=0,nf=0;l<i;l++)
	{
		if (!vect[l].visitato) nf++;
	}
	firsts=new GraphNode*[nf];
	for(l=0,k=0;l<i;l++)
	{
		if (!vect[l].visitato) {firsts[k]=vect+l;}
		else vect[l].visitato=0;
	}
}

CProtocolGraph::~CProtocolGraph()
{
	if (vect) 
		delete[]vect;
	if (firsts) delete[]firsts;
}

void CProtocolGraph::ClearVisited()
{
	for(int l=0;l<nv;l++)
	{
		vect[l].visitato=0;
	}
}

GraphNode::GraphNode()
{
	next=NULL;
	nn=0;
	nome=NULL;
	visitato=0;
}

GraphNode::~GraphNode()
{
	if (nn && next) delete[] next;
}

int CProtocolGraph::IsVisitable(int start, const char * pr)
{
	if(start>=nv) return 0;
	ClearVisited();
	return IsVisitable(vect[start],pr);
}

int CProtocolGraph::IsVisitable(GraphNode & n, const char * pr)
{
	n.visitato=1;
	if (strcmp(pr,n.nome)==0) return 1;
	for(int i=0;i<n.nn;i++)
	{
		if(n.next[i]->visitato==0 && IsVisitable(*(n.next[i]),pr)) return 1;
	}
	return 0;
}
