//				QUERY.H
//header file for QUERY.CPP

#if !defined( __QUERY_H )
#define __QUERY_H

#include "parser.h"
#include "readers.h"
#include "../evm/expvm.h"
#include "../../vm/filed/savefile.h"
#include "../../comuni/vec_cl.h"
#include <limits.h>

typedef enum {BFALSE=0,BTRUE=1,BCANTTELL=2} MyBoolean;

//the value used to indicate that a number is not computable
#define UNKNOWN_VALUE (UINT_MAX-1)
//the value used to indicate that a number is not computed yet
#define UNCOMPUTED_VALUE UINT_MAX

class LineCollection;

#include "istruzioni.h"

//the options of a query gathered in a block
class OptionBlock
{
private:
    unsigned int options;	//it's bits are the Yes/No options
    unsigned long interval;	//the time for 'a row in the table'in seconds
public:
    OptionBlock(){oldItem=-1;}
    //initializes the option block reading from the given file,reporting
    //any errors and returning 1 just if everything is OK
    int initialize(TextfileParser* file,LineCollection* errorReport,CPacketDescriber &pdesc);
    int useSemigraphicCharacters(){return options& 0x1;}
    int reportFrameCount(){return options& 0x2;}
    int reportFrameRate(){return options& 0x4;}
    int reportFramePercentage(){return options& 0x8;}
    int reportByteCount(){return options& 0x10;}
    int reportByteRate(){return options& 0x20;}
    int reportBytePercentage(){return options& 0x40;}
    int reportBytesPerFrame(){return options& 0x80;}
    int reportTotals(){return options& 0x100;}
    int reportAverages(){return options& 0x200;}
    int reportMaximums(){return options& 0x400;}
    int reportMinimums(){return options& 0x800;}
    int reportExtremeFramesizes(){return options& 0x1000;}
    int reportJustFinal(){return options& 0x2000;}
    int getOption(int nr){return options & (1<<nr);}
    unsigned long getInterval(){return interval;}
    inline MyBoolean excluded(CPacketDescriber &pdesc,item* CItem)
	{
	 if(exclude.genvars && CItem)
	 {
	   if (oldItem!=(signed)CItem->itemNr)
	   {
		int f=pdesc.proto.FindProto(CItem->firstpr);
		const int* r_crea_vars;
		int c_ind;
		pdesc.GetCalcPr(r_crea_vars, c_ind);
		pdesc.SetCalcPr(exclude.crv,exclude.nv);
		pdesc.ExaminePacket(f,CItem);
		oldItem=CItem->itemNr;
		pdesc.SetCalcPr(r_crea_vars, c_ind);
	   }
	 }
	 CExpVM vm(pdesc);
	 ExpVal e = vm.ExecuteProgram(exclude.ist,exclude.ni,
								exclude.cost,exclude.nc,CItem);
	 if (e.valid && e.val) return BTRUE;
	 else if (e.valid) return BFALSE;
	 return BCANTTELL;
	}
    unsigned int defaultLen(CPacketDescriber &pdesc,item* CItem)
	{
	 if(lenParam.genvars && CItem)
	 {
	   if (oldItem!=(signed)CItem->itemNr)
	   {
		int f=pdesc.proto.FindProto(CItem->firstpr);
		const int* r_crea_vars;
		int c_ind;
		pdesc.GetCalcPr(r_crea_vars, c_ind);
		pdesc.SetCalcPr(lenParam.crv,lenParam.nv);
		pdesc.ExaminePacket(f,CItem);
		oldItem=CItem->itemNr;
		pdesc.SetCalcPr(r_crea_vars, c_ind);
		oldItem=CItem->itemNr;
	   } 
	 }
	 CExpVM vm(pdesc);
	 ExpVal e = vm.ExecuteProgram(lenParam.ist,lenParam.ni,
								lenParam.cost,lenParam.nc,CItem);
	 if (e.valid ) return e.val;
	 return UNKNOWN_VALUE;
	}
    ~OptionBlock();
	Istruzioni lenParam;
	Istruzioni exclude;
	int oldItem;
};

//structure for keeping the overall totals about the data analysed
typedef struct
{
    unsigned int nrInterval;	//the nr of time intervals of the analysis
    unsigned long time;		//the duration of the entire analysis
    unsigned long byteCount;	//overall total of the byte count
    unsigned long frameCount;	//overall total of the frame count
} OverallTotals;

//this class contains all the informations needded to define a group (a column
//in the query table) and the information gathered during the analysis

#ifndef _MAX_PATH
#define _MAX_PATH 1000
#endif

class Group 
{
private:
    char groupName[MaxWordLength+1];
    char capName[_MAX_PATH+1];
    Istruzioni predicate;	//the predicate for deciding if a
	//certain frame will or not be included (counted)
    Istruzioni lenParam;		//what to report as length
    //data members used during analysis
    unsigned long frameCount;	//number of frames
    unsigned long byteCount;	//total length of frames
    unsigned int lastFrameLen;	//the length of the last inspected frame
    unsigned long data[25];	//all the data to be reported at in the table
	//and at the end of it
	CSaveCap* saveCap;
public:
    Group(){oldItem=-1; saveCap=NULL;}
    //reads the gtoup from the given file reporting the encountered errors; if
    //file is eroneous returns 0
    int initialize(TextfileParser* file,LineCollection* errorReport,CPacketDescriber &pdesc);
    unsigned long getData(int index){return data[index];}
	//reads data from location pointed by index
    void startAnalysis();	//starts analysis of a new file
    //analizes a frame and if the predicate returns BTRUE updates the counters
    void inspect(CPacketDescriber &pdesc, item* cItem);
    //computes all the values to be reported, actualizes the min... , max...
    //and total... data members resets the counters to 0
    void endInterval(unsigned long duration,unsigned long allBytes,
	unsigned long allFrames);
    unsigned int lastFrameSize(){return lastFrameLen;}
    inline MyBoolean predicated(CPacketDescriber &pdesc,item* CItem)
	{
	 if(predicate.genvars && CItem)
	 {
	   if (oldItem!=(signed)CItem->itemNr)
	   {
		int f=pdesc.proto.FindProto(CItem->firstpr);
		const int* r_crea_vars;
		int c_ind;
		pdesc.GetCalcPr(r_crea_vars, c_ind);
		pdesc.SetCalcPr(predicate.crv,predicate.nv);
		pdesc.ExaminePacket(f,CItem);
		oldItem=CItem->itemNr;
		pdesc.SetCalcPr(r_crea_vars, c_ind);
	   } 
	 }
	 CExpVM vm(pdesc);
	 ExpVal e = vm.ExecuteProgram(predicate.ist,predicate.ni,
								predicate.cost,predicate.nc,CItem);
	 if (e.valid && e.val) return BTRUE;
	 else if (e.valid) return BFALSE;
	 return BCANTTELL;
	}
    unsigned int calcLen(CPacketDescriber &pdesc,item* CItem)
	{
	 if(lenParam.genvars && CItem)
	 {
	   if (oldItem!=(signed)CItem->itemNr)
	   {
		int f=pdesc.proto.FindProto(CItem->firstpr);
		const int* r_crea_vars;
		int c_ind;
		pdesc.GetCalcPr(r_crea_vars, c_ind);
		pdesc.SetCalcPr(lenParam.crv,lenParam.nv);
		pdesc.ExaminePacket(f,CItem);
		oldItem=CItem->itemNr;
		pdesc.SetCalcPr(r_crea_vars, c_ind);
		oldItem=CItem->itemNr;
	   } 
	 }
	 CExpVM vm(pdesc);
	 ExpVal e = vm.ExecuteProgram(lenParam.ist,lenParam.ni,
								lenParam.cost,lenParam.nc,CItem);
	 if (e.valid ) return e.val;
	 return UNKNOWN_VALUE;
	}
    //this function has to be called at the end of the analysis with the
    //totals before calling any gaeData function with a.. codes
    void stopAnalysis(OverallTotals* total);
    char* getName(){return groupName;}
	virtual Group& operator = (Group& g);
    ~Group();
	int oldItem;
};

typedef unsigned long(Group::*groupFunction)();
class Query
{
private:
	int outcsv;
	FILE* outfile;
    OptionBlock* ob;
    //semigraphic characters for building the table
    vector<Group*> groups;
    Group* group(int n){return groups[n];}
    //auxiliary functions called during analysis
    void separatorLine(char* buffer, LineCollection* table);
	//inserts a separation line in the table using buffer
    void dataLine(char* buffer, LineCollection* table, char*model,int index);
    void dataLine(char* buffer, LineCollection* table, int model,int index);
	//inserts a line with data in the table using buffer; for reporting
	//values data[index] is used and model is used to build every cell
    void cellRow(char* buffer,LineCollection*table,char*hdr1,char*hdr2,
	int baseIndex);
	//builds a cell row, puting in the first column hdr1 and hdr2(if not
	//NULL) and reporting data starting from baseIndex and up to
	//baseIndex + 6
    void submit(CPacketDescriber &pdesc,item*cItem,unsigned long& allBytes,
	unsigned long& allFrames);
	//submits a frame to the analysis of the groups
    //characters for building the table
    unsigned char ulCorner;
    unsigned char uT;
    unsigned char urCorner;
    unsigned char leT;
    unsigned char cross;
    unsigned char rT;
    unsigned char llCorner;
    unsigned char loT;
    unsigned char lrCorner;
    unsigned char hLine;
    unsigned char vLine;
public:
	char m_CsvSep;
	void insExtreme(char* buffer,LineCollection *table);
	void insTotals(char* buffer, LineCollection* table);
	void SetCsv();
	int nvis;
	void reportMessage(char*m1,const char*m2, LineCollection* table);
	void insTableFooter(char* buffer,LineCollection* table);
	int insHeader(LineCollection* table, const char* c1=NULL, const char* c2=NULL);
	void insTableHeader(char*buffer,LineCollection* table);
	void insTable2Header(char*buffer,LineCollection* table);
	int SetFile(const char* fn);
    Query(){ob=0;outfile=NULL;outcsv=0;}
    //reads the query from the given file reporting the encountered errors; if
    //file is eroneous returns 0
    int initialize(TextfileParser* file,LineCollection* errorReport,CPacketDescriber &pdesc);
    //analyses the given logfile
    void analyze(const char* logfileName,LogfileReader &file,LineCollection* table,
	CPacketDescriber &pdesc);
    ~Query();
};

enum groupdata 
{
	//codes for accessing group data
	//values
	vFC=0,
	vFPS=1,
	vFP=2,
	vBC=3,
	vBPS=4,
	vBP=5,
	vBPF=6,
	//"global" information
	//totals
	totalFC=7,
	totalBC=8,
};

enum avgdata
{
//averages (the same codes as for the values because are not used
//simultaneously)
aFC=0,
aFPS=1,
aFP=2,
aBC=3,
aBPS=4,
aBP=5,
aBPF=6,
//maximums
maxFC=9,
maxFPS=10,
maxFP=11,
maxBC=12,
maxBPS=13,
maxBP=14,
maxBPF=15,
//minimums
minFC=16,
minFPS=17,
minFP=18,
minBC=19,
minBPS=20,
minBP=21,
minBPF=22,
//absolut=extremes
maxFS=23,
minFS=24
};

#endif