#ifndef __ISTRUZ
#define __ISTRUZ

#include "../../comuni/structs.h"
#include "../../comuni/asksay.h"
#include "../../comuni/codeprocessor.h"

#ifndef ENGLISH
#define ERR_ISTMEM "Memoria esaurita"
#else
#define ERR_ISTMEM "Out of Memory"
#endif

class Query;

class Istruzioni
{
public:
	Istruzioni(){ist=NULL; ni=0;cost=NULL;nc=0;crv=NULL;nv=0;genvars=0;}
	inline ~Istruzioni()
	{if (ist) delete[]ist;if (cost) delete[]cost;if (crv) delete[]crv;}
	inline void SetIstr(istruzione* istr, int nis);
	inline void SetCost(Cost* istr, int nis);
	inline void SetCrVar(int* istr, int nis);
	inline operator istruzione*() {return ist;}
	inline operator Cost*() {return cost;}
	inline Istruzioni& operator =(Istruzioni& i);
	istruzione* ist;
	int ni;
	Cost *cost;
	int nc;
	int *crv;
	int nv;
	int genvars;
};

inline Istruzioni& Istruzioni::operator =(Istruzioni& i)
{
	SetIstr(i.ist,i.ni);
	SetCost(i.cost,i.nc);
	SetCrVar(i.crv,i.nv);
	return i;
}

inline void Istruzioni::SetIstr(istruzione* istr, int nis) 
{
	if (ist) delete[]ist; 
	if (!istr) return;
	ist=new istruzione[nis];
	ni=nis;
	if(!ist) {ni=0;Say(ERR_ISTMEM /*Memoria esaurita*/);return;}
	for(int i=0;i<nis;i++)
		{ist[i].p1=istr[i].p1;ist[i].ist_number=istr[i].ist_number;}
}

#ifdef LINUX
inline Cost* alloca_cost(int nis)
{
 return new Cost[nis];
}

inline void copy_cost(Cost& c1, Cost& c2)
{
  c1=c2;
}
#endif

inline void Istruzioni::SetCost(Cost* istr, int nis) 
{
	if (cost) delete[]cost; 
	if (!istr) return;
#ifndef LINUX
	cost=new Cost[nis];
#else
	cost=alloca_cost(nis);
#endif
	nc=nis;
	if(!cost) {nc=0;Say(ERR_ISTMEM /*Memoria esaurita*/);return;}
	for(int i=0;i<nis;i++)
#ifndef LINUX
		{cost[i].operator=(istr[i]);}
#else
		copy_cost(cost[i],istr[i]);
#endif
}

inline void Istruzioni::SetCrVar(int* istr, int nis)
{
	if (crv) delete[]crv; 
	if (!istr) return;
	crv=new int[nis];
	nv=nis;
	if(!crv) {nc=0;Say(ERR_ISTMEM /*Memoria esaurita*/);return;}
	for(int i=0;i<nis;i++)
		{crv[i]=istr[i];}
}

#endif
