//				PARSER.H
//header file for PARSER.CPP

#if !defined( __PARSER_H )
#define __PARSER_H

#include "../../vm/filed/lfreader.h"

//maximal length for lines containing FDL expressions to be parsed
#define MaxTextLineLength	500

//generic class for parsing
class TextParser
{
private:
    const char* const buffer;	//buffer for info to be parsed
    int errorCode;
protected:
    int pos;		//the current position inside the line
public:
    TextParser(char* info):buffer(info){errorCode=0;pos=0;}
    int getErrorCode(){return errorCode;}
    //gives more detailed information about the error that occured
    virtual int errorInfo(int* position=0,const char** line=0,int* lineNum=0);
    void setErrorCode(int errCode) {if(!errorCode)errorCode=errCode;}
    void resetErrorCode(){errorCode=0;}
    void skipBlanks();		//skips over spaces and tabs in input line
    unsigned int readNumber();	//reads a positive integer
    char lookAhead();		//returns a lookahead character (skips blanks)
    char nextChar();
	//returns a lookahead character without skipping blanks
    void popChar();		//advances a character in input
    int wLookAhead(char* word);	//checks if next word in input is 'word'
    //advances a word in input copying it to the buffer (if it's not NULL)
    void popWord(char*buf=0);
};

//class for parsing a text file
class TextfileParser:public TextParser
{
private:
    char rBuffer[MaxTextLineLength+2];	//buffer for reading from file
    int lineNr;				//the current line number
    FILE* f;				//the text file
public:
	const char* GetLine();
	int GetLineNr();
    TextfileParser(const char* filename);
    int getLine();	//reads a line jumping over comment lines
    virtual int errorInfo(int* position=0,const char** line=0,int* lineNum=0);
    ~TextfileParser();
};

//returns textual interpretation of a parser error code (implemented in
//readers.cpp)
const char* interpretParserError(int code);

//the maximal length for a word recognized by parser
#define MaxWordLength		25
//the maximal length of a string constant that can be defined
#define MaxStringLength		30

//defines for parser error codes
#define peOK			0
#define peOpenFailure		1
#define peUnexpectedEOF		2
#define peLineTooLong	        3
#define peNumberExpected	4
#define peUnexpectedEOL		5
#define peRightParanthExpected	6
#define peWordExpected		7
#define peLeftSqBracketExp	8
#define peRigthSqBracketExp	9
#define peNumberUpTo7Expected	10
#define peCommaExpected		11
#define peWordTooLong		12
#define peBoolExprExpected	13
#define peOperatorExpected	14
#define peStringExprExpected	15
#define peHexDigitExpected	16
#define peStringTooLong		17
#define peWrongDecimalString	18
#define pePeriodExpected	19
#define peWrongEscapeSequence	20
#define peInvalidNumber		21
#define peUnknownParameter	22
#define peUnknownStrParameter	23
#define peUnknownIntParameter	24
#define peIntegerExprExpected	25
#define peArithOperExpected	26

#endif