//				QUERY.CPP
// this file implements the structures used in a query except the member
//functions used at reading them from a '*.qry' file

#include <time.h>
#include <string.h>
#include <assert.h>
#include "query.h"
#include "parser.h"
#include "../../comuni/linecol.h"
#include "../../comuni/asksay.h"
#include "../../vm/filed/lfreader.h"
#include "../../vm/filed/codes.h"
#include "../messages.h"
#define SIZEOFWORD 2

#ifndef ENGLISH
#define ERR_STATS "Impossibile processare le statistiche"
#else
#define ERR_STATS "Unable to evaluate statistics"
#endif

//calculates how much percent of B is A (both are expected to be longs)
#define PERCENT(A,B) (B>1000000L?A/(B/100):A*100/B)

const item* discardedFrame=NULL;//{WholeFrame,0};
    //this frame will be submitted to analysis instead of any discarded frame
//
//OptionBlock class
//
OptionBlock::~OptionBlock()
{
}

//
//Group class
//
//starts analysis of a new file (initialization of 'global' data members)
void Group::startAnalysis()
{
    frameCount=byteCount=0;
    lastFrameLen=0;
    data[totalFC]=data[totalBC]=data[maxFC]=data[maxBC]=data[maxBPS]=
	data[maxBP]=data[maxBPF]=data[maxFPS]=data[maxFP]=data[maxFS]=0;
    data[minFPS]=data[minFC]=data[minBC]=data[minBPS]=4280000000;
    data[minBP]=data[minFP]=100;
    data[minBPF]=data[minFS]=9999;
}

//analizes a frame and if the predicate returns BTRUE updates the counters
void Group::inspect(CPacketDescriber &pdesc, item* cItem)
{
    if(predicated(pdesc,cItem)==BTRUE)
	{
	lastFrameLen=calcLen(pdesc,cItem);
	if(lastFrameLen==UNKNOWN_VALUE)
	    lastFrameLen=0;
	assert(lastFrameLen!=UNCOMPUTED_VALUE);
	if(lastFrameLen>data[maxFS])
	    data[maxFS]=lastFrameLen;
	if(lastFrameLen<data[minFS]&&lastFrameLen!=0)
	    data[minFS]=lastFrameLen;
	byteCount+=lastFrameLen;
	frameCount++;
	if(saveCap) saveCap->pcap_dump(cItem);
	}
    else lastFrameLen=UNCOMPUTED_VALUE;
}

//computes all the values to be reported, actualizes the min... , max...
//and total... data members resets the counters to 0
void Group::endInterval(unsigned long duration,unsigned long allBytes,
     unsigned long allFrames)
{
    //updating values and min/max s
    //Lasciate ogni speranza...
    data[vFC]=frameCount;
    if(data[vFC]>data[maxFC])
	data[maxFC]=data[vFC];
    if(data[vFC]<data[minFC])
	data[minFC]=data[vFC];
    data[vBC]=byteCount;
    if(data[vBC]>data[maxBC])
	data[maxBC]=data[vBC];
    if(data[vBC]<data[minBC])
	data[minBC]=data[vBC];
    if(duration==0)
	{
	data[vFPS]=data[vFC];
	data[vBPS]=data[vBC];
	}
    else
	{
	data[vFPS]=data[vFC]/duration;
	if(data[vFPS]>data[maxFPS])
	    data[maxFPS]=data[vFPS];
	if(data[vFPS]<data[minFPS])
	    data[minFPS]=data[vFPS];
	//vBPS
	data[vBPS]=data[vBC]/duration;
	if(data[vBPS]>data[maxBPS])
	    data[maxBPS]=data[vBPS];
	if(data[vBPS]<data[minBPS])
	    data[minBPS]=data[vBPS];
	}
    if(allFrames==0)
	data[vFP]=100;
    else
	{
	data[vFP]=PERCENT(data[vFC],allFrames);
	if(data[vFP]>data[maxFP])
	    data[maxFP]=data[vFP];
	if(data[vFP]<data[minFP])
	    data[minFP]=data[vFP];
	}
    if(allBytes==0)
	data[vBP]=100;
    else
	{
	data[vBP]=PERCENT(data[vBC],allBytes);
	if(data[vBP]>data[maxBP])
	    data[maxBP]=data[vBP];
	if(data[vBP]<data[minBP])
	    data[minBP]=data[vBP];
	}
    if(data[vFC]==0)
	data[vBPF]=0;//576;
    else
	{
	data[vBPF]=data[vBC]/data[vFC];
	if(data[vBPF]>data[maxBPF])
	    data[maxBPF]=data[vBPF];
	if(data[vBPF]<data[minBPF])
	    data[minBPF]=data[vBPF];
	}
    //updating totals
    data[totalBC]+=data[vBC];
    data[totalFC]+=data[vFC];
    //resetting counters
    frameCount=byteCount=0;
}

//this function has to be called at the end of the analysis with the
//totals before calling any gaeData function with a.. codes
void Group::stopAnalysis(OverallTotals* total)
{
    if(total->nrInterval==0)
	{
	data[aFC]=data[totalFC];
	data[aBC]=data[totalBC];
	}
    else
	{
	data[aFC]=data[totalFC]/total->nrInterval;
	data[aBC]=data[totalBC]/total->nrInterval;
	}
    if(total->time==0)
	{
	data[aBPS]=data[totalBC];
	data[aFPS]=data[totalFC];
	}
    else
	{
	data[aBPS]=data[totalBC]/total->time;
	data[aFPS]=data[totalFC]/total->time;
	}
    if(total->frameCount==0)
	data[aFP]=100;
    else
	data[aFP]=PERCENT(data[totalFC],total->frameCount);
    if(total->byteCount==0)
	data[aBP]=100;
    else
	data[aBP]=PERCENT(data[totalBC],total->byteCount);
    if(data[totalFC]==0)
	data[aBPF]=0;//576;
    else
	data[aBPF]=data[totalBC]/data[totalFC];
    }

Group::~Group()
{
	if(saveCap) {saveCap->pcap_dump_close(); delete saveCap;}
}

//
//Query class
//
//auxiliary non-member function for skipping all non-frame items and setting
//the current time and discarded frame counter if necessary; returns NULL if
//while skipping items an lfreader error occured
const item* getFrame(LogfileReader* lfr,time_t* time,unsigned long* discarded)
{
    const item* frame;
    frame=lfr->getCrt();
    if(frame==NULL)
	return NULL;
	*time=((time_t)(frame->secs));
	*discarded+=frame->discarded;
    while(!isFrame(frame->type))
	{
	if(!lfr->nextItem())
	    return NULL;
	frame=lfr->getCrt();
	*time=((time_t)(frame->secs));
	*discarded+=frame->discarded;
	}
    return frame;
}


//submits a frame to the analysis of the groups
void Query::submit(CPacketDescriber &pdesc,item*cItem,unsigned long& allBytes,
    unsigned long& allFrames)
    {
    if(ob->excluded(pdesc,cItem)!=BTRUE)
	{
	int n;
	//submittimg the frame to all the groups
	for(n=0;n<groups.get_n_el();n++)
	group(n)->inspect(pdesc,cItem);
	unsigned int frameSize=0;
	for(n=0;n<groups.get_n_el();n++)
	    {
	    unsigned int k;
	    k=group(n)->lastFrameSize();
	    if(k!=UNCOMPUTED_VALUE)
		{
		frameSize=k;
		break;
		}
	    }
	//if no group sets the frame size...
	if(frameSize==0)
	    frameSize=ob->defaultLen(pdesc,cItem);
	if(frameSize==UNKNOWN_VALUE)
	    frameSize=0;
	allBytes+=frameSize;
	allFrames++;
	}
}

//analyses the given logfile
void Query::analyze(const char* logfileName,LogfileReader &file,LineCollection* table,
    CPacketDescriber &pdesc)
{
    //opening the logfile
	int num_vis=0;
	if (table==NULL && outfile==NULL) 
	{
		Say(ERR_STATS /*Impossibile processare le statistiche*/);
		return;
	}
	reportMessage(Q_ANALIZING,logfileName,table);
    if(!file.Jump(1))
	{
	char* errorMessage;
	switch(file.getErrorCode())
	    {
	    case freEOF:errorMessage=QE_EOF;break;
	    case freFormat:errorMessage=QE_FORMAT;break;
	    case freTruncated:errorMessage=QE_TRUNC;break;
	    case freInitFailed:errorMessage=QE_IF;break;
	    case freCannotRead:errorMessage=QE_CR;break;
	    default:errorMessage=QE_DEFAULT;break;
	    }
	reportMessage(QE_NOTABGEN,errorMessage,table);
	return;
	}
	int n;
	nvis=num_vis=insHeader(table);
    //the real header
    char buffer[MaxLineLength+1];
	insTableHeader(buffer,table);
    //now will read the logfile and compute the table
    //ParameterBlock params(pd);
    const item* frame;
    //totals for all frames for entire analysis
    OverallTotals total;
    total.byteCount=0;
    total.frameCount=0;
    total.time=0;
    total.nrInterval=0;
    //counters for each interval
    unsigned long discarded;	//counter of discarded packets
    unsigned long allBytes;	//byte counter for frames from all groups
    unsigned long allFrames;	//frame counter for all groups
    discarded=0;
    allBytes=0;
    allFrames=0;
    //time variables
    time_t crtTime;
    time_t intervalEnd;		//when is suposed to end the current interval
    time_t lastIntervalEnd;	//the end of the previous interval
    frame=getFrame(&file,&crtTime,&discarded);
    intervalEnd=crtTime+ob->getInterval();
    lastIntervalEnd=crtTime;
    for(n=0;n<groups.get_n_el();n++)
	group(n)->startAnalysis();
    //the main analizing loop
    do
	{
	unsigned long duration=crtTime-lastIntervalEnd;
	if((crtTime>=intervalEnd||frame==0)&&!(duration==0&&allFrames==0))
	    {
	    //submitting all the discarded frames
	    //params.setFrame(&discardedFrame);
	    while(discarded>0)
		{
		submit(pdesc,NULL,allBytes,allFrames);
		discarded--;
		}
	    for(n=0;n<groups.get_n_el();n++)
		group(n)->endInterval(duration,allBytes,allFrames);

	    if(!ob->reportJustFinal())
		{
		//building the table line itself
		char hdr1[8];
		char hdr2[8];
		memcpy(hdr1,ctime(&lastIntervalEnd)+11,8);
		memcpy(hdr2,ctime(&crtTime)+11,8);
		cellRow(buffer,table,hdr1,hdr2,vFC);
		}
	    //updating totals
	    total.time+=duration;
	    total.nrInterval++;
	    total.byteCount+=allBytes;
	    total.frameCount+=allFrames;
	    allBytes=0;
	    allFrames=0;
	    //setting the next interval's end
	    lastIntervalEnd=crtTime;
	    intervalEnd=crtTime+ob->getInterval();
	    }
	if(frame==0)
	    break;
	//processing the frame
	//params.setFrame(frame);
	submit(pdesc,(struct itemstruct *)frame,allBytes,allFrames);

	file.nextItem();	//yes, I need both calls
	frame=getFrame(&file,&crtTime,&discarded);
	}
    while(1);
    for(n=0;n<groups.get_n_el();n++)
	group(n)->stopAnalysis(&total);

	if(!ob->reportJustFinal())
		insHeader(table,"Finals","");
    if(ob->reportAverages())
	cellRow(buffer,table,QE_AVG,NULL,aFC);
    if(ob->reportMaximums())
	cellRow(buffer,table,QE_MAX,NULL,maxFC);
    if(ob->reportMinimums())
	cellRow(buffer,table,QE_MIN,NULL,minFC);
	if(ob->reportTotals()||ob->reportExtremeFramesizes())
		insTable2Header(buffer,table);
    if(ob->reportTotals())
	//totals can be reported just for frame and byte counts
	{
		insTotals(buffer,table);
	}
    if(ob->reportExtremeFramesizes())
	{
		insExtreme(buffer,table);
	}
	insTableFooter(buffer,table);
    //after the loop we could mention the cause why stoped too
    char *lastMessage;
    switch(file.getErrorCode())
	{
	case freEOF: lastMessage=QE_EOF1; break;
	case freFormat: lastMessage=QE_FORMAT1; break;
	case freTruncated: lastMessage=QE_TRUNC1; break;
	default: lastMessage=QE_UEO1; break;
	}
	reportMessage(QE_END1,lastMessage,table);
}

Query::~Query()
{
    delete ob;
	for(int i=0;i<groups.get_n_el();i++) delete groups[i];
	if (outfile) 
		if (outfile!=stdout)fclose (outfile);
		else fflush (stdout);
}


int Query::SetFile(const char * fn)
{
	if (!strcmp(fn,"-")) outfile=stdout;
	else outfile=fopen(fn,"w");
	if (outfile) return 0;
	return 1;
}