//				PARSER.CPP
//this file contains all the functions and global variables used at parsing
//a file

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "parser.h"

//Auxiliary functions used by the parsers

//decides if a certain character may or not start a word
int isWordBegining(char c)
{
return isalpha(c)||c=='_';
}

//decides if a certain character may or not occur inside a word
int isWordInterior(char c)
{
return isalnum(c) || c=='_' || c=='.' ;
}

//returns an integer equal to the value of a hex digit
int xValue(char c)
{
return (isalpha(c)?tolower(c)-'a'+10:c-'0');
}

//
//TextParser class
//
//skips over spaces and tabs in input line
void TextParser::skipBlanks()
{
    if(errorCode)
	return;
    while((buffer[pos]==' ')||(buffer[pos]=='\t'))
	pos++;
}

//reads a positive integer in decimal or hex notation
unsigned int TextParser::readNumber()
{
    if(errorCode)
	return 0;
    skipBlanks();
    if(buffer[pos]<'0'||buffer[pos]>'9')
	{
	errorCode=peNumberExpected;
	return 0;
	}
    unsigned int ret=0;
    if(buffer[pos]=='0'&&(buffer[pos+1]=='x'||buffer[pos+1]=='X'))
	//reading a hex number
	{
	pos+=2;
	while(isxdigit(buffer[pos]))
	    {
	    ret=ret*16+xValue(buffer[pos]);
	    pos++;
	    }
	}
    else
	//reading a decimal int
	{
	while(buffer[pos]>='0'&&buffer[pos]<='9')
	    {
	    ret=ret*10+(buffer[pos]-'0');
	    pos++;
	    }
	}
    return ret;
}

//returns a lookahead character (skips blanks)
char TextParser::lookAhead()
{
    if(errorCode)
	return 0;
    skipBlanks();
    return buffer[pos];
}

//returns a lookahead character without skipping blanks
char TextParser::nextChar()
{
    if(errorCode)
	return 0;
    return buffer[pos];
}

//advances a character in input
void TextParser::popChar()
{
    if(errorCode)
	return;
    if(buffer[pos]=='\0')
	errorCode=peUnexpectedEOL;
    else
	pos++;
}

//checks if next word in input is 'word'
int TextParser::wLookAhead(char* word)
{
    int n;
    if(errorCode)
	return 0;
    skipBlanks();
    for(n=0;word[n]!='\0';n++)
	if(buffer[pos+n]!=word[n])
	    break;
    if(word[n]=='\0'&&!isWordInterior(buffer[pos+n]))
	return 1;
    else
	return 0;
}

//advances a word in input and if the buf is not NULL returns in it the word
//just read (skips first blanks)
void TextParser::popWord(char* buf)
{
    int n;
    if(errorCode)
	{
	if(buf!=NULL)
	    buf[0]='\0';
	return;
	}
    skipBlanks();
    if(!isWordBegining(buffer[pos]))
	{
	errorCode=peWordExpected;
	return;
	}
    n=0;
    do
	{
	if(n==MaxWordLength)
	    {
	    errorCode=peWordTooLong;
	    if(buf!=NULL)
		buf[n]=0;
	    return;
	    }
	if(buf!=NULL)
	    buf[n]=buffer[pos];
	n++;
	pos++;
	}
    while(isWordInterior(buffer[pos]));
    if(buf!=NULL)
	buf[n]='\0';
}

int TextParser::errorInfo(int* position,const char** line,int* lineNum)
{
    if(position!=0)
	*position=pos;
    if(line!=0)
	*line=buffer;
    return errorCode;
}

//
//TextfileParser class
//
TextfileParser::TextfileParser(const char* filename):
    TextParser(rBuffer)
{
    if((f=fopen(filename,"rt"))==NULL)
	setErrorCode(peOpenFailure);
    lineNr=0;
}

TextfileParser::~TextfileParser()
{
    if(f!=NULL)
	fclose(f);
}

int TextfileParser::getLine()
{
    if(getErrorCode())
	return 0;
    do
	{
	fgets(rBuffer,MaxTextLineLength+2,f);
	if(feof(f))
	    {
	    setErrorCode(peUnexpectedEOF);
	    return 0;
	    }
	if(rBuffer[strlen(rBuffer)-1]=='\n')
	    rBuffer[strlen(rBuffer)-1]='\0';
	if(strlen(rBuffer)<=MaxTextLineLength)
	    //incrementing the line counter just if the line is read entirely
	    lineNr++;
	pos=0;
	skipBlanks();	//for being able to skip in case it's comment or blank
	}
    while (rBuffer[0]==';'||rBuffer[pos]=='\0');
    if(strlen(rBuffer)>MaxTextLineLength)
	//the line is too long
	{
	//but we have to read it until it's end
	getLine();
	setErrorCode(peLineTooLong);
	return 0;
	}
    return 1;
}

int TextfileParser::errorInfo(int* position,const char** line,int* lineNum)
{
    if(lineNum!=0)
	*lineNum=lineNr;
    return TextParser::errorInfo(position,line,lineNum);
}

const char* TextfileParser::GetLine()
{
	return rBuffer+pos;
}

int TextfileParser::GetLineNr()
{
	return lineNr;
}
