#include <time.h>
#include <string.h>
#include <assert.h>
#include "query.h"
#include "../../comuni/linecol.h"
#include "../messages.h"

#ifndef ENGLISH
#define STR_BE1 "\"Inizio\""
#define STR_BE2 "\"Fine\""
#define STR_TOTS "Totali"
#else
#define STR_BE1 "\"Begin\""
#define STR_BE2 "\"End\""
#define STR_TOTS "Totals"
#endif
//inserts the table header and other infos
int Query::insHeader(LineCollection * table,const char* c1,const char* c2)
{
	string ini="\"";
	string end="\"";
	end+=m_CsvSep;
	end+="\n";
	
	if (!outcsv)
	{
		ini="";
		if (table) end="";
		else end="\n";
	}
	else if (table) {end="\"";end+=m_CsvSep;};

	string str,vis,vis2;

	if (c1)
	{
		if(!outcsv) return 0;
		vis2="\"";
		vis2+=c1;
		vis2+="\"";
	}
	else 
		vis2="\"hh:mm:ss\"";
	vis2+=m_CsvSep;
	if (c2)
	{
		vis2+="\"";
		vis2+=c2;
		vis2+="\"";
	}
	else 
		vis2+="\"hh:mm:ss\"";
	vis2+=m_CsvSep;

	int num_vis=0;
	if(c1==NULL)
	{
		str=ini+QE_INFO+end;
		if (table) table->insert(str);
		else fprintf(outfile,str);

		if (ob->reportFrameCount())
		{
			str=ini+QE_NUM+end;
			if (table) table->insert(str);
			else fprintf(outfile,str);
			num_vis++;
			vis+="\"f\"";
			vis+=m_CsvSep;
		}

		if (ob->reportFrameRate())
		{
			str=ini+QE_FR+end;
			if (table) table->insert(str);
			else fprintf(outfile,str);
			num_vis++;
			vis+="\"f/s\"";
			vis+=m_CsvSep;
		}
	
	    if (ob->reportFramePercentage())
		{
			str=ini+QE_NF+end;
			if (table) table->insert(str);
			else fprintf(outfile,str);
			num_vis++;
			vis+="\"f %%\"";
			vis+=m_CsvSep;
		}

		if (ob->reportByteCount())
		{	
			str=ini+QE_NB+end;
			if (table) table->insert(str);
			else fprintf(outfile,str);
			num_vis++;
			vis+="\"b\"";
			vis+=m_CsvSep;
		}

		if (ob->reportByteRate())
		{
			str=ini+QE_DR+end;
			if (table) table->insert(str);
			else fprintf(outfile,str);
			num_vis++;
			vis+="\"b/s\"";
			vis+=m_CsvSep;
		}

		if (ob->reportBytePercentage())
		{
			str=ini+QE_DRP+end;
			if (table) table->insert(str);
			else fprintf(outfile,str);
			num_vis++;
			vis+="\"b %%\"";
			vis+=m_CsvSep;
		}

		if (ob->reportBytesPerFrame())
		{
			str=ini+QE_AFS+end;
			if (table) table->insert(str);
			else fprintf(outfile,str);
			num_vis++;
			vis+="\"bpf\"";
			vis+=m_CsvSep;
		}
	} 
	else 
	{
		if (ob->reportFrameCount())
		{
			num_vis++;
			vis+="\"f\"";
			vis+=m_CsvSep;
		}

		if (ob->reportFrameRate())
		{
			num_vis++;
			vis+="\"f/s\"";
			vis+=m_CsvSep;
		}
	
	    if (ob->reportFramePercentage())
		{
			num_vis++;
			vis+="\"f %%\"";
			vis+=m_CsvSep;
		}

		if (ob->reportByteCount())
		{	
			num_vis++;
			vis+="\"b\"";
			vis+=m_CsvSep;
		}

		if (ob->reportByteRate())
		{
			num_vis++;
			vis+="\"b/s\"";
			vis+=m_CsvSep;
		}

		if (ob->reportBytePercentage())
		{
			num_vis++;
			vis+="\"b %%\"";
			vis+=m_CsvSep;
		}

		if (ob->reportBytesPerFrame())
		{
			num_vis++;
			vis+="\"bpf\"";
			vis+=m_CsvSep;
		}
	}

	if(! outcsv)
	{
     if (table) table->insert(QE_GROUPS);
	  else fprintf(outfile,QE_GROUPS "\n");
    
	 int n;
     for(n=0;n<groups.get_n_el();n++)
	  if (table) table->insert(" %d.%s",n+1,group(n)->getName());
		else fprintf(outfile," %d.%s\n",n+1,group(n)->getName());
	}
	else
	{
	  string h;
	  h="";
	  h+=m_CsvSep;
	  if (table) table->insert(h);
		else fprintf(outfile,h+"\n");
	 int n,i;
	 char tmp[500];
	 if(c1) 
		 str="\"\"";
	 else
		str=STR_BE1;
	 str+=m_CsvSep;
	 if(c2) 
		 str+="\"\"";
	 else
		str+=STR_BE2;
	 str+=m_CsvSep;
	 if (!table) fprintf(outfile,str);
     for(n=0;n<groups.get_n_el();n++)
	 {
	  if (table) 
	  {
		  sprintf(tmp,"\"%d.%s\"%c",n+1,group(n)->getName(),m_CsvSep);
		  str+=tmp;
	  }
		else fprintf(outfile,"\"%d.%s\"%c",n+1,group(n)->getName(),m_CsvSep);
	  for(i=1;i<num_vis;i++)
	   if (table) str+=m_CsvSep;
		 else fprintf(outfile,"%c",m_CsvSep);
	 }
	 if (!table) fprintf(outfile,"\n");
		else table->insert(str);
	 if (outcsv) str=vis2;
	  else str="";
	 if (!table) fputs(str,outfile);
	 for(n=0;n<groups.get_n_el();n++)
	 {
	  if (table) 
	  {
		  str+=vis;
	  }
		else fprintf(outfile,vis);
	 }
	 if (!table) fprintf(outfile,"\n");
		else table->insert(str);
	}
	return num_vis;
}

//inserts first table lines
void Query::insTableHeader(char * buffer, LineCollection * table)
{
	if(!outcsv)
	{
 	 int n;
	 if (table) 
	 {
      buffer[0]=ulCorner;
      for(n=1;n<9+groups.get_n_el()*11;n++)
        if((n-9)%11==0)
	    buffer[n]=uT;
        else
	    buffer[n]=hLine;
      buffer[9+groups.get_n_el()*11]=urCorner;
      buffer[10+groups.get_n_el()*11]='\0';
      table->insert(buffer);
      buffer[0]=vLine;
      strcpy(buffer+1,QE_TIMEGR);
      buffer[9]=vLine;
      for(n=0;n<groups.get_n_el();n++)
	   sprintf(buffer+10+n*11,QE_GRP,n+1,vLine);
      table->insert(buffer);
	 }
	 else
	 {
	  putc(ulCorner,outfile);
      for(n=1;n<9+groups.get_n_el()*11;n++)
        if((n-9)%11==0)
	     putc(uT,outfile);
        else
	     putc(hLine,outfile);
	  putc(urCorner,outfile);
	  putc('\n',outfile);
	  putc(vLine,outfile);
	  fputs(QE_TIMEGR,outfile);
	  putc(vLine,outfile);
      for(n=0;n<groups.get_n_el();n++)
	   fprintf(outfile,QE_GRP ,n+1,vLine);
	  putc('\n',outfile);
	 }
	}
}

void Query::insTable2Header(char * buffer, LineCollection * table)
{
	if(outcsv)
	{
	 string str=""; str+=m_CsvSep; 
	 int n;
	 char tmp[500];
	 if (!table) fprintf(outfile,"%c\n\"\"%c\"\"%c",m_CsvSep,m_CsvSep,m_CsvSep);
     for(n=0;n<groups.get_n_el();n++)
	 {
	  if (table) 
	  {
		  sprintf(tmp,"\"%d.%s\"%c",n+1,group(n)->getName(),m_CsvSep);
		  str+=tmp;
	  }
		else fprintf(outfile,"\"%d.%s\"%c",n+1,group(n)->getName(),m_CsvSep);
	 }
	 if (!table) fprintf(outfile,"\n");
		else table->insert(str);
	}
}

void Query::insTableFooter(char * buffer, LineCollection * table)
{
	if(!outcsv)
	{
 	 int n;
	 if (table) 
	 {
      buffer[0]=llCorner;
      for(n=1;n<9+groups.get_n_el()*11;n++)
        if((n-9)%11==0)
	    buffer[n]=loT;
        else
	    buffer[n]=hLine;
      buffer[9+groups.get_n_el()*11]=lrCorner;
      table->insert(buffer);
	 }
	 else
	 {
	  putc(llCorner,outfile);
      for(n=1;n<9+groups.get_n_el()*11;n++)
         if((n-9)%11==0)
	      putc(loT,outfile);
         else
	      putc(hLine,outfile);
	  putc(lrCorner,outfile);
	  putc('\n',outfile);
	 }
    } 
	else
	{
	 string str;
	 str+=m_CsvSep;
	 if (!table) {str+="\n";fprintf(outfile,str);}
		else table->insert(str);
	}

}

//inserts a separation line in the table using buffer
void Query::separatorLine(char* buffer, LineCollection* table)
{
    int n;
	if (table) 
	{
     buffer[0]=leT;
     for(n=1;n<9+groups.get_n_el()*11;n++)
       if((n-9)%11==0)
	   buffer[n]=cross;
       else
	   buffer[n]=hLine;
     buffer[9+groups.get_n_el()*11]=rT;
     table->insert1(buffer);
	}
	else
	{
	 putc(leT,outfile);
     for(n=1;n<9+groups.get_n_el()*11;n++)
       if((n-9)%11==0)
	   putc(cross,outfile);
       else
	   putc(hLine,outfile);
	 putc(rT,outfile);
	 putc('\n',outfile);
	}
}

//inserts a line with data in the table using buffer; for reporting
//values data[index] is used and model is used to build every cell
void Query::dataLine(char* buffer, LineCollection* table,char*model,
    int index)
{
    int n;
	if (table) 
	{
		buffer[0]=vLine;
		buffer[9]=vLine;
		for(n=0;n<groups.get_n_el();n++)
		{
			sprintf(buffer+10+n*11,model,group(n)->getData(index),vLine);
			buffer[20+n*11]=vLine;
		}
		buffer[10+n*11]='\0';
		table->insert1(buffer);
	}
	else
	{
		putc(vLine,outfile);
		buffer[9]='\0';
		fputs(buffer+1,outfile);
		putc(vLine,outfile);
		for(n=0;n<groups.get_n_el();n++)
		{
			fprintf(outfile,model,group(n)->getData(index));
			putc(vLine,outfile);
		}
		putc('\n',outfile);
	}
}

//the formats for reporting different kinds of values
char* format[]=
{
"%9luf",
"%7uf/s",
"  f  %3u%% ",
"%9lub",
"%7lub/s",
"  b  %3u%% ",
"  %4u bpf"
};

//builds a cell row, puting in the first column hdr1 and hdr2(if not NULL)
//and reporting data starting from baseIndex and up to baseIndex + 6
void Query::cellRow(char* buffer,LineCollection*table,char*hdr1,char*hdr2,
    int baseIndex)
{
	if(!outcsv)
	{
     separatorLine(buffer,table);
     int opNr;
     int nrLine=0;	//the number of lines drawn
     for(opNr=1;opNr<=7;opNr++) 
	 //we draw a line for every value to report (if requested by options)
	  if(ob->getOption(opNr))
	     {
	     //preparing the first column
	      if(nrLine==0)
 		  memcpy(buffer+1,hdr1,8);
	      else
		   if(nrLine==1&&hdr2!=NULL)
		     memcpy(buffer+1,hdr2,8);
		   else
		     memcpy(buffer+1,"        ",8);
	      int dataNr=opNr-1;
		  dataLine(buffer,table,format[dataNr],baseIndex+dataNr);
	      nrLine++;
	     }
     if(nrLine==0)
	 {
	  memcpy(buffer+1,hdr1,8);
	  dataLine(buffer,table,"          ",0);
	  nrLine++;
	 }
     if(nrLine==1&&hdr2!=NULL)
	 {
	  memcpy(buffer+1,hdr2,8);
	  dataLine(buffer,table,"          ",0);
	 }
	}
	else
	{
	 string str;
	 char tmp[20];
	 str="\"";
	 if(hdr1)
		{if (hdr1[8]!='\0')hdr1[8]='\0';str+=hdr1;}
	 str+="\"";
	 str+=m_CsvSep;
	 str+="\"";
	 if(hdr2)
		{if (hdr2[8]!='\0')hdr2[8]='\0';str+=hdr2;}
	 str+="\"";
	 str+=m_CsvSep;
	 int n;
	 for(n=0;n<groups.get_n_el();n++)
		{
		    if (ob->reportFrameCount()) 
			{
				sprintf(tmp,"%d%c",group(n)->getData(0+baseIndex),m_CsvSep);
				str+=tmp;
			}
		    if (ob->reportFrameRate())
			{
				sprintf(tmp,"%d%c",group(n)->getData(1+baseIndex),m_CsvSep);
				str+=tmp;
			}
			if (ob->reportFramePercentage())
			{
				sprintf(tmp,"%d%c",group(n)->getData(2+baseIndex),m_CsvSep);
				str+=tmp;
			}
		    if (ob->reportByteCount()) 
			{
				sprintf(tmp,"%d%c",group(n)->getData(3+baseIndex),m_CsvSep);
				str+=tmp;
			}
		    if (ob->reportByteRate())
			{
				sprintf(tmp,"%d%c",group(n)->getData(4+baseIndex),m_CsvSep);
				str+=tmp;
			}
			if (ob->reportBytePercentage())
			{
				sprintf(tmp,"%d%c",group(n)->getData(5+baseIndex),m_CsvSep);
				str+=tmp;
			}
			if (ob->reportBytesPerFrame())
			{
				sprintf(tmp,"%d%c",group(n)->getData(6+baseIndex),m_CsvSep);
				str+=tmp;
			}
		}
	    if (!table) {str+="\n";fprintf(outfile,str);}
			 else table->insert(str);
	}
}

void Query::dataLine(char* buffer, LineCollection* table, int model,
    int index)
{
	dataLine(buffer,table,format[model],index);
}

void Query::reportMessage(char * m1, const char * m2, LineCollection * table)
{
	string s;
	if (outcsv) {s="\"";s+=m1;s+="\"";s+=m_CsvSep;}
	else s=m1;
    if (table) table->insert(s,m2);
	else {fprintf(outfile,s,m2);putc('\n',outfile);}
}

void Query::SetCsv()
{
	outcsv=1;
}

void Query::insTotals(char * buffer, LineCollection * table)
{
	if(!outcsv)
	{
	 int nrLine=0;
	 separatorLine(buffer,table);
	 if(ob->reportFrameCount())
	    {
	    memcpy(buffer+1,QE_TOT,8);
	    dataLine(buffer,table,0,totalFC);
	    nrLine++;
	    }
	 if(ob->reportByteCount())
	    {
	    if(nrLine==0)
		memcpy(buffer+1,QE_TOT,8);
	    else
		memcpy(buffer+1,"        ",8);
	    dataLine(buffer,table,3,totalBC);
	    nrLine++;
	    }
	 if(nrLine==0)
	    {
	    memcpy(buffer+1,QE_TOT,8);
	    dataLine(buffer,table,"          ",vFC);
	    }
	}
	else
	{
	 string str,pv,pv2;
	 char tmp[20];
	 int n;
     if (ob->reportFrameCount())
	 {
	  str="\"";
	  str+=STR_TOTS /*Totali*/;
	  str+="\"";
	  str+=m_CsvSep;
	  str+="\"";
	  str+="(f)";
	  str+="\"";
	  str+=m_CsvSep;
	  for(n=0;n<groups.get_n_el();n++)
		{
			sprintf(tmp,"%d%c",group(n)->getData(totalFC),m_CsvSep);
			str+=tmp;
		}
	 }
	 if (!table) {str+="\n";fprintf(outfile,str);}
		else table->insert(str);
	 if (ob->reportByteCount())
	 {
	  str="\"";
	  str+=STR_TOTS /*Totali*/;
	  str+="\"";
	  str+=m_CsvSep;
	  str+="\"";
	  str+="(b)";
	  str+="\"";
	  str+=m_CsvSep;
	  for(n=0;n<groups.get_n_el();n++)
		{
			sprintf(tmp,"%d%c",group(n)->getData(totalBC),m_CsvSep);
			str+=tmp;
		}
	  if (!table) {str+="\n";fprintf(outfile,str);}
		else table->insert(str);
	 }
	}
}

void Query::insExtreme(char * buffer, LineCollection * table)
{
	if(!outcsv)
	{
	 separatorLine(buffer,table);
	 memcpy(buffer+1,QE_ABSMAX,8);
	 dataLine(buffer,table,6,maxFS);
	 memcpy(buffer+1,QE_ABSMIN,8);
	 dataLine(buffer,table,6,minFS);
	}
	else
	{
	 string str;
	 char tmp[20];
	 int n;
	 str="\"";
	 str+=QE_ABSMAX;
	 str+="\"";
	 str+=m_CsvSep;
	 str+="\"";
	 str+="(bpf)";
	 str+="\"";
	 str+=m_CsvSep;
	 for(n=0;n<groups.get_n_el();n++)
		{
		    sprintf(tmp,"%d%c",group(n)->getData(maxFS),m_CsvSep);
			str+=tmp;
		}
	 if (!table) {str+="\n";fprintf(outfile,str);}
		else table->insert(str);
	 str="\"";
	 str+=QE_ABSMIN;
	 str+="\"";
	 str+=m_CsvSep;
	 str+="\"";
	 str+="(bpf)";
	 str+="\"";
	 str+=m_CsvSep;
	 for(n=0;n<groups.get_n_el();n++)
		{
		    sprintf(tmp,"%d%c",group(n)->getData(minFS),m_CsvSep);
			str+=tmp;
		}
	 if (!table) {str+="\n";fprintf(outfile,str);}
		else table->insert(str);
	}
}
