//				READERS.CPP
// this file contains the function used for reading the parameter definition
//and query files and all the 'initialize' members of the objects involved

#include <string.h>
#include "readers.h"
#include "parser.h"
#include "query.h"
#include "../../comuni/linecol.h"
#include "../../comuni/rprogress.h"
#include "../messages.h"

//parameter name collection error codes
#define pnOK			0
#define pnAlreadyExists		2
#define pnTooManyNamesDefined	3

//parameter definition error codes
#define pdOK			0
//inheriting the pn... codes
#define pdBadExpression		50
#define pdBadFormula		51
#define pdBadName		52
#define pdInvalidFunction	53

#ifndef ENGLISH
#define ERR_OUT "Impossibile aprire il file di output"
#else
#define ERR_OUT "Unable to open output file"
#endif

//the textual forms of the Yes/No options (at queries)
char* optionKeywords[]=
{
"UseSemigraphicCharacters",
"ReportFrameCount",
"ReportFrameRate",
"ReportFramePercentage",
"ReportByteCount",
"ReportByteRate",
"ReportBytePercentage",
"ReportFrameSize",
"ReportTotals",
"ReportAverages",
"ReportMaximums",
"ReportMinimums",
"ReportExtremeFramesizes",
"ReportJustFinal"
};
#define NrOptions 14

int lowMem();

#include "istruzioni.h"

extern int BeginParsing();
extern ProtocolVect *proto;
extern char* TextToParse;
extern int errorflag,i_ind,c_ind,nc;
extern vector <istruzione> *ist;
extern vector <int> *crea_vars;
extern vector <Cost> *costanti;
extern int yylineno_offset;
extern LineCollection* lcp;
extern int genvars;

void ParseExpression(LineCollection *lc,Istruzioni &i,CPacketDescriber &pdesc,char* fltr, int o)
{
	vector <int> r_crea_vars;
	vector <Cost> r_costanti;
	vector <istruzione> r_ist;

	crea_vars=&r_crea_vars;
	costanti=&r_costanti;
	ist=&r_ist;

	proto=&pdesc.proto;
	TextToParse=fltr;
	yylineno_offset=o-1;
	lcp=lc;
	i_ind=0;c_ind=0;nc=0;
	BeginParsing();
	if (errorflag){i_ind=0;c_ind=0;nc=0;}

	i.genvars=genvars;
	i.SetIstr(r_ist,i_ind);
	i.SetCost(r_costanti,nc);
	i.SetCrVar(r_crea_vars,c_ind);
}

//checks the amount of free memory reporting failure
int lowMemo(LineCollection* errorReport)
{
    if(lowMem())
	{
	errorReport->insert(E_NOMEM);
	return 1;
	}
    return 0;
}

const char* interpretParserError(int code)
{
    switch(code)
	{
	case peOK:return RE_OK;
	case peOpenFailure:return RE_OPFAIL;
	case peUnexpectedEOF:return RE_UEOF;
	case peLineTooLong:return RE_LTL;
	case peNumberExpected:return RE_NUMEXP;
	case peUnexpectedEOL:return RE_UEOLN;
	case peRightParanthExpected:return RE_RPE;
	case peWordExpected:return RE_WE;
	case peLeftSqBracketExp:return RE_LSBE;
	case peRigthSqBracketExp:return RE_RSBE;
	case peNumberUpTo7Expected:return RE_NUT7E;
	case peCommaExpected:return RE_CE;
	case peWordTooLong:return RE_WTL;
	case peBoolExprExpected:return RE_BEE;
	case peOperatorExpected:return RE_EOLTOE;
	case peStringExprExpected:return RE_SEE;
	case peHexDigitExpected:return RE_HDE;
	case peStringTooLong:return RE_STL;
	case peWrongDecimalString:return RE_WDS;
	case pePeriodExpected:return RE_PE;
	case peWrongEscapeSequence:return RE_WES;
	case peInvalidNumber:return RE_IN;
	case peUnknownParameter:return RE_UBP;
	case peUnknownStrParameter:return RE_USP;
	case peUnknownIntParameter:return RE_UIP;
	case peIntegerExprExpected:return RE_IEE;
	case peArithOperExpected:return RE_AOE;
	default:return RE_UE;
	}
}
//reports a parser error and resets error code to allow further processing
void reportError(TextfileParser* file,LineCollection* errorReport)
{
    int linenum,pos,n;
    char* line;
    char buffer[MaxTextLineLength+1];
    const char* errMessage;
    errMessage=interpretParserError(file->getErrorCode());
    file->errorInfo(&pos,(const char **)&line,&linenum);
    errorReport->insert(RE_SYNERR,linenum,errMessage);
    errorReport->insert(line);
    for(n=0;n<pos;n++)
	buffer[n]=' ';
    buffer[n++]='^';
    buffer[n]='\0';
    errorReport->insert(buffer);
    file->resetErrorCode();
}
//reports a parser error
void reportDefError(int defCode,LineCollection* errorReport,char* variable,
    TextfileParser* file)
{
    char* errorMessage;
    int lineNum;
    file->errorInfo(0,0,&lineNum);
    switch(defCode)
	{
	case pnAlreadyExists:errorMessage=RE_PAD;break;
	case pnTooManyNamesDefined:errorMessage=RE_TMPD;break;
	case pdBadExpression:errorMessage=RE_INCE;break;
	case pdBadFormula:errorMessage=RE_INCF;break;
	case pdBadName:errorMessage=RE_INVPN;break;
	case pdInvalidFunction:errorMessage=RE_INVF;break;
	default:errorMessage=RE_UNKNOWN;break;
	}
    errorReport->insert(RE_ERRDEF,variable,
	lineNum-1,errorMessage);	//-1 because we already read the next
}

//
//readQuery section
//

//tries to read a keyword from a file ...
//return codes: 0 OK; 1 EOF; 2 otherError
int keyword(TextfileParser* file,LineCollection* errorReport,char* keyword)
{
    int lineNum;	//for helping at error reporting
    if(file->getErrorCode()==peUnexpectedEOF)
	{
	errorReport->insert(RE_UNEXPEOF);
	return 1;
	}
    if(file->getErrorCode()==peLineTooLong)
	{
	file->errorInfo(0,0,&lineNum);
	errorReport->insert(RE_TOOLONG,lineNum);
	return 2;
	}
    if(!file->wLookAhead(keyword))
	{
	file->errorInfo(0,0,&lineNum);
	errorReport->insert(RE_BADKEY,lineNum,keyword);
	return 2;
	}
    //popping the keyword
    file->popWord();
    if(file->lookAhead()!='=')
	{
	errorReport->insert(RE_EQNF,keyword);
	return 2;
	}
    file->popChar();
    return 0;
}

//initializes the option block reading from the given file,reporting
//any errors and returning 1 just if everything is OK
int OptionBlock::initialize(TextfileParser* file,LineCollection* errorReport,CPacketDescriber &pdesc)
{
    int n,errorOccured;
    int lineNum;	//for helping at error reporting
    options=0;
    //reading the Yes/No options
    for(n=errorOccured=0;n<NrOptions;n++)
	{
	//reading the keyword
	file->resetErrorCode();
	file->getLine();
	switch(keyword(file,errorReport,optionKeywords[n]))
	    {
	    case 1://EOF
		return 0;
	    case 2://a lighter error occured
		errorOccured=1;
		continue;
	    default:;//OK
	    }
	//reading the option
	char buffer[MaxWordLength+1];
	file->popWord(buffer);
        if (buffer[0]=='Y')buffer[0]='y';
	if (buffer[1]=='E')buffer[1]='e';
	if (buffer[2]=='S')buffer[2]='s';
	if(strcmp(buffer,"yes")==0)
	    options|=(0x1<<n);
	else
	   {
	    //it should be no
	    if (buffer[0]=='N')buffer[0]='n';
	    if (buffer[1]=='O')buffer[1]='o';
	    if(strcmp(buffer,"no")!=0)
		{
		errorReport->insert(RE_BADYN
		    ,optionKeywords[n],buffer);
		errorOccured=1;
		}
	    }
	}
	if(options==0) options=1;
    //reading the length of the analysis time interval
    file->resetErrorCode();
    file->getLine();
    switch(keyword(file,errorReport,"LengthOfInterval"))
	{
	case 1://EOF
	    return 0;
	case 2://a lighter error occured
	    errorOccured=1;
	    break;
	default://OK reading the time info in 'hours minutes seconds' format
	    interval=0;
	    int factor;
	    for(factor=3600;factor>0;factor=factor/60)
		{unsigned int val;
		val=file->readNumber();
		if(file->getErrorCode())
		    {
		    file->errorInfo(0,0,&lineNum);
		    errorReport->insert(RE_BADTIMEFMT,lineNum);
		    errorOccured=1;
		    break;
		    }
		interval+=((long)factor)*val;
		}
	}
    //reading the predicate that will qualify the frames for analysis
    file->resetErrorCode();
    file->getLine();
    switch(keyword(file,errorReport,"ExcludedFrames"))
	{
	case 1://EOF
	    return 0;
	case 2://a lighter error occured
	    errorOccured=1;
	default://OK reading the info;
	    ParseExpression (errorReport,exclude,pdesc,(char*)file->GetLine(),file->GetLineNr());
	    if(errorflag)
		{
		errorOccured=1;
		}
	}
    //reading the name of the integer parameter to be counted as packet
    //length if the groups don't supply something usefull
    file->resetErrorCode();
    file->getLine();
    switch(keyword(file,errorReport,"DefaultLengthParameter"))
	{
	case 1://EOF
	    return 0;
	case 2://a lighter error occured
	    errorOccured=1;
	default://OK reading the info;
	    ParseExpression (errorReport,lenParam,pdesc,(char*)file->GetLine(),file->GetLineNr());
	    if(errorflag)
		{
		errorOccured=1;
		}
	}
    if(errorOccured)
	return 0;
    else
	return 1;
}

//reads the group from the given file reporting the encountered errors; if
//file is eroneous returns 0
int Group::initialize(TextfileParser* file,LineCollection* errorReport,CPacketDescriber &pdesc)
{
    int errorOccured=0;
    //reading the name of the group
    switch(keyword(file,errorReport,"GroupName"))
	{
	case 1://EOF
	    return 0;
	case 2://a lighter error occured
	    errorOccured=1;
	default://OK reading the info;
	    file->popWord(groupName);
	    if(file->getErrorCode())
		{
		reportError(file,errorReport);
		errorOccured=1;
		}
	}
    file->resetErrorCode();
    file->getLine();
	const char* cap;
    switch(keyword(file,errorReport,"OutCap"))
	{
	case 1://EOF
	    return 0;
	case 2://a lighter error occured
	    errorOccured=1;
	default://OK reading the info;
		cap=(char*)file->GetLine();
		while (cap[0]==' ' || cap[0]=='\t' || cap[0]=='\n') {cap++;}
		strcpy(capName,cap);
	    if(file->getErrorCode())
		{
		errorOccured=1;
		}
		if (capName[0]!='\0') 
		{
			saveCap=new CSaveCap(NULL);
			if(!saveCap->pcap_dump_open(capName)) {delete saveCap; saveCap=NULL;}
		}
	}
    file->resetErrorCode();
    file->getLine();
    //reading the predicate
    switch(keyword(file,errorReport,"Predicate"))
	{
	case 1://EOF
	    return 0;
	case 2://a lighter error occured
	    errorOccured=1;
	default://OK reading the info;
	    ParseExpression (errorReport,predicate,pdesc,(char*)file->GetLine(),file->GetLineNr());
	    if(errorflag)
		{
		errorOccured=1;
		}
	}
    file->getLine();
    //reading the parameter to report as length
    switch(keyword(file,errorReport,"LengthParameter"))
	{
	case 1://EOF
	    return 0;
	case 2://a lighter error occured
	    errorOccured=1;
	default://OK reading the info;
	    ParseExpression (errorReport,lenParam,pdesc,(char*)file->GetLine(),file->GetLineNr());
	    if(errorflag)
		{
		errorOccured=1;
		}
	}
    if(errorOccured)
	return 0;
    else
	return 1;
}

Group& Group::operator = (Group& g)
{
	frameCount=g.frameCount;
    byteCount=g.byteCount;
    lastFrameLen=g.lastFrameLen;
    for(int i=0;i<25;i++)data[i]=g.data[i];
    predicate=g.predicate;
    lenParam=g.lenParam;
	strcpy(groupName,g.groupName);
	return g;
}

//reads the query from the given file reporting the encountered errors; if
//file is eroneous returns 0
Query::initialize(TextfileParser* file,LineCollection* errorReport,CPacketDescriber &pdesc)
{
    //reading the options
    int Ok;
    ob=new OptionBlock;
    if(lowMemo(errorReport))
	return 0;
	Ok=ob->initialize(file,errorReport,pdesc);
    if(Ok)
	//initializing the bricks for the table as requested in options
	if(ob->useSemigraphicCharacters())
	    {
	    ulCorner =	0xDA;
	    uT =	0xC2;
	    urCorner =	0xBF;
	    leT =	0xC3;
	    cross =	0xC5;
	    rT =	0xB4;
	    llCorner =	0xC0;
	    loT =	0xC1;
	    lrCorner =	0xD9;
	    hLine =	0xC4;
	    vLine =	0xB3;
	    }
	else
	    {
	    ulCorner =	'/';
	    uT =	'+';
	    urCorner =	'\\';
	    leT =	'+';
	    cross =	'+';
	    rT =	'+';
	    llCorner =	'\\';
	    loT =	'+';
	    lrCorner =	'/';
	    hLine =	'-';
	    vLine =	'|';
	    }
    //reading the groups
    file->getLine();
    while(file->getErrorCode()!=peUnexpectedEOF)
	{
	reportProgress(0);
	Group* newGroup;
	newGroup=new Group;
	if(newGroup->initialize(file,errorReport,pdesc))	/// !!!!!!!!!!!!!!!
	    {
	    groups[groups.get_n_el()]=newGroup;
	    if(lowMemo(errorReport))
		return 0;
	    }
	else
		{
	    delete newGroup;
		return 0;
		}
	file->resetErrorCode();
	file->getLine();
	}
    //check if table wouldn't be too large to fit
	if (outfile==NULL)
    if(9+11*groups.get_n_el()>=MaxLineLength)
	{
	errorReport->insert(RE_TOOGRPS,groups.get_n_el());
	return 0;
	}
	if(!Ok) return 0;
    return 1;
}

//reads the query from the given file reporting the encountered errors; if
//file is eroneous returns NULL
Query* readQuery(const char* fileName,const char* out ,LineCollection* errorReport,CPacketDescriber &pdesc)
{
    //initial messages
	{
	time_t crtTime;
	char * chars;		//for the textual form of the time
	crtTime=time(NULL);
	chars=ctime(&crtTime);
	chars[24]='\0';
	errorReport->insert(RE_ERRQRY
	    ,fileName,chars);
	}
    //opening the file
    TextfileParser file(fileName);
    if(file.getErrorCode())
	{
	errorReport->insert(RE_ERROF);
	return NULL;
	}
    Query* rez;
    rez=new Query;
	if (out && out[0]!='\0')
	{
	  if(rez->SetFile(out)) 
	  {
		  Say(ERR_OUT /*Impossibile aprire il file di output*/);
		  delete rez;
		  rez=NULL;
		  return NULL;
	  }
	}
    if(!rez->initialize(&file,errorReport,pdesc))
	{
	delete rez;
	return NULL;
	}
    errorReport->clear();
    return rez;
}
