#include "reporter.h"
#include <stdio.h>
#include <string.h>
#include "evm/expvm.h"

#ifndef ITALIANO
#define RP_EMLOG "Error moving through Logfile"
#define RP_NOPARLD "No parameter definitions loaded"
#define RP_ERRFLT "Error in filter, position %d, code %s"
#define RP_EOF "End Of File reached"
#define RP_BOF "Begin Of File reached"
#define ERR_NOFLT "No filter defined"
#define ERR_MOVE "Error moving through capture"
#else
#define RP_EMLOG "Errore muovendosi nel Logfile"
#define RP_NOPARLD "Non e' stato caricato un file PDF"
#define RP_ERRFLT "Filtro errato, posizione %d, codice %s"
#define RP_EOF "Raggiunto l'End Of File"
#define RP_BOF "Raggiunto il Begin Of File"
#define ERR_NOFLT "Nessun filtro valido impostato"
#define ERR_MOVE "Errore muovendosi nei pacchetti"
#endif


Reporter::Reporter(const char* lfoName,const char* pfoName,
	      const char* dfoName,const char* ifoName,const char* lfName, 
		  char* fltr):LogfileReader(lfName,lfoName)
{
	cItem=NULL;
    lfname=NULL;
    pfoname=NULL;
    dfoname=NULL;
    ifoname=NULL;
	filter=NULL;
	if(errorCode!=freOK && errorCode!=freBOF) return;
	else errorCode=freOK;
    filter=NULL;
	lfp= (LogfileReader*) this;
    if (fltr!=NULL) setFilter(fltr); else filter=NULL;
    myerror[0]='\0';
    lfname=new char[strlen(lfName)+1];
    pfoname=new char[strlen(pfoName)+1];
    strcpy(lfname,lfName);
    strcpy(pfoname,pfoName);
	if (errorCode==freOK) 
		if (pfoname[0]=='\0' || pdesc.OpenDescription(pfoName)) 
		{
			errorCode =freBadPDO; 
			delete[] pfoname; 
			pfoname=NULL; 
		}
		else
		{
		    dfoname=new char[strlen(dfoName)+1];
			strcpy(dfoname,dfoName);
		}
	if (errorCode==freOK) 
		if (pdesc.OpenCode(dfoName)) 
		{
			errorCode =freBadDFO;
			delete[] dfoname; 
			dfoname=NULL; 
		}
		else
		{
		    ifoname=new char[strlen(ifoName)+1];
			strcpy(ifoname,ifoName);
		}
	if(dfoname) pdesc.SetMode(ANALIZE);
	else pdesc.SetMode(DUMP);
	if (errorCode==freOK || errorCode==freBadDFO) 
		if (pdesc.OpenIndexCode(ifoname)) 
		{
			if(errorCode==freOK) errorCode =freBadIFO;
			delete[] ifoname; ifoname=NULL; 
		}
	int oldErr=errorCode;
    cItem=First();
	errorCode=oldErr;
}

Reporter::~Reporter()
{
	if (filter) delete[]filter;
    if (lfname) delete[]lfname;
    if (pfoname) delete[]pfoname;
    if (dfoname) delete[]dfoname;
}

int Reporter::GetPos()
{
    LogfilePos p;
    getCrtPos(&p);
    if (p.itemNr==1) return 1;
    if ((int)p.position==(int)fileLen) return 3;
    return 2;
}

extern int BeginParsing();
extern ProtocolVect *proto;
extern char* TextToParse;
extern int errorflag,i_ind,c_ind,nc;
extern vector <istruzione> *ist;
extern vector <int> *crea_vars;
extern vector <Cost> *costanti;
extern int yylineno_offset;
extern LineCollection* lcp;

char* Reporter::setFilter(char* fltr)
{
    if (fltr==NULL || fltr[0]=='\0')
      {
        filter=NULL;
		i_ind=0;
		c_ind=0;
        return NULL;
      }
     else
      {
		if (filter) delete[]filter;
        filter=new char[strlen(fltr)+1];
        strcpy(filter,fltr);
		ist=&r_ist;
		crea_vars=&r_crea_vars;
		::proto=&pdesc.proto;
		::costanti=&costanti;
		TextToParse=filter;
		yylineno_offset=0;
		lcp=NULL;
		BeginParsing();
		nc=::nc;
		i_ind =::i_ind;
		c_ind =::c_ind;
		pdesc.SetCalcPr(r_crea_vars, c_ind);
		if(errorflag) return NULL;
      }
 return filter;
}

item* Reporter::First()
{
 errorCode=freBOF;
#ifndef WIN32
 if(logfile==NULL) return NULL;
 fseek(logfile,0,SEEK_END);
 fileLen=ftell(logfile);
 fseek(logfile,0,SEEK_SET);
#else
 if(!cap)
	if(logfile==NULL) return NULL;
#endif
 if(!cap)
 {
	lfo.ReadHeader(logfile);
    crt.itemNr=0;
    return next();
 }
 else
   if (n_Items)
	return Jump(1);
   else {lc.clear(); return &crt;}
}

item* Reporter::Last()
{
 return Jump(lfp->GetNItems());
}

item* Reporter::current()
{
 myerror[0]='\0';
 cItem=getCrt();
 if (cItem) AnalizePacket();
 return cItem;
}

item* Reporter::Next()
{
    if (filter==NULL)
     {
      if(!lfp->nextItem())
       {
	    strcpy(myerror,RP_EMLOG);
	    return NULL;
	   }
      myerror[0]='\0';
     cItem=lfp->getCrt();
	 if (cItem) AnalizePacket();
     return cItem;
     }
    else if (filteredJump(1)) cItem=NULL;
   return cItem;
}

item* Reporter::Prev()
{
    if (crt.itemNr==0) return First();
    if (filter==NULL)
     {
      if(!lfp->previousItem())
       {
	    strcpy(myerror,RP_EMLOG);
	    return NULL;
	   }
      myerror[0]='\0';
     cItem=lfp->getCrt();
	 if (cItem) AnalizePacket();
     return cItem;
     }
    else if (filteredJump(0)) cItem=NULL;
 return cItem;
}

item* Reporter::next()
{
      if(!lfp->nextItem())
       {
	    strcpy(myerror,RP_EMLOG);
	    return NULL;
	   }
      myerror[0]='\0';
     cItem=lfp->getCrt();
	 if (cItem) AnalizePacket();
     return cItem;
}

item* Reporter::prev()
{
      if(!lfp->previousItem())
       {
	    strcpy(myerror,RP_EMLOG);
	    return NULL;
	   }
      myerror[0]='\0';
     cItem=lfp->getCrt();
	 if (cItem) AnalizePacket();
     return cItem;
}

int Reporter::filteredJump(int dir)
{
	LogfilePos lp;
    getCrtPos(&lp);
	int t;
    if(i_ind==0)
	{
        strcpy(myerror,ERR_NOFLT /*Nessun filtro valido impostato*/);
		return -1;
	}
	if(dir==0)
	{
		do
		{
		 t=lfp->previousItem();
		 if(!t)
		 {
	      strcpy(myerror,RP_BOF);
		  setCrtPos(&lp);
	      return 1;
		 }
	     myerror[0]='\0';
		 cItem=lfp->getCrt();
		}
		while (!ExecuteProgram(r_ist,i_ind));
	}
	else if(dir==1)
	{
		do
		{
		 t=lfp->nextItem();
		 if(!t)
		 {
	      strcpy(myerror,RP_EOF);
		  setCrtPos(&lp);
	      return 1;
		 }
	     myerror[0]='\0';
		 cItem=lfp->getCrt();
		}
		while (!ExecuteProgram(r_ist,i_ind));
	}
	if (cItem) AnalizePacket(); else return 1;
	return 0;
}


int Reporter::GetItemNumber()
{
	return crt.itemNr;
}

item* Reporter::Jump(int n)
{
      if(!lfp->Jump(n))
       {
	    strcpy(myerror,RP_EMLOG);
	    return NULL;
	   }
      myerror[0]='\0';
     cItem=lfp->getCrt();
	 if (cItem) AnalizePacket();
     return cItem;
}

int Reporter::AnalizePacket()
{
	lc.clear();
	if (pfoname==NULL) AnalyzeNoFiles(cItem);
		else
		{
			if (dfoname==NULL) AnalyzeNoFiles(cItem);
			int f=pdesc.proto.FindProto(cItem->firstpr);
			pdesc.ProcessPacket(lc,f,cItem);
		}
	lc.insert1("==========================================================================");
	pdesc.DumpHex(lc,cItem->data,cItem->size);
	return 0;
}

TSDWORD Reporter::ExecuteProgram(const istruzione * ist, int ni)
{
	int f=pdesc.proto.FindProto(cItem->firstpr);
	pdesc.ExaminePacket(f,cItem);
	CExpVM vm(pdesc);
	ExpVal v=vm.ExecuteProgram(r_ist,i_ind,costanti,nc,cItem);
	if (v.valid) return v.val;
	return 0;
}

int Reporter::AnalyzeShort(int n,int ff,FILE* file)
{
	 string str;
	 lc.clear();
	 if (n<=0) n=1;
     for(;n<=n_Items && ff!=0;n++,ff--)
     {
	  lfp->Jump(n);
	  if (ff<-1) ff=-1;
      cItem=lfp->getCrt();
	  int f=pdesc.proto.FindProto(cItem->firstpr);
	  str="";
	  if (ifoname) 
	  {
		pdesc.ShortProcessPacket(str,f,cItem);
		if (file) fprintf(file,"%s\n",(const char*)str);
		else
		 lc.insert1((const char*)str);
	  }
	  else
	  {
		lc.insert( "%02dh:%02dm:%02ds Item number %d",(cItem->secs%86400)/3600,
		(cItem->secs%3600)/60,cItem->secs%60,n);
	  }
	 }
	 if (ff<0) lfp->Jump(1);
     cItem=lfp->getCrt();
     return 0;
}

int Reporter::SetMode(int m)
{
 int o=pdesc.GetMode();
 pdesc.SetMode(m);
 return o;
}

int Reporter::AnalyzeCurrent(int o)
{
	myerror[0]='\0';
	cItem=getCrt();
	if(!cItem) return 0;
	lc.clear();
	if (o&ANALIZE)
	{
		if (pfoname==NULL) AnalyzeNoFiles(cItem);
		else
		{
			if (dfoname==NULL) AnalyzeNoFiles(cItem);
			int f=pdesc.proto.FindProto(cItem->firstpr);
			pdesc.ProcessPacket(lc,f,cItem);
		}
	}
	if (o&ANALIZE && o&DUMP_HEX)
		lc.insert1("==========================================================================");
	if (o&DUMP_HEX)
	pdesc.DumpHex(lc,cItem->data,cItem->size);
	return 1;
}

int Reporter::GetProtocols(LineCollection & lc,int v)
{
	if (pdesc.GetProtos(lc,v)) return 0;
	return 1;
}


int Reporter::AnalyzeNoFiles(item* cItem)
{
	if (cItem==NULL) return 0;
	lc.insert1("----- General -----");
    lc.insert("Item number %d, position in logfile %d%%",cItem->itemNr,cItem->posIndicator); 
	lc.insert( "Timestamp: %8dh:%02dm:%02ds:%08dus",(cItem->secs%86400)/3600,
		(cItem->secs%3600)/60,cItem->secs%60,cItem->usecs);
	lc.insert1("----- Description -----");
	if (cItem->type==1) 
	{	
		lc.insert("Item type: Time stamp & statistical information");
	}
	else if (cItem->type==2) 
	{
		lc.insert( "Item type: Frame trace, %d bytes available", cItem->size);
		lc.insert( "Frame size is %d (%X hex) bytes",cItem->truesize,cItem->truesize);
	}
	else if (cItem->type==3) 
	{
		lc.insert( "Item type: Minimal Frame, %d bytes available", cItem->size);
		lc.insert( "Frame size is %d (%X hex) bytes",cItem->truesize,cItem->truesize);
	}
	else if (cItem->type==128) 
	{
		lc.insert( "Item type: Partial frame, %d bytes available", cItem->size);
		lc.insert( "Frame size is %d (%X hex) bytes",cItem->truesize,cItem->truesize);
	}
	else if (cItem->type==129) 
	{
		lc.insert( "Item type: Whole frame, %d bytes available", cItem->size);
		lc.insert( "Frame size is %d (%X hex) bytes",cItem->truesize,cItem->truesize);
	}
	else lc.insert( "Item type: %d", cItem->type);
	return 1;
}

int Reporter::GetProtocolsShort(LineCollection & lc,int v)
{
	if (pdesc.GetProtosShort(lc,v)) return 0;
	return 1;
}

int Reporter::GetCurItem()
{
 myerror[0]='\0';
 string s;
 char t[10];
 cItem=getCrt();
 if (cItem) 
 {
	 lc.insert("Secs: %d", cItem->secs);
	 lc.insert("USecs: %d", cItem->usecs);
	 lc.insert("True Size: %d", cItem->truesize);
	 lc.insert1("Data:");
	 int i,j;
	 for(i=0,j=0;i<(signed)cItem->truesize;i++)
	 {
		 sprintf(t,"%02X ",cItem->data[i]);
		 s+=t;
		 if (j==15) 
		 {
			 lc.insert1(s);
			 j=0;
			 s="";
		 } else j++;
	 }
	 lc.insert1(s);
	 return 1;
 }
 return 0;
}

const char* Reporter::GetLogName()
{
	return lfname;
}

int Reporter::GetFilteredPackets(vector<int> &v)
{
	int j=0;
    if(i_ind==0)
	{
        Say(ERR_NOFLT /*Nessun filtro valido impostato*/);
		return -1;
	}
	int n=GetNItems();
	if(!First()) {Say(ERR_MOVE /*Errore muovendosi nei pacchetti*/);return -1;}
	if (ExecuteProgram(r_ist,i_ind)) {v[j]=1;j++;}
	LogfilePos lp;
    getCrtPos(&lp);
	int t;
	for(int i=1;i<n;i++)
		{
		 t=lfp->nextItem();
		 if(!t)
	      return j;
		 if (ExecuteProgram(r_ist,i_ind)) {v[j]=i+1;j++;}
		 cItem=lfp->getCrt();
		}
	return j;
}

