#ifndef REPORTER
#define REPORTER

#include "../comuni/linecol.h"
#include "../vm/filed/lfreader.h"
#include "../vm/packetd/packetd.h"

class Reporter :public LogfileReader
{
 private:
	 int nc;
	 int AnalizePacket();
    LogfileReader *lfp;
    item* cItem;
    char* filter;
    char myerror[255];
    char *lfname;
    char *pfoname;
    char *dfoname;
    char *ifoname;
    int filteredJump(int dir);
	vector <istruzione> r_ist;
	int i_ind;
	int c_ind;
	vector <int> r_crea_vars;
	vector <Cost> costanti;
 public:
	 int GetFilteredPackets(vector<int> &v);
	 const char* GetLogName();
	 int GetCurItem();
	 int GetProtocolsShort(LineCollection & lc,int v=0);
	 int AnalyzeNoFiles(item* cItem);
	 int GetProtocols(LineCollection& lc,int v=0);
	 int AnalyzeCurrent(int o);
	 int SetMode(int m);
	 int AnalyzeShort(int n=0,int f=-1,FILE* file=NULL);
	 TSDWORD ExecuteProgram(const istruzione* ist, int ni);
	 int GetItemNumber();
 Reporter(const char* lfoName="default.lfo",const char* pfoName="default.pfo",
	      const char* dfoName="default.dfo",const char* ifoName="default.ifo",
		  const char* lfName="default.log", 
		  char* fltr=NULL);
 ~Reporter();
 const char* const getError(){return myerror;}
 char* setFilter(char* fltr=NULL);
 LineCollection* const GetLines(){return &lc;}
 LineCollection lc;
 int GetPos();
 item* Jump(int n);
#ifndef ENGLISH
 item* Current(){if (cItem==NULL) strcpy(myerror,"File non aperto o errato");return cItem;}
#else
 item* Current(){if (cItem==NULL) strcpy(myerror,"Wrong File");return cItem;}
#endif
 item* First();
 item* Last();
 item* Next();
 item* Prev();
 item* next();
 item* prev();
 item* current();
 inline item* nextf() {return Next();};
 inline item* prevf() {return Prev();};
 inline const char *const GetPdoName() {return pfoname;};
 inline const char *const GetLfName() {return lfname;};
 CPacketDescriber pdesc;
};

#endif