// CodeVm.h: interface for the CCodeVm class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CODEVM_H__CAF336E3_1D3D_11D2_941E_000000000000__INCLUDED_)
#define AFX_CODEVM_H__CAF336E3_1D3D_11D2_941E_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "../vmachine.h"
#include "../../comuni/codeprocessor.h"
#include "../../comuni/structs.h"
#include "../../comuni/vec_cl.h"
#include "../filed/lfreader.h"
#include "printf/print.h"

class CLogDocument;

class CCodeVm : public CVMachine
{
public:
	int e_var;
	int OpenCode(const char* c, time_t Tim, int Id);
	void SetProtocolStruct(p_struct * p,int np);
	int ProtoExists(const char*);
	void SetLogDoc(CLogDocument* l);
	void SetString(string* est);
	int SetPacketOffset (int o,int s=-1);
	int SetPacketBytes(TUBYTE * p, int len, item* cItem);
	void SetLineCollection(LineCollection* lc);
	TSDWORD DebugProgram(const char* c, TSDWORD* pars=NULL, int np=0);
	TSDWORD ExecuteProgram(const char* c, TSDWORD* pars=NULL, int np=0);
	int VExecuteAddIn(stack<TSDWORD> &s,istruzione *ist, const TUBYTE * c);
	int OpenCode(const char* c, int IsMacro=0);
	int GetProtoNumber(const char* c) {return cp.GetProtoNumber(c);}
	CCodeVm();
	virtual ~CCodeVm();

private:
	int CanInsert;
	int s_var;
	int OpenCode(FILE* f);
	int psize;
	string* istr;
	LineCollection* llc;
	vector<TUBYTE*> vars;
	int debug;
	TUBYTE * packet;
	item* cItem;
	int plen;
	int poffset;
	int nvs;
	int vs;
	int CreaVariabili(Protos& p, TSDWORD* pars, int np);
	AddIn a;
	p_struct* ps;
	int np;
	vector<TSDWORD>* vect;
	int nv;
	CCodeProcessor cp;
	Protos* pr;
	CPrint p;
	CLogDocument* log;
};

#endif // !defined(AFX_CODEVM_H__CAF336E3_1D3D_11D2_941E_000000000000__INCLUDED_)
