// CodeVm.cpp: implementation of the CCodeVm class.
//
//////////////////////////////////////////////////////////////////////

#include "codevm.h"
#include <stdio.h>
#include "../../comuni/string_l.h"
#include "../../parsers/cparser/l_struct.h"
#include "../../comuni/asksay.h"
#include "../../query/clogdocument.h"
#include <limits.h>

#ifndef ENGLISH
#define ERR_ASS "Assegnamento di %d (%d byte) alla variabile %s (offset %d)."
#define ERR_FND "Chiamata a funzione non definita"
#define ERR_MEM "Memoria esaurita"
#define ERR_FUNC "Chiamata della funzione: %s."
#define ERR_LINE "Linea: %d"
#define ERR_LAB "Errore del parser nelle label"
#define ERR_JMP "Impossibile eseguire il salto"
#define ERR_STR "Stringa non definita"
#define ERR_NOPCK "Impossibile eseguire l'istruzione se non  disponibile un pacchetto"
#define ERR_VMVAR "Variabile della macchina virtuale non definita"
#define ERR_ARRAY "Accesso ad array errato"
#define ERR_MACMAC "Impossibile richiamare una macro da una macro"
#define ERR_INS "Errore del parser: istruzione valida solo per le macro"
#define ERR_CONT "Si vuole continuare l'esecuzione dopo gli errori verificatisi?"
#define ERR_LFO "Errore nel processamento delle istruzioni dell'LFO"
#define ERR_PROT "Prototipo errato"
#define ERR_FND1 "Funzione non definita"
#define ERR_NP "Numero di parametri errati"
#define ERR_TS "Questo file non  stato creato usando il file PDO attuale. Si vuole continuare?"
#else
#define ERR_ASS "Assigning %d (%d byte) to vatiable %s (offset %d)."
#define ERR_FND "Call to undefined function"
#define ERR_MEM "Out of memory"
#define ERR_FUNC "Call to function: %s."
#define ERR_LINE "Line: %d"
#define ERR_LAB "Parser error in labels"
#define ERR_JMP "Unable to execute jump"
#define ERR_STR "Undefined string"
#define ERR_NOPCK "Unable to execute instruction without a packet"
#define ERR_VMVAR "Virtual machine variable not defined"
#define ERR_ARRAY "Wrong array access"
#define ERR_MACMAC "Unable to call a macro from a macro"
#define ERR_INS "Parser error: instruction valid only in macros"
#define ERR_CONT "Errors occurred. Do you wish to continue?"
#define ERR_LFO "Errors processing instructions"
#define ERR_PROT "Bad prototype"
#define ERR_FND1 "Function not defined"
#define ERR_NP "Wrong parameter number"
#define ERR_TS "This file was not created using current PDO file. Do you wish to continue?"
#endif
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

int PushBits(stack<TSDWORD> &s, int par);

extern string IniName;

CCodeVm::CCodeVm()
{
	a.ist_number=I_PUSH_BITS;
	a.funzione=&PushBits;
	SetAddIn(&a,1);
	nvs=-1;
	debug=0;
	llc=NULL;
	istr=NULL;
	CIniProcesser ini(IniName);
	ini.CreateHash();
	const char* c=ini.Search("Settings","Tables");
	if (!c) c="tables.dat";
	p.OpenTable(c);
	p.SetExtensions(ini,"PRINT");
	vect=NULL;
	nv=0;
	log=NULL;
	psize=-1;
	CanInsert=1;
}

CCodeVm::~CCodeVm()
{
	if (vect) delete[]vect;
	if (log && llc && llc->getLineCount()) log->PutOutput(llc);
}

#ifdef LINUX
vector<TSDWORD> *alloca_vect(int nv)
{
	return new vector<TSDWORD>[nv];
}
#endif

int CCodeVm::OpenCode(const char * c, int IsMacro)
{
	if(c==NULL || c[0]=='\0') return 1;
	FILE* f=fopen(c,"rb");
	if (!f) return 1;
	if (IsMacro) 
	{
		int i;
		if(fread(&i,sizeof(int),1,f)!=1 || i!=MAGIC_MACRO) return 1; 
	}

	return OpenCode(f);
}

int CCodeVm::VExecuteAddIn(stack<TSDWORD> & s, istruzione * ist, const TUBYTE * c)
{
	 string str;
	 int ns;
	 Protos* p,*p2;
	 const char** stringhe=cp.GetStrings(ns);
	 int t,y,r,i;
	 char st[100];
	 TSDWORD *params;
	 TUBYTE* q, ch;
	 TDWORD th;
	 TWORD sh;
	 switch (ist->ist_number)
		 {
			case I_ASSEGN:
				r=t=s.pop();
				y=ist->p1;
				if (debug) 
				{
					if (strlen(pr->nomivars[y])>=50) pr->nomivars[50]='\0';
					sprintf (st,ERR_ASS /*Assegnamento di %d (%d byte) alla variabile %s (offset %d).*/
						,r,pr->vars[y],pr->nomivars[y],pr->offs[y]);
					Say(st);
				}
				if (!mustinvert) t=INV_DWORD(&t);
				q=(TUBYTE*)&t;
				if(pr->vars[y]==1) 
					vars[nvs][pr->offs[y]]=q[0];
				else if(pr->vars[y]==2) 
				{
					vars[nvs][pr->offs[y]]=q[1];
					vars[nvs][pr->offs[y]+1]=q[0];
				}
				else 
				{
					vars[nvs][pr->offs[y]]=q[3];
					vars[nvs][pr->offs[y]+1]=q[2];
					vars[nvs][pr->offs[y]+2]=q[1];
					vars[nvs][pr->offs[y]+3]=q[0];
				}
				//s.pop();
				s.push(r);
				return 0;
			case I_CH_FUNZ:
				t=ist->p1;
				y=index;
				p2=pr;
				p=cp.FindProto(t);
				if (p==NULL) {Say(ERR_FND /*Chiamata a funzione non definita*/); return 1;}
				params=new TSDWORD[p->np];
				if (params==NULL) {Say(ERR_MEM /*Memoria esaurita*/); return 1;}
				for(t=0;t<p->np;t++) params[p->np-1-t]=s.pop();
				if (debug) 
				{
					sprintf (st,ERR_FUNC /*Chiamata della funzione: %s.*/,p->nome.n);
					Say(st);
				}
				s.push(ExecuteProgram(p->nome.n,params,p->np));
				pr=p2;
				delete[]params;
				index=y;
				return 0;
			case I_LAB:
				if (debug)
				{
					sprintf (st,ERR_LINE /*Linea: %d*/,ist->p1);
					Say(st);
				}
				return 0;
			case I_GOTO:
				t=ist->p1;
				if(t<0) {Say(ERR_LAB /*Errore del parser nelle label*/);return 1;}
				if (t>pr->ni) {Say(ERR_JMP /*Impossibile eseguire il salto*/);return 1;}
				index=t-1;
				return 0;
			case I_TITLE:
				t=ist->p1;
				if (t>=ns) {Say(ERR_STR /*Stringa non definita*/);return 1;}
				if (llc)
				{
					str="----- ";
					str+=stringhe[t];
					str+=" -----";
					if (psize>0)
					{
					 char t[20];
					 sprintf(t," [%d-%d]",poffset,poffset+psize-1);
					 str+=t;
					 psize=-1;
					}
					llc->insert1((const char*) str);
				}
				else if (istr) 
				{
					str=stringhe[t];
					(*istr)+=string(" <") + str + ">";
				}
				 else Say((const char*) stringhe[t]);
				return 0;
			case I_PRINT:
				t=ist->p1;
				CCodeVm::p.SetPacket(packet);
				if (t>=ns) {Say(ERR_STR /*Stringa non definita*/);return 1;}
				if (llc)
				{
					if (CanInsert<0) CCodeVm::p.gr=1;
					CCodeVm::p.s=s_var;
					CCodeVm::p.e=e_var;
					t=CCodeVm::p.Print(llc,s,stringhe[t], c);
					s_var=INT_MAX;
					e_var=0;
				}
				else
					t=CCodeVm::p.Print(llc,s,stringhe[t], c);
				CanInsert=1;
				if (!llc)
				{
					if (istr) 
					{
						if((*istr)!="")(*istr)+=" ";
						(*istr)+=CCodeVm::p.GetString();
					}
					else Say((const char*)CCodeVm::p.GetString());
				}
				return t;
			case I_RESET_LOG_VARS:
				if (ist->p1==0)
				{
				 s_var=INT_MAX;
				 e_var=0;
				 CanInsert=1;
				}
				else if (ist->p1==1)
				{
					e_var=s.pop();
					s_var=s.pop();
				    CanInsert=0;
				}
				else 
				{
					CanInsert=s.pop();
					if (CanInsert) CanInsert=-1; else CanInsert=0;
					e_var=s.pop();
					s_var=s.pop();
				}
				return 0;
			case I_IF:
				y=s.pop();
				t=ist->p1;
				if(t<0) {Say(ERR_LAB /*Errore del parser nelle label*/);return 1;}
				if (t>pr->ni) {Say(ERR_JMP /*Impossibile eseguire il salto*/);return 1;}
				if(!y) index=t-1;
				return 0;
		    case I_P_PUSH_BYTE:
				if (packet==NULL || ist->p1+poffset>=plen)  {s.push(0);return 1;}
				ch=packet[ist->p1+poffset];
				if (llc && CanInsert==1)
				{
				 t=ist->p1+poffset;
				 if (s_var>t) s_var=t;
				 if (e_var<t+1) e_var=t+1;
				}
				t=ch&0xFF;
				s.push(t);
				return 0;
		    case I_P_PUSH_WORD:
				if (packet==NULL || ist->p1+poffset>=plen)  {s.push(0);return 1;}
				if (mustinvert) sh=INV_WORD((void*)(packet+ist->p1+poffset));
					else sh=*((TWORD*)(packet+ist->p1+poffset));
				if (llc && CanInsert==1)
				{
				 t=ist->p1+poffset;
				 if (s_var>t) s_var=t;
				 if (e_var<t+2) e_var=t+2;
				}
				t=sh&0xFFFF;
				s.push(t);
				return 0;
		    case I_P_PUSH_DWORD:
				if (packet==NULL || ist->p1+poffset>=plen)  {s.push(0);return 1;}
				if (llc && CanInsert==1)
				{
				 t=ist->p1+poffset;
				 if (s_var>t) s_var=t;
				 if (e_var<t+4) e_var=t+4;
				}
				if (mustinvert) th=INV_DWORD((void*)(packet+ist->p1+poffset));
					else th=*((TDWORD*)(packet+ist->p1+poffset));
				s.push(th);
				return 0;
			case I_P_ASSEGN_BITS:
				if (packet==NULL || ps==NULL || ist->p1>=np)  {return 1;}
				else
				{
					int itmp,tt,m=0;
					itmp=ps[ist->p1].be-ps[ist->p1].bs+1;
					for(tt=0;tt<itmp;tt++)
						m+=1<<tt;
					th=s.pop();
					TSDWORD th2=s.get_top();
					th2&=m;
					m<<=ps[ist->p1].bs;
					th2<<=ps[ist->p1].bs;
					m=~m;
					th&=m;
					th|=th2;
					if (ps[ps[ist->p1].ref].size==1) 
					{
						ch=(TUBYTE)th;
						*((TUBYTE*)(packet+poffset+ps[ps[ist->p1].ref].offset))=ch;
					}
					else if (ps[ps[ist->p1].ref].size==2) 
					{
						sh=(TWORD)th;
						if(mustinvert)sh=INV_WORD(&sh);
						*((TWORD*)(packet+poffset+ps[ps[ist->p1].ref].offset))=sh;
					}
					else if (ps[ps[ist->p1].ref].size==4) 
					{
						if(mustinvert)th=INV_DWORD(&th);
						*((TSDWORD*)(packet+poffset+ps[ps[ist->p1].ref].offset))=th;
					} 
					else return 1;
				}
				return 0;
			case I_P_ASSEGN:
				if (packet==NULL || ps==NULL || ist->p1>=np)  {return 1;}
				th=s.get_top();
				if (ps[ist->p1].size==1) 
				{
					ch=(TUBYTE)th;
					*((TUBYTE*)(packet+poffset+ps[ist->p1].offset))=ch;
				}
				else if (ps[ist->p1].size==2) 
				{
					sh=(TWORD)th;
					if(mustinvert)sh=INV_WORD(&sh);
					*((TWORD*)(packet+poffset+ps[ist->p1].offset))=sh;
				}
				else if (ps[ist->p1].size==4) 
				{
					if(mustinvert)th=INV_DWORD(&th);
					*((TSDWORD*)(packet+poffset+ps[ist->p1].offset))=th;
				} 
				else return 1;
				return 0;
			case I_GETVMVAR:
				if (cItem==NULL) 
				{
					Say(ERR_NOPCK /*Impossibile eseguire l'istruzione se non  disponibile un pacchetto*/);
					return 1;
				}
				t=ist->p1;
				if (t>=ns) {Say(ERR_STR /*Stringa non definita*/);return 1;}
				if (strcmp(stringhe[t],"FrameAvail")==0) s.push(cItem->size);
				else if (strcmp(stringhe[t],"FrameSize")==0) s.push(cItem->truesize);
				else if (strcmp(stringhe[t],"ItemNumber")==0) s.push(cItem->itemNr);
				else if (strcmp(stringhe[t],"FrameSecs")==0) s.push(cItem->secs);
				else if (strcmp(stringhe[t],"FrameUSecs")==0) s.push(cItem->usecs);
				else if (strcmp(stringhe[t],"Written")==0) s.push(cItem->written);
				else if (strcmp(stringhe[t],"Discarded")==0) s.push(cItem->discarded);
				else if (strcmp(stringhe[t],"FrameType")==0) s.push(cItem->type);
				else if (strcmp(stringhe[t],"SizeNotInt")==0) s.push(cItem->truesize-poffset);
				else if (strcmp(stringhe[t],"SizeInt")==0) s.push(poffset);
				else if (strcmp(stringhe[t],"Position")==0) s.push(cItem->posIndicator);
				else {Say(ERR_VMVAR /*Variabile della macchina virtuale non definita*/);s.push(0);}
				return 0;
			case I_P_CHECK:
				th=s.pop();
				if (packet==NULL || th>(unsigned)plen)  
					{s.push(0);llc->insert1("----- Data not available -----");return 1;}
					else s.push(0xFFFFFFFF);
				return 0;
			case I_CONV:
				th=s.pop();
				if (packet==NULL || th+1>(unsigned)plen)  {s.push(0);return 1;}
				ch=packet[th];
				t=ch&0xFF;
				s.push(t);
				return 0;
			case I_CONV16:
				th=s.pop();
				if (packet==NULL || th+2>(unsigned)plen)  {s.push(0);return 1;}
				if (mustinvert) sh=INV_WORD((void*)(packet+th));
					else sh=*((TWORD*)(packet+th));
				t=sh&0xFFFF;
				s.push(t);
				return 0;
			case I_CONV24:
				th=s.pop();
				if (packet==NULL || th+4>(unsigned)plen)  {s.push(0);return 1;}
				if (mustinvert) 
				{
					th=INV_DWORD((void*)(packet+th));
					th&=0xFFFFFF;
				}
					else 
					{
						th=*((TDWORD*)(packet+th));
						th>>=8;
					}
				s.push(th);
				return 0;
			case I_CONV32:
				th=s.pop();
				if (packet==NULL || th+4>(unsigned)plen)  {s.push(0);return 1;}
				if (mustinvert) th=INV_DWORD((void*)(packet+th));
					else th=*((TDWORD*)(packet+th));
				s.push(th);
				return 0;
			case I_OFFSET_S:
				s.push(pr->offs[ist->p1]);
			case I_OFFSET_P:
				s.push(ist->p1+poffset);
				return 0;
			case I_VECTOR:
				t=ist->p1;
				if (t>=nv||t<0) {Say(ERR_ARRAY /*Accesso ad array errato*/); return 1;}
				i=s.pop(); 
				if(i<0||i>65535) i=0;
				s.push(vect[t][i]);
				return 0;
			case I_V_ASSEGN:
				t=ist->p1;
				th=s.pop();
				i=s.pop();
				if(i<0||i>65535) i=0;
				vect[t][i]=th;
				s.push(th);
				if (t>=nv||t<0) {Say(ERR_ARRAY /*Accesso ad array errato*/); return 1;}
				return 0;
			case I_APRINT:
				t=ist->p1;
				if (t>=nv||t<0) {Say(ERR_ARRAY /*Accesso ad array errato*/); return 1;}
				str="";
				th=s.pop();
				st[1]='\0';
				for(i=0;i<(signed)strlen(stringhe[th]);i++)
				{
					if(stringhe[th][i]!='%' || 
					   (stringhe[th][i]=='%' && 
					    stringhe[th][i+1]!='s' && 
					    stringhe[th][i+1]!='d' && 
					    stringhe[th][i+1]!='u' 
					  ))
					{
						st[0]=stringhe[th][i];
					    st[1]='\0';
						str+=st;
					}
					else 
					{
						i++;
					    st[1]='\0';
						if (stringhe[th][i]=='s')
							{
							 for (int j=0;j<vect[t].get_n_el()&&vect[t][j]!=0;j++)
								{st[0]=(char)vect[t][j];str+=st;}
							}
						else if (stringhe[th][i]=='d')
							for (int j=0;j<vect[t].get_n_el();j++)
								{sprintf(st,"%d",vect[t][j]);str+=st;}
						else if (stringhe[th][i]=='u')
							for (int j=0;j<vect[t].get_n_el();j++)
								{sprintf(st,"%u",vect[t][j]);str+=st;}
					}
				}
				if (llc)
				{
				 char ty[40];
				 if (s_var < e_var)
				 if (CanInsert<0)
					sprintf(ty," - {%d-%d}",s_var,e_var-1);
				 else
					sprintf(ty," - [%d-%d]",s_var,e_var-1);
				 CanInsert=1;
				 str+=ty;
				 s_var=INT_MAX;
				 e_var=0;
				}
				if(llc) llc->insert1((const char*)str);
				else if (istr) *istr+=string(" ") + str;
				else Say((const char*)str);
				return 0;
			case I_CLEAR:
				t=ist->p1;
				if (t>=nv||t<0) {Say(ERR_ARRAY /*Accesso ad array errato*/); return 1;}
				vect[t].empty();
				return 0;
			case I_VLEN:
				t=ist->p1;
				if (t>=nv||t<0) {Say(ERR_ARRAY /*Accesso ad array errato*/); return 1;}
				s.push(vect[t].get_n_el());
				return 0;
			case I_STRLEN:
				t=ist->p1;
				if (t>=nv||t<0) {Say(ERR_ARRAY /*Accesso ad array errato*/); return 1;}
				for(i=0;i<vect[t].get_n_el();i++) if(vect[t][i]==0) {s.push(i);break;}
				return 0;
			case I_COMMAND:
				t=ist->p1;
				if (t>=ns) {Say(ERR_STR /*Stringa non definita*/);return 1;}
				str=stringhe[t];
				str.TrimLeft();
				str.MakeUpper();
				if (strncmp(str,"MACRO",5)==0)
				{
					Say(ERR_MACMAC /*Impossibile richiamare una macro da una macro*/);
					return 1;
				}
				str=stringhe[t];
				if (log) 
					{
						if (llc && llc->getLineCount()) log->PutOutput(llc);
						t=log->ParseCommand(str);
						if (llc) llc->clear();
					}
					else {Say(ERR_INS /*Errore del parser: istruzione valida solo per le macro*/);return 1;}
				s.push(t);
				if(!t) 
					if(Ask(ERR_CONT /*Si vuole continuare l'esecuzione dopo gli errori verificatisi?*/)==IDNO) 
						return 1;
				return 0;
		    default:
				errore(ERR_LFO /*Errore nel processamento delle istruzioni dell'LFO*/);
		 }
	return 1;
}

int CCodeVm::CreaVariabili(Protos & p, TSDWORD* pars, int np)
{
   vs=0;
   int sp=0,i;
   pr=&p;
   if (p.offs) delete[]p.offs;
   p.offs=new int[p.nv];
   if(!p.offs) return 1;
   for(i=0;i<p.nv;i++)
	{
		switch (p.vars[i])
		{
		 case 0:
			 Say(ERR_PROT /*Prototipo errato*/);
			 return 1;
			 break;
		 case 1:
			 p.offs[i]=vs;
			 vs++;
			 break;
		 case 2:
			 p.offs[i]=vs;
			 vs+=2;
			 break;
		 case 4:
			 p.offs[i]=vs;
			 vs+=4;
			 break;
		 default: 
			 Say(ERR_PROT /*Prototipo errato*/);
			 return 1;
		}
	}
	nvs++;
    vars[nvs]=new TUBYTE[vs];
	for(i=0;i<vs;i++) vars[nvs][i]=0;
    if (np!=0 && pars!=NULL)
	for(i=0;i<np;i++)
	{
		if (!mustinvert) pars[i]=INV_DWORD(&pars[i]);
		switch (p.vars[i])
		{
		 case 1:
			 vars[nvs][p.offs[i]]=((TUBYTE*)(&pars[i]))[0];
			 break;
		 case 2:
			 vars[nvs][p.offs[i]]=((TUBYTE*)(&pars[i]))[1];
			 vars[nvs][p.offs[i]+1]=((TUBYTE*)(&pars[i]))[0];
			 break;
		 case 4:
			 vars[nvs][p.offs[i]]=((TUBYTE*)(&pars[i]))[3];
			 vars[nvs][p.offs[i]+1]=((TUBYTE*)(&pars[i]))[2];
			 vars[nvs][p.offs[i]+2]=((TUBYTE*)(&pars[i]))[1];
			 vars[nvs][p.offs[i]+3]=((TUBYTE*)(&pars[i]))[0];
			 break;
		 default: 
			 break;
		}
	}
    return 0;
}

#include <limits.h>

TSDWORD CCodeVm::ExecuteProgram(const char * c, TSDWORD* pars, int np)
{
	TSDWORD ret;

	Protos* p=cp.FindProto(c);
	if(!p) 
	{	
		Say(ERR_FND1 /*Funzione non definita*/);
		return 1;
	}
	s_var=INT_MAX;
	e_var=0;
	if(p->np!=np) {Say(ERR_NP /*Numero di parametri errati*/);return 1;}
	CreaVariabili(*p,pars,np);
	TUBYTE* t=vars[nvs];
	ret = CVMachine::ExecuteProgram(p->ist,t);
	delete[] vars[nvs];
	nvs--;
	return ret;
}

TSDWORD CCodeVm::DebugProgram(const char * c, TSDWORD * pars, int np)
{
	debug=1;
	TSDWORD r=ExecuteProgram(c, pars, np);
	debug=0;
	return r;
}

void CCodeVm::SetLineCollection(LineCollection * lc)
{
	llc=lc;
}

int CCodeVm::SetPacketBytes(TUBYTE * p, int len, item* it)
{
	packet=p;
	plen=len;
	cItem=it;
	if (p==NULL) len=0;
	return 0;
}

int CCodeVm::SetPacketOffset(int o,int s)
{
	poffset=o;
	psize=s;
	return 0;
}

void CCodeVm::SetString(string * est)
{
	istr=est;
}

void CCodeVm::SetLogDoc(CLogDocument * l)
{
	log=l;
}

int CCodeVm::ProtoExists(const char *c)
{
	Protos* p=cp.FindProto(c);
	if (p) return 1;
	return 0;
}

void CCodeVm::SetProtocolStruct(p_struct * p,int n)
{
	ps=p;
	np=n;
}

int CCodeVm::OpenCode(const char * c, time_t Tim, int Id)
{
	if(c==NULL || c[0]=='\0') return 1;
	FILE* f=fopen(c,"rb");
	if (!f) return 1;
	int i;
	if(fread(&i,sizeof(int),1,f)!=1 || i!=MAGIC_XFF) return 1; 
	time_t t;
	if(fread(&t,sizeof(time_t),1,f)!=1)return 1; 
	if(fread(&i,sizeof(int),1,f)!=1) return 1; 
	if (i!=Id || t!=Tim) 
	if (Ask(ERR_TS /*Questo file non  stato creato usando il file PDO attuale. Si vuole continuare?*/)==IDNO) return 1;
	return OpenCode(f);
}

int CCodeVm::OpenCode(FILE * f)
{
	int i=cp.Serialize(1,f);
	nv=cp.GetVectNumber();
	if (vect) delete[]vect;
#ifndef LINUX
	vect=new vector<TSDWORD>[nv];
#else
	vect=alloca_vect(nv);
#endif
	if (vect==NULL) nv=0;
	return i;
}
