//				TABLES.CPP
// this file contains auxiliary functions used during interpretation of a
//frame

#include "tables.h"

CTables::CTables ()
{
	tables=NULL;
	ni=0;
	unknown="???";
}

CTables::~CTables ()
{
	if(tables) fclose(tables);
}

//reads a line from tables skipping comment lines; returns true on success
int CTables::getLine()
{
    do
	{
	fgets(tBuffer,MaxLength+2,tables);
	if(feof(tables))
	    return 0;
	if(tBuffer[strlen(tBuffer)-1]=='\n')
	    tBuffer[strlen(tBuffer)-1]='\0';
	}
    while (tBuffer[0]==';');
    pos=0;
    return 1;
}
//compares characters from tBuffer with the given data
int CTables::compare(const unsigned char* data,int len)
{

    for(int k=0;k<len;k++)
	{
	unsigned char val;
	if(!isxdigit(tBuffer[pos+2*k])||!isxdigit(tBuffer[pos+2*k+1]))
	    return R_ERROR;
	val=(xValue(tBuffer[pos+2*k])<<4)|xValue(tBuffer[pos+2*k+1]);
	if(val<data[k])
	    return LESS;
	if(val>data[k])
	    return GREATER;
	}
    if(tBuffer[pos+2*len]==' '||tBuffer[pos+2*len]=='-')
	return EQUAL;
    return R_ERROR;
}

const char* CTables::Find (const char* title,const TUBYTE* data)
{
    long post;
	int len;

    if(tables==NULL)
	return NULL;
	post=-1;
	int i;
	for(i=0;i<ni;i++)
		if(strcmp(title,indice[i].nome)==0) {post=indice[i].pos;break;}
    if(post==-1) return NULL;
	len=indice[i].len;
    fseek(tables,post,SEEK_SET);
    //searching for the given value
    while(getLine()&&tBuffer[0]!='[')
	{
	char c;
	c=compare(data,len);
	pos+=2*len+1;
	if(c==EQUAL&&tBuffer[pos-1]==' ')
	    return tBuffer+pos;
	if(tBuffer[pos-1]=='-'&&(c==EQUAL||c==LESS))
	    //it's an interval
	    {
	    c=compare(data,len);
	    pos+=2*len+1;
	    if(tBuffer[pos-1]==' '&&(c==EQUAL||c==GREATER))
		return tBuffer+pos;
	    }
	}
    return NULL;
}

int CTables::OpenTable(const char * f)
{
	if (f==NULL) return 1;
	if (tables) fclose(tables);
	tables=fopen(f,"r");
	if (tables==NULL) return 1;
	char t[MaxLength];
	char *q;
	ni=0;
	int l;
	while(fgets(t,MaxLength,tables))
	{
	 q=TrimLine(t);
	 l=strlen(q)-1;
	 if(q[0]=='[' && q[l]==']') 
	 {
		 int i;
		 for(i=l-1;i>=0&&q[i]!=':';i--);
		 sscanf(q+i+1,"%d",&indice[ni].len);
		 q[i]='\0';
		 strcpy(indice[ni].nome,q+1);
		 indice[ni].pos=ftell(tables);
		 ni++;
	 }
	}
	return 0;
}

char* CTables::TrimLine(char * q)
{
	 int l;
	 for(;q[0]==' '||q[0]=='\t'||q[0]=='\n';q++);
	 for(l=strlen(q);(q[l-1]==' '||q[l-1]=='\t'||q[l-1]=='\n')&& l>=0;q[l-1]='\0',l--);
	 return q;
}
