//				TABLES.H
// header file for TABLES.CPP

#if !defined( __TABLES_H )
#define __TABLES_H

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "../../../comuni/vec_cl.h"
#include "../../../comuni/string_l.h"
#include "../../../comuni/structs.h"

//return values for compare
#define EQUAL	0
#define LESS	1
#define GREATER	2
#define R_ERROR	3

#define MaxLength		80

typedef struct _items
{
	long pos;
	char nome[MaxLength+2];
	int len;
} TableItems;

class CTables
{
public:
	int OpenTable(const char* f);
 CTables();
 ~CTables();
 //searches for a field in "TABLES.DAT"
 const char* Find (const char* title,const TUBYTE* data);
 inline const char* SFind (const char* title,const TUBYTE* data);
protected:
 const char* unknown;
 FILE* tables;				//the "TABLES.DAT" file
 char tBuffer[MaxLength+2];	//text buffer for reading
 int pos;				//position in buffer
 vector<TableItems> indice;
 int ni;
 char* TrimLine(char* l);
 int xValue(char c){return (isalpha(c)?tolower(c)-'a'+10:c-'0');};
 int getLine();
 int compare(const unsigned char* data,int len);
};

inline const char* CTables::SFind (const char* title,const TUBYTE* data)
{ 
	const char* t;
	t=Find(title,data);
	if (t==NULL) t=unknown;
	return t;
}

#endif
