//				LFREADER.CPP
//This file contains different kinds of logfile readers. This objects are not
//TViews. They never write to the screen.

#include "../../comuni/rprogress.h"
#include <time.h>
#define SIZEOFWORD 2

#include "savefile.h"
#include "lfreader.h"

#ifndef ENGLISH
#define ERR_EOF "Tentativo di superare la fine del file"
#else
#define ERR_EOF "You are trying to go after end of file"
#endif

int MaxItemSize=1514;

LogfileReader::LogfileReader(const char* fileName, const char* lfoName):crt(MaxItemSize+1),indice(50000,50000)
{
    crt.itemNr=0;
	cap=NULL;
	errorCode=freOK;
    if((logfile=fopen(fileName,"rb"))==NULL)
	{
		errorCode=freBadLOG;
		return;
	}
    else
	{
	 errorCode=freBOF;
	 //reading the file length
	 fseek(logfile,0,SEEK_END);
	 fileLen=ftell(logfile);
	 fseek(logfile,0,SEEK_SET);
	}
	if (lfoName && lfoName[0]!='\0') 
	{
		if (lfo.ReadFile(lfoName)<0) {errorCode=freBadLFO; return;}
		n_Items=lfo.CreateIndex(logfile,indice);
		if (lfo.ReadHeader(logfile)<0) {errorCode=freInitFailed; return;}
	} else 
		{
			cap =new CCap(&crt);
			if (!cap){errorCode=freInitFailed;return;}
			if (fileLen==0)
			{
				fclose(logfile);
				CSaveCap s(NULL);
				s.pcap_dump_open(fileName);
				s.pcap_dump_close();
			    if((logfile=fopen(fileName,"rb"))==NULL)
					{ errorCode=freBadLOG;return;}
				else
				{
					errorCode=freBOF;
					fseek(logfile,0,SEEK_END);
					fileLen=ftell(logfile);
					fseek(logfile,0,SEEK_SET);
				}
			}
#ifndef WIN32
			if (!cap->pcap_open_offline(logfile)) 
				{errorCode=freBadLOG; return;}
		    n_Items=cap->CreateIndex(logfile,indice);
#else
			fclose (logfile);
			logfile=NULL;
			if (!cap->pcap_open_offline(fileName)) 
				{errorCode=freBadLOG; return;}
		    n_Items=cap->CreateIndex(indice);
#endif
		}
}

//reads the item that starts at the current file position (making format
//checks too); on error doesn't set the original file position
//is called by nextItem and prevItem
Boolean LogfileReader::readItem()
{
	if(!cap)
	{
		//reading the discriminator
		if(lfo.ReadPHeader(logfile))
		{
		 errorCode=freEOF;
		 return False;
		}
		crt.type=lfo.cp->type;
		crt.size=lfo.cp->plen;
		crt.truesize=lfo.cp->len;
		crt.secs=lfo.secs;
		crt.usecs=lfo.usecs;
		crt.written=lfo.written;
		crt.discarded=lfo.discarded;
		crt.firstpr=lfo.FirstProtocol;
		if(crt.size>(unsigned)MaxItemSize)
			{
			 errorCode=freFormat;
		     return False;
		    }
		int newBytes=fread(crt.data,crt.size,1,logfile)*crt.size;
		if(newBytes!=(int)crt.size)
		{
		 errorCode=freTruncated;
		 return False;
		}
		if(lfo.ReadPTrailer(logfile))
		{
		 errorCode=freEOF;
		 return False;
		}
	}
	 else
	{
		 if (cap->pcap_next_packet()) 
		 {
		  errorCode=freEOF;
		  return False;
		 }
	}
    errorCode=freOK;
    return True;
}

//reads the item begining at the current position
Boolean LogfileReader::nextItem()
{
    //let's see if we may do anything
    if(errorCode==freInitFailed)
	return False;
    //saving the current situation for being able to rebuild it on failure
    getCrtPos(&lfp);
    //reading the item
    if(!readItem())
	{
	 setCrtPos(&lfp);
	 return False;
	}
    crt.itemNr++;
    updatePosInfo();
	LogfilePos pos;
	getCrtPos(&pos);
	int p=(pos.position*100/fileLen);
    reportProgress(p);		//reporting to the screen
    return True;
}

//jumps backward an item (called by previousItem) (also checks BOF)
Boolean LogfileReader::skipBackItem()
{
    return Jump(crt.itemNr-1);
}

//this function may seem a little confuse, but that's the price payed for
//keeping nextItem simple
Boolean LogfileReader::previousItem()
{
    //let's see if we may do anything
    if(errorCode==freInitFailed) return False;
	if (n_Items<0||crt.itemNr<2) return False;
	long l=indice.operator[](crt.itemNr-2);
	if (l<0) return False;
    getCrtPos(&lfp);
    //reading the item
#ifndef WIN32
	fseek(logfile,l,SEEK_SET);
#else
	if(!cap)
		fseek(logfile,l,SEEK_SET);
	else 
		cap->SetPos(l);
#endif
    if(!readItem())
	{
	 setCrtPos(&lfp);
	 return False;
	}
    crt.itemNr--;
    updatePosInfo();
	int p=(lfp.position*100/fileLen);
    reportProgress(p);		//reporting to the screen
    return True;
}

LogfileReader::~LogfileReader()
{
    if(logfile)fclose(logfile);
	if (cap) delete cap;
}

void LogfileReader::updatePosInfo()
{
    long crtPos;

#ifdef WIN32
	if (!cap)
		crtPos=ftell(logfile);
	else
		crtPos=cap->GetPos();
#else
	crtPos=ftell(logfile);
#endif
    if(fileLen>40000000L)
	//we have to avoid overflows
	crt.posIndicator=crtPos/(fileLen/100);
    else
	crt.posIndicator=(crtPos*100)/fileLen;
}

//for storing the current pos outside
void LogfileReader::getCrtPos(LogfilePos * pos)
{
    //let's see if we may do anything
    if(errorCode==freInitFailed)
	return;
#ifdef WIN32
	if (!cap)
		pos->position=ftell(logfile);
	else
		pos->position=cap->GetPos();
#else
    pos->position=ftell(logfile);
#endif
    pos->itemNr=crt.itemNr;
    pos->logfile=this;
}

//for setting a position
void LogfileReader::setCrtPos(const LogfilePos* pos)
{
    //let's see if we may do anything
    if(errorCode==freInitFailed)
	return;
    if(pos->logfile!=this)
	return;
    crt.itemNr=pos->itemNr;
#ifdef WIN32
	if (!cap)
	    fseek(logfile,pos->position,SEEK_SET);
	else
		cap->SetPos(pos->position);
#else
    fseek(logfile,pos->position,SEEK_SET);
#endif
}

void LogfileReader::setLfo(const char *f)
{
	if(f) lfo.ReadFile(f);
}

Boolean LogfileReader::Jump(int n)
{
    //let's see if we may do anything
    if(errorCode==freInitFailed) return False;
	if (n_Items<=0||n<=0) return False;
	if (n>n_Items) {n=n_Items;Say(ERR_EOF /*Tentativo di superare la fine del file*/);}
	if (n<=0) return False;
	long l=indice[n-1];
	if (l<0) return False;
    getCrtPos(&lfp);
    //reading the item
#ifndef WIN32
	fseek(logfile,l,SEEK_SET);
#else
	if(!cap)
		fseek(logfile,l,SEEK_SET);
	else 
		cap->SetPos(l);
#endif
    if(!readItem())
	{
	 setCrtPos(&lfp);
	 return False;
	}
    crt.itemNr=n;
    updatePosInfo();
	int p=(lfp.position*100/fileLen);
    reportProgress(p);		//reporting to the screen
    return True;
}

int LogfileReader::GetNItems()
{
	return n_Items;
}

int LogfileReader::GetLinkType()
{
	if(!cap) return lfo.GetLinkType();
	return cap->GetLinkType();
}
