//				LFREADER.H
//This is a header file for LFREADER.CPP

#if !defined( LFREADER)
#define LFREADER

#include <stdio.h>
#include <time.h>
#ifdef WIN32
#ifndef LINUX
#include <sys/types.h>
#endif
#endif
#include "../../comuni/btypes.h"
#include "lforeader.h"	// Added by ClassView
#include "../../comuni/vec_cl.h"
#include "../../comuni/structs.h"

extern int MaxItemSize;

//structure for holding an item in memory
typedef struct itemstruct
{
    unsigned char type;			//the type of the item
    unsigned int size;          	//it's size
    unsigned int truesize;          	//it's size
	const char* firstpr;
	TDWORD secs;
	TDWORD usecs;
	TDWORD written;
	TDWORD discarded;
    TUBYTE *data;	//the actual item
    //some other information not directly read from the item
    unsigned long itemNr;
    int posIndicator;	//a number between 0 and 100 to indicate the current
			//position inside the logfile (aproximatelly)
	itemstruct(int i=1515) {data=new TUBYTE[i];}
	~itemstruct() {if (data) delete[] data;}
} item;

//structure for remembering a position inside the logfile (serves at jumps)
//may not be modified by anybody but the lfreader
typedef struct
{
private:
    unsigned long itemNr;	//crt item number
    unsigned long position;	//crt position in file
    void* logfile;		//I need tis pointer for checks
public:
friend class LogfileReader;
friend class Reporter;
}LogfilePos;

class CCap;

//the logfile lecturer itself (prety complex)
class LogfileReader
{
protected:
    FILE* logfile;
    item crt;		//the current item
    long fileLen;	//the length read at initialisation
    int errorCode;		//the error code of the last operation
    Boolean readItem();
                //reads the item that starts at the current
				//file position (making format checks too)
    Boolean skipBackItem();	//jumps backward an item
    void updatePosInfo();       //updates crt.posIndicator
	LfoReader lfo;
	int n_Items;
	CCap * cap;
public:
	int GetLinkType();
	int GetNItems();
	Boolean Jump(int n);
	void setLfo(const char*);
    LogfileReader(const char* fileName, const char* lfoName);//constructor with file opening
    item* getCrt(){if (errorCode)return NULL; else return &crt;}
    //both functions return True on succes and False if any error occured
    Boolean nextItem();			//reads the next item into it's memory
    Boolean previousItem();		//reads the previous item
    //the following two functions save & restore the crt item too
    void getCrtPos(LogfilePos * pos);	//for storing the current pos outside
    void setCrtPos(const LogfilePos* pos);	//for setting a position
    int getErrorCode(){return errorCode;}
    ~LogfileReader();		//destructor with file closing...
	int IsCap() {if (cap) return 1; return 0;}
private:
	LogfilePos lfp;
	vector<long> indice;
};

//The error codes for the LogfileReader
#define	freOK		0
#define	freEOF		1
#define	freBOF		2
#define	freFormat	3
#define	freTruncated	4
#define	freInitFailed	5
#define freCannotRead	6
#define freBadLFO	7
#define freBadPDO	8
#define freBadDFO	9
#define freBadIFO	10
#define freBadLOG	11
#endif
