// LfoReader.h: interface for the LfoReader class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LFOREADER_H__F0D39438_1595_11D2_940D_000000000000__INCLUDED_)
#define AFX_LFOREADER_H__F0D39438_1595_11D2_940D_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <stdio.h>
#include "../../parsers/fparser/l_structs.h"
#include "../../comuni/vec_cl.h"
#include "../../comuni/rprogress.h"
#include "../vmachine.h"
#include "../../comuni/stack_cl.h"
#include "../../comuni/asksay.h"

class LfoReader : public CVMachine
{
public:
	int GetLinkType();
	int SetFirstProtocol(stack <TSDWORD>& s,int p1);
	virtual int VExecuteAddIn(stack<TSDWORD> &,istruzione *ist, const TUBYTE * c);
	void SetInversion(TSDWORD i);
	int ReadPTrailer(FILE * f);
	int ReadPHeader(FILE * f);
	int ObjOk;
	int ReadHeader(FILE* f);
	int CreateIndex(FILE* f,vector<long> & indice);
	int ReadFile(const char* nome);
	int LfoError(const char* c);
	LfoReader(const char* nomefile=NULL);
	char FirstProtocol[MAX_NAME+1];
	virtual ~LfoReader();
	packet* cp;
	header h;
	TDWORD usecs;
	TDWORD secs;
	TDWORD written;
	TDWORD discarded;
	//Prototipi delle funzioni AddIn
	int InvertBytes(stack<TSDWORD> &s, int par);
	int Len(stack<TSDWORD> &s, int par);
	int PLen(stack<TSDWORD> &s, int par);
	int LinkType(stack<TSDWORD> &s, int par);
	int Type(stack<TSDWORD> &s, int par);
	int Check(stack<TSDWORD> &s, int par); 
private:
	AddIn a[5];
	int dword;
	void SortPTypes(packet* p, int np);
	int INPUT(int& t);
	int np;
	FILE* in;
	packet* p;
};

#endif // !defined(AFX_LFOREADER_H__F0D39438_1595_11D2_940D_000000000000__INCLUDED_)
