// LfoReader.cpp: implementation of the LfoReader class.
//
//////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <limits.h>
#include "lforeader.h"

#ifndef OPENSILENT
#define Lerrore(A) {LfoError(A);return -1;}
#else
#define Lerrore(A) {return -1;}
#endif 

#ifndef ENGLISH
#define ERR_GEN "Errore generico non definibile nell'LFO"
#define ERR_LFO "Il file LFO non esiste o non  accessibile"
#define ERR_LFO1 "File LFO errato"
#define ERR_MEM "Memoria esaurita"
#define ERR_READ "Errore di lettura da file"
#define ERR_ILFO "Errore nel processamento delle istruzioni dell'LFO"
#else
#define ERR_GEN "Error in LFO file"
#define ERR_LFO "Wrong LFO file"
#define ERR_LFO1 "Wrong LFO file"
#define ERR_MEM "Out of Memory"
#define ERR_READ "Error reading from file"
#define ERR_ILFO "Error processing LFO instructions"
#endif
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

LfoReader::LfoReader(const char* nomefile)
{
	h.mustinvert=0;
	mustinvert=0;
	in=NULL;
	h.hdr=NULL;
	h.ist=NULL;
	ObjOk=0;
	secs=0;
	usecs=0;
	p=NULL;
	np=0;
	if (nomefile) ReadFile(nomefile);
}

LfoReader::~LfoReader()
{
	if(in) fclose(in);
	if (h.hdr) delete[] h.hdr;
	int i;
	for(i=0;i<np;i++)
	  if (p[i].pckhdr) delete[]p[i].pckhdr;

}

int LfoReader::LfoError(const char* c)
{
		if (c==NULL) {Say(ERR_GEN /*Errore generico non definibile nell'LFO*/);}
		else {Say (c);}
		return -1;
}

int LfoReader::ReadFile(const char * nome)
{
	in=fopen (nome,"r");
	if (in==NULL) Lerrore(ERR_LFO /*Il file LFO non esiste o non  accessibile*/);
	int r,i;
	if (p)
	{
	 for(r=0;r<np;r++)
		{
		 if (p[r].ist) delete [] p[r].ist;
		 if (p[r].pckhdr) delete [] p[r].pckhdr;
		 if (p[r].pcktrl) delete [] p[r].pcktrl;
		}
	 delete [] p;
	 p=NULL;
	}
	if (h.ist) delete[] h.ist;
	if (h.hdr) delete[] h.hdr;
	// Parte dell'Header
	INPUT(r);
	if(r!=O_HDRH) Lerrore(ERR_LFO1 /*File LFO errato*/);
	INPUT(np);
	p=new packet[np];
	if (!p) Lerrore(ERR_MEM /*Memoria esaurita*/);
	for(r=0;r<np;r++) p[r].ist=NULL;
	INPUT(h.size);
	INPUT(h.tsize);
	h.ist=new istruzione[h.tsize+1];
	for(r=0;r<h.tsize;r++)
		{
		 INPUT (h.ist[r].ist_number);
		 INPUT (h.ist[r].p1);
		}
	h.ist[r].ist_number=I_END;
	h.ist[r].p1=0;
	INPUT(r);
	if(r!=O_HDRH_E) Lerrore(ERR_LFO1 /*File LFO errato*/);
	// Parte dei pacchetti
	for(i=0;i<np;i++)
	{
		INPUT(r);
		if(r!=O_PKTH) Lerrore(ERR_LFO1 /*File LFO errato*/);
		INPUT(p[i].hlen);
		INPUT(p[i].len);
		p[i].pckhdr=NULL;
		p[i].pcktrl=NULL;
	    p[i].ist=new istruzione[p[i].len+1];
	    for(r=0;r<p[i].len;r++)
		{
		 INPUT (p[i].ist[r].ist_number);
		 INPUT (p[i].ist[r].p1);
		}
		p[i].ist[r].ist_number=I_END;
		p[i].ist[r].p1=0;
		INPUT(r);
		if(r!=O_PKTH_E) Lerrore(ERR_LFO1 /*File LFO errato*/);
		INPUT(r);
		if(r!=O_PKTT) Lerrore(ERR_LFO1 /*File LFO errato*/);
		INPUT(p[i].tlen);
		INPUT(r);
		if(r!=O_PKTT_E) Lerrore(ERR_LFO1 /*File LFO errato*/);
	}
	INPUT(r);
	if(r!=O_HDRT) Lerrore(ERR_LFO1 /*File LFO errato*/);
	INPUT(h.tsize);
	INPUT(r);
	if(r!=O_HDRT_E) Lerrore(ERR_LFO1 /*File LFO errato*/);
	SortPTypes(p,np);
	ObjOk=1;
	return 0;
}

int LfoReader::INPUT(int & t)
{
	if (fread(&t,sizeof(int),1,in)==0) 
	{
		Lerrore(ERR_READ /*Errore di lettura da file*/); 
		return -1;
	}
	return t;
}

static int cmp(const void* a,const void*b)
{
	packet* pa,*pb;
	pa=(packet*)a;pb=(packet*)b;
	if (pa->hlen<pb->hlen) return -1;
	if (pa->hlen==pb->hlen) return 0;
	return 1;
}

void LfoReader::SortPTypes(packet* p, int np)
{
	qsort(p,np,sizeof(packet),&cmp);
}

static long GetFileLeft(FILE* f)
{
	long p1,p2;
	p1=ftell(f);
	fseek(f,-1,SEEK_END);
	p2=ftell(f)-p1;
	fseek(f,p1,SEEK_SET);
	return p2;
}

static long GetFileLen(FILE* f)
{
	long p1,p2;
	p1=ftell(f);
	fseek(f,-1,SEEK_END);
	p2=ftell(f);
	fseek(f,p1,SEEK_SET);
	return p2;
}

int LfoReader::CreateIndex(FILE* f,vector<long> & indice)
{
 int i,n=0;
 if (f==NULL) return -1;
 i=ReadHeader(f);
 if (i) return -1;
 long l;
 do
 {
	 l=GetFileLeft(f);
	 reportProgress(100-(l*100/GetFileLen(f)));
	 if (l>h.tsize)
	 {
		 indice[n]=ftell(f);
		 n++;
		 if(ReadPHeader(f)!=0) return -1;
		 fseek(f,cp->plen+cp->tlen,SEEK_CUR);
     }
 } while (l>h.tsize);
 return n;
}

int LfoReader::ReadHeader(FILE * f)
{
 if (ObjOk==0) return -1;
 if (f==NULL) return -1;
 fseek(f,0,SEEK_SET);
 if (h.hdr) delete[] h.hdr;
 h.hdr=new TUBYTE[h.size];
 h.mustinvert=0;
 h.linktype=0;
 if (h.hdr==NULL) return -1;
 if((int)fread(h.hdr,sizeof(TUBYTE),h.size,f)!=h.size) return -1;
 ExecuteProgram(h.ist,h.hdr);
 return 0;
}

int LfoReader::ReadPHeader(FILE * f)
{
  int i,size=0;
  written=0;
  discarded=0;
  for(i=0;i<np;i++)	
  {
	  if(i!=0) fseek(f,-(cp->hlen),SEEK_CUR);
	  cp=p+i;
	  if (cp->pckhdr==NULL) cp->pckhdr = new TUBYTE[cp->hlen];
	  if (cp->pckhdr==NULL) return -1;
	  if((int)fread(cp->pckhdr,sizeof(TUBYTE),cp->hlen,f)!=cp->hlen) return -1;
	  ExecuteProgram(cp->ist,cp->pckhdr);
	  if (cp->check) return 0;
  }
  cp=NULL;
  return -1;
}

int LfoReader::ReadPTrailer(FILE * f)
{
	if (!cp) return -1;
	if (cp->pcktrl==NULL && cp->tlen!=0) 
	{
		cp->pcktrl = new TUBYTE[cp->tlen];
		if (cp->pcktrl==NULL) return -1;
	}
	if(cp->tlen!=0)
	 if((int)fread(cp->pcktrl,sizeof(TUBYTE),cp->tlen,f)!=cp->tlen) return -1;
  return 0;
}

void LfoReader::SetInversion(TSDWORD i)
{
	h.mustinvert=i;
	mustinvert=h.mustinvert;
}

int LfoReader::InvertBytes(stack<TSDWORD> &s, int par)
{
	SetInversion(s.pop());
	return 0;
}

int LfoReader::LinkType(stack<TSDWORD> &s, int par)
{
	h.linktype=s.pop();
	return 0;
}

int LfoReader::Len(stack<TSDWORD> &s, int par)
{
    if(cp==NULL) 
	{
		errore(ERR_ILFO /*Errore nel processamento delle istruzioni dell'LFO*/); 
		return 1;
	}
	cp->len=s.pop();
	return 0;
}

int LfoReader::PLen(stack<TSDWORD> &s, int par)
{
    if(cp==NULL) 
	{
		errore(ERR_ILFO /*Errore nel processamento delle istruzioni dell'LFO*/); 
		return 1;
	}
	cp->plen=s.pop();
	return 0;
}

int LfoReader::Type(stack<TSDWORD> &s, int par)
{
    if(cp==NULL) 
	{
		errore(ERR_ILFO /*Errore nel processamento delle istruzioni dell'LFO*/); 
		return 1;
	}
	cp->type=s.pop();
	return 0;
}

int LfoReader::Check(stack<TSDWORD> &s, int par)
{
    if(cp==NULL) 
	{
		errore(ERR_ILFO /*Errore nel processamento delle istruzioni dell'LFO*/); 
		return 1;
	}
	cp->check=s.pop();
	if(!cp->check) return 1;
	return 0;
}


int LfoReader::VExecuteAddIn(stack<TSDWORD> &s,istruzione *ist, const TUBYTE * c)
{
	 switch (ist->ist_number)
		 {
			case I_INVERTBYTES:
				return InvertBytes(s,ist->p1);
				break;
			case I_LEN:
				return Len(s,ist->p1);
				break;
			case I_LINKTYPE:
				return LinkType(s,ist->p1);
				break;
			case I_PLEN:
				return PLen(s,ist->p1);
				break;
			case I_TYPE:
				return Type(s,ist->p1);
				break;
			case I_CHECK:
				return Check(s,ist->p1);
				break;
			case I_SECS:
				secs=s.pop();
				return 0;
				break;
			case I_USECS:
				usecs=s.pop();
				return 0;
				break;
			case I_WRITTEN:
				written=s.pop();
				return 0;
				break;
			case I_DISCARDED:
				discarded=s.pop();
				return 0;
				break;
			case I_FIRSTP:
				return SetFirstProtocol(s,ist->p1);
				break;
		    default:
				errore(ERR_ILFO /*Errore nel processamento delle istruzioni dell'LFO*/);
		 }
	return 1;
}

int LfoReader::SetFirstProtocol(stack<TSDWORD> &s, int p1)
{
	int i;
	for(i=0;i<p1&&i<MAX_NAME;i++)
		FirstProtocol[i]=(char) s.pop();
	FirstProtocol[i]='\0';
	return 0;
}

int LfoReader::GetLinkType()
{
	return h.linktype;
}
