#include "savefile.h"
#include "../../comuni/asksay.h"
#include "lfreader.h"
#include "../../iniprocessor/iniprocesser.h"

#define BPF_ALIGNMENT sizeof(bpf_int32)

#ifndef ENGLISH
#define ERR_MEM "Memoria esaurita"
#define ERR_IN "Errore di apertura del file di ingresso"
#define ERR_HDR "Errore nella lettura dell'header"
#define ERR_DUMP "Bad dump file format"
#define ERR_OLD "Formato del file troppo vecchio"
#define ERR_BOGUS "bogus savefile header"
#define ERR_MALLOC "BUFMOD hack malloc"
#define ERR_TDUMP "File troncato"
#define ERR_OUT "Errore nell'apertura del file di output"
#else
#define ERR_MEM "Out of Memory"
#define ERR_IN "Error opening input file"
#define ERR_HDR "Error reading header"
#define ERR_DUMP "Bad dump file format"
#define ERR_OLD "File format too old"
#define ERR_BOGUS "bogus savefile header"
#define ERR_MALLOC "BUFMOD hack malloc"
#define ERR_TDUMP "truncated dump file"
#define ERR_OUT "Error opening output file"
#endif
CCap::CCap(struct itemstruct* i) 
#ifndef WIN32
{cItem=i;f=NULL;p=NULL;fpr=NULL;}
#else
{
	cItem=i;p=NULL;fpr=NULL;
    lpvFile = NULL;
    hFileMap = INVALID_HANDLE_VALUE;
    hFile = INVALID_HANDLE_VALUE;
}
#endif

CCap::~CCap()
{
	if (p) free(p); 
	if (fpr) delete[]fpr;
#ifndef WIN32
	if(f) fclose(f); 
#else
   if (lpvFile!=NULL) UnmapViewOfFile(lpvFile);
   if (hFile != INVALID_HANDLE_VALUE) CloseHandle(hFileMap);
   if (hFile != INVALID_HANDLE_VALUE) CloseHandle(hFile);
#endif
}

void CCap::swap_hdr(struct pcap_file_header *hp)
{
	hp->version_major = SWAPSHORT(hp->version_major);
	hp->version_minor = SWAPSHORT(hp->version_minor);
	hp->thiszone = SWAPLONG(hp->thiszone);
	hp->sigfigs = SWAPLONG(hp->sigfigs);
	hp->snaplen = SWAPLONG(hp->snaplen);
	hp->linktype = SWAPLONG(hp->linktype);
}

extern string IniName;

#ifndef WIN32

pcap_t * CCap::pcap_open_offline(FILE *fp)
{
	struct pcap_file_header hdr;
	int linklen;
	CIniProcesser ini(IniName,1);

	if (p) free(p);
	p = (pcap_t *)malloc(sizeof(*p));
	if (p == NULL) {
		Say(ERR_MEM /*Memoria esaurita*/);
		return (NULL);
	}

	memset((char *)p, 0, sizeof(*p));
	/*
	 * Set this field so we don't close stdin in pcap_close!
	 */

	if (fp == NULL) {Say(ERR_IN /*Errore di apertura del file di ingresso*/);return NULL;}
	f=fp;
	fseek(fp,0,SEEK_SET);
	if (fread((char *)&hdr, sizeof(hdr), 1, fp) != 1) {

		Say(ERR_HDR /*Errore nella lettura dell'header*/);
		goto bad;
	}
	if (hdr.magic != TCPDUMP_MAGIC) {
		if (SWAPLONG(hdr.magic) != TCPDUMP_MAGIC) {
			Say(ERR_DUMP /*Bad dump file format*/);
			goto bad;
		}
		p->sf.swapped = 1;
		swap_hdr(&hdr);
	}
	if (hdr.version_major < PCAP_VERSION_MAJOR) {
		Say(ERR_OLD /*Formato del file troppo vecchio*/);
		goto bad;
	}
	p->tzoff = hdr.thiszone;
	p->snapshot = hdr.snaplen;
	p->linktype = hdr.linktype;
	p->sf.rfile = fp;
	p->bufsize = hdr.snaplen;

	/* Align link header as required for proper data alignment */
	/* XXX should handle all types */
	switch (p->linktype) {

	case DLT_EN10MB:
		linklen = 14;
		break;

	case DLT_FDDI:
		linklen = 13 + 8;	/* fddi_header + llc */
		break;

	case DLT_NULL:
	default:
		linklen = 0;
		break;
	}

	p->sf.base = (u_char *)malloc(p->bufsize + BPF_ALIGNMENT);
	p->buffer = p->sf.base + BPF_ALIGNMENT - (linklen % BPF_ALIGNMENT);
	p->sf.version_major = hdr.version_major;
	p->sf.version_minor = hdr.version_minor;
#ifdef PCAP_FDDIPAD
	/* XXX padding only needed for kernel fcode */
	pcap_fddipad = 0;
#endif
	char chr[20];
	const char *charact;
	sprintf(chr,"%d",p->linktype);
	charact=ini.SearchFromFile("Cap", chr);
	if (charact!=NULL && charact[0]!='\0')
	{
		fpr=new char[strlen(charact)+1];
		int k;
		for (k=0;k<(signed)strlen(charact);k++) 
			if (islower(charact[k])) fpr[k]=toupper(charact[k]);
			else fpr[k]=charact[k];
		fpr[k]='\0';
	}
	else
	{
		fpr= new char[4];
		strcpy(fpr,"MAC");
	}
	return (p);
 bad:
	free(p);
	p=NULL;
	return (NULL);
}

#else

pcap_t * CCap::pcap_open_offline(const char* fp)
{
   if (fp == NULL) {Say(ERR_IN /*Errore di apertura del file di ingresso*/);return NULL;}
   // Open the file for reading and writing.
   hFile = CreateFile(fp, GENERIC_READ,
      FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

   if (hFile == INVALID_HANDLE_VALUE) {
      MessageBox(NULL, __TEXT("File could not be opened."),
         __TEXT("Query"), MB_OK);
      return(0);
   }

   dwFileSize = GetFileSize(hFile, NULL);

   hFileMap = CreateFileMapping(hFile, NULL, PAGE_READONLY ,
      0, dwFileSize, NULL);

   if (hFileMap == NULL) {
      // File-Mapping open failed.
      MessageBox(NULL, __TEXT("File map could not be opened."),
         __TEXT("Query"), MB_OK);
      CloseHandle(hFile);
      hFile = INVALID_HANDLE_VALUE;
      return(0);
   }

   // Get the address where the first byte of the file 
   // is mapped into memory.
   lpvFile = MapViewOfFile(hFileMap, FILE_MAP_READ, 0, 0, 0);

   if (lpvFile == NULL) {
      // Map view of file failed.
      MessageBox(NULL, __TEXT("Could not map view of file."),
         __TEXT("Query"), MB_OK);
      CloseHandle(hFileMap);
      CloseHandle(hFile);
      hFileMap = INVALID_HANDLE_VALUE;
      hFile = INVALID_HANDLE_VALUE;
      return(0);
   }
   index=0;
	

	struct pcap_file_header hdr;
	int linklen;
	CIniProcesser ini(IniName,1);

	if (p) free(p);
	p = (pcap_t *)malloc(sizeof(*p));
	if (p == NULL) {
		Say(ERR_MEM /*Memoria esaurita*/);
		return (NULL);
	}

	memset((char *)p, 0, sizeof(*p));
	/*
	 * Set this field so we don't close stdin in pcap_close!
	 */

	if (dwFileSize<sizeof(hdr)) {

		Say(ERR_HDR /*Errore nella lettura dell'header*/);
		goto bad;
	}
	else memcpy(&hdr,lpvFile,sizeof(hdr));
	if (hdr.magic != TCPDUMP_MAGIC) {
		if (SWAPLONG(hdr.magic) != TCPDUMP_MAGIC) {
			Say(ERR_DUMP /*Bad dump file format*/);
			goto bad;
		}
		p->sf.swapped = 1;
		swap_hdr(&hdr);
	}
	if (hdr.version_major < PCAP_VERSION_MAJOR) {
		Say(ERR_OLD /*Formato del file troppo vecchio*/);
		goto bad;
	}
	index=sizeof(hdr);
	p->tzoff = hdr.thiszone;
	p->snapshot = hdr.snaplen;
	p->linktype = hdr.linktype;
	p->sf.rfile = NULL;
	p->bufsize = hdr.snaplen;

	/* Align link header as required for proper data alignment */
	/* XXX should handle all types */
	switch (p->linktype) {

	case DLT_EN10MB:
		linklen = 14;
		break;

	case DLT_FDDI:
		linklen = 13 + 8;	/* fddi_header + llc */
		break;

	case DLT_NULL:
	default:
		linklen = 0;
		break;
	}

	p->sf.base = (u_char *)malloc(p->bufsize + BPF_ALIGNMENT);
	p->buffer = p->sf.base + BPF_ALIGNMENT - (linklen % BPF_ALIGNMENT);
	p->sf.version_major = hdr.version_major;
	p->sf.version_minor = hdr.version_minor;
#ifdef PCAP_FDDIPAD
	/* XXX padding only needed for kernel fcode */
	pcap_fddipad = 0;
#endif
	char chr[20];
	const char *charact;
	sprintf(chr,"%d",p->linktype);
	charact=ini.SearchFromFile("Cap", chr);
	if (charact!=NULL && charact[0]!='\0')
	{
		fpr=new char[strlen(charact)+1];
		int k;
		for (k=0;k<(signed)strlen(charact);k++) 
			if (islower(charact[k])) fpr[k]=toupper(charact[k]);
			else fpr[k]=charact[k];
		fpr[k]='\0';
	}
	else
	{
		fpr= new char[4];
		strcpy(fpr,"MAC");
	}
	return (p);
 bad:
	free(p);
	p=NULL;
	return (NULL);
}

#endif

/*
 * Read sf_readfile and return the next packet.  Return the header in hdr
 * and the contents in buf.  Return 0 on success, SFERR_EOF if there were
 * no more packets, and SFERR_TRUNC if a partial packet was encountered.
 */
int CCap::sf_next_packet(struct pcap_pkthdr *hdr, u_char *buf, int buflen)
{
	FILE *fp;

	if (p==NULL) return -1;
	fp = p->sf.rfile;

	/* read the stamp */
#ifndef WIN32
	if (fread((char *)hdr, sizeof(struct pcap_pkthdr), 1, fp) != 1) 
#else
	if (dwFileSize>=index+sizeof(struct pcap_pkthdr))
	{
		memcpy(hdr,(BYTE*)lpvFile+index,sizeof(struct pcap_pkthdr));
		index +=sizeof(struct pcap_pkthdr);
	}
	else
#endif
	{
		/* probably an EOF, though could be a truncated packet */
		return (1);
	}

	if (p->sf.swapped) {
		/* these were written in opposite byte order */
		hdr->caplen = SWAPLONG(hdr->caplen);
		hdr->len = SWAPLONG(hdr->len);
		hdr->ts.tv_sec = SWAPLONG(hdr->ts.tv_sec);
		hdr->ts.tv_usec = SWAPLONG(hdr->ts.tv_usec);
	}
	/*
	 * We interchanged the caplen and len fields at version 2.3,
	 * in order to match the bpf header layout.  But unfortunately
	 * some files were written with version 2.3 in their headers
	 * but without the interchanged fields.
	 */
	if (p->sf.version_minor < 3 ||
	    (p->sf.version_minor == 3 && hdr->caplen > hdr->len)) {
		int t = hdr->caplen;
		hdr->caplen = hdr->len;
		hdr->len = t;
	}

	if ((unsigned)hdr->caplen > (unsigned)buflen) {
		/*
		 * This can happen due to Solaris 2.3 systems tripping
		 * over the BUFMOD problem and not setting the snapshot
		 * correctly in the savefile header.  If the caplen isn't
		 * grossly wrong, try to salvage.
		 */
		static u_char *tp = NULL;
		static int tsize = 0;

		if (hdr->caplen > 65535) {
			Say(ERR_BOGUS /*bogus savefile header*/);
			return (-1);
		}
		if ((unsigned)tsize < (unsigned)hdr->caplen) {
			tsize = ((hdr->caplen + 1023) / 1024) * 1024;
			if (tp != NULL)
				free((u_char *)tp);
			tp = (u_char *)malloc(tsize);
			if (tp == NULL) {
				tsize = 0;
				Say(ERR_MALLOC /*BUFMOD hack malloc*/);
				return (-1);
			}
		}
#ifndef WIN32
		if (fread((char *)tp, hdr->caplen, 1, fp) != 1) 
#else
		if (dwFileSize>=index+hdr->caplen)
		{
			memcpy(tp,(BYTE*)lpvFile+index,hdr->caplen);
			index +=hdr->caplen;
		}
		else
#endif
		{
			Say(ERR_TDUMP /*truncated dump file*/);
			return (-1);
		}
		/*
		 * We can only keep up to buflen bytes.  Since caplen > buflen
		 * is exactly how we got here, we know we can only keep the
		 * first buflen bytes and must drop the remainder.  Adjust
		 * caplen accordingly, so we don't get confused later as
		 * to how many bytes we have to play with.
		 */
		hdr->caplen = buflen;
		memcpy((char *)buf, (char *)tp, buflen);

	} else {
		/* read the packet itself */

#ifndef WIN32
		if (fread((char *)buf, hdr->caplen, 1, fp) != 1) 
#else
		if (dwFileSize>=index+hdr->caplen)
		{
			memcpy(buf,(BYTE*)lpvFile+index,hdr->caplen);
			index +=hdr->caplen;
		}
		else
#endif
		{
			Say(ERR_DUMP /*truncated dump file*/);
			return (-1);
		}
	}
	return (0);
}

int CCap::pcap_next_packet()
{
	int ret= sf_next_packet(&hdr, cItem->data, MaxItemSize);
	cItem->type=130;
	cItem->size=hdr.caplen;
	cItem->truesize=hdr.len;
	cItem->secs=hdr.ts.tv_sec;
	cItem->usecs=hdr.ts.tv_usec;
	cItem->written=0;
	cItem->discarded=0;
	cItem->firstpr=fpr;
	return ret;
}

#ifndef WIN32

int CCap::CreateIndex(FILE * f, vector<long> & indice)
{
 int n=0;
 if (f==NULL) return -1;
 do
 {
	indice[n]=ftell(f);
	n++;
	if(pcap_next_packet()!=0) return n-1;
 } while (1);
}

#else

int CCap::CreateIndex(vector<long> & indice)
{
 int n=0;
 index=sizeof(struct pcap_file_header);
 do
 {
	indice[n]=index;
	n++;
	if(pcap_next_packet()!=0) return n-1;
 } while (1);
}

#endif

item* CCap::GetItem()
{
	return cItem;
}

void CCap::pcap_close()
{
#ifndef WIN32
	if (f) fclose(f);
	f=NULL;
#endif
}


////////////////////////////////////////////////////////////////////////
// 
// Classe CSaveCap
//
////////////////////////////////////////////////////////////////////////

/*
 * Initialize so that sf_write() will output to the file named 'fname'.
 */
#ifndef WIN32

FILE *CSaveCap::pcap_dump_open(const char *fname,int lt)
{
	if (f) fclose(f);
	f = fopen(fname, "wb");
	return pcap_dump_open(f, lt);
}

#else

BYTE *CSaveCap::pcap_dump_open(const char *fname,int lt,int size)
{
   hFileMap = INVALID_HANDLE_VALUE;
   hFile = INVALID_HANDLE_VALUE;
   // Open the file for reading and writing.
   hFile = CreateFile(fname, GENERIC_WRITE | GENERIC_READ,
      0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
   index=0;
   np=0;

   if (hFile == INVALID_HANDLE_VALUE) {
      // File open failed.
      MessageBox(NULL, __TEXT("File could not be opened."),
         __TEXT("Query"), MB_OK);
      return(0);
   }

   // Get the size of the file. I am assuming here that the
   // file is smaller than 4 GB.
   dwFileSize = size;

   hFileMap = CreateFileMapping(hFile, NULL, PAGE_READWRITE,
      0, dwFileSize, NULL);

   if (hFileMap == NULL) {
      // File-Mapping open failed.
      MessageBox(NULL, __TEXT("File map could not be opened."),
         __TEXT("Query"), MB_OK);
      CloseHandle(hFile);
      hFile = INVALID_HANDLE_VALUE;
      return(0);
   }

   // Get the address where the first byte of the file 
   // is mapped into memory.
   lpvFile = MapViewOfFile(hFileMap, FILE_MAP_WRITE, 0, 0, 0);

   if (lpvFile == NULL) {
      // Map view of file failed.
      MessageBox(NULL, __TEXT("Could not map view of file."),
         __TEXT("Query"), MB_OK);
      CloseHandle(hFileMap);
      CloseHandle(hFile);
      hFileMap = INVALID_HANDLE_VALUE;
      hFile = INVALID_HANDLE_VALUE;
      return(0);
   }
   if (!ps) 
	{
		ps= (pcap_t*) calloc(1,sizeof(pcap_t));
		if (ps==NULL)
		{
			Say(ERR_MEM /*Memoria esaurita*/);
			return (NULL);
		}
		ps->linktype=lt;
		ps->snapshot=MaxItemSize;
	}
	(void)sf_write_header(ps->linktype, ps->tzoff, ps->snapshot);
   return (BYTE*)lpvFile;
}

BYTE * CSaveCap::pcap_dump_expand() 
{
   if (!lpvFile) return NULL;
   UnmapViewOfFile(lpvFile);
   CloseHandle(hFileMap);
   SetFilePointer(hFile, index, NULL, FILE_BEGIN);
   SetEndOfFile(hFile);
   dwFileSize*=2;
   /*SYSTEM_INFO s;
   GetSystemInfo(&s); 
   DWORD ns=dwFileSize;
   if (ns<s.dwAllocationGranularity) ns=s.dwAllocationGranularity;*/
   hFileMap = CreateFileMapping(hFile, NULL, PAGE_READWRITE,
      0, dwFileSize/*ns*/, NULL);

   if (hFileMap == NULL) {
      // File-Mapping open failed.
      MessageBox(NULL, __TEXT("File map could not be opened."),
         __TEXT("Query"), MB_OK);
      CloseHandle(hFile);
      hFile = INVALID_HANDLE_VALUE;
      return(0);
   }

   // Get the address where the first byte of the file 
   // is mapped into memory.

   /*ns=index/s.dwAllocationGranularity;
   np+=ns;
   index=index-ns*s.dwAllocationGranularity;*/

   lpvFile = MapViewOfFile(hFileMap, FILE_MAP_WRITE, 0, 0/*np*s.dwAllocationGranularity*/, 0);

   if (lpvFile == NULL) {
      // Map view of file failed.
	  DWORD err=GetLastError();
	  char t[100];
	  sprintf(t,"Could not map view of file. Error %d",err);
      MessageBox(NULL, t,
         __TEXT("Query"), MB_OK);
      CloseHandle(hFileMap);
      CloseHandle(hFile);
      hFileMap = INVALID_HANDLE_VALUE;
      hFile = INVALID_HANDLE_VALUE;
      return(0);
   }
   return (BYTE*)lpvFile;
}

#endif

#ifndef WIN32
FILE* CSaveCap::pcap_dump_open(FILE * fn,int lt)
{
	f=fn;
	if (f == NULL)
		{
			Say(ERR_OUT /*Errore nell'apertura del file di output*/);
			return (NULL);
		}
    if (!ps) 
	{
		ps= (pcap_t*) calloc(1,sizeof(pcap_t));
		if (ps==NULL)
		{
			Say(ERR_MEM /*Memoria esaurita*/);
			return (NULL);
		}
		ps->linktype=lt;
		ps->snapshot=MaxItemSize;
	}
	(void)sf_write_header(f, ps->linktype, ps->tzoff, ps->snapshot);
	return ((FILE *)f);
}

#endif

void CSaveCap::pcap_dump_close()
{
#ifndef WIN32
	if (f) fclose(f);
	f=NULL;
#else
   if (!lpvFile) return;
   UnmapViewOfFile(lpvFile);
   CloseHandle(hFileMap);
   SetFilePointer(hFile, index, NULL, FILE_BEGIN);
   SetEndOfFile(hFile);
   CloseHandle(hFile);
#endif
}

#ifndef WIN32
int CSaveCap::sf_write_header(FILE *fp, int linktype, int thiszone, int snaplen)
#else
int CSaveCap::sf_write_header(int linktype, int thiszone, int snaplen)
#endif
{
	struct pcap_file_header hdr;

	hdr.magic = TCPDUMP_MAGIC;
	hdr.version_major = PCAP_VERSION_MAJOR;
	hdr.version_minor = PCAP_VERSION_MINOR;

	hdr.thiszone = thiszone;
	hdr.snaplen = snaplen;
	hdr.sigfigs = 0;
	hdr.linktype = linktype;

#ifndef WIN32
	if (fwrite((char *)&hdr, sizeof(hdr), 1, fp) != 1)
		return (-1);
#else
	if (dwFileSize<sizeof(hdr) && !pcap_dump_expand())return (-1);
	memcpy(lpvFile,&hdr,sizeof(hdr));
	index=sizeof(hdr);
#endif
	return (0);
}

/*
 * Output a packet to the initialized dump file.
 */
int CSaveCap::pcap_dump(struct itemstruct * i)
{
 if(i==NULL) 
 {
	i=cItem;
	if(i==NULL) return 0;
 }
 struct pcap_pkthdr h;
 h.caplen=i->size;
 h.len=i->truesize;
 if (h.len==0 && h.caplen==0) return 0;
 h.ts.tv_sec=i->secs;
 h.ts.tv_usec=i->usecs;
 return pcap_dump(&h,i->data);
}

int CSaveCap::pcap_dump(const struct pcap_pkthdr *h, const u_char *sp)
{
	/* XXX we should check the return status */
#ifndef WIN32
	if(fwrite((char *)h, sizeof(*h), 1, f)!=1) return 1;
	if(fwrite((char *)sp, h->caplen, 1, f)!=1) return 1;
#else
	if (dwFileSize<index+sizeof(*h)&& !pcap_dump_expand())return (1);
	memcpy(index+(BYTE*)lpvFile,h,sizeof(*h));
	index+=sizeof(*h);
	if (dwFileSize<index+h->caplen&& !pcap_dump_expand())return (1);
	memcpy(index+(BYTE*)lpvFile,sp,h->caplen);
	index+=h->caplen;
#endif
	return 0;
}
