#ifndef CAPFILES
#define CAPFILES

#include <stdio.h>

#ifndef WIN32
#include <sys/time.h>
#else
#if ! defined CONSOLE
#include <afxsock.h>
#else
#include <winsock.h>
#endif

#include <time.h>
#endif

#include "../../comuni/structs.h"
#include "../../comuni/vec_cl.h"

#define u_short TWORD
#define bpf_u_int32 TDWORD
#define bpf_int32 TSDWORD
#define u_char TUBYTE

#define TCPDUMP_MAGIC 0xa1b2c3d4

#define	SWAPLONG(y) \
((((y)&0xff)<<24) | (((y)&0xff00)<<8) | (((y)&0xff0000)>>8) | (((y)>>24)&0xff))
#define	SWAPSHORT(y) \
	( (((y)&0xff)<<8) | ((u_short)((y)&0xff00)>>8) )

#define SFERR_TRUNC		1
#define SFERR_BADVERSION	2
#define SFERR_BADF		3
#define SFERR_EOF		4 /* not really an error, just a status */

#define PCAP_VERSION_MAJOR 2
#define PCAP_VERSION_MINOR 4

struct pcap_file_header {
	bpf_u_int32 magic;
	u_short version_major;
	u_short version_minor;
	bpf_int32 thiszone;	/* gmt to local correction */
	bpf_u_int32 sigfigs;	/* accuracy of timestamps */
	bpf_u_int32 snaplen;	/* max length saved portion of each pkt */
	bpf_u_int32 linktype;	/* data link type (DLT_*) */
};

struct pcap_pkthdr {
	struct timeval ts;	/* time stamp */
	bpf_u_int32 caplen;	/* length of portion present */
	bpf_u_int32 len;	/* length this packet (off wire) */
};

struct pcap_sf {
	FILE *rfile;
	int swapped;
	int version_major;
	int version_minor;
	u_char *base;
};

struct itemstruct;

struct pcap {
	int snapshot;
	int linktype;
	int tzoff;	
	int offset;	
	int bufsize;
	u_char *buffer;
	u_char *bp;
	int cc;
	struct pcap_sf sf;
	struct itemstruct* cItem;
	u_char *pkt;
};

typedef struct pcap pcap_t;

class CCap 
{
private:
	pcap_t *p;
#ifndef WIN32
	FILE *f;
#else
	HANDLE hFile, hFileMap;
	LPVOID lpvFile;
	DWORD dwFileSize;
	DWORD index;
#endif
	char* fpr;
	struct itemstruct* cItem;
	struct pcap_pkthdr hdr;
	void CCap::swap_hdr(struct pcap_file_header *hp);
public:
	int GetLinkType() {return p->linktype;}
	void pcap_close();
	struct itemstruct* GetItem();
	CCap(struct itemstruct* i);
#ifndef WIN32
	int CreateIndex(FILE* f,vector<long> & indice);
#else
	int CreateIndex(vector<long> & indice);
	DWORD GetPos(){return index;}
	DWORD GetSize(){return dwFileSize;}
	void SetPos(DWORD l){index=l;}
#endif
	int pcap_next_packet();
	~CCap();
#ifndef WIN32
	pcap_t *pcap_open_offline(FILE *fp);
#else
	pcap_t *pcap_open_offline(const char*fp);
#endif
	int sf_next_packet(struct pcap_pkthdr *hdr, u_char *buf, int buflen);
};

#define DLT_NULL	0	/* no link-layer encapsulation */
#define DLT_EN10MB	1	/* Ethernet (10Mb) */
#define DLT_EN3MB	2	/* Experimental Ethernet (3Mb) */
#define DLT_AX25	3	/* Amateur Radio AX.25 */
#define DLT_PRONET	4	/* Proteon ProNET Token Ring */
#define DLT_CHAOS	5	/* Chaos */
#define DLT_IEEE802	6	/* IEEE 802 Networks */
#define DLT_ARCNET	7	/* ARCNET */
#define DLT_SLIP	8	/* Serial Line IP */
#define DLT_PPP		9	/* Point-to-point Protocol */
#define DLT_FDDI	10	/* FDDI */
#define DLT_ATM_RFC1483	11	/* LLC/SNAP encapsulated atm */
#define DLT_RAW		12	/* raw IP */
#define DLT_SLIP_BSDOS	13	/* BSD/OS Serial Line IP */
#define DLT_PPP_BSDOS	14	/* BSD/OS Point-to-point Protocol */

class CSaveCap 
{
private:
	pcap_t *ps;
#ifndef WIN32
	FILE *f;
#else
	HANDLE hFile, hFileMap;
	LPVOID lpvFile;
	DWORD dwFileSize;
	DWORD index;
	DWORD np;
#endif
	struct itemstruct* cItem;
	struct pcap_pkthdr hdr;
#ifndef WIN32
	int sf_write_header(FILE *fp, int linktype, int thiszone, int snaplen);
#else
	int sf_write_header(int linktype, int thiszone, int snaplen);
#endif
public:
#ifndef WIN32
	CSaveCap(struct itemstruct* i) {cItem=i;f=NULL;ps=NULL;}
	~CSaveCap(){if (ps) free(ps); if(f) fclose(f);}
	FILE* pcap_dump_open(FILE* f,int lt);
	FILE *pcap_dump_open(const char *fname,int lt=DLT_EN10MB);
#else
	CSaveCap(struct itemstruct* i) {cItem=i;ps=NULL;}
	~CSaveCap(){if (ps) free(ps);}
	BYTE *pcap_dump_open(const char *fname,int lt=DLT_EN10MB,int size=1000000);
	BYTE *pcap_dump_expand();
#endif
	void pcap_dump_close();
	int pcap_dump(struct itemstruct* i);
	int pcap_dump(const struct pcap_pkthdr *h, const u_char *sp);
};

#endif