// PacketD.cpp: implementation of the CPacketDescriber class.
//
//////////////////////////////////////////////////////////////////////

#include "packetd.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

#include "../../comuni/asksay.h"
#include "../../comuni/linecol.h"

#ifndef OPENSILENT
#define oerror errore
#else
#define oerror(A) return -1;
#endif

#ifndef ENGLISH
#define ERR_NF "Nome di file errato"
#define ERR_IN "Impossibile aprire il file sorgente"
#define ERR_FE "File errato"
#define ERR_NOPDF "Si deve aprire un file di descrizione dei protocolli"
#define ERR_FP "Il primo protocollo non  valido"
#define ERR_CMD "Errore nell'esecuzione dei comandi"
#define ERR_NP "Impossibile determinare il prossimo protocollo"
#define ERR_FPNV "Il primo protocollo non  valido"
#define ERR_NOVARS " [Nessuna variabile definita]"
#define ERR_NOPCK "Impossibile eseguire l'istruzione se non  disponibile un pacchetto"
#define ERR_VMVAR "Variabile della macchina virtuale non definita"
#else
#define ERR_NF "Bad file name"
#define ERR_IN "Unable to open source file"
#define ERR_FE "Bad file"
#define ERR_NOPDF "You must open a PDF file"
#define ERR_FP "Not valid first protocol"
#define ERR_CMD "Error executing commands"
#define ERR_NP "Unable to know next protocol"
#define ERR_FPNV "Invalid first protocol"
#define ERR_NOVARS " [No variable defined]"
#define ERR_NOPCK "Unable to execute instruction without a packet"
#define ERR_VMVAR "Virtual machine variable not defined"
#endif

int PushBits(stack<TSDWORD> &s, int par)
{
	int n=s.pop();
	int bs,be,t,tt,m=0;
	bs=par&0xFF;
	be=(par>>8)&0xFF;
	t=be-bs+1;
	for(tt=0;tt<t;tt++)
		m+=1<<tt;
	n>>=bs;
	n&=m;
	return n;
}

CPacketDescriber::CPacketDescriber()
{
	a.ist_number=I_PUSH_BITS;
	a.funzione=&PushBits;
	SetAddIn(&a,1);
	ncv=0;
	cv=NULL;
	mode=0;
	pg=NULL;
	firstPr=-1;
	curItem=NULL;
}

CPacketDescriber::~CPacketDescriber()
{
	if (pg) delete pg;
}

int CPacketDescriber::OpenDescription(const char * c)
{
	FILE* yyin;

	if (c==NULL) oerror(ERR_NF /*Nome di file errato*/);
	yyin=fopen(c,"rb");
	if (yyin==NULL) {oerror(ERR_IN /*Impossibile aprire il file sorgente*/);}
	int i;
	fread(&i,sizeof(int),1,yyin);
	if (i!=MAGIC_PDF) errore(ERR_FE /*File errato*/);
	fread(&Pdo_Time,sizeof(time_t),1,yyin);
	fread(&Pdo_Id,sizeof(int),1,yyin);
	fread(&np,sizeof(int),1,yyin);
	if (np<0) errore(ERR_FE /*File errato*/);
	for(i=0;i<np;i++)
	{
	  proto[i].Serialize(1,yyin);
	}
	if (yyin)fclose (yyin);
	CreateProtocolGraph();
	return 0;
}

int CPacketDescriber::ProcessPacket(LineCollection &lc,int i, item* cItem)
{
	TUBYTE * p=cItem->data;
	int len= cItem->size;
	int visit_n=1,ll;
	const TUBYTE* t=p;
	CCase* c;
	istruzione* ist;
	const char* ch;
	int startAnalysis;
	curItem=cItem;
	if(firstPr<0) startAnalysis=1; else startAnalysis=0;
	vm.SetLineCollection(&lc);
	vm.SetString(NULL);
	vm.SetPacketBytes(p,len,cItem);
	vm.SetPacketOffset(0);
	proto.ClearVisited();
	if(mode & ANALIZE) 
		vm.ExecuteProgram("MAIN");
	if(mode & DEBUG_ANALIZE)
		vm.DebugProgram("MAIN");
	vm.SetPacketOffset(0,proto[i].GetSize());
	SetProtoOffset(0);
	if (np<=0) {Say(ERR_NOPDF /*"Si deve aprire un file di descrizione dei protocolli*/); curItem=NULL; return 1;}
	if (i<0) {Say(ERR_FP /*Il primo protocollo non  valido*/); curItem=NULL; return 1;}
	int s=0,it,l=len;
	int skip,o=0;
	s=proto[i].GetSize();
	while (i>=0 && len-s>=0)
	{
		if (i==firstPr) startAnalysis=1;
		skip=0;
		proto[i].SetVisited(visit_n);
		visit_n++;
		int tmp;
		p_struct* p=proto[i].GetPS(tmp);
		vm.SetProtocolStruct(p,tmp);
		if(mode & ANALIZE)
		{
		 if (startAnalysis)
		 if (vm.ProtoExists(proto[i].GetName()))
			vm.ExecuteProgram(proto[i].GetName());
		 else
			proto[i].DumpProtocol(lc,t+o);
		}
		if(mode & DEBUG_ANALIZE)
		{
		 vm.DebugProgram(proto[i].GetName());
		}
		if(mode & DUMP)
		{
		 proto[i].DumpProtocol(lc,t+o);
		}
		if(mode & CREATE_VARS)
		{
		 for(ll=0;ll<ncv;ll++)
		  if(cv[ll]==i)
		   {proto[i].CalcolaCampi(t+o);break;}
		}
		int y;
		for(y=0;;y++)
		{
			c=proto[i].GetCase(y);
			if(!c) break;
			ist = c->GetCaseCode();
			if (!ist) {curItem=NULL; errore(ERR_CMD /*Errore nell'esecuzione dei comandi*/);}
			 it=ExecuteProgram(ist,t,o);
			if (it==0) {continue;i++;}
			ch=c->GetNextProtocol();
			if(strcmp(ch,"DATA")==0) 
			{
			    ist=proto[i].GetSkipCode();
				if(ist) skip=ExecuteProgram(ist,t,o);
				s+=skip; o+=s;
				proto[i].SetDataOffset(o);
				vm.SetPacketOffset(o,-1);
				SetProtoOffset(o);
				if(mode & ANALIZE) 
						vm.ExecuteProgram("DATA");
				if(mode & DEBUG_ANALIZE) vm.DebugProgram("DATA");
				goto fine;
			}
			for(it=0;it<np;it++) 
				if(strcmp(proto[it].GetName(),ch)==0) break;
			if(it<0 || it>=np) {curItem=NULL; errore(ERR_NP /*Impossibile determinare il prossimo protocollo*/);}
			 else 
			{	 
			    ist=proto[i].GetSkipCode();
				
				if(ist) skip=ExecuteProgram(ist,t,o);
				s+=skip;
				o+=s;
				proto[i].SetDataOffset(o);
				i=it;
				lastvisited=i;
				vm.SetPacketOffset(o,proto[i].GetSize());
				SetProtoOffset(o);
				len-=s;
				s=proto[i].GetSize();
				break;
			}		
		}
	}
fine:
	if(mode & DUMP_HEX)
	{
 	 DumpHex(lc,p,l);
	}
	curItem=NULL; 
	return 0;
}


void CPacketDescriber::SetMode(int i)
{
	mode=i;
}

int CPacketDescriber::GetMode()
{
	return mode;
}

int CPacketDescriber::CreateProtocolGraph()
{
	if (pg) delete pg;
	pg=new CProtocolGraph(proto);
	if (!pg) return 1;
	return 0;
}


void CPacketDescriber::SetCalcPr(const int * cvp, int ncvp)
{
	cv=cvp;
	ncv=ncvp;
}

int CPacketDescriber::ExaminePacket(int i, item * cItem)
{
	int om=mode;
	mode=CREATE_VARS;
	LineCollection lc(100,1000);
	ProcessPacket(lc,i,cItem);
	mode=om;
	return 0;
}

int CPacketDescriber::ShortProcessPacket(string & str, int i, item * cItem)
{
	TUBYTE * p=cItem->data;
	int len= cItem->size;
	int visit_n=1;
	const TUBYTE* t=p;
	CCase* c;
	istruzione* ist;
	const char* ch;
	int startAnalysis;
	curItem=cItem;
	if(firstPr<0) startAnalysis=1; else startAnalysis=0;
	ivm.SetLineCollection(NULL);
	ivm.SetString(&str);
	ivm.SetPacketBytes(p,len,cItem);
	ivm.SetPacketOffset(0);
	SetProtoOffset(0);
	proto.ClearVisited();
	ivm.ExecuteProgram("MAIN");
	if (np<=0) {curItem=NULL; Say(ERR_NOPDF /*Si deve aprire un file di descrizione dei protocolli*/); return 1;}
	if (i<0) {curItem=NULL; Say(ERR_FPNV /*Il primo protocollo non  valido*/); return 1;}
	int s=0,it,l=len;
	int skip,o=0;
	s=proto[i].GetSize();
	while (i>=0 && len-s>=0)
	{
		if (i==firstPr) startAnalysis=1;
		skip=0;
		proto[i].SetVisited(visit_n);
		visit_n++;
		if (startAnalysis)
		if(mode & ANALIZE)
		{
		 if (ivm.ProtoExists(proto[i].GetName()))
			 ivm.ExecuteProgram(proto[i].GetName());
		}
		int y;
		for(y=0;;y++)
		{
			c=proto[i].GetCase(y);
			if(!c) break;
			ist = c->GetCaseCode();
			if (!ist) {curItem=NULL; errore(ERR_CMD /*Errore nell'esecuzione dei comandi*/);}
			 it=ExecuteProgram(ist,t,o);
			if (it==0) {continue;i++;}
			ch=c->GetNextProtocol();
			if(strcmp(ch,"DATA")==0) 
			{
				goto fine;
			}
			for(it=0;it<np;it++) 
				if(strcmp(proto[it].GetName(),ch)==0) break;
			if(it<0 || it>=np) {curItem=NULL; errore(ERR_NP /*Impossibile determinare il prossimo protocollo*/);}
			 else 
			{	 
			    ist=proto[i].GetSkipCode();
				
				if(ist) skip=ExecuteProgram(ist,t,o);
				s+=skip;
				o+=s;
				proto[i].SetDataOffset(o);
				i=it;
				lastvisited=i;
				ivm.SetPacketOffset(o);
				SetProtoOffset(o);
				len-=s;
				s=proto[i].GetSize();
				break;
			}		
		}
	}
fine:
	curItem=NULL; 
	return 0;
}

int CPacketDescriber::GetProtos(LineCollection & lc,int v)
{
	lc.clear();
	int i,j,k,l;
	const char* c;
	for(i=0;i<np;i++)
	{
		if (!v && proto[i].GetVirt()) continue;
		c=proto[i].GetName();
		lc.insert("----- %s -----",c);
		if (!proto[i].GetVarNumber()) lc.insert1(ERR_NOVARS /* [Nessuna variabile definita]*/);
		else for(j=0;j<proto[i].GetVarNumber();j++)
			 {
				k=proto[i].GetVarSize(j);
				if (k)
				 lc.insert(" %s (%d BYTE)",proto[i].GetVarName(j),k);
				else
				 {
				  proto[i].GetOffset(j,k,l);
				  lc.insert("  %s (Start Bit %d - End Bit %d)",proto[i].GetVarName(j),k,l);
				 }
			 }
	}
	return 0;
}

int CPacketDescriber::SetFirstDumpProtocol(const char * c)
{
	if (c==NULL || c[0]=='\0') {firstPr=-1;return 0;}
	string s((char*)c);
	s.MakeUpper();
	int i;
	for(i=0;i<np;i++) 
		if (s==proto[i].GetName())
			{firstPr=i;return 0;}
	return 1;
}

int CPacketDescriber::GetProtosShort(LineCollection & lc,int v)
{
	lc.clear();
	int i;
	const char* c;
	for(i=0;i<np;i++)
	{
		if (!v && proto[i].GetVirt()) continue;
		c=proto[i].GetName();
		lc.insert1(c);
	}
	return 0;
}

int CPacketDescriber::GetFirstDumpProtocol(string & s)
{
	if (firstPr<0) s="";
	else s=proto[firstPr].GetName();
	return 0;
}

void CPacketDescriber::GetCalcPr(const int * & vars, int & n)
{
	vars=cv;
	n=ncv;
}

int CPacketDescriber::VExecuteAddIn(stack<TSDWORD> & s, istruzione * ist, const TUBYTE * c)
{
	if (ist->ist_number=I_GETVMVAR)
	{
		if (curItem==NULL) 
		{
			Say(ERR_NOPCK /*Impossibile eseguire l'istruzione se non  disponibile un pacchetto*/);
			return 1;
		}
		if (ist->p1==0) s.push(curItem->size);
		else if (ist->p1==1) s.push(curItem->truesize);
		else if (ist->p1==2) s.push(curItem->itemNr);
		else if (ist->p1==3) s.push(curItem->secs);
		else if (ist->p1==4) s.push(curItem->usecs);
		else if (ist->p1==5) s.push(curItem->written);
		else if (ist->p1==6) s.push(curItem->discarded);
		else if (ist->p1==7) s.push(curItem->type);
		else if (ist->p1==8) s.push(curItem->truesize-pckoffset);
		else if (ist->p1==9) s.push(pckoffset);
		else if (ist->p1==10) s.push(curItem->posIndicator);
		else {Say(ERR_VMVAR /*Variabile della macchina virtuale non definita*/);s.push(0);}
		return 0;
	}
	return 1;
}

