// PacketD.h: interface for the CPacketDescriber class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PACKETD_H__EF0F5D92_1BAB_11D2_941A_000000000000__INCLUDED_)
#define AFX_PACKETD_H__EF0F5D92_1BAB_11D2_941A_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "../vmachine.h"
#include "../../comuni/protocolvect.h"
#include "../packetd/packetd.h"
#include "../coded/codevm.h"
#include "../filed/lfreader.h"
#include "../../query/protocolgraph.h"

class LineCollection;

#define DUMP 1
#define INDEX 2
#define ANALIZE 4
#define DEBUG_ANALIZE 8
#define DUMP_HEX 16
#define CREATE_VARS 32

class CPacketDescriber : public CVMachine
{
public:
	void GetCalcPr(const int*&vars, int& n);
	int GetFirstDumpProtocol(string& s);
	int GetProtosShort(LineCollection & lc,int v);
	int SetFirstDumpProtocol(const char* c);
	int GetProtos(LineCollection& lc,int v);
	int ShortProcessPacket(string& s ,int i, item* cItem);
	int ExaminePacket(int i, item* cItem);
	void SetCalcPr(const int* cv, int ncv);
	int CreateProtocolGraph();
	int GetMode();
	void SetMode(int i);
	int GetLastVisitedProtocol(){return lastvisited;}
	AddIn a;
	int ProcessPacket(LineCollection &lc, int i,item* cItem);
	int OpenDescription(const char* c);
	CPacketDescriber();
	virtual ~CPacketDescriber();
	inline int OpenCode(const char* c) {return vm.OpenCode(c, Pdo_Time, Pdo_Id);};
	inline int OpenIndexCode(const char* c) {return ivm.OpenCode(c, Pdo_Time, Pdo_Id);};
	inline int IsVisitable(int start, const char * pr) 
	{if(pg) return pg->IsVisitable(start,pr);else return 0;}
	ProtocolVect proto;
	int VExecuteAddIn(stack<TSDWORD> & s, istruzione * ist, const TUBYTE * c);
	void SetProtoOffset(int o) {pckoffset=o;}
private:
	int Pdo_Id;
	int pckoffset;
	time_t Pdo_Time;
	int firstPr;
	int lastvisited;
	CProtocolGraph* pg;
	const int* cv;
	int ncv;
	int mode;
	item* curItem;
	CCodeVm vm;
	CCodeVm ivm;
	int np;
};

#endif // !defined(AFX_PACKETD_H__EF0F5D92_1BAB_11D2_941A_000000000000__INCLUDED_)
