// VMachine.cpp: implementation of the CVMachine class.
//
//////////////////////////////////////////////////////////////////////

#include "../comuni/stack_cl.h"
#include "../comuni/string_l.h"
#include "packetd/packetd.h"
#include "../comuni/linecol.h"
#include <limits.h>
#include "../comuni/asksay.h"

#ifndef ENGLISH
#define ERR_LFO "Errore nel processamento delle istruzioni dell'LFO"
#else
#define ERR_LFO "Error processing instructions in LFO file"
#endif
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVMachine::CVMachine()
{
	mustinvert=0x1234;
	if (*((TUBYTE*)(&mustinvert))==0x34) 
		mustinvert=1; 
	else
		mustinvert=0;
	addin=NULL;
	na=0;
}

CVMachine::~CVMachine()
{

}

TSDWORD CVMachine::ExecuteProgram(istruzione * ist, const TUBYTE * c,int o, int silent)
{
	stack<TSDWORD> s;
	TDWORD t,a,b;
	TUBYTE ch;
	TWORD sh;
	int h,y;
	unsigned int i;
	// Per non fare underflow
	s.push(0);
	// Processamento delle istruzioni
	for(index=0;ist[index].ist_number!=I_END;index++)
		{
		 switch (ist[index].ist_number)
		 {
		  case I_END:
			 y=s.n_max_el();
			 if(y>=0) return s.pop();
			 return 0;
		  case I_PUSH:
			 s.push(ist[index].p1);
			 break;
		  case I_POP:
			 s.pop();
			 break;
		  case I_PLUS:
			 s.push(s.pop()+s.pop());
			 break;
		  case I_MINUS:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 s.push(-s.pop()+s.pop());
			 break;
		  case I_MUL:
			 s.push(s.pop()*s.pop());
			 break;
		  case I_DIV:
			 a=s.pop();
			 b=s.pop();
			 if (b==0) s.push(INT_MAX);
			 else s.push(b/a);
			 break;
		  case I_MOD:
			 a=s.pop();
			 b=s.pop();
			 if (b==0) s.push(0);
			 else s.push(b%a);
			 break;
		  case I_AND:
			 s.push(s.pop() & s.pop());
			 break;
		  case I_OR:
			 s.push(s.pop()|s.pop());
			 break;
		  case I_UN_MINUS:
			 s.push(-s.pop());
			 break;
		  case I_NOT:
			 s.push(~s.pop());
			 break;
		  case I_EQUAL:
			 if(s.pop()==s.pop())s.push(0xFFFFFFFF);
			 else s.push(0);
			 break;
		  case I_NOT_EQUAL:
			 if(s.pop()!=s.pop())s.push(0xFFFFFFFF);
			 else s.push(0);
			 break;
		  case I_MIN_EQUAL:		
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 if(s.pop()>=s.pop())s.push(0xFFFFFFFF);
			 else s.push(0);
			 break;
		  case I_MAG_EQUAL:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 if(s.pop()<=s.pop())s.push(0xFFFFFFFF);
			 else s.push(0);
			 break;
		  case I_MIN:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 if(s.pop()>s.pop())s.push(0xFFFFFFFF);
			 else s.push(0);
			 break;
		  case I_MAG:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 if(s.pop()<s.pop())s.push(0xFFFFFFFF);
			 else s.push(0);
			 break;
		  case I_LSHIFT:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 a=s.pop();
			 b=s.pop();
			 s.push(b<<a);
			 break;
		  case I_RSHIFT:
			 // Attenzione i segni vanno rovesciati a causa dello stack
			 a=s.pop();
			 b=s.pop();
			 t=0;
			 for(i=0;i<32-a;i++) t+=1<<i;
			 s.push((b>>a)&t);
			 break;
		  case I_PUSH_BYTE:
			 if (c==NULL)  {s.push(0);break;}
			 ch=c[ist[index].p1+o];
			 t=ch&0xFF;
			 s.push(t);
			 break;
		  case I_PUSH_WORD:
			 if (c==NULL)  {s.push(0);break;}
			 if (mustinvert) sh=INV_WORD((void*)(c+ist[index].p1+o));
				else sh=*((TWORD*)(c+ist[index].p1+o));
			 t=sh&0xFFFF;
			 s.push(t);
			 break;
		  case I_PUSH_DWORD:
			 if (c==NULL)  {s.push(0);break;}
			 if (mustinvert) t=INV_DWORD((void*)(c+ist[index].p1+o));
				else t=*((TDWORD*)(c+ist[index].p1+o));
			 s.push(t);
			 break;
		  default:
			 h=na; 
			 if(addin)
				 for(h=0;h<na;h++)
				 {
					 if (addin+h==NULL) break;
					 if (addin[h].ist_number==ist[index].ist_number)
					 { s.push((*addin[h].funzione)(s,ist[index].p1)); break;}
				 }
			 if(h==na && !silent)
				 if(VExecuteAddIn(s,&(ist[index]), c))return 1;
			 else break;
		 }
		}
	y=s.n_max_el();
	if(y>=0) return s.pop();
	return 0;
}

TWORD CVMachine::INV_WORD(void* A)
{
	TWORD word; 
	((TUBYTE*)&word)[0]=((TUBYTE*)A)[1];
	((TUBYTE*)&word)[1]=((TUBYTE*)A)[0];
	return word;
}

TDWORD CVMachine::INV_DWORD(void* A)
{
	TDWORD word; 
	((TUBYTE*)&word)[0]=((TUBYTE*)A)[3];
	((TUBYTE*)&word)[1]=((TUBYTE*)A)[2];
	((TUBYTE*)&word)[2]=((TUBYTE*)A)[1];
	((TUBYTE*)&word)[3]=((TUBYTE*)A)[0];
	return word;
}


void CVMachine::SetAddIn(AddIn * a, int n)
{
	addin=a;
	na=n;
}

int CVMachine::VExecuteAddIn(stack<TSDWORD> &s,istruzione *ist, const TUBYTE * c)
{
	errore(ERR_LFO /*Errore nel processamento delle istruzioni dell'LFO*/);
	return 1;
}


void CVMachine::DumpHex(LineCollection & lc,const TUBYTE * v, int n)
{
	int i,n1,n2,l=0;
	char t[10];
	char c[2];
	string s;
	c[1]='\0';
	n1=n2=n;
	while(n1>0)
	{
		s.Empty();
		s += "* ";
		for (i=0;i<16&&n1>0;i++,n1--,l++)
		{
			if (i==4 || i==8 || i== 12) s+="| ";
			sprintf(t,"%02X ",(int)(v[l]&0xff)); s+=t;
		}
		l-=i;
		for (;i<16;i++)
		{
			if (i==4 || i==8 || i== 12) s+="| ";
			s+="   ";
		}
		s += "[";
		for (i=0;i<16&&n2>0;i++,n2--,l++)
			{
			 c[0]=v[l];
			 if (c[0]>=' ') s+=c; else s+=".";
			}
		s+="]";
		lc.insert("%s",(const char*) s);
	}
}
