// VMachine.h: interface for the CVMachine class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VMACHINE_H__BF784673_1ADF_11D2_9418_000000000000__INCLUDED_)
#define AFX_VMACHINE_H__BF784673_1ADF_11D2_9418_000000000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "../comuni/structs.h"
#include "../comuni/stack_cl.h"
#include "../comuni/linecol.h"
#include "../comuni/asksay.h"

#ifndef errore
#define errore(A) {Say(A); return 1;}
#endif

typedef int (*fz) (stack<TSDWORD> &, int);
typedef struct _AddIn
{
	int ist_number;
	fz funzione;
} AddIn;

class CVMachine  
{
public:
	void DumpHex(LineCollection& lc, const TUBYTE* v, int n);
	virtual int VExecuteAddIn(stack<TSDWORD> &,istruzione *ist, const TUBYTE * c);
	void SetAddIn(AddIn* a,int n);
	TSDWORD ExecuteProgram(istruzione *ist, const TUBYTE* c,int o=0, int silent=0);
	CVMachine();
	virtual ~CVMachine();

private:
	int na;
	AddIn* addin;
protected:
	int mustinvert;
	int index;
	TDWORD INV_DWORD(void*);
	TWORD INV_WORD(void*);
};

#endif // !defined(AFX_VMACHINE_H__BF784673_1ADF_11D2_9418_000000000000__INCLUDED_)
