//
// WinfingerPrint 2 Development Code
// vacuum@technotronic.com Mike@eEye.com
// 08/23/1999
// Console application
// Determines win32 OS version
// Enumerates NetBIOS Shares
// Enumerates Groups
// Uses lots of code from the MSDN samples.
// Link with : netapi32.lib, advapi32.lib, mpr.lib
// Thanks to Napster for helping debug the querygroup() and queryuser() functions 
// Thanks to _greg hoglund for CVS, suggestions, and bugfixes
 

#ifndef UNICODE
#define UNICODE
#endif
#include <stdio.h>
#include <windows.h> 
#include <lm.h>
#include <stdlib.h>
#include <iostream.h>
#include <memory.h>



void diskenum(FILE *,LPWSTR);
void querygroup(FILE *, LPTSTR);
void queryuser(FILE *, LPTSTR);
void queryservices(FILE *, LPTSTR);
void UnicodeToAnsi (wchar_t *, char *);
void DisplayUsage (char *);
void NullSession(LPTSTR);
void RegConnection(FILE*, LPTSTR);
unsigned short *getnetwork(DWORD);
int winfingerprint(FILE *, LPTSTR);

#define SZ_ENUM_BUF 4096 
#define VERSION "Winfingerprint 2.10"
// Uncomment to turn on DEBUGGING
// #define DEBUG

int wmain(int argc, wchar_t *argv[], char *newargv[])
{
   DWORD k = 1;
   LPTSTR pszServerName = NULL;
   char *filename;
   char opt;
   int i, j, ret, optdiskenum = 0, optquerygroup = 0, optqueryuser = 0, optqueryservices = 0, optnull = 0;
   int output = 0, optmass = 0, optservername = 0, optreg = 0;
   FILE *stream;
 
   // Fill another argv[] but we use this for getopt() 
   for(j = 0; j < argc; j++){
	   UnicodeToAnsi (argv[j], newargv[j]);
#ifdef DEBUG
   	   printf("--- [#%d : Original Argv[] = %S, NewArgv[] = %s] \n", j, argv[j], newargv[j]);
#endif
	}

   if (argc <= 1) DisplayUsage(newargv[0]);

   for(i = 1; i < argc; i++){
		if((strncmp(newargv[i], "-", 1) == 0) || (strncmp(newargv[i], "/", 1) == 0)){
#ifdef DEBUG
	   printf("After strncmp() we have: %s\n", newargv[i]); 
#endif
		newargv[i] += 1;
        opt = (char)newargv[i][0];

#ifdef DEBUG
	   printf("The opt for the switch is: %c\n", opt);
#endif

				switch(opt){
			case 'A': // We do all.
			case 'a':
			   optdiskenum = 1;
			   optquerygroup = 1;
			   optqueryuser = 1;
			   optqueryservices = 1;
			   optreg = 1;
			   optnull = 1;
			   break;
			case 'D': // Enumerate NetBIOS Shares.
			case 'd':
               optdiskenum = 1;
			   break;
			case 'S': // Enumerate Services.
			case 's':
				optqueryservices = 1;
		        break;
			case 'M':  // 'Network Neighborhood' Scan
			case 'm':
				optmass = 1;
                break;
            case 'N':  // Creates Null Session
            case 'n':
				optnull = 1;
				break;
			case 'O':  // HTML Output filename
			case 'o':
				output = 1;
				filename = newargv[i +1];
				break;
            case 'R':  // Registry Manipulation
            case 'r':
				optreg = 1;
				break;
			case 'T': // Computer name is here.
			case 't':
				if(argv[i + 1] != NULL)
				pszServerName = argv[i + 1];
				optservername = 1;
				break;
			case 'U': // Enumerate Users.
			case 'u':
				 optqueryuser = 1;
                break;
			case 'G': // Enumerate Groups.
			case 'g':
				optquerygroup = 1;
	   	        break;
			case 'H': // Show usage.
			case 'h':
				DisplayUsage(newargv[0]);
			    break;
			case '?': // Show usage.
				DisplayUsage(newargv[0]);
     	    	break;  
			default: // We do all.
                optdiskenum = 1;
			    optquerygroup = 1;
			    optqueryuser = 1;
			    optqueryservices = 1;
				optreg = 1;
				optnull = 1;
				break;
			} 
		}
	}
   
   printf("%s by vacuum@technotronic.com & Mike@eEye.com 1999\n\n", VERSION);
   
   if((optmass) && (optservername))
	   fprintf(stderr, "You specified a 'Network Neighboorhood' scan and a Computername.\nPlease choose one or the other.\n"), exit(1);
   
   if(optnull && !optmass && !optservername)
		fprintf(stderr, "You specified a 'Null Session' scan and did not choose a mass scan or a Servername.\nPlease choose one and try again.\n"), exit(1);
   
   if(!output)
	   filename = "winfingerprint.html";
  
   if( (stream = fopen(filename, "w" )) == NULL ) 
			printf( "The file 'winfingerprint.html' was not opened\n" ), exit(1);
   
	 
   
     fprintf(stream, "<HTML>\n<HEAD>\n<TITLE>%s output</TITLE>\n</HEAD>\n<BODY>\n", VERSION);
     fprintf(stream,"<CENTER><a href=\"http://www.technotronic.com/winfingerprint/\"><IMG border=0 alt=\"%s\"SRC = \"winfingerprint.jpg\"></a><BR>\n", VERSION);
     fprintf(stream, "by <A HREF = \"mailto:vacuum@technotronic.com\">vacuum@technotronic.com</A></CENTER>\n");
     fprintf(stream, "<a href=\"aboutwinfingerprint.html\">About %s</a><BR>\n", VERSION);

     printf("Enumerating Available Servers, Please wait ...\n");
	 
	 if(optmass){
        while((pszServerName = getnetwork(k)) != NULL)
		{
         ret=winfingerprint(stream, pszServerName);
		 if(ret != 5){
			 // An error occured.
			 if(ret) break;

             // Get on with the show.
			 if(optnull) NullSession(pszServerName);
			 if(optreg) RegConnection(stream, pszServerName);
			 if(optdiskenum) diskenum(stream,pszServerName);
			 if(optquerygroup) querygroup(stream,pszServerName);
			 if(optqueryuser) queryuser(stream,pszServerName);
			 if(optqueryservices) queryservices(stream,pszServerName);
			 
			 
			 
		 }
		 k++;
		}
	 }
	 else{
         ret=winfingerprint(stream, pszServerName);
         // An error occured
	   if(ret != 5){
		 if(ret) fclose(stream), exit(1);
         if(optnull) NullSession(pszServerName);
		 if(optreg) RegConnection(stream, pszServerName);
	     if(optdiskenum) diskenum(stream,pszServerName);
	     if(optquerygroup) querygroup(stream,pszServerName);
         if(optqueryuser) queryuser(stream,pszServerName);
	     if(optqueryservices) queryservices(stream,pszServerName);
         
		 }
	 }
	 
      // All complete.
	  printf("done.\n\n");

   	  printf("Open '%s' in your favorite web browser to view results.\n\n", filename);
      printf("%s by vacuum@technotronic.com & Mike@eEye.com 1999\n", VERSION);
	  
	  fprintf(stream,"</BODY>\n</HTML>\n");
	  fclose(stream);

   return 0;
}

void diskenum(FILE *stream2,LPWSTR computername)
{
   PSHARE_INFO_502 BufPtr,p;
   NET_API_STATUS res;
   DWORD i;
   LPVOID lpMsgBuf;
   DWORD entriesread=0, resume_handle=0, totalentries=0;
   fprintf(stream2,"<TABLE BORDER=1>\n");
   // Added so it prints the ComputerName not UNC name. Aesthetics.
   // Found out it would die if ONLY -d was called. It is because 
   // we set it to do computername + 2 for aesthetics. Therefore, here is the If() to fix it.
   if(computername == NULL)
      fprintf(stream2,"<TR><TD><B>Shares:</B></TD><TD><B>Local Path:</B></TD><TD><B>Uses:</B></TD><TD><B>Descriptor:</B></TD></TR>\n");
   else
      fprintf(stream2,"<TR><TD><B>%S's Shares:</B></TD><TD><B>Local Path:</B></TD><TD><B>Uses:</B></TD><TD><B>Descriptor:</B></TD></TR>\n", computername + 2);
   
   do 
   {
      res = NetShareEnum(computername,      
						 502,                    
						 (LPBYTE *) &BufPtr,      
						 0xFFFFFFFF,     
						 &entriesread,  
						 &totalentries,  
						 &resume_handle);
 
	  if(res == ERROR_SUCCESS || res == ERROR_MORE_DATA)
      {
         p=BufPtr;
         for(i=1;i<=entriesread;i++)
         {
            fprintf(stream2,"<TR><TD>%-20S</TD><TD>%-30S</TD><TD>%-8u</TD>",p->shi502_netname, p->shi502_path, p->shi502_current_uses);
            
			if (IsValidSecurityDescriptor(p->shi502_security_descriptor)){
               fprintf(stream2,"<TD>Yes</TD></TR>\n");
			}
            else{
				fprintf(stream2,"<TD>No</TD></TR>\n");
			}

            p++;
         }
         NetApiBufferFree(BufPtr);
      }
      else {  
	  
			FormatMessage(     FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL );
			fprintf(stream2,"<TR><TD>Share Enumeration Error: %S </B></TD></TR>\n" ,(LPCTSTR)lpMsgBuf);
			fprintf(stderr,"Share Enumeration Error (%S):\n %S\n" ,GetLastError(),(LPCTSTR)lpMsgBuf);
			LocalFree( lpMsgBuf );
		    return;
	
			}
   }
   
   while (res==ERROR_MORE_DATA);
   fprintf(stream2,"</TABLE>");
   
}

void querygroup(FILE *stream3, LPTSTR szServer)
 {
   PNET_DISPLAY_GROUP pBuff, p; 
   DWORD res, dwRec, i = 0;
   LPVOID lpMsgBuf;
#ifdef DEBUG
       printf("querygroup(), szServer: [%S]\n", szServer);
#endif
   do 
   {  
      res = NetQueryDisplayInformation(szServer, 3, i, 1000, 25, &dwRec, (PVOID *)&pBuff); 
        
	   if((res==ERROR_SUCCESS) || (res==ERROR_MORE_DATA))
	  { 
#ifdef DEBUG
	   printf("dwRec(%d), NET_DISPLAY_GROUP(%d)\n", dwRec, sizeof(NET_DISPLAY_GROUP));
#endif
	   p = pBuff;
		 for(;dwRec>0;dwRec--)
		 
		 { 
			fprintf(stream3,"Name:      %S<BR>\n"
				  "Comment:   %S<BR>\n" 
                  "Group ID:  %u<BR>\n"
				  "Attributes: %u<BR>\n" 
                  "<HR>\n", 
                  p->grpi3_name,
				  p->grpi3_comment, 
                  p->grpi3_group_id,
				  p->grpi3_attributes);
				  
            i = p->grpi3_next_index;  //if there is more then set the index 
            p++;
	  }
		 NetApiBufferFree(pBuff);
	  } 
      else{
          if((res==ERROR_SUCCESS) || (res==ERROR_MORE_DATA))
		  FormatMessage(     FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL );
			fprintf(stream3,"Group Enumeration Error:(%u)\n %S\n" ,res,(LPCTSTR)lpMsgBuf);
			fprintf(stderr,"Group Enumeration Error:(%u)\n %S\n" ,res,(LPCTSTR)lpMsgBuf);
			LocalFree( lpMsgBuf );
		  break;
	  }
   }
   while (res==ERROR_MORE_DATA);

} 

void queryuser(FILE *stream4, LPTSTR szServer)
 {
   PNET_DISPLAY_USER pBuff, p; 
   DWORD res, dwRec, i = 0;
   LPVOID lpMsgBuf;
#ifdef DEBUG
       printf("queryuser(), szServer: [%S]\n", szServer);
#endif
   do 
   {  
      res = NetQueryDisplayInformation(szServer, 1, i, 1000, 1000*sizeof(NET_DISPLAY_USER), &dwRec, (PVOID *)&pBuff); 
      if((res==ERROR_SUCCESS) || (res==ERROR_MORE_DATA))
	  { 
#ifdef DEBUG
	   printf("dwRec(%d), NET_DISPLAY_USER(%d)\n", dwRec, sizeof(NET_DISPLAY_USER));
#endif
		 p = pBuff;
		 for(;dwRec>0;dwRec--)
		 
		 { 
			fprintf(stream4,
			          "Name:      %S<BR>\n"
				  "Comment:   %S<BR>\n" 
                                  "FullName:  %S<BR>\n"
				  "User Id: %u<BR>\n"
				  "<HR>\n", 
                  		  p->usri1_name, 
		  		  p->usri1_comment, 
                  		  p->usri1_full_name,
				  p->usri1_user_id); 
			
                         if (p->usri1_flags & UF_SCRIPT) 
                fprintf(stream4,"(The logon script executed. This value must be set for LAN Manager 2.0 or Windows NT.)<BR>\n");
			 
			 if (p->usri1_flags & UF_ACCOUNTDISABLE) 
                fprintf(stream4,"(The user's account is disabled.)<BR>\n");
		        
		   	 if (p->usri1_flags & UF_HOMEDIR_REQUIRED) 
                fprintf(stream4,"(The home directory is required. Windows NT ignores this value.)<BR>\n");
			 
			 if (p->usri1_flags & UF_PASSWD_NOTREQD) 
                fprintf(stream4,"(No password is required.)<BR>\n");
			 
			 if (p->usri1_flags & UF_PASSWD_CANT_CHANGE ) 
                fprintf(stream4,"(The user cannot change the password.)<BR>\n");
			 
			 if (p->usri1_flags & UF_LOCKOUT) 
                fprintf(stream4,"(The Account is Locked)<BR>\n");
			 
			 if (p->usri1_flags & UF_DONT_EXPIRE_PASSWD) 
                fprintf(stream4,"(Password does not expire)<BR>\n");
			 
			 fprintf(stream4,"<HR>\n");

            i = p->usri1_next_index;  //if there is more then set the index 
            p++;
	  }
		 NetApiBufferFree(pBuff);
	  } 
      else{
		  	FormatMessage(     FORMAT_MESSAGE_ALLOCATE_BUFFER | 
			FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL );
			fprintf(stream4,"User Enumeration Error:(%u)\n %S\n",res,(LPCTSTR)lpMsgBuf);
			fprintf(stderr, "User Enumeration Error:(%u)\n %S\n" ,res,(LPCTSTR)lpMsgBuf);
			LocalFree( lpMsgBuf );
		  break;
	  }
   }
   while (res==ERROR_MORE_DATA);

}

void queryservices(FILE *stream5, LPTSTR szServer)

{
	SC_HANDLE scm;
	BOOL success;
	LPENUM_SERVICE_STATUS status;
	DWORD numServices=0, sizeNeeded=0, resume=0;

	// Open a connection to the SCM
	scm = OpenSCManager(szServer, 0,
		SC_MANAGER_ALL_ACCESS);
	if (!scm)

    printf("Error with OpenSCManager\n");

	// get the number of bytes to allocate
	// MAKE SURE resume starts at 0
	resume = 0;
	success = EnumServicesStatus(scm, 
		SERVICE_WIN32 | SERVICE_DRIVER,
		SERVICE_ACTIVE | SERVICE_INACTIVE,
		0, 0, &sizeNeeded, &numServices, &resume);
	if (GetLastError() != ERROR_MORE_DATA)
    printf("Error with EnumServicesStatus\n");

	// Allocate space
	status = (LPENUM_SERVICE_STATUS)
		LocalAlloc(LPTR, sizeNeeded);
#ifdef DEBUG
	   printf("sizeNeeded(%d)\n", LocalAlloc(LPTR, sizeNeeded));
#endif
	// Get the status records. Making an assumption
	// here that no new services get added during
	// the allocation (could lock the database to
	// guarantee that...)
	resume = 0;
	success = EnumServicesStatus(scm, 
		SERVICE_WIN32 | SERVICE_DRIVER,
		SERVICE_ACTIVE,
		status, sizeNeeded, &sizeNeeded,
			&numServices, &resume);
	if (!success)
#ifdef DEBUG
	   fprintf(stderr, "In EnumServicesStatus: %d", GetLastError());
#else
       printf("Error with EnumServicesStatus\n");
#endif
	DWORD i;
fprintf(stream5,"<B>\nServices:</B><BR>\n");
	for (i=0; i < numServices; i++)

fprintf(stream5,"%d %S %S<BR>\n",i,status[i].lpServiceName,status[i].lpDisplayName);

	
	// Clean up
	LocalFree(status);
	CloseServiceHandle(scm);
}

void UnicodeToAnsi (wchar_t *wcs, char *mbs)
{
  if (wcs)
    wcstombs (mbs, wcs, (wcslen (wcs) + 1) * sizeof (WCHAR));
  else
    *mbs = '\0';
}

int winfingerprint(FILE *stream, LPTSTR pszServerName){
   DWORD dwLevel = 101;
   LPSERVER_INFO_101 pBuf = NULL;
   NET_API_STATUS nStatus;
   LPVOID lpMsgBuf;
   
   nStatus = NetServerGetInfo(pszServerName,
                              dwLevel,
                              (LPBYTE *)&pBuf);
	 
   
   if (nStatus == NERR_Success)
   {
      fprintf(stream,"<HR>\n");
			fprintf(stream, "Platform: %d<BR>\n", pBuf->sv101_platform_id);
			fprintf(stream, "Name:    <B>%S</B><BR>\n", pBuf->sv101_name);
			fprintf(stream, "Version:  %d.%d<BR>\n", pBuf->sv101_version_major, pBuf->sv101_version_minor); 
            fprintf(stream, "Type:     %d<BR>\n", pBuf->sv101_type); 
            fprintf(stream, "Comment: %S<BR>\n", pBuf->sv101_comment);

      if (pBuf->sv101_type & SV_TYPE_DOMAIN_CTRL)
		  fprintf(stream,"%S is a PDC.<BR>", pBuf->sv101_name);
	  else if (pBuf->sv101_type & SV_TYPE_DOMAIN_BAKCTRL)
		  fprintf(stream,"%S is a BDC.<BR>", pBuf->sv101_name);
      else if (pBuf->sv101_type & SV_TYPE_SERVER_NT )
		  fprintf(stream,"%S is a NT MEMBER SERVER.<BR>",pBuf->sv101_name);
      else if (pBuf->sv101_type &  SV_TYPE_NT )
  		  fprintf(stream,"%S is a NT WORKSTATION.<BR>",pBuf->sv101_name);
  	  else if (pBuf->sv101_type & SV_TYPE_SQLSERVER)
	      fprintf(stream,"%S is running SQL.<BR>",pBuf->sv101_name);
      else if (pBuf->sv101_type &  SV_TYPE_NOVELL )
		  fprintf(stream,"%S is a Novell Netware Server.<BR>",pBuf->sv101_name);
	  else if (pBuf->sv101_type & SV_TYPE_WFW )
		  fprintf(stream,"%S is Windows for Workgroups.<BR>",pBuf->sv101_name);
      else if (pBuf->sv101_type &  SV_TYPE_WINDOWS )
		  fprintf(stream,"%S is running Windows 9x.<BR>",pBuf->sv101_name);
	  
   }
   
   else{ 
      
       FormatMessage(     FORMAT_MESSAGE_ALLOCATE_BUFFER | 
	  		FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
			NULL,
			GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf,
			0,
			NULL );
	        fprintf(stream,"User Enumeration Error %d: %S\n" ,nStatus, (LPCTSTR)lpMsgBuf);
        	fprintf(stderr, "User Enumeration Error %d: %S\n" ,nStatus, (LPCTSTR)lpMsgBuf);
			LocalFree(lpMsgBuf ); 
	         
		if (pBuf != NULL)
          NetApiBufferFree(pBuf);
	   return 1;
   }

      if (pBuf->sv101_type & (SV_TYPE_NOVELL | SV_TYPE_WFW | SV_TYPE_WINDOWS)){
      fprintf(stream,"Not running Group/User Enumeration. Machine does not support it.<BR>");
	  // I picked 5 because 5 is cool.
	  return 5; 
   }
   if (pBuf != NULL)
      NetApiBufferFree(pBuf);
return 0;
}

unsigned short *getnetwork(DWORD i){
	HANDLE enumHandle;
	LPNETRESOURCE buffer;
	DWORD bufferSize = 16384, numEntries = 0xFFFFFFFF;
	DWORD result, resultEnum;
    
	buffer = (LPNETRESOURCE) GlobalAlloc( GPTR, bufferSize);
	
	result = WNetOpenEnum(
		RESOURCE_CONTEXT,		// scope of enumeration
		RESOURCETYPE_ANY,		// resource types to list
		0,						// resource usage to list
		NULL,					// pointer to resource structure
		&enumHandle);			// pointer to enumeration handle buffer
	
	if (result != NO_ERROR)
	{
		printf("WNetOpenEnum Error: %d\n",result);
	}


    resultEnum = WNetEnumResource(
		enumHandle,				// handle to enumeration
		&numEntries,			// pointer to entries to list
		buffer,				    // pointer to buffer for results
		&bufferSize);			// pointer to buffer size variable

		if (resultEnum == NO_ERROR)
		{

			for(i; i < numEntries; i++)
				{
					if( buffer[i].dwDisplayType == RESOURCEDISPLAYTYPE_SERVER)
						{
							printf("Enumerating [%S]\n", buffer[i].lpRemoteName + 2);
							return (buffer[i].lpRemoteName);
						}
				}
		}
		else if (resultEnum != ERROR_NO_MORE_ITEMS)
			printf("WNetEnumResource Error: %d\n", resultEnum);
		

	while (resultEnum != ERROR_NO_MORE_ITEMS);

	GlobalFree((HGLOBAL) buffer);
    result = WNetCloseEnum(enumHandle);
	if (result != NO_ERROR)
		printf("WNetCloseEnum ERROR: %d\n",result);

return NULL;
}


void NullSession(LPTSTR Server)
{
	LPCWSTR szIpc = L"\\IPC$"; 
    WCHAR RemoteResource[UNCLEN + 5 + 1]; // UNC len + \IPC$ + NULL 
    DWORD cchServer; 

	NET_API_STATUS nas; 
    NETRESOURCE     nr;
	
	cchServer = lstrlenW( Server );  
    if(Server[0] != L'\\' && Server[1] != L'\\') {
		// 
        // prepend slashes and NULL terminate
		//  
        RemoteResource[0] = L'\\';
		RemoteResource[1] = L'\\'; 
        RemoteResource[2] = L'\0';
	}
	else
	{ 
        cchServer -= 2; // drop slashes from count  
        RemoteResource[0] = L'\0';
	}
	if(cchServer > CNLEN)
	{ 
        SetLastError(ERROR_INVALID_COMPUTERNAME);
		printf("Error in Null Session Routine\n");
	}  
    if(lstrcatW(RemoteResource, Server) == NULL) printf("Error in Null Session Routine\n");
    if(lstrcatW(RemoteResource, szIpc) == NULL) printf("Error in Null Session Routine\n");

   nr.dwType    = RESOURCETYPE_ANY;
   nr.lpLocalName       = NULL;
   nr.lpProvider        = NULL;
   nr.lpRemoteName = (LPTSTR) RemoteResource;
   
   
   nas = WNetAddConnection2(&nr, (LPTSTR) L"", (LPTSTR) L"", 0);
   if( nas == NERR_Success )
   printf("Null IPC$ Session Established [%S].\n",Server +2);
   else
	   printf("Null Session NOT Established Error: %d.\n", nas);
       
}

void RegConnection(FILE *stream2, LPTSTR szServer)
{
LONG result;
HKEY hKey, phkResult;
DWORD dwType; 
WCHAR lpData[MAX_PATH];
DWORD dwBufLen;
TCHAR lpName[256]; 
DWORD lpcbName = 256; 
FILETIME time;
int index ; 

    
 
     


		result = RegConnectRegistry(szServer,        // address of name of remote computer
								HKEY_LOCAL_MACHINE,  // predefined registry handle
								&hKey);              // address of buffer for remote registry handle
		if (result != ERROR_SUCCESS)
		{
			printf("RegConnectRegistry ERROR: %d\n",result);
			return;

		}
		else printf("Registry Connected [%S]\n", szServer);
		
		result = RegOpenKeyEx(hKey,                  // handle to open key
   L"Software\\Microsoft\\Windows NT\\CurrentVersion",// address of name of subkey to open
							  0,                     // reserved
					          KEY_QUERY_VALUE,        // security access mask
                              &phkResult);           // address of handle to open key

		if (result != ERROR_SUCCESS)
		{
			printf("RegOpenKeyEx ERROR: %d\n",result);
			return;

		}


        result = RegQueryValueEx(phkResult,          // handle to key to query
                                 L"CSDVersion",      // address of name of value to query
								 NULL,               // reserved
								 &dwType,            // address of buffer for value type
                                 (LPBYTE) lpData,    // address of data buffer
                                 &dwBufLen);         // address of data buffer size

		if (result != ERROR_SUCCESS)
		{
			printf("RegQueryValueEx ERROR: %d\n",result);
			return;
			

		}
		else 
		{
		// 	printf("[%S] %S\n",szServer, lpData);
			fprintf(stream2, "<p>[%S] <b>%S</b>\n",szServer, lpData);
		}
             
 RegCloseKey(hKey);

 fprintf(stream2, "<BR>Hotfixes Applied:<BR>\n");

 	result = RegConnectRegistry(szServer,            // address of name of remote computer
								HKEY_LOCAL_MACHINE,  // predefined registry handle
								&hKey);              // address of buffer for remote registry handle
		if (result != ERROR_SUCCESS)
		{
			printf("RegConnectRegistry ERROR: %d\n",result);
			return;

		}
		else printf("Registry Connected [%S]\n", szServer);
		
		result = RegOpenKeyEx(hKey,                  // handle to open key
   L"Software\\Microsoft\\Windows NT\\CurrentVersion\\Hotfix",// address of name of subkey to open
							  0,                     // reserved
					          KEY_ENUMERATE_SUB_KEYS,// security access mask
                              &phkResult);           // address of handle to open key

		if (result == ERROR_SUCCESS)
		{
		index = 0;
		lpcbName = sizeof(lpName);
		
		result = RegEnumKeyEx(
                 phkResult,          // handle to key to enumerate
				 index,              // index of subkey to enumerate
                 lpName,             // address of buffer for subkey name
                 &lpcbName,          // address for size of subkey buffer
				 NULL,               // reserved
				 NULL,               // address of buffer for class string
				 NULL,               // address for size of class buffer
                 &time);
   
			//while (result != ERROR_NO_MORE_ITEMS)
	    for(index = 0; result != ERROR_NO_MORE_ITEMS; index++)
		{
				
				
				lpcbName = sizeof(lpName);
		result = RegEnumKeyEx(
                 phkResult,          // handle to key to enumerate
				 index,              // index of subkey to enumerate
                 lpName,             // address of buffer for subkey name
                 &lpcbName,          // address for size of subkey buffer
				 NULL,               // reserved
				 NULL,               // address of buffer for class string
				 NULL,               // address for size of class buffer
                 &time);

				fprintf(stream2, "[%S]<BR>\n",lpName); 
			}
		}
	RegCloseKey(hKey);
	fprintf(stream2, "<BR><BR>\n"); 


}

void DisplayUsage (char *arg)
{
	printf("%s vacuum@technotronic.com & Mike@eEye.com\n\n", VERSION);
    printf("Usage: %s [-t \\\\COMPUTERNAME] [-a -d -g -m -n -r -s -u -h]\n", arg);
	printf("NOTE: If no server is supplied (e.g., No '-t') localhost is used.\n", arg);
	printf(" -a Enumerates NetBIOS Shares, Users, Groups, and Services\n");
    printf(" -d Enumerates Shares\n");
	printf(" -g Enumerates Groups\n");
	printf(" -m Scan entire 'Network Neighborhood'\n");
	printf(" -n Establishes Null Session\n");
	printf(" -r Registry Querying\n");
	printf(" -s Enumerates Services\n");
	printf(" -u Enumerates Users\n");
	printf(" -o Output filename 'e.g. myscan.html'\n");
	printf(" -h Shows Usage\n");
	exit(1);
}


