#ifndef __IF_LOADED
#define __IF_LOADED 1
/****************************************************************************
**
**  <if.h> - Structures providing a packet transport mechanism
**
*****************************************************************************
**  Header is nonstandard
*****************************************************************************
**
**  Copyright Digital Equipment Corporation 1993, 1995. All rights reserved.
**
**  Restricted Rights: Use, duplication, or disclosure by the U.S.
**  Government is subject to restrictions as set forth in subparagraph
**  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
**  52.227-14 Alt. III, as applicable.
**
**  This software is proprietary to and embodies the confidential
**  technology of Digital Equipment Corporation. Possession, use, or
**  copying of this software and media is authorized only pursuant to a
**  valid written license from Digital or an authorized sublicensor.
**
******************************************************************************
**
**  Copyright (c) 1982, 1993 Regents of the University of California.
**  All rights reserved.  The Berkeley software License Agreement
**  specifies the terms and conditions for redistribution.
**
**      if.h             8.1 (Berkeley) 6/10/93
**
******************************************************************************
*/

/*
**  All includes of other header files must be done prior to altering the
**  pointer size mode.
*/
#include <socket.h>


#pragma __nostandard
#ifdef __cplusplus
    extern "C" {
#endif


/*
**  Ensure that regardless of user /pointer_size usage, we begin processing
**  using a 32 bit pointer context.
*/
#if __INITIAL_POINTER_SIZE
#   if (__VMS_VER < 70000000) || !defined __ALPHA
#      error " Pointer size usage not permitted before OpenVMS Alpha V7.0"
#   endif
#   pragma __pointer_size __save
#   pragma __pointer_size 32
#endif


/*
**  All structures should be member aligned on natural boundaries
*/
#pragma __member_alignment __save
#pragma __member_alignment


/*
**  External model of relaxed refdef
*/
#pragma __extern_model __save
#pragma __extern_model __relaxed_refdef


/*
**  Public typedefs
*/
#ifndef ____U_INT
#   define ____U_INT
    typedef unsigned int __u_int;
#endif

#if !defined __U_INT && !defined _DECC_V4_SOURCE
#   define __U_INT
    typedef unsigned int u_int;
#endif


/*
**  Structures defining a network interface, providing a packet transport
**  mechanism (ala level 0 of the PUP protocols).
**
**  Each interface accepts output datagrams of a specified maximum length,
**  and provides higher level routines with input datagrams received from
**  its medium.
**
**  Output occurs when the routine if_output is called, with three
**  parameters:  (*ifp->if_output)(ifp, m, dst, rt)
**
**  Here m is the mbuf chain to be sent and dst is the destination address.
**  The output routine encapsulates the supplied datagram if necessary,
**  and then transmits it on its medium.
**
**  On input, each interface unwraps the data received by it, and either
**  places it on the input queue of a internetwork datagram routine and
**  posts the associated software interrupt, or passes the datagram to a
**  raw packet input routine.
**
**  Routines exist for locating interfaces by their addresses or for
**  locating a interface on a certain network, as well as more general
**  routing and gateway routines maintaining information used to locate
**  interfaces.  These routines live in the files if.c and route.c
*/
#define IFA_ROUTE RTF_UP  /* route installed */


/*
**  Interface request structure used for socket ioctl's.  All interface
**  ioctl's must have parameter definitions which begin with ifr_name.  The
**  remainder may be interface specific.
*/
#define IFNAMSIZ 16

struct ifreq {
    char ifr_name[IFNAMSIZ];            /* if name, e.g. "en0"      */
    union {
	struct sockaddr ifru_addr;      /* address                  */
	struct sockaddr ifru_dstaddr;   /* other end of p-to-p link */
	struct sockaddr ifru_broadaddr; /* broadcast address        */
	int ifru_flags;                 /* flags                    */
	int ifru_metric;                /* metric                   */
	caddr_t ifru_data;              /* for use by interface     */
	int ifru_value;                 /* for use by interface     */
    } ifr_ifru;
};

#define ifr_addr      ifr_ifru.ifru_addr
#define ifr_dstaddr   ifr_ifru.ifru_dstaddr
#define ifr_broadaddr ifr_ifru.ifru_broadaddr
#define ifr_flags     ifr_ifru.ifru_flags
#define ifr_metric    ifr_ifru.ifru_metric
#define ifr_data      ifr_ifru.ifru_data
#define ifr_value     ifr_ifru.ifru_value


/*
**  Structure used to query de and qe for physical addresses
*/
struct ifdevea {
    char ifr_name[IFNAMSIZ];            /* if name, e.g. "en0"      */
    u_char default_pa[6];               /* default hardware address */
    u_char current_pa[6];               /* current physical address */
};

struct ifaliasreq {
    char ifra_name[IFNAMSIZ];           /* if name, e.g. "en0"      */
    struct sockaddr ifra_addr;
    struct sockaddr ifra_broadaddr;
    struct sockaddr ifra_mask;
};


/*
**  Structure used in SIOCGIFCONF request.  Used to retrieve interface
**  configuration for machine (useful for programs which must know all
**  networks accessible).
*/
struct ifconf {
    int ifc_len;                        /* size of associated buffer    */
    union {
	caddr_t ifcu_buf;               /* buffer address               */
	struct ifreq *ifcu_req;         /* array of structures returned */
    } ifc_ifcu;
};

#define ifc_buf ifc_ifcu.ifcu_buf 
#define ifc_req ifc_ifcu.ifcu_req


/*
**  Structure for EEPROM downline upgrades. (Supported by FDDI adapter
*/
struct ifeeprom {
    char ife_name[IFNAMSIZ];	/* if name, e.g. "fza0"         */
    u_char ife_data[64];        /* block of EEPROM data         */
    __u_int ife_offset;         /* byte offset from base        */
    __u_int ife_blklen;         /* len of EEPROM block          */
    __u_int ife_lastblk;	/* True if last block           */
};

#define IFE_NOTLAST     0x0     /* Intermediary block of EEPROM image      */
#define IFE_LASTBLOCK   0x1     /* Last block of EEPROM image              */
#define IFE_SUCCESS     0x0     /* Block of EEPROM successfully written    */
#define IFE_RETRY       0x1     /* Retry last block written                */
#define IFE_FAIL        0x2     /* Fail entire EEPROM image write sequence */


/*
**  Structure for set adapter's characteristics
*/
struct ifchar {
    char ifc_name[IFNAMSIZ];
    __u_int ifc_treq;
    __u_int ifc_tvx;
    __u_int ifc_lem;
    __u_int ifc_rtoken;
    __u_int ifc_ring_purger;
    __u_int ifc_cnt_interval;	   /* Not applicable to DEFZA */
    u_short ifc_full_duplex_mode;  /* Not applicable to DEFZA */
};

#define FDX_ENB 1
#define FDX_DIS 2


/*
**  Restore the users pointer context
*/
#if __INITIAL_POINTER_SIZE
#   pragma __pointer_size __restore
#endif

#ifdef __cplusplus
    }
#endif

#pragma __member_alignment __restore
#pragma __extern_model __restore
#pragma __standard
#endif  /* __IF_LOADED  */
