#ifndef __DIRENT_LOADED
#define __DIRENT_LOADED 1
/* MODIFIED FOR USE WITH SAMBA. NO VERSION CHECK. MORE CHANGES
 * E. Meyer, 27-Sep-1996 */
/* #if __VMS_VER >= 70000000  /****  Supported starting with OpenVMS V7.0  ****/
/****************************************************************************
**
**  <dirent.h> - Directory manipulation functions
**
*****************************************************************************
**  Header introduced by the ISO POSIX-1 Standard
*****************************************************************************
**
**  Copyright Digital Equipment Corporation 1993, 1995. All rights reserved.
**
**  Restricted Rights: Use, duplication, or disclosure by the U.S.
**  Government is subject to restrictions as set forth in subparagraph
**  (c) (1) (ii) of DFARS 252.227-7013, or in FAR 52.227-19, or in FAR
**  52.227-14 Alt. III, as applicable.
**
**  This software is proprietary to and embodies the confidential
**  technology of Digital Equipment Corporation. Possession, use, or
**  copying of this software and media is authorized only pursuant to a
**  valid written license from Digital or an authorized sublicensor.
**
******************************************************************************
*/

#pragma __nostandard

/*
** Set up feature test macros
*/
# if defined _XOPEN_SOURCE_EXTENDED && !defined _XOPEN_SOURCE
#   define _XOPEN_SOURCE
# endif

# if defined _XOPEN_SOURCE && _POSIX_C_SOURCE < 2
#   undef  _POSIX_C_SOURCE
#   define _POSIX_C_SOURCE      2
# endif

# if defined _POSIX_SOURCE && _POSIX_C_SOURCE < 1
#   undef  _POSIX_C_SOURCE	    /* _POSIX_SOURCE obsolete.   */
#   define _POSIX_C_SOURCE	1   /* #define _POSIX_C_SOURCE 1 instead */
# endif

# if defined _POSIX_C_SOURCE && !defined _ANSI_C_SOURCE
#   define _ANSI_C_SOURCE
# endif 

# if defined __HIDE_FORBIDDEN_NAMES && !defined _ANSI_C_SOURCE
#   define _ANSI_C_SOURCE
# endif


#ifdef __cplusplus
    extern "C" {
#endif


/*
**  Ensure that regardless of user /pointer_size usage, we begin processing
**  using a 32 bit pointer context.
*/
#if __INITIAL_POINTER_SIZE
#   if (__VMS_VER < 70000000) || !defined __ALPHA
#      error " Pointer size usage not permitted before OpenVMS Alpha V7.0"
#   endif
#   pragma __pointer_size __save
#   pragma __pointer_size 32
#endif


/*
**  All structures should be member aligned on natural boundaries
*/
#pragma __member_alignment __save
#pragma __member_alignment

#if 0	/* IfN/Mey - don't define ino_t - not needed */
#if defined _XOPEN_SOURCE || !defined _POSIX_C_SOURCE
#   ifndef ____INO_T 
#	define ____INO_T 1
	typedef unsigned short __ino_t;
#   endif

#   ifndef  __INO_T 
#	define __INO_T 1
	typedef __ino_t ino_t;
#   endif
#endif
#endif

/*
**  Data structure returned by readdir() function.  This structure
**  contains the minimum information specified by XPG4.
*/
#if defined _XOPEN_SOURCE || !defined _POSIX_C_SOURCE
    struct dirent {
	char d_name[256]; 	    /* File name (always less than NAME_MAX) */
#if 0	/* IfN/Mey - don't define ino_t - not needed */
	ino_t d_ino[3];		    /* IFI (vms-style inode) */
#endif
    };
#else
    struct dirent {
	char d_name[256];	/* File name (always less than NAME_MAX) */
    };
#endif


/*
**  Data structure returned by opendir() function.  A pointer to one of
**  these is returned by opendir() and is used by the the other routines.
**  The contents of this structure do not have to be visible to users.
*/
#ifndef __DIR
#   define __DIR 1
    typedef struct _dirdesc DIR;
#endif


/*
**  Define a private typedef used to indicate a short pointer to a DIR
**  structure which is always returned by the CRTL.
*/
#ifndef __DIR_PTR32
#   define __DIR_PTR32 1
    typedef DIR * __DIR_ptr32;
#endif

#ifndef __STRUCT_DIRENT_PTR32
#   define __STRUCT_DIRENT_PTR32 1
    typedef struct dirent * __struct_dirent_ptr32;
#endif


/*
**  The only pointer permitted to be a 64 bit pointer is the name of the 
**  directory being opened.  All structure pointers are pointers to DEC
**  C RTL allocated memory.  We will define a 64 bit character pointer to
**  be used in the function prototypes.
*/
#if __INITIAL_POINTER_SIZE
#   pragma __pointer_size 64
#endif


/*
**  Function prototypes
*/
__DIR_ptr32 opendir (const char *dirname);
__struct_dirent_ptr32 readdir (DIR * dirp);

void  rewinddir (DIR *dirp);
int   closedir  (DIR *dirp);


/*
**  X/Open extensions
*/
#if defined _XOPEN_SOURCE || !defined _POSIX_C_SOURCE
    void      seekdir   (DIR *dirp, long int loc);
    long int  telldir   (DIR *dirp);
#endif


/*
**  Restore the users pointer context
*/
#if __INITIAL_POINTER_SIZE
#   pragma __pointer_size __restore
#endif

#ifdef __cplusplus
    }
#endif
#pragma __member_alignment __restore
#pragma __standard
/* #endif /* __VMS_VER       */
#endif /* __DIRENT_LOADED */
