/* 
   Unix SMB/Netbios implementation.
   Version 1.9.
   Copyright (C) Andrew Tridgell 1994-1997

   This file is part of the port to OpenVMS
   VMS specific definitions, part 2
   Copyright (C) Eckart Meyer 1996-1997
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*	vms2.h
 *
 * includes, some additional prototypes and other misc stuff
 */

#include <arpa/inet.h>
#include <fcntl.h>
#include <dirent.h>
#include <string.h>
#include <unistd.h>
#include <sys/vfs.h>

#if __VMS_VER < 70000000
int strcasecmp(char * __s, char * __t);
#endif
int statfs(char * __path, struct statfs * __buf);
char *crypt(char * __key, char * __salt);
char *mktemp(char * __buf);
/* int gettimeofday(struct timeval * __tv, struct timezone * __timezone); /**/
int gettimeofday(struct timeval * __tv, void * __timezone); /**/
int chroot(char * __path);
int getopt(int __argc, char * const __argv[], const char * __optstring); 
int initgroups(char * __name, gid_t __basegid);
int setgroups(int __ngroups, gid_t __gidset[]);

int vms_process_exists(int pid);
#define SIGNAL_CAST (void (*)(int))
#ifndef bzero
#define bzero(a,n)    memset(a,0,n)
#endif
#define chroot chdir	/* don't know how to implement chroot ... */
#define NOSTRDUP

/* socket definitions */

#define setsockopt vms_setsockopt
int vms_setsockopt (int __sd, int __level, int __optname, const char * __optval, 
			int __optlen);
int vms_socket (int __af, int __mess_type, int __prot_type);
#define SELECT_CAST (int *)
#define TCP_NODELAY 1	/* test this ! */

/* definitions for VMS file name mangling */

char *VMSMakeFilename(char * __vms_buf, char * __file_spec);
char *vms_make_name(char * __name);
char *vms_get_name(char * __name);
#define chdir(__path) chdir(vms_make_name(__path))
#define chmod(__name, __mode) chmod(VMSMakeFilename(NULL,__name), __mode)
#define fopen(__path, __mode) fopen(vms_make_name(__path), __mode)

/* strerror crashes with unknown error codes - it does not know 'vms-error'!
   also, older C RTL versions don't know about ENOTEMPTY */
#ifndef ENOTEMPTY
#define ENOTEMPTY 66
#endif
#define strerror(__errno) ( (__errno == EVMSERR) ? "VMS error" : ( \
		(__errno == ENOTEMPTY) ? "Directory not empty" : \
		strerror(__errno)) )

#define NOSTRCASECMP
#define NO_STRFTIME	/* strftime is obviously not working */
#define NO_GET_BROADCAST
#define NO_GETSPNAM
#define NO_EID
#define USE_WAITPID
#define USE_GETCWD
#define USE_SETSID
#define USE_SYSTEM 1			/* in UID.C for smbrun */
#define NO_FORK_DEBUG			/* server.c and util.c */
#define FTRUNCATE_CAN_EXTEND 1		/* util.c */

