5'  Syntax10.Scn.Fnt      8  FoldElems New  ?  Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  @     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc            
AVL trees with string as key.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 8   
    8        8       8   m   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt                      7        
       
	Key=string.StringPtr;
	NodePtr*=POINTER TO Node;
	Node*=RECORD (persistent.Object)
		key*:Key;
		left,right:NodePtr;
		balance:Balance;
	END;
	TreePtr*=NodePtr; 8      Syntax10b.Scn.Fnt      6    8   #   Syntax10.Scn.Fnt  3    3   

	Read in an avl tree or subtree.
	
	Time: O(n).

 8       8   7   8               8   #   Syntax10.Scn.Fnt  1    1   

	Write an avl tree or subtree.
	
	Time: O(n).

 8       8   #   Syntax10.Scn.Fnt  %   %  
BEGIN
	(*
		Write elements of superclass, by using its read method.
	*)
	node.write^(rider);
	(*
		Write own elements.
	*)
	Files.WriteString(rider,node.key^);
	Files.WriteNum(rider,node.balance);
	persistent.writeObject(rider,node.left);
	persistent.writeObject(rider,node.right);
END write; 8   /    8   #   Syntax10.Scn.Fnt       
VAR
	rightNode:NodePtr;
	rightLeftNode:NodePtr;
BEGIN
	rightNode:=node.right;
	rightLeftNode:=rightNode.left;
	rightNode.left:=rightLeftNode.right;
	rightLeftNode.right:=rightNode;
	node.right:=rightLeftNode.left;
	rightLeftNode.left:=node;
	IF rightLeftNode.balance=leftHeavier THEN node.balance:=rightHeavier; ELSE node.balance:=balanced; END;
	IF rightLeftNode.balance=rightHeavier THEN rightNode.balance:=leftHeavier; ELSE rightNode.balance:=balanced; END;
	node:=rightLeftNode;
	node.balance:=balanced;
END doubleRLRotation; 8   /    8   #   Syntax10.Scn.Fnt       
VAR
	leftNode:NodePtr;
	leftRightNode:NodePtr;
BEGIN
	leftNode:=node.left;
	leftRightNode:=leftNode.right;
	leftNode.right:=leftRightNode.left;
	leftRightNode.left:=leftNode;
	node.left:=leftRightNode.right;
	leftRightNode.right:=node;
	IF leftRightNode.balance=rightHeavier THEN node.balance:=leftHeavier; ELSE node.balance:=balanced; END;
	IF leftRightNode.balance=leftHeavier THEN leftNode.balance:=rightHeavier; ELSE leftNode.balance:=balanced; END;
	node:=leftRightNode;
	node.balance:=balanced;
END doubleLRRotation; 8       8   #   Syntax10.Scn.Fnt         

	mayInsert indicates, if a value should be inserted (TRUE) when it is not found. When FALSE, it indicates,
	that one only wishes to search for the value.
	
	Time: O(log n)
	Space: O(log n)

 8       k8     Syntax10.Scn.Fnt      8  FoldElems New  #   Syntax10.Scn.Fnt  .    .   
	node1:NodePtr;
	result:string.CompareResult; 8   0   58   #   Syntax10.Scn.Fnt       search2(node.left,newNode,nodeFound,gainedWeight,mayInsert);
			IF gainedWeight THEN
				CASE node.balance OF	(* depending on old weight *)
				| rightHeavier:	(* didn't increase our weight *)
					node.balance:=balanced; gainedWeight:=FALSE;
				| balanced:	(* our weight increased *)
					node.balance:=leftHeavier;
				| leftHeavier:	(* We can't let the heavier side become more heavier. *)
					node1:=node.left;
					IF node1.balance=leftHeavier THEN
						node.left:=node1.right;
						node1.right:=node;
						node.balance:=balanced;
						node:=node1;
					ELSE
						doubleLRRotation(node);
					END;
					node.balance:=balanced;
					gainedWeight:=FALSE;
				END;
			END; 8   '    8   #   Syntax10.Scn.Fnt       search2(node.right,newNode,nodeFound,gainedWeight,mayInsert);
			IF gainedWeight THEN
				CASE node.balance OF
				| leftHeavier:
					node.balance:=balanced; gainedWeight:=FALSE;
				| balanced:
					node.balance:=rightHeavier;
				| rightHeavier:
					node1:=node.right;
					IF node1.balance=rightHeavier THEN
						node.right:=node1.left;
						node1.left:=node;
						node.balance:=balanced;
						node:=node1;
					ELSE
						doubleRLRotation(node);
					END;
					node.balance:=balanced;
					gainedWeight:=FALSE;
				END;
			END; 8   6      
VAR
BEGIN
	gainedWeight:=FALSE;
	IF node=NIL THEN
		IF mayInsert THEN
			gainedWeight:=TRUE;
			newNode.left:=NIL;
			newNode.right:=NIL;
			newNode.balance:=balanced;
			node:=newNode;
		ELSE
			nodeFound:=NIL;
		END;
	ELSE
		result:=string.compare(newNode.key^,node.key^);
		IF result=string.less THEN
			
		ELSIF result=string.greater THEN
			
		ELSE
			nodeFound:=node;
		END;
	END;	
END search2; 8           $    8   #   Syntax10.Scn.Fnt  $    $   

	Time: O(log n)
	Space: O(log n)

 8       }8   #   Syntax10.Scn.Fnt  a    a   
VAR
	dummy:BOOLEAN;
	dummyNode:NodePtr;
BEGIN
	search2(tree,node,dummyNode,dummy,TRUE);
END add; 8           7    8   #   Syntax10.Scn.Fnt  $    $   

	Time: O(log n)
	Space: O(log n)

 8       D8   #   Syntax10.Scn.Fnt         
VAR
	dummy:BOOLEAN;
	newNode:NodePtr;
BEGIN
	NEW(newNode);
	string.dup(newNode.key,key);
	node:=NIL;
	search2(tree,newNode,node,dummy,FALSE);
END search; 8               8   #   Syntax10.Scn.Fnt           

	Time: O(n)
	Space: O(log n)

 8       q8   #   Syntax10.Scn.Fnt  m    m   
BEGIN
	IF tree#NIL THEN
		dump(tree.left);
		Log.Str(tree.key^); Log.Ln;
		dump(tree.right);
	END;
END dump; 8   I    8   #   Syntax10.Scn.Fnt  $    $   

	Time: O(log n)
	Space: O(log n)

 8       E8     Syntax10.Scn.Fnt      8  FoldElems New  #   Syntax10.Scn.Fnt  5    5   
	nodeToDelete:NodePtr;
	result:string.CompareResult; 8   D    s8   #   Syntax10.Scn.Fnt  k   k  
	VAR
		node1:NodePtr;
		balance1:Balance;
	BEGIN
		CASE node.balance OF
		| leftHeavier:
			node.balance:=balanced;
		| balanced:
			node.balance:=rightHeavier;
			lostWeight:=FALSE;
		| rightHeavier:
			node1:=node.right;
			balance1:=node1.balance;
			IF balance1=leftHeavier THEN	(* needs double rotation *)
				doubleRLRotation(node);
			ELSE
				node.right:=node1.left;
				node1.left:=node;
				IF balance1=balanced THEN node.balance:=rightHeavier; node1.balance:=leftHeavier; lostWeight:=FALSE;
				ELSE node.balance:=balanced; node1.balance:=balanced;
				END;
				node:=node1;
			END;
		END;
	END balanceLeft; 8   E    r8   #   Syntax10.Scn.Fnt  l   l  
	VAR
		node1:NodePtr;
		balance1:Balance;
	BEGIN
		CASE node.balance OF
		| rightHeavier:
			node.balance:=balanced;
		| balanced:
			node.balance:=leftHeavier;
			lostWeight:=FALSE;
		| leftHeavier:
			node1:=node.left;
			balance1:=node1.balance;
			IF balance1=rightHeavier THEN	(* needs double rotation *)
				doubleLRRotation(node);
			ELSE
				node.left:=node1.right;
				node1.right:=node;
				IF balance1=balanced THEN node.balance:=leftHeavier; node1.balance:=rightHeavier; lostWeight:=FALSE;
				ELSE node.balance:=balanced; node1.balance:=balanced;
				END;
				node:=node1;
			END;
		END;
	END balanceRight; 8   <    %8   #   Syntax10.Scn.Fnt       
	VAR
		balance:Balance;
		left,right:NodePtr;
	BEGIN
		IF node.right#NIL THEN
			del(node.right,lostWeight);
			IF lostWeight THEN balanceRight(node,lostWeight); END;
		ELSE
			balance:=nodeToDelete.balance;
			left:=nodeToDelete.left;
			right:=nodeToDelete.right;
			nodeToDelete^:=node^;
			nodeToDelete.balance:=balance;
			nodeToDelete.left:=left;
			nodeToDelete.right:=right;
			node:=node.left;
			lostWeight:=TRUE;
		END;
	END del; 8        
VAR
	
	PROCEDURE balanceLeft(VAR node:NodePtr; VAR lostWeight:BOOLEAN);
	
	PROCEDURE balanceRight(VAR node:NodePtr; VAR lostWeight:BOOLEAN);
	
	PROCEDURE del(VAR node:NodePtr; VAR lostWeight:BOOLEAN);
	
BEGIN
	IF node=NIL THEN
		lostWeight:=FALSE;
	ELSE
		result:=string.compare(key^,node.key^); 
		IF result=string.less THEN
			delete2(key,node.left,lostWeight);
			IF lostWeight THEN balanceLeft(node,lostWeight); END;
		ELSIF result=string.greater THEN
			delete2(key,node.right,lostWeight);
			IF lostWeight THEN balanceRight(node,lostWeight); END;
		ELSE
			nodeToDelete:=node;
			IF nodeToDelete.right=NIL THEN
				node:=nodeToDelete.left;
				lostWeight:=TRUE;
			ELSIF nodeToDelete.left=NIL THEN
				node:=nodeToDelete.right;
				lostWeight:=TRUE;
			ELSE
				del(nodeToDelete.left,lostWeight);
				IF lostWeight THEN balanceLeft(node,lostWeight); END;
			END;
			nodeToDelete:=NIL;
		END;
	END;	
END delete2; 8               8   #   Syntax10.Scn.Fnt  $    $   

	Time: O(log n)
	Space: O(log n)

 8       8   #   Syntax10.Scn.Fnt  @    @   
VAR
	dummy:BOOLEAN;
BEGIN
	delete2(key,tree,dummy);
END delete; 8         MODULE avlString; (**)

IMPORT
	Files,Log
	,persistent,string;
	
(*enum: Balance=(leftHeavier,balanced,rightHeavier); *)
TYPE
	Balance=SHORTINT;
CONST
	leftHeavier=0;
	balanced=1;
	rightHeavier=2;

TYPE

PROCEDURE (node:NodePtr) read*(VAR rider:Files.Rider; VAR err:persistent.Error); (**)
VAR
	temp:LONGINT;
	tempString:ARRAY 256 OF CHAR;
BEGIN
	(*
		Read in elements of superclass, by using its read method.
	*)
	node.read^(rider,err);
	IF err=persistent.none THEN
		(*
			Read in own elements.
		*)
		Files.ReadString(rider,tempString);
		string.dup(node.key,tempString);
		Files.ReadNum(rider,temp); node.balance:=SHORT(SHORT(temp));
		IF err=persistent.none THEN persistent.readObject(rider,node.left(persistent.ObjectPtr),err); END;
		IF err=persistent.none THEN persistent.readObject(rider,node.right(persistent.ObjectPtr),err); END;
	END;
END read;

PROCEDURE (node:NodePtr) write*(VAR rider:Files.Rider); (**)

PROCEDURE doubleRLRotation(VAR node:NodePtr);

PROCEDURE doubleLRRotation(VAR node:NodePtr);

PROCEDURE search2(
	VAR node:NodePtr; newNode:NodePtr; VAR nodeFound:NodePtr; VAR gainedWeight:BOOLEAN; mayInsert:BOOLEAN
);(**)

PROCEDURE add*(VAR tree:TreePtr; node:NodePtr);(**)

PROCEDURE search*(tree:TreePtr; key:string.String; VAR node:NodePtr);(**)

PROCEDURE dump*(tree:TreePtr);(**)

PROCEDURE delete2(key:Key; VAR node:NodePtr; VAR lostWeight:BOOLEAN);(**)

PROCEDURE delete*(VAR tree:TreePtr; key:Key);(**)

END avlString.