
  Syntax10.Scn.Fnt      8  FoldElems New       Z   StyleElems Alloc   Paragraph  P     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc      /   8   
    8   #   Syntax10.Scn.Fnt         
	Display
	,list; 8       p8   #   Syntax10.Scn.Fnt  n    n   
	totalHeight:INTEGER;
	totalWidth:INTEGER;
	usedHeight:INTEGER;
	usedWidth:INTEGER;
	bitmapList:list.ListPtr; 8       8   \   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt  	   Courier10.Scn.Fnt             
	BitmapPtr*=POINTER TO Bitmap;
	Bitmap=RECORD (list.Node)
		width:INTEGER;
		height:INTEGER;
		allocatedWidth:INTEGER;
		allocatedHeight:INTEGER;
		x:INTEGER;
		y:INTEGER;
	END; 8      Syntax10b.Scn.Fnt     Courier10.Scn.Fnt          8   #   Syntax10.Scn.Fnt  P    P   

	Copy the bitmap to the display, so that the lower left corner
	is at (x,y).

 8       8   #   Syntax10.Scn.Fnt  Y    Y   
BEGIN
	Display.CopyBlock(src.x,src.y,src.width,src.height,x,y,Display.replace);
END put; 8           6    W8   #   Syntax10.Scn.Fnt         

	Copy the rectangle on the display with itslower left corner at (x,y)
	and which is w pixel width and h pixel height to the bitmap.

 8       8   #   Syntax10.Scn.Fnt         
BEGIN
	ASSERT(width<=dst.allocatedWidth);
	ASSERT(height<=dst.allocatedHeight);
	Display.CopyBlock(x,y,width,height,dst.x,dst.y,Display.replace);
	dst.width:=width;
	dst.height:=height;
END get; 8           0    i8   #   Syntax10.Scn.Fnt  u    u   

	Allocate a bitmap with given width and height. Returns NIL if the bitmap
	couldn't been allocated.
	
	Time: O(1)

 8       8   #   Syntax10.Scn.Fnt  	   	  
BEGIN
	IF width<totalWidth-usedWidth THEN
			NEW(bitmap);
			bitmap.x:=usedWidth;
			bitmap.y:=-height;
			INC(usedWidth,width);
	ELSIF height<ABS(totalHeight-usedHeight) THEN
		IF width<totalWidth THEN
			NEW(bitmap);
			bitmap.x:=0;
			bitmap.y:=usedHeight-height;
			DEC(usedHeight,height);
		ELSE
			bitmap:=NIL;
		END;
	ELSE
		bitmap:=NIL;
	END;
	IF bitmap#NIL THEN
		bitmap.allocatedWidth:=width;
		bitmap.allocatedHeight:=height;
		bitmap.width:=0;
		bitmap.height:=0;
		bitmapList.addTail(bitmap);
	END;
END new; 8               >8   #   Syntax10.Scn.Fnt         

	Free the bitmap. This should really be triggered by the garbage
	collector, I hope modify this in the future.
	
	Time: O(n). n=number of allocated bitmaps.

 8       h8   #   Syntax10.Scn.Fnt  v   v  
VAR
	node:list.NodePtr;
	right:INTEGER;
BEGIN
	bitmap.remove();
	(* compact *)
	usedWidth:=0;
	usedHeight:=0;
	node:=bitmapList.next;
	WHILE node#bitmapList DO
		WITH node:BitmapPtr DO
			right:=node.x+node.width;
			IF right>usedWidth THEN usedWidth:=right; END;
			IF node.y<usedHeight THEN usedHeight:=node.y; END;
		END;
		node:=node.next;
	END;
	bitmap:=NIL;
END free; 8       ^8   #   Syntax10.Scn.Fnt         
	usedWidth:=0; usedHeight:=0;
	totalWidth:=Display.Width;
	totalHeight:=Display.UBottom;
	NEW(bitmapList);
	bitmapList.init();
 8       d  MODULE bitmap; (*
Manage multiple bitmaps on secondary display.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	When I wrote my menu module, I needed to save and later restore the display area covered by the menu. The bitmap modules
	I've seen so far, allowed only one single concurrent save at any time, because multiple save would overwrite each other.
	
	This module manages the resource "secondary display" and allows you to allocate several regions of it. This allows you to save
	several display regions simultaneously. The allocation mechanism is very simple, so it is possible, that it doesn't find a free 
	region although there would be enough unused room.
	
*)

IMPORT

VAR
	
TYPE

PROCEDURE put*(src:BitmapPtr; x,y:INTEGER);(**)

PROCEDURE get*(dst:BitmapPtr; x,y:INTEGER; width,height:INTEGER);(**)

PROCEDURE new*(VAR bitmap:BitmapPtr; width,height:INTEGER);(**)

PROCEDURE free*(VAR bitmap:BitmapPtr);(**)

BEGINEND bitmap.