U  Syntax10.Scn.Fnt      a8  FoldElems New    Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  7     Z     Paragraph       Z     Paragraph       Z     Paragraph      ^  ParcElems Alloc      4  Syntax10i.Scn.Fnt                 Syntax14.Scn.Fnt  0   Syntax10b.Scn.Fnt     Courier8.Scn.Fnt  co     Courier10.Scn.Fnt      
                            
        @[s          
                                ^       k   ^  u       ^       |    ^  u      ^           ~  PopupElems Alloc Buch #   Syntax10.Scn.Fnt  [   [  buch.postcard 1 0 
buch.visa 1 0 
buch.geldVonPost 1 0 100.00 
buch.geldVonPost 1 0 200.00 
buch.geldVonPost 1 0 
buch.telefon 1 0 
buch.eMail 1 0 
__________________________________________________________
buch.lohn 0 3 
__________________________________________________________
buch.report 
buch.showKonto 1 
buch.showKonto 2 
buch.showKonto 3    Syntax16b.Scn.Fnt  
        s              
                    
                s     #և         
                                
    s     ࡎ         
    ,        ,        *                 ^       .   
    X   s         
Private bookkeeping.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

When I wrote this program, I didn't think of distributing it, so it contains comments and procedure names which are partly in german. I hope you will understand anyway how it works.

I use this program to keep track of my money. The accounts and the payments and incomes are defined in a Text file named BuchYear.Text. Year is the parameter given to buch.open, which opens the file and positions the cursor at the end.

E.g. buch.open 1996 will open Buch1996.Text.

This is what a bookkeeping file should look like:

Private "Buchhaltung" von Claudio Nieder

1996

Konti

  1	Account 1	   1267.28
  2	Account two	   7685.65
  3	A third account	   4958.30

Buchungen

0103	Some payment	 1	 0	  352.40
0103	Another payment	 1	 0	   50.00
0108	Transfer account 1 to 3	 1	 3	  210.00
0108	Some income	 0	 2	 5000.00

Important is, that there are the words "Konti" and "Buchungen" to introduce the two sections with te account definitions and the bookings. It is also important, that before the word "Konti" there is somewhere a number specifying the year.

The account section consists of lines having each three fields separated by a single tabulator character. The fields are:

1. An account number . The first line has to have number 1, the second number 2 etc.
2. An account description. Whatever you want.
3. The initial ammount of the account.

The bookings sections consists of lines having each five fields separated by a single tabulator character. The fields are:

1.	Date written as MMDD where MM is the month number and DD is the day number. The first line in above example refers to the third january.
2.	Booking description. Whatever you want.
3.	The account from which the money is taken. 0 is used for "the outside world", which I when I get some income.
4.	The account to which the money goes. 0 is used for "the outside world", which I use when I spend the money.
5.	The money transferred.

You simply type in bookings by hand. To facilitate your work, you can write procedures as the one found at the end named geldVonPost etc. You can put a popup like this  into your menu definition (Buch.Menu.Text) which will have these command in it. So you can generate complete or partial entries simply with the mouse.

The most important command then is buch.report, which has to be called from the menubar. It will generate a report from the bookings, which contains, the initial state of the accounts, all bookings and the final state of each account. So you can always know, how much money is in each account. The report from above example would look like this:

Report 1996


Konti am 1. Januar 1996

  1	Account 1	   1267.28
  2	Account two	   7685.65
  3	A third account	   4958.30

	Total	  13911.23

Buchungen

 3.01.	Some payment	 1	 0	   352.40
 3.01.	Another payment	 1	 0	    50.00
 8.01.	Transfer account 1 to 3	 1	 3	   210.00
 8.01.	Some income	 0	 2	  5000.00

Endstand

  1	Account 1	    654.88	(  3.5%)	   -612.40	(-48.3%)
  2	Account two	  12685.65	( 68.5%)	   5000.00	( 65.1%)
  3	A third account	   5168.30	( 27.9%)	    210.00	(  4.2%)

	Total	  18508.83		   4597.60	( 33.0%)

It shows you for each account the final ammount, the percentage this account contributes to your whole posessions and the aboslute and relative change to the initial value. It also gives you the total amount of all accounts, and the absolute and relative change from the inital total.
 
buch.showKonto accountNumber will produce a report with just the states and bookings of a single account. This is useful, when you see, that your final value for an account does not match with e.g. what your bank tells you have on that account. By having a "filtered" record, you can more easily compare, if all your bookings match the records you receive from the bank.

 8   
    8   #   Syntax10.Scn.Fnt  ?    ?   
	arguments,Fonts,Log,Oberon,string,TextFrames,Texts,Viewers,w; 8       8   #   Syntax10.Scn.Fnt  #    #   
	alpha=0; number=1; real=2; eot=3; 8       8   #   Syntax10.Scn.Fnt  I   I  
	Konto=RECORD
		num:LONGINT;
		item:ARRAY 80 OF CHAR;
		value:LONGREAL;
	END;
	Buchung=RECORD
		date:LONGINT;
		item:ARRAY 80 OF CHAR;
		from,to:LONGINT;
		value:LONGREAL;
	END;
	Scanner=RECORD (Texts.Reader)
		nextCh:CHAR;
		class:SHORTINT;
		num:LONGINT;
		float: LONGREAL;
(*
		len:SHORTINT;
*)
		str:ARRAY 256 OF CHAR;
	END; 8   z    8   #   Syntax10.Scn.Fnt  R    R   
BEGIN
	Texts.OpenReader(scanner,text,pos);
	scanner.nextCh:=" ";
END openScanner; 8   &    }8   /  Syntax10.Scn.Fnt      8  FoldElems New  #   Syntax10.Scn.Fnt  8    8   
	ch:CHAR;
	digit:LONGREAL;
	i:SHORTINT;
	mult:LONGREAL; 8      8   #   Syntax10.Scn.Fnt  #   #  
				IF ('0'<=ch) & (ch<='9') THEN
					scanner.num:=ORD(ch)-ORD('0')+scanner.num*10;
					digit:=ORD(ch)-ORD('0');
					scanner.float:=scanner.float*10.0D0;
					scanner.float:=scanner.float+digit;
				ELSIF ch='.' THEN
					scanner.class:=real;
				ELSE
					scanner.class:=alpha;
				END; 8       8   #   Syntax10.Scn.Fnt         
				IF ('0'<=ch) & (ch<='9') THEN
					digit:=ORD(ch)-ORD('0');
					digit:=digit*mult;
					scanner.float:=scanner.float+digit;
					mult:=mult*0.1D0;
				ELSE
					scanner.class:=alpha;
				END; 8       U  
VAR
BEGIN
	ch:=scanner.nextCh;
	WHILE ((ch=' ') OR (ch=1CX) OR (ch=w.cr)) & (~scanner.eot) DO
		Texts.Read(scanner,ch);
	END;
	IF scanner.eot THEN
		scanner.class:=eot;
	ELSE
		scanner.num:=0;
		scanner.float:=0.0D0;
		scanner.class:=number;
		mult:=0.1D0;
		i:=0;
		WHILE (~scanner.eot) & (ch#",") & (ch#w.tab) & (ch#w.cr) DO
			scanner.str[i]:=ch;
			CASE scanner.class OF
			| number:
			| real:
			| alpha: (* nothing more to do *)
			END;
			INC(i);
			Texts.Read(scanner,ch);
		END;
		IF ~scanner.eot THEN Texts.Read(scanner,scanner.nextCh); END;
		scanner.str[i]:=0X;
	END;
END scan; 8   ,    68   #   Syntax10.Scn.Fnt       
VAR
	arg:arguments.T;
BEGIN
	arguments.init(arg);
	arguments.next(arg);
	year[0]:=0X;
	IF (arg.type=arguments.parameter) & (arg.scanner.line=0) & (arg.scanner.class=Texts.Int) THEN 
		year[0]:=CHR(ORD('0')+arg.scanner.i DIV 1000 MOD 10); year[1]:=CHR(ORD('0')+arg.scanner.i DIV 100 MOD 10);
		year[2]:=CHR(ORD('0')+arg.scanner.i DIV 10 MOD 10); year[3]:=CHR(ORD('0')+arg.scanner.i MOD 10);
		year[4]:=0X;
	END;
END getYear; 8      Syntax10b.Scn.Fnt          8     Syntax10.Scn.Fnt      r8  FoldElems New  #   Syntax10.Scn.Fnt  l    l   
	fileName:ARRAY 80 OF CHAR;
	pos:LONGINT;
	text:Texts.Text;
	viewer: Viewers.Viewer;
	year:ARRAY 5 OF CHAR; 8       `8   #   Syntax10.Scn.Fnt  ~    ~   
		Create a new text. If the passed name is not empty, then the file is used as
		text, otherwise an empty text is produced.
	 8   =     
VAR
BEGIN
	getYear(year);
	fileName:="Buch";
	string.append(fileName,year);
	string.append(fileName,".Text");
	text:=TextFrames.Text(fileName);(**)
	viewer:=w.openViewer(fileName,"Buch.Menu.Text","System.Close  System.Copy  Edit.Store  ",text);
	IF text.len>400 THEN pos:=text.len-400 ELSE pos:=0; END;
	Oberon.PassFocus(viewer);
	TextFrames.Show(viewer.dsc.next(TextFrames.Frame),pos);
	TextFrames.SetCaret(viewer.dsc.next(TextFrames.Frame),text.len);
END open; 8   B    8   #   Syntax10.Scn.Fnt  6   6  
BEGIN
	WHILE (scanner.class#eot) & (scanner.class#number) DO
		scan(scanner);
	END;
	year[0]:=CHR(ORD('0')+scanner.num DIV 1000 MOD 10); year[1]:=CHR(ORD('0')+scanner.num DIV 100 MOD 10);
	year[2]:=CHR(ORD('0')+scanner.num DIV 10 MOD 10); year[3]:=CHR(ORD('0')+scanner.num MOD 10);
	year[4]:=0X;
END scanYear; 8   @    c8   #   Syntax10.Scn.Fnt  {    {   
BEGIN
	WHILE (scanner.class#eot) & ((scanner.class#alpha) OR (scanner.str#str)) DO
		scan(scanner);
	END;
END syncScanner; 8   V    8   #   Syntax10.Scn.Fnt  L   L  
BEGIN
	num:=0;
	LOOP
		scan(scanner); IF scanner.class#number THEN EXIT; END; konto[num].num:=scanner.num; (* ignore line numbers *)
		scan(scanner); IF scanner.class#alpha THEN Log.Str("Exit alpha"); EXIT; END; COPY(scanner.str,konto[num].item);
		scan(scanner); IF scanner.class#real THEN Log.Str("Exit real"); EXIT; END; konto[num].value:=scanner.float;
		IF num#konto[num].num-1 THEN
			Log.Str("Warnung: Konto-Nr. nicht aufsteigend."); Log.Ln;
			EXIT;
		END;
		INC(num);
		IF num>=LEN(konto) THEN
			Log.Str("Warnung: Zuviele Konti."); Log.Ln;
			EXIT; 
		END;
	END;
END readKonto; 8   ^    z8   #   Syntax10.Scn.Fnt  d   d  
BEGIN
	num:=0;
	LOOP
		scan(scanner); IF scanner.class#number THEN EXIT; END; buchungen[num].date:=scanner.num;
		scan(scanner); IF scanner.class#alpha THEN EXIT; END; COPY(scanner.str,buchungen[num].item);
		scan(scanner); IF scanner.class#number THEN EXIT; END; buchungen[num].from:=scanner.num;
		scan(scanner); IF scanner.class#number THEN EXIT; END; buchungen[num].to:=scanner.num;
		scan(scanner); IF scanner.class#real THEN EXIT; END; buchungen[num].value:=scanner.float;
		INC(num);
		IF num>=LEN(buchungen) THEN
			Log.Str("Warnung: Zuviele Buchungen."); Log.Ln;
			EXIT; 
		END;
	END;
END readBuchung; 8               8   )    8   c   8       ]8   #   Syntax10.Scn.Fnt         
			Create a new text. If the passed name is not empty, then the file is used as
			text, otherwise an empty text is produced.
		 8       @8   #   Syntax10.Scn.Fnt       openScanner(scanner,src,0);
		scan(scanner);
		scanYear(scanner,year);
		fileName:="Report";
		string.append(fileName,year);
		string.append(fileName,".Text");
		dummyViewer:=w.openViewer(fileName,"Buch.Menu.Text","System.Close  System.Copy  Edit.Store  ",dst);
		syncScanner(scanner,"Konti");
		readKonto(scanner,konti,numKonti); 
		syncScanner(scanner,"Buchungen");
		readBuchung(scanner,buchungen,numBuchungen);     8   a    8   #   Syntax10.Scn.Fnt  !   !  w.setFont("Syntax10b.Scn.Fnt"); w.ln; w.str("Konti am 1. Januar "); w.str(year); w.ln; w.append(dst);
		parc:=w.newParc();
		parc.width:=185*TextFrames.mm;
		parc.nofTabs:=2;
		parc.tab[0]:=10*TextFrames.mm;
		parc.tab[1]:=103*TextFrames.mm;
		w.elem(parc); w.append(dst);
		w.ln;
		Texts.SetFont(w.w,fixFont);
		sum:=0.0;
		FOR i:=0 TO numKonti-1 DO
			w.int(konti[i].num,3); w.ch(w.tab);
			Texts.SetFont(w.w,varFont);
			w.str(konti[i].item); w.ch(w.tab);
			Texts.SetFont(w.w,fixFont);
			w.longRealFix(konti[i].value,10,2);
			sum:=sum+konti[i].value;
			w.ln;
			w.append(dst);
		END;
		w.ln;
		w.ch(w.tab);
		w.setFont("Syntax10b.Scn.Fnt");
		w.str("Total"); w.ch(w.tab); 
		Texts.SetFont(w.w,fixFont);
		w.longRealFix(sum,10,2); w.ln;
		w.append(dst);
		initialKonti:=konti;
		initialSum:=sum;     8       A8   #   Syntax10.Scn.Fnt       w.setFont("Syntax10b.Scn.Fnt"); w.ln; w.str("Buchungen"); w.ln; w.append(dst);
		parc:=w.newParc();
		parc.width:=185*TextFrames.mm;
		parc.nofTabs:=5;
		parc.tab[0]:=16*TextFrames.mm;
		parc.tab[1]:=100*TextFrames.mm;
		parc.tab[2]:=110*TextFrames.mm;
		parc.tab[3]:=120*TextFrames.mm;
		parc.tab[4]:=144*TextFrames.mm;
		w.elem(parc); w.append(dst);
		w.ln;
		Texts.SetFont(w.w,fixFont);
		FOR i:=0 TO numBuchungen-1 DO
			IF buchungen[i].date MOD 100 >9 THEN
				w.ch(CHR(buchungen[i].date MOD 100 DIV 10+48)); 
			ELSE
				w.ch(' ');
			END;
			w.ch(CHR(buchungen[i].date MOD 10+48)); 
			w.ch('.');
			w.ch(CHR(buchungen[i].date DIV 1000 MOD 10+48));
			w.ch(CHR(buchungen[i].date DIV 100 MOD 10+48));
			w.ch('.');
			w.ch(w.tab);
			Texts.SetFont(w.w,varFont);
			w.str(buchungen[i].item); w.ch(w.tab);
			Texts.SetFont(w.w,fixFont);
			from:=buchungen[i].from;
			to:=buchungen[i].to;
			w.int(from,2); w.ch(w.tab);
			w.int(to,2); w.ch(w.tab);
			value:=buchungen[i].value;
			w.longRealFix(value,9,2);
			IF from#0 THEN konti[from-1].value:=konti[from-1].value-value; END;
			IF to#0 THEN konti[to-1].value:=konti[to-1].value+value; END;
			w.ln;
			w.append(dst);
		END;     8       8  #   Syntax10.Scn.Fnt         Print konti at end f   8       8       	        58   1  Syntax10.Scn.Fnt      8  FoldElems New  #   Syntax10.Scn.Fnt  <   <  
	arg:arguments.T;
	buchungen:ARRAY 200 OF Buchung;
	fileName:ARRAY 50 OF CHAR;
	from,to:LONGINT;
	i:INTEGER;
	konti:ARRAY 25 OF Konto;
	konto:LONGINT;
	numBuchungen,numKonti:INTEGER;
	parc: TextFrames.Parc;
	scanner:Scanner;
	src,dst:Texts.Text;
	value:LONGREAL;
	dummyViewer: Viewers.Viewer;
	year:ARRAY 5 OF CHAR; 8   t   Syntax10b.Scn.Fnt      	       $    ]8   #   Syntax10.Scn.Fnt         
			Create a new text. If the passed name is not empty, then the file is used as
			text, otherwise an empty text is produced.
		 8       J8   #   Syntax10.Scn.Fnt       openScanner(scanner,src,0);
	scan(scanner);
	scanYear(scanner,year);
	fileName:="Report";
	string.append(fileName,year);
	string.append(fileName,".Text");
	dummyViewer:=w.openViewer(fileName,"Buch.Menu.Text","System.Close  System.Copy  Edit.Store  ",dst);
	syncScanner(scanner,"Konti");
	readKonto(scanner,konti,numKonti); 
	syncScanner(scanner,"Buchungen");
	readBuchung(scanner,buchungen,numBuchungen);     8       8   #   Syntax10.Scn.Fnt       w.setFont("Syntax10b.Scn.Fnt"); w.ln; w.str("Stand am 1. Januar "); w.str(year); w.ln; w.append(dst);
	parc:=w.newParc();
	parc.nofTabs:=2;
	parc.tab[0]:=10*TextFrames.mm;
	parc.tab[1]:=103*TextFrames.mm;
	w.elem(parc); w.append(dst);
	w.ln;
	Texts.SetFont(w.w,fixFont);
	w.int(konti[konto-1].num,3); w.ch(w.tab);
	Texts.SetFont(w.w,varFont);
	w.str(konti[konto-1].item); w.ch(w.tab);
	Texts.SetFont(w.w,fixFont);
	w.longRealFix(konti[konto-1].value,10,2);
	w.ln;
	w.append(dst);     8       8   #   Syntax10.Scn.Fnt       w.setFont("Syntax10b.Scn.Fnt"); w.ln; w.str("Buchungen"); w.ln; w.append(dst);
	parc:=w.newParc();
	parc.nofTabs:=5;
	parc.tab[0]:=16*TextFrames.mm;
	parc.tab[1]:=100*TextFrames.mm;
	parc.tab[2]:=110*TextFrames.mm;
	parc.tab[3]:=120*TextFrames.mm;
	parc.tab[4]:=144*TextFrames.mm;
	w.elem(parc); w.append(dst);
	w.ln;
	Texts.SetFont(w.w,fixFont);
	FOR i:=0 TO numBuchungen-1 DO
		from:=buchungen[i].from;
		to:=buchungen[i].to;
		IF (from=konto) OR (to=konto) THEN
			IF buchungen[i].date MOD 100 >9 THEN
				w.ch(CHR(buchungen[i].date MOD 100 DIV 10+48)); 
			ELSE
				w.ch(' ');
			END;
			w.ch(CHR(buchungen[i].date MOD 10+48)); 
			w.ch('.');
			w.ch(CHR(buchungen[i].date DIV 1000 MOD 10+48));
			w.ch(CHR(buchungen[i].date DIV 100 MOD 10+48));
			w.ch('.');
			w.ch(w.tab);
			Texts.SetFont(w.w,varFont);
			w.str(buchungen[i].item); w.ch(w.tab);
			Texts.SetFont(w.w,fixFont);
			w.int(from,2); w.ch(w.tab);
			w.int(to,2); w.ch(w.tab);
			value:=buchungen[i].value;
			w.longRealFix(value,9,2);
			IF from#0 THEN konti[from-1].value:=konti[from-1].value-value; END;
			IF to#0 THEN konti[to-1].value:=konti[to-1].value+value; END;
			w.ch(w.tab); w.longRealFix(konti[konto-1].value,9,2);
			w.ln;
			w.append(dst);
		END;
	END;     8       8   #   Syntax10.Scn.Fnt       w.setFont("Syntax10b.Scn.Fnt"); w.ln; w.str("Endstand"); w.ln; w.append(dst);
		parc:=w.newParc();
		parc.nofTabs:=3;
		parc.tab[0]:=10*TextFrames.mm;
		parc.tab[1]:=103*TextFrames.mm;
		parc.tab[2]:=140*TextFrames.mm;
		w.elem(parc); w.append(dst);
		w.ln;
		Texts.SetFont(w.w,fixFont);
		w.int(konti[konto-1].num,3); w.ch(w.tab);
		Texts.SetFont(w.w,varFont);
		w.str(konti[konto-1].item); w.ch(w.tab);
		Texts.SetFont(w.w,fixFont);
		w.longRealFix(konti[konto-1].value,10,2);
		w.ln;
		w.append(dst);     8         
VAR
BEGIN
	arguments.init(arg);
	IF arg.type#arguments.menu THEN
		Log.Str("Fehler beim parameter parsen."); Log.Ln;
		RETURN;
	END;
	src:=arg.text;
	arguments.next(arg);
	IF (arg.type=arguments.parameter) & (arg.scanner.class=Texts.Int) & (arg.scanner.i>0) THEN
		konto:=arg.scanner.i;
	ELSE
		Log.Int(arg.type); Log.Int(arg.scanner.class); 
		Log.Str("Konto nicht angegeben."); Log.Ln;
		RETURN;
	END;
	dst:=TextFrames.Text("");(**)
	Read in book  
	w.setFont("Syntax16b.Scn.Fnt"); w.str("Report "); w.str(year); w.str(" Konto "); w.int(konto,1);
	w.ln; w.ln; w.append(dst);
	Print konti at beginn
	Print bookings (?)
	Print konti at end
END showKonto; 8   7    8   Q   Syntax10.Scn.Fnt    Syntax10b.Scn.Fnt                   
VAR
	arg:arguments.T;
	betrag:REAL;
	nachKonto,vonKonto:LONGINT;
	pos:LONGINT;
BEGIN
	arguments.init(arg);
	IF arg.type#arguments.menu THEN
		Log.Str("Fehler beim parameter parsen."); Log.Ln;
	ELSE
		arguments.next(arg);
		IF (arg.type=arguments.parameter) & (arg.scanner.class=Texts.Int) THEN
			vonKonto:=arg.scanner.i;
		ELSE
			Log.Str("Von Konto nicht angegeben."); Log.Ln;
			RETURN;
		END;
		arguments.next(arg);
		IF (arg.type=arguments.parameter) & (arg.scanner.class=Texts.Int) THEN
			nachKonto:=arg.scanner.i;
		ELSE
			Log.Str("Nach Konto nicht angegeben."); Log.Ln;
			RETURN;
		END;
		arguments.next(arg);
		IF (arg.type=arguments.parameter) & (arg.scanner.class=Texts.Real) THEN
			betrag:=arg.scanner.x;
		ELSE
			betrag:=0.0;
		END;
		arguments.init(arg);
		Texts.SetFont(w.w,fixFont);
		w.ch(w.tab);
		Texts.SetFont(w.w,varFont);
		w.str(transaktionName); w.ch(w.tab);
		Texts.SetFont(w.w,fixFont);
		w.int(vonKonto,2); w.ch(w.tab);
		w.int(nachKonto,2); w.ch(w.tab);
		IF betrag>0.0 THEN
			w.realFix(betrag,8,2); w.ln;
		END;
		Texts.Insert(arg.text,arg.frame.carloc.pos,w.w.buf);
		IF arg.text.len>40 THEN pos:=arg.text.len-40 ELSE pos:=0; END;
		TextFrames.Show(arg.frame,pos);
		TextFrames.SetCaret(arg.frame,arg.text.len);
	END;
END transaktion; 8               8   #   Syntax10.Scn.Fnt  ;    ;   
BEGIN
	transaktion("Geld von Postomat");
END geldVonPost;
 8       
            8   #   Syntax10.Scn.Fnt  8    8   
BEGIN
	transaktion("Rckzahlung Peter");
END darlehen;
 8       
            8   #   Syntax10.Scn.Fnt  7    7   
BEGIN
	transaktion("Krankenkasse");
END krankenkasse;
 8       
            8   #   Syntax10.Scn.Fnt  -    -   
BEGIN
	transaktion("Telefon");
END telefon;
 8       
            8   #   Syntax10.Scn.Fnt  *    *   
BEGIN
	transaktion("E-Mail");
END eMail;
 8       
            8   #   Syntax10.Scn.Fnt  '    '   
BEGIN
	transaktion("Lohn");
END lohn;
 8       
            8   #   Syntax10.Scn.Fnt  8    8   
BEGIN
	transaktion("Kauf mit Postcard");
END postcard;
 8               8   1   Syntax10.Scn.Fnt              1   
BEGIN
	transaktion("Kauf mit VISA: ");
END visa; 8   f      MODULE buch; (**)

IMPORT

CONST

TYPE

VAR
	fixFont:Fonts.Font;
	varFont:Fonts.Font;

PROCEDURE openScanner(VAR scanner:Scanner; text:Texts.Text; pos:LONGINT);

PROCEDURE scan(VAR scanner:Scanner);

PROCEDURE getYear(VAR year:ARRAY OF CHAR);

PROCEDURE open*;

PROCEDURE scanYear(VAR scanner:Scanner; VAR year:ARRAY OF CHAR);

PROCEDURE syncScanner(VAR scanner:Scanner; str:ARRAY OF CHAR);

PROCEDURE readKonto(VAR scanner:Scanner; VAR konto:ARRAY OF Konto; VAR num:INTEGER);

PROCEDURE readBuchung(VAR scanner:Scanner; VAR buchungen:ARRAY OF Buchung; VAR num:INTEGER);

PROCEDURE report*;
TYPE
	KontoArray=ARRAY  25 OF Konto;
VAR
	arg:arguments.T;
	buchungen:ARRAY 410 OF Buchung;
	fileName:ARRAY 50 OF CHAR;
	from,to:LONGINT;
	i:INTEGER;
	initialKonti:KontoArray;
	initialSum:LONGREAL;
	konti:KontoArray;
	numBuchungen,numKonti:INTEGER;
	parc: TextFrames.Parc;
	scanner:Scanner;
	src,dst:Texts.Text;
	sum:LONGREAL;
	value:LONGREAL;
	dummyViewer:Viewers.Viewer;
	year:ARRAY 5 OF CHAR;
BEGIN
	arguments.init(arg);
	IF arg.type=arguments.end THEN
		Log.Str("No source."); Log.Ln;
	ELSE
		src:=arg.text;
		dst:=TextFrames.Text("");(**)
		Read in book  
		w.setFont("Syntax16b.Scn.Fnt"); w.str("Report "); w.str(year); w.ln; w.ln; w.append(dst);
		Print konti at beginn
		Print bookings (?)
		w.setFont("Syntax10b.Scn.Fnt"); w.ln; w.str("Endstand"); w.ln; w.append(dst);
		parc:=w.newParc();
		parc.width:=187*TextFrames.mm;
		parc.nofTabs:=5;
		parc.tab[0]:=10*TextFrames.mm;
		parc.tab[1]:=100*TextFrames.mm;
		parc.tab[2]:=123*TextFrames.mm;
		parc.tab[3]:=147*TextFrames.mm;
		parc.tab[4]:=167*TextFrames.mm;
		w.elem(parc); w.append(dst);
		w.ln;
		Texts.SetFont(w.w,fixFont);
		sum:=0.0;
		FOR i:=0 TO numKonti-1 DO
			sum:=sum+konti[i].value;
		END;
		FOR i:=0 TO numKonti-1 DO
			w.int(konti[i].num,3); w.ch(w.tab);
			Texts.SetFont(w.w,varFont);
			w.str(konti[i].item); w.ch(w.tab);
			Texts.SetFont(w.w,fixFont);
			w.longRealFix(konti[i].value,10,2); w.ch(w.tab);
			w.ch('('); w.longRealFix(100.0D0*konti[i].value/sum,5,1); w.str('%)'); w.ch(w.tab);
			w.longRealFix(konti[i].value-initialKonti[i].value,10,2); w.ch(w.tab);
			w.ch('(');
			IF initialKonti[i].value>0.0 THEN
				w.longRealFix(100.0D0*(konti[i].value/initialKonti[i].value-1.0D0),5,1);
				w.str('%)');
			ELSE
				w.str('neu)');
			END;
			w.ln;
			w.append(dst);
		END;
		w.ln;
		w.ch(w.tab);
		w.setFont("Syntax10b.Scn.Fnt");
		w.str("Total"); w.ch(w.tab);
		Texts.SetFont(w.w,fixFont);
		w.longRealFix(sum,10,2);  w.ch(w.tab); w.ch(w.tab);
		w.longRealFix(sum-initialSum,10,2); w.ch(w.tab);
		w.ch('('); w.longRealFix(100.0D0*(sum/initialSum-1.0D0),5,1); w.str('%)');
		w.ln;
		w.append(dst);
	END;
END report;

PROCEDURE showKonto*;

PROCEDURE transaktion(transaktionName:ARRAY OF CHAR);

PROCEDURE geldVonPost*;
PROCEDURE darlehen*;
PROCEDURE krankenkasse*;
PROCEDURE telefon*;
PROCEDURE eMail*;
PROCEDURE lohn*;
PROCEDURE postcard*;
PROCEDURE visa*;

BEGIN
	fixFont:=Fonts.This("Courier10.Scn.Fnt");
	varFont:=Fonts.This("Syntax10.Scn.Fnt");
END buch.