	  Syntax10.Scn.Fnt  
    8  FoldElems New       Z   StyleElems Alloc   Paragraph  R     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc          8   ^    B   Syntax10b.Scn.Fnt  	        8   /   8       8       8       8   y  Syntax10i.Scn.Fnt      N    !       8   6    8   P       P    8   a    8           8       8   .    L                        8       
        8   Y   8   4    8   W    8       8       8   
        &    8       8       8   A       m        9    8               8       8       8       8               8   ?    8       8   @   8               8   ?    8       8   @   8       	        8   3    8       8   !   8   
            8       8       8      8   
            8   ?    8       8   k   8   
            8   .    8       8      8   
            8   .    8       8      8   
            8   .    8       8      8   
            8   ?    8       8   f   8               8   *    8       8      8               8   j   8       8   E                              R    8   h    ?  MODULE ce; (*
Some commands I find useful when editing texts.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*)

IMPORT
	EditTools,FoldElems,Fonts,Log,Oberon,TextFrames,Texts
	,arguments,string,dataTypes,w;

VAR
	boldFont:Fonts.Font;
	normalFont:Fonts.Font;

PROCEDURE storeBoth*; (*

	This command has to be placed in the menu of a text viewer. It will store
	the viewer as Oberon file, and if the name ends in .Text, also as ASCII
	file, using the file name without the .Text ending.
	
	StoreBoth accepts an option \t which disables the translation of tab
	characters into spaces.
	 
*)
VAR
	arg:arguments.T;
	ch:CHAR;
	convertTab:BOOLEAN;
	count:LONGINT;
	err:BOOLEAN;
	i:INTEGER;
	name:dataTypes.FileName;
	r:Texts.Reader;
	text:Texts.Text;
BEGIN
	convertTab:=TRUE;
	arguments.init(arg);
	IF arg.type=arguments.menu THEN
		COPY(arg.name,name);
		arguments.next(arg);
		IF (arg.type=arguments.parameter) 
			& (arg.scanner.class=Texts.Char) & (arg.scanner.line=0) & (arg.scanner.c="\") THEN
			Texts.Scan(arg.scanner^);
			IF (arg.scanner.class=Texts.Name) & (arg.scanner.line=0) THEN
				IF arg.scanner.s="t" THEN (* don't convert tab to spaces. *)
					convertTab:=FALSE;
				END;
			END;
		END;
		arguments.init(arg); (* retrieve the original parameters. *)
		Log.Str("CE.StoreBoth "); Log.Str(name);
		(*
			Store as is.
		*)
		Texts.Close(arg.text,name); Log.Int(arg.text.len);
		(*
			If name terminates with .Text, then store under name without .Text as ASCII
		*)
		(*
			Get length, and if long enough and terminate with .Text, then truncate the name.
		*)
		i:=-1; REPEAT INC(i) UNTIL name[i]=0X;
		IF (i>5) & (name[i-5]=".") & (name[i-4]="T") & (name[i-3]="e") & (name[i-2]="x") & (name[i-1]="t") THEN
			name[i-5]:=0X;
			Log.Str(" & "); Log.Str(name);
			FoldElems.ExpandAll(arg.text,0,TRUE);
			w.storeAscii(arg.text,name,convertTab,count,err);
			IF err THEN Log.Str(" [unknown character codes found]"); END;
			FoldElems.CollapseAll(arg.text,{FoldElems.tempLeft});
			Log.Int(count);
		END;
		Log.Ln;
		text:=arg.viewer.dsc(TextFrames.Frame).text;
		Texts.OpenReader(r,text,text.len-1);
		Texts.Read(r,ch);
		IF ch="!" THEN Texts.Delete(text,text.len-1,text.len); END
	END
END storeBoth;

PROCEDURE show(frame:TextFrames.Frame; pos:LONGINT);
VAR
	beg:LONGINT;
	delta:LONGINT;
	end:LONGINT;
	message:Oberon.ControlMsg;
BEGIN
	delta:=200;
	Oberon.RemoveMarks(frame.X,frame.Y,frame.W,frame.H);
	message.id:=Oberon.neutralize;
	frame.handle(frame,message);
	LOOP
		beg:=frame.org;
		end:=TextFrames.Pos(frame,frame.X+frame.W,frame.Y);
		IF (beg<=pos) & (pos<end) OR (delta=0) THEN EXIT; END;
		TextFrames.Show(frame,pos-delta);
		delta:=delta DIV 2;
	END;
END show;

PROCEDURE readNext(text:Texts.Text; VAR reader:Texts.Reader; VAR ch:CHAR; VAR inString:CHAR);(*

	Skip whitespace and comments as well as semicolons. Missing
	semicolons aren't significant to the semantic, if both sources compile.

*)
VAR
	comment:LONGINT;
	noStop:BOOLEAN;
BEGIN
	(*
		noStop is needed, for the case where two comments
		are adjacent.
	*)
	comment:=0;
	REPEAT
		noStop:=FALSE;
		Texts.Read(reader,ch);
		IF (inString=0X) & (ch="(") THEN
			Texts.Read(reader,ch);
			IF ch="*" THEN INC(comment);
			ELSIF comment=0 THEN (* go back by one *)
				ch:="(";
				Texts.OpenReader(reader,text,Texts.Pos(reader)-1);
			END;
		ELSIF (comment>0) THEN
			IF (ch="*") THEN
				REPEAT Texts.Read(reader,ch); UNTIL ch#'*';
				IF ch=")" THEN DEC(comment); noStop:=TRUE; END;
			END;
		ELSE (* not in comment *)
			IF (ch#0X) & (ch=inString) THEN
				inString:=0X;
			ELSIF (ch='"') OR (ch="'") THEN
				inString:=ch;
			END;
		END;
	UNTIL reader.eot OR ((~noStop) & (comment=0) & (ch>" ") & (ch#";"));
END readNext;

PROCEDURE compareSource*;
VAR
	ch1:CHAR;
	ch2:CHAR;
	frame1:TextFrames.Frame;
	frame2:TextFrames.Frame;
	inString1:CHAR;
	inString2:CHAR;
	pos:LONGINT;
	reader1:Texts.Reader;
	reader2:Texts.Reader;
BEGIN
	frame1:=EditTools.SelectedFrame();
	IF frame1#NIL THEN TextFrames.RemoveSelection(frame1); END;
	frame2:=EditTools.SelectedFrame();
	IF frame2#NIL THEN
		ASSERT(frame1#frame2);
		Texts.OpenReader(reader1,frame1.text,frame1.selbeg.pos);
		Texts.OpenReader(reader2,frame2.text,frame2.selbeg.pos);
		inString1:=0X;
		inString2:=0X;
		REPEAT
			readNext(frame1.text,reader1,ch1,inString1);
			readNext(frame2.text,reader2,ch2,inString2);
		UNTIL (ch1#ch2) OR (ch1=0X);
		pos:=Texts.Pos(reader1)-1;
		show(frame1,pos);
		TextFrames.SetSelection(frame1,pos,pos+1);
		pos:=Texts.Pos(reader2)-1;
		show(frame2,pos);
		TextFrames.SetSelection(frame2,pos,pos+1);
	END;
END compareSource;

PROCEDURE writeIt(ch:CHAR; reader:Texts.Reader);(*

	Writes character together with the correct attributes,
	and handles also elements.

*)
BEGIN
	Texts.SetColor(w.w,reader.col);
	Texts.SetOffset(w.w,reader.voff);
	Texts.SetFont(w.w,reader.fnt);
	IF ch=Texts.ElemChar THEN
		w.elem(w.cloneElem(reader.elem));
	ELSE
		w.ch(ch);
	END;
END writeIt;
	

PROCEDURE makeCaseSelection*(text:Texts.Text; beg,end:LONGINT);(*
	
	If you select a text like
		
		a
		b
		c
		d
		e
		f
		g
	
	you will get
	
		|  0: name:="a";
		|  1: name:="b";
		|  2: name:="c";
		|  3: name:="d";
		|  4: name:="e";
		|  5: name:="f";
		|  6: name:="g";

*)
VAR
	ch:CHAR;
	count,length:LONGINT;
	i,time:LONGINT;
	reader:Texts.Reader;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	count:=0;
	IF time>= 0 THEN
		i:=beg;
		LOOP
			Texts.OpenReader(reader,text,i);
			REPEAT Texts.Read(reader,ch); INC(i) UNTIL (ch>" ") OR (i=end); (* skip leading blanks. *)
			Texts.SetColor(w.w,reader.col);
			Texts.SetOffset(w.w,reader.voff);
			Texts.SetFont(w.w,reader.fnt);
			w.str("|"); w.int(count,3); w.str(': name:="');
			length:=w.w.buf.len;
			w.insert(text,i-1);
			INC(i,length);
			INC(end,length);
			IF i<end THEN
				Texts.OpenReader(reader,text,i);
				REPEAT Texts.Read(reader,ch); INC(i) UNTIL (ch=0DX) OR (i=end);
				Texts.SetColor(w.w,reader.col);
				Texts.SetOffset(w.w,reader.voff);
				Texts.SetFont(w.w,reader.fnt);
			END;
			w.str('";');
			IF ch#0DX THEN w.insert(text,i); EXIT; END;
			length:=w.w.buf.len;
			w.insert(text,i-1);
			INC(i,length);
			INC(end,length);
			IF i=end THEN EXIT; END;
			INC(count);
		END;
	END;
END makeCaseSelection;

PROCEDURE makeCase*;(*
	
	If you select a text like
		
		a
		b
		c
		d
		e
		f
		g
	
	you will get
	
		|  0: name:="a";
		|  1: name:="b";
		|  2: name:="c";
		|  3: name:="d";
		|  4: name:="e";
		|  5: name:="f";
		|  6: name:="g";

*)
VAR
	beg,end,time:LONGINT;
	text:Texts.Text;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time>= 0 THEN
		makeCaseSelection(text,beg,end);
	END;
END makeCase;

PROCEDURE ansiToOberon*;(*
	
	Converts the selection from ANSI to Oberon character set.

*)
VAR
	beg:LONGINT;
	ch:CHAR;
	end:LONGINT;
	err:string.ConvertError;
	i:LONGINT;
	reader:Texts.Reader;
	text:Texts.Text;
	time:LONGINT;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		Texts.OpenReader(reader,text,beg);
		FOR i:=beg TO end-1 DO
			Texts.Read(reader,ch);
			string.convertAnsiToOberon(ch,err);
			IF err=string.conversionUnknown THEN
				Log.Str("Unknown character at"); Log.Int(i); Log.Ln;
			END;
			writeIt(ch,reader);
		END;
		Texts.Delete(text,beg,end);
		w.insert(text,beg);
	END;
END ansiToOberon;

PROCEDURE oberonToAnsi*;(*
	
	Converts the selection from Oberon to ANSI character set.

*)
VAR
	beg:LONGINT;
	ch:CHAR;
	end:LONGINT;
	err:string.ConvertError;
	i:LONGINT;
	reader:Texts.Reader;
	text:Texts.Text;
	time:LONGINT;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		Texts.OpenReader(reader,text,beg);
		FOR i:=beg TO end-1 DO
			Texts.Read(reader,ch);
			string.convertOberonToAnsi(ch,err);
			IF err=string.conversionUnknown THEN
				Log.Str("Unknown character at"); Log.Int(i); Log.Ln;
			END;
			writeIt(ch,reader);
		END;
		Texts.Delete(text,beg,end);
		w.insert(text,beg);
	END;
END oberonToAnsi;

PROCEDURE tabIndent*; (*

	Change blank indentation into TAB indentation.

*)
VAR
	beg:LONGINT;
	ch:CHAR;
	end:LONGINT;
	i:LONGINT;
	reader:Texts.Reader;
	text:Texts.Text;
	time:LONGINT;
	newLine:BOOLEAN;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		Texts.OpenReader(reader,text,beg);
		FOR i:=beg TO end-1 DO
			Texts.Read(reader,ch);
			IF ch=w.cr THEN
				newLine:=TRUE;
			ELSIF ch#' ' THEN
				newLine:=FALSE;
			ELSIF newLine THEN
				ch:=w.tab;
			END;
			writeIt(ch,reader);
		END;
		Texts.Delete(text,beg,end);
		w.insert(text,beg);
	END;
END tabIndent;	

PROCEDURE compactParagraph*; (*

	Substitute carriage returns by blanks and compress multiple
	blanks to single blanks. With the option \t tabs are counted as
	blanks and compacted too.

*)
VAR
	arg:arguments.T;
	beg:LONGINT;
	blank:BOOLEAN;
	ch:CHAR;
	end:LONGINT;
	i:LONGINT;
	reader:Texts.Reader;
	removeTabs:BOOLEAN;
	text:Texts.Text;
	time:LONGINT;
BEGIN
	blank:=FALSE;
	removeTabs:=FALSE;
	arguments.init(arg);
	arguments.next(arg);
	IF (arg.type=arguments.parameter) 
		& (arg.scanner.class=Texts.Char) & (arg.scanner.line=0) & (arg.scanner.c="\") THEN
		Texts.Scan(arg.scanner^);
		IF (arg.scanner.class=Texts.Name) & (arg.scanner.line=0) THEN
			IF arg.scanner.s="t" THEN (* remove tabs too *)
				removeTabs:=TRUE;
			END;
		END;
	END;
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		Texts.OpenReader(reader,text,beg);
		FOR i:=beg TO end-1 DO
			Texts.Read(reader,ch);
			IF (ch=w.cr) OR (ch=' ') OR (removeTabs & (ch=w.tab)) THEN
				blank:=TRUE;
			ELSE
				IF blank THEN
					writeIt(' ',reader);
					blank:=FALSE;
				END;
				writeIt(ch,reader);
			END;
		END;
		Texts.Delete(text,beg,end);
		w.insert(text,beg);
	END;
END compactParagraph;	

PROCEDURE blanksToTab*; (*

	Substitute sequences of 2 and more blanks by a single tab.

*)
VAR
	beg:LONGINT;
	blank:LONGINT;
	ch:CHAR;
	end:LONGINT;
	i:LONGINT;
	reader:Texts.Reader;
	text:Texts.Text;
	time:LONGINT;
BEGIN
	blank:=0;
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		Texts.OpenReader(reader,text,beg);
		FOR i:=beg TO end-1 DO
			Texts.Read(reader,ch);
			IF ch=' ' THEN
				INC(blank);
			ELSE
				IF blank>1 THEN
					writeIt(w.tab,reader);
					blank:=0;
				ELSIF blank=1 THEN
					writeIt(' ',reader);
					blank:=0;
				END;
				writeIt(ch,reader);
			END;
		END;
		Texts.Delete(text,beg,end);
		w.insert(text,beg);
	END;
END blanksToTab;
	
PROCEDURE export*; (*

	Make selection bold and add a star to it.

*)
VAR
	beg:LONGINT;
	end:LONGINT;
	text:Texts.Text;
	time:LONGINT;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		w.ch('*');
		w.insert(text,end);
		EditTools.ChangeFontStyle(text,beg,end,'?','b');
	END;
END export;
	
PROCEDURE short*; (*

	Make selection bold and add a star to it.

*)
VAR
	beg:LONGINT;
	end:LONGINT;
	text:Texts.Text;
	time:LONGINT;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		w.ch(')');
		w.insert(text,end);
		w.str("SHORT(");
		w.insert(text,beg);
	END;
END short;
	
PROCEDURE long*; (*

	Make selection bold and add a star to it.

*)
VAR
	beg:LONGINT;
	end:LONGINT;
	text:Texts.Text;
	time:LONGINT;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		w.ch(')');
		w.insert(text,end);
		w.str("LONG(");
		w.insert(text,beg);
	END;
END long;
	
PROCEDURE firstBlankToTab*; (*

	Substitute sequences of 2 and more blanks by a single tab.

*)
VAR
	beg:LONGINT;
	ch:CHAR;
	end:LONGINT;
	i:LONGINT;
	reader:Texts.Reader;
	newline:BOOLEAN;
	text:Texts.Text;
	time:LONGINT;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		Texts.OpenReader(reader,text,beg);
		FOR i:=beg TO end-1 DO
			Texts.Read(reader,ch);
			IF ch=w.cr THEN newline:=TRUE; END;
			IF ch=' ' THEN
				IF newline THEN
					writeIt(w.tab,reader);
					newline:=FALSE;
				ELSE
					writeIt(' ',reader);
				END;
			ELSE
				writeIt(ch,reader);
			END;
		END;
		Texts.Delete(text,beg,end);
		w.insert(text,beg);
	END;
END firstBlankToTab;

PROCEDURE upcase*;(*
	
	Converts the selection to uppercase.

*)
VAR
	beg:LONGINT;
	ch:CHAR;
	end:LONGINT;
	i:LONGINT;
	reader:Texts.Reader;
	text:Texts.Text;
	time:LONGINT;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		Texts.OpenReader(reader,text,beg);
		FOR i:=beg TO end-1 DO
			Texts.Read(reader,ch);
			writeIt(CAP(ch),reader);
		END;
		Texts.Delete(text,beg,end);
		w.insert(text,beg);
	END;
END upcase;

PROCEDURE enum*; (*
	
	Given a selection of Enum=(a,b,c) generates on the following
	lines:
	
		TYPE
			Enum=SHORTINT;
		CONST
			a=0; b=1; c=2;
	
	If Enum is followed by a star ("*") then the type and the
	constants are marked for export. The start of the selection marks 
	the beginning for the parsing. The end of the selection marks the
	insert point for the generated stuff.

*)
VAR
	beg:LONGINT;
	end:LONGINT;
	export:BOOLEAN;
	number:SHORTINT;
	scanner:Texts.Scanner;
	text:Texts.Text;
	time:LONGINT;
	typeName:ARRAY 64 OF CHAR;
BEGIN
	Oberon.GetSelection(text,beg,end,time);
	IF time<0 THEN
		Log.Str("No valid selection.");
	ELSE
		Texts.OpenScanner(scanner,text,beg);
		Texts.Scan(scanner);
		IF scanner.class#Texts.Name THEN
			Log.Str("Type name expected"); Log.Int(Texts.Pos(scanner)); Log.Ln;
		ELSE
			COPY(scanner.s,typeName);
			Texts.Scan(scanner);
			export:=(scanner.class=Texts.Char) & (scanner.c="*");
			IF export THEN Texts.Scan(scanner); END;	
			IF (scanner.class#Texts.Char) OR (scanner.c#"=") THEN
				Log.Str("Equal expected"); Log.Int(Texts.Pos(scanner)); Log.Ln;
			ELSE
				Texts.Scan(scanner);
				IF (scanner.class#Texts.Char) OR (scanner.c#"(") THEN
					Log.Str("Left parens expected"); Log.Int(Texts.Pos(scanner)); Log.Ln;
				ELSE
					w.str("TYPE"); w.ln;
					w.ch(w.tab);
					IF export THEN Texts.SetFont(w.w,boldFont); ELSE Texts.SetFont(w.w,normalFont); END;
					w.str(typeName);
					IF export THEN Texts.SetFont(w.w,normalFont); w.ch("*"); END;
					w.str("=SHORTINT;"); w.ln;
					w.str("CONST"); w.ln;
					w.ch(w.tab);
					number:=0;
					LOOP
						Texts.Scan(scanner);
						IF scanner.eot THEN
							Log.Str("Reached end of text."); Log.Int(Texts.Pos(scanner)); Log.Ln;
							EXIT;
						END;
						IF scanner.class=Texts.Name THEN
							IF export THEN Texts.SetFont(w.w,boldFont); ELSE Texts.SetFont(w.w,normalFont); END;
							w.str(scanner.s);
							IF export THEN Texts.SetFont(w.w,normalFont); w.ch("*"); END;
							w.ch("=");
							IF number>100 THEN w.ch(CHR(number DIV 100+ORD("0"))); number:=number MOD 100; END;
							IF number>10 THEN w.ch(CHR(number DIV 10+ORD("0"))); number:=number MOD 10; END;
							w.ch(CHR(number+ORD("0")));
							w.ch(";");
							Texts.Scan(scanner);
							IF scanner.class=Texts.Char THEN
								IF scanner.c=")" THEN (* done *)
									w.ln;
									w.insert(text,end);
									EXIT;
								ELSIF scanner.c#"," THEN
									Log.Str("Comma or right parens expected"); Log.Int(Texts.Pos(scanner)); Log.Ln;
									EXIT;
								ELSE
									w.ch(" ");
								END;
							END;
						ELSE
							Log.Str("Identifier expected"); Log.Int(Texts.Pos(scanner)); Log.Ln;
							EXIT;
						END;
						INC(number);
					END;
				END;
			END;
		END;	
	END;
END enum;

BEGIN
	boldFont:=Fonts.This("Syntax10b.Scn.Fnt");
	normalFont:=Fonts.This("Syntax10.Scn.Fnt");
END ce.