  Syntax10.Scn.Fnt      8  FoldElems New  ?  Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  =     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc            
Complex number operations.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 8       o8   _   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt                          3   
	Float=LONGREAL;
	T*=RECORD
		re*,im*:Float;
	END; 8      Syntax10b.Scn.Fnt          8   #   Syntax10.Scn.Fnt  3    3   
BEGIN
	c.re:=a.re+b.re;
	c.im:=a.im+b.im;
END add; 8               8   #   Syntax10.Scn.Fnt  3    3   
BEGIN
	c.re:=a.re-b.re;
	c.im:=a.im-b.im;
END sub; 8               8   #   Syntax10.Scn.Fnt  G    G   
BEGIN
	c.re:=a.re*b.re-a.im*b.im;
	c.im:=a.re*b.im+a.im*b.re;
END mul; 8               8   #   Syntax10.Scn.Fnt  /    /   
BEGIN
	a.re:=r*a.re;
	a.im:=r*a.im;
END scale; 8               |8   #   Syntax10.Scn.Fnt  b    b   
VAR
	d:Float;
BEGIN
	d:=b.re*b.re+b.im*b.im;
	b.im:=-b.im;
	mul(a,b,c);
	scale(c,1.0/d);
END div; 8               8   #   Syntax10.Scn.Fnt  U    U   
VAR
	d:Float;
BEGIN
	d:=a.re*a.re+a.im*a.im;
	a.im:=-a.im;
	scale(a,1.0/d);
END inv; 8           
    8   #   Syntax10.Scn.Fnt  7    7   
BEGIN
	RETURN MathL.sqrt(a.re*a.re+a.im*a.im)
END abs; 8           
    {8   #   Syntax10.Scn.Fnt  c   c  
VAR
	phi:Float;
BEGIN
	IF a.re=0.0 THEN
		IF a.im=0.0 THEN phi:=0.0;
		ELSIF a.im>0.0 THEN phi:=MathL.pi/2.0;
		ELSE phi:=-MathL.pi/2.0;
		END;
	ELSIF a.re<0.0 THEN
		IF a.im<0.0 THEN
			phi:=-MathL.pi-MathL.arctan(a.im/(-a.re));
		ELSE
			phi:=MathL.pi-MathL.arctan(a.im/(-a.re));
		END;
	ELSE
		phi:=MathL.arctan(a.im/a.re);
	END;
	RETURN phi;
END arg; 8               8   #   Syntax10.Scn.Fnt  E    E   
BEGIN
	a.re:=abs*MathL.cos(arg);
	a.im:=abs*MathL.sin(arg);
END set; 8       r  MODULE complex; (**)

IMPORT MathL;

TYPE

PROCEDURE add*(a,b:T; VAR c:T);

PROCEDURE sub*(a,b:T; VAR c:T);

PROCEDURE mul*(a,b:T; VAR c:T);

PROCEDURE scale*(VAR a:T; r:Float);

PROCEDURE div*(a,b:T; VAR c:T);

PROCEDURE inv*(VAR a:T);

PROCEDURE abs*(a:T):Float;

PROCEDURE arg*(a:T):Float;

PROCEDURE set*(VAR a:T; abs,arg:Float);

END complex.
