eG  Syntax10.Scn.Fnt      N8  FoldElems New  f  Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  [     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc             Syntax10b.Scn.Fnt         M  
Find module dependencies and compile all needed modules.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

	This module exports a make command, as well as the needed procedure to
	easily integerate the functionality of make in you own modules.
	
	NOTE:
		To make this module work, you have to modify and recompile XE.
		You must mark for export the procedure MarkErrors.
		
		I hope this will not be needed in future, as I try to convince the author
		of XE to make this modification in his source too.
		
		If you don't like XE, then you can remove the procedure callXE and the import of module XE.
		
		If you don't know yet XE, then I suggest you download it from ftp.inf.ethz.ch.
		
 8   
    S8   1   Syntax10.Scn.Fnt  F        4    }   
	Compiler,Files,FoldElems,Log,Modules,Oberon,TextFrames,Texts,Viewers,XE
	,arguments,directory,fileId,list,string,types,w;
	 8       8   #   Syntax10.Scn.Fnt  '   '  
	ModuleDependencyPtr=POINTER TO ModuleDependency;
	Import=RECORD (list.Node)
		module:ModuleDependencyPtr;
	END;
	ImportPtr=POINTER TO Import;
	ImportListPtr=list.ListPtr;
	ModuleDependency=RECORD (list.Node)
		name:Modules.Name;
		state:State;
		imports:ImportListPtr;
	END;
	DependencyListPtr=list.ListPtr;
(*
	Module=RECORD (list.Node)
		name:Modules.Name;
	END;
	ModulePtr=POINTER TO Module;
*)
	CompilationListPtr=list.ListPtr;
	Parameter=RECORD (arguments.Parameter)
		dependencyList:DependencyListPtr;
	END;
	ParameterPtr=POINTER TO Parameter; 8       X      Syntax10b.Scn.Fnt  	    p    |8   #   Syntax10.Scn.Fnt  b    b   

	Add a module into the dependency list, if it is not already there.
	
	Time: O(n)
	Space: O(1)

 8       8   #   Syntax10.Scn.Fnt       
VAR
	node:list.NodePtr;
BEGIN
	node:=dependencyList.next;
	found:=FALSE;
	WHILE (node#dependencyList) & (~found) DO
		WITH node:ModuleDependencyPtr DO
			found:=node.name=name;
		END;
		IF ~found THEN node:=node.next; END;
	END;
	IF found THEN
		module:=node(ModuleDependencyPtr);
	ELSE
		NEW(module);
		module.name:=name;
		module.state:=added;
		NEW(module.imports);
		module.imports.init();
		dependencyList.addTail(module);
	END;
END addModule;
 8       	    [    )8   #   Syntax10.Scn.Fnt         

	Add a module into the dependency list, if it is not yet in it, and add
	an import referencing this module into the import list.
	
	Time: O(n) because of addModule.
	Space: O(1)

 8       _8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      e    _  
VAR
	found:BOOLEAN;
	import:ImportPtr;
	module:ModuleDependencyPtr;
BEGIN
	addModule(dependencyList,name,found,module);
	IF found THEN
		IF module.state=parsing THEN
			Log.Str("Module "); Log.Str(name); Log.Str(" imports itself !"); Log.Ln;
			HALT(33);
		END;
	END;
	NEW(import);
	import.module:=module;
	importList.addTail(import);
END addImport;
 8       8   #   Syntax10.Scn.Fnt  /    /   

	Read the imports from the dependency file.

 8       8   C   Syntax10.Scn.Fnt  p  Syntax10b.Scn.Fnt      Y      
VAR
	dependencyFile:Files.File;
	id:LONGINT;
	name:Modules.Name;
	rider:Files.Rider;
BEGIN
	dependencyFile:=Files.Old(dependencyFileName);
	error:=dependencyFile=NIL;
	IF ~error THEN
		Files.Set(rider,dependencyFile,0);
		Files.ReadLInt(rider,id);
		error:=id#fileId.dependencyFile1;
	END;
	IF ~error THEN
		LOOP
			Files.ReadString(rider,name);
			IF rider.eof THEN EXIT; END;
			addImport(dependencyList,importList,name);
		END;
	END;
END readDependencyFile; 8   _    8   #   Syntax10.Scn.Fnt  0    0   

	Store the import list to a dependency file.

 8       8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      <     
VAR
	dependencyFile:Files.File;
	node:list.NodePtr;
	rider:Files.Rider;
BEGIN
	dependencyFile:=Files.New(dependencyFileName);
	ASSERT(dependencyFile#NIL);
	Files.Set(rider,dependencyFile,0);
	Files.WriteLInt(rider,fileId.dependencyFile1);
	node:=importList.next;
	WHILE node#importList DO
		WITH node:ImportPtr DO
			Files.WriteString(rider,node.module.name);
		END;
		node:=node.next;
	END;
	Files.Register(dependencyFile);
END storeDependencyFile; 8           -    D8   #   Syntax10.Scn.Fnt         

	If both files exists and newFile is newer than oldFile then return TRUE,
	if oldFile doesn't exist then return TRUE, return FALSE in all other cases.

 8       J8   C   Syntax10.Scn.Fnt  Y  Syntax10b.Scn.Fnt          t  
VAR
	newFileInfo:directory.FileInfo;
	oldFileInfo:directory.FileInfo;
	result:BOOLEAN;
BEGIN
	directory.getFileInfo(newFile,newFileInfo,result);
	IF result THEN
		directory.getFileInfo(oldFile,oldFileInfo,result);
		IF result THEN
			result:=directory.compareDate(newFileInfo,oldFileInfo)=directory.newer;
		ELSE
			result:=TRUE;
		END;
	END;
	RETURN result;
END isNewer; 8           J    8   #   Syntax10.Scn.Fnt  J   J  

	Parse a module just enough, to know which other modules it
	imports. Add the information into our lists. If a dependency file exists,
	which is newer than the module source, the contents of the dependency
	file is used, to save time.
	
	Time estimate: O(n) [n = length of source]
	Space estimate: O(n) [n = length of source]
	
 8       _8     Syntax10.Scn.Fnt      8  FoldElems New  _   Syntax10.Scn.Fnt  a   Syntax10b.Scn.Fnt                      U    "  
	VAR
		comment:INTEGER;
	BEGIN
		comment:=0;
		LOOP
			IF sourceReader.eot THEN
				error:=TRUE; EXIT;
			ELSIF ch="(" THEN
				Texts.Read(sourceReader,ch);
				IF ch="*" THEN INC(comment); Texts.Read(sourceReader,ch); ELSIF comment=0 THEN error:=TRUE; EXIT; END;
			ELSIF (comment>0) & (ch="*") THEN
				Texts.Read(sourceReader,ch);
				IF ch=")" THEN DEC(comment); Texts.Read(sourceReader,ch); END;
			ELSIF (comment=0) & (ch>" ") THEN
				error:=FALSE; EXIT;
			ELSE
				Texts.Read(sourceReader,ch);
			END;
		END;
	END skipBlanksAndComments; 8   =    8   #   Syntax10.Scn.Fnt         
	VAR
		i:INTEGER;
	BEGIN
		skipBlanksAndComments(error);
		IF ~error THEN
			i:=0;
			WHILE (str[i]#0X) & (str[i]=ch) DO Texts.Read(sourceReader,ch); INC(i); END;
			error:=str[i]#0X;
		END;
	END check; 8   *    8   #   Syntax10.Scn.Fnt  ]   ]  
	VAR
		error:BOOLEAN;
		i:INTEGER;
	BEGIN
		skipBlanksAndComments(error);
		IF ~error THEN
			i:=0;
			error:=(CAP(ch)<"A") OR ("Z"<CAP(ch));
			WHILE ~error DO
				id[i]:=ch;
				Texts.Read(sourceReader,ch);
				INC(i);
				error:=(i>=LEN(id)) OR ~(("0"<=ch) & (ch<="9") OR ("A"<=CAP(ch)) & (CAP(ch)<="Z"));
			END;
		END;
		id[i]:=0X;
	END getId; 8      
	  
VAR
	ch:CHAR;
	dependencyFileName:types.FileName;
	dummyRes:INTEGER;
	error,importInvalid:BOOLEAN;
	fileName:types.FileName;
	id:Modules.Name;
	source:Texts.Text;
	sourceReader:Texts.Reader;
	
	PROCEDURE skipBlanksAndComments(VAR error:BOOLEAN);
				
	PROCEDURE check(str:ARRAY OF CHAR; VAR error:BOOLEAN);
	
	PROCEDURE getId(VAR id:ARRAY OF CHAR);
		
BEGIN
	COPY(module.name,fileName);
	string.append(fileName,".Mod");
	COPY(module.name,dependencyFileName);
	string.append(dependencyFileName,".Dependency");
	IF isNewer(dependencyFileName,fileName) THEN
		module.state:=parsing;
		Log.Str("- "); Log.Str(dependencyFileName);
		readDependencyFile(dependencyList,dependencyFileName,module.imports,error);
		IF error THEN
			Log.Str(" not found.");
		ELSE
			module.state:=parsed;
			Log.Str(" done.");
		END;
		Log.Ln;
	ELSE
		error :=TRUE; (* Force parsing module source *)
	END;
	IF error THEN
		(*
			Perform normal parsing, if the dependency file is older, or
			there were problems reading it. In case an invalid dependency
			file exists, it is deleted.
		*)
		Files.Delete(dependencyFileName,dummyRes);
		module.state:=parsing;
		Log.Str("- "); Log.Str(fileName);
		source:=TextFrames.Text(fileName);
		IF (source=NIL) OR (source.len=0) THEN
			 Log.Str(" not found."); Log.Ln;
			 module.state:=inexistant;
		ELSE
			FoldElems.ExpandAll(source,0,TRUE);
			Texts.OpenReader(sourceReader,source,0);
			Texts.Read(sourceReader,ch);
			importInvalid:=TRUE;
			check("MODULE",error);
			IF ~error THEN check(module.name,error); END;
			IF ~error THEN check(";",error); END;
			IF ~error THEN check("IMPORT",error); importInvalid:=~error; END;
			WHILE ~error DO
				getId(id);
				skipBlanksAndComments(error);
				IF (~error) & (ch=":") THEN
					Texts.Read(sourceReader,ch);
					error:=ch#"=";
					IF ~error THEN Texts.Read(sourceReader,ch); getId(id); END;
				END;
				IF ~error THEN
					addImport(dependencyList,module.imports,id);
					check(",",error);
					IF error THEN check(";",importInvalid); END;
				END;
			END;
			IF importInvalid THEN
				Log.Str(" error in source.");
			ELSE
				Log.Str(" done.");
				storeDependencyFile(dependencyFileName,module.imports);
			END;
			Log.Ln;
			FoldElems.CollapseAll(source,{FoldElems.tempLeft});
			module.state:=parsed;
		END;
	END;
END parseModule; 8           =    8   #   Syntax10.Scn.Fnt         

	Add a module into the dependency list. If it wasn't already in the
	list, then call parseModule, to add all imports. parseModule is called 
	repeatedly, so that all modules added by the first parse get parsed too.
	
	Time: O(n)
	Space: O(1)

 8       8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      Y    '  
VAR
	found:BOOLEAN;
	module:ModuleDependencyPtr;
BEGIN
	addModule(dependencyList,name,found,module);
	IF ~found THEN
		LOOP
			parseModule(dependencyList,module);
			IF module.next=dependencyList THEN EXIT; END;
			module:=module.next(ModuleDependencyPtr);
		END;
	END;
END addModuleWithImport; 8           D    8   #   Syntax10.Scn.Fnt  P   P  
VAR
	module:ModuleDependencyPtr;
	moduleDependency:ModuleDependencyPtr;
	node:list.NodePtr;
BEGIN
	node:=importList.next;
	WHILE node#importList DO
		WITH node:ImportPtr DO
			moduleDependency:=node.module;
			ASSERT((moduleDependency.state#added) & (moduleDependency.state#parsing));
			IF moduleDependency.state=sorting THEN
				Log.Str("Module "); Log.Str(moduleDependency.name); Log.Str(" is part of a cycle."); Log.Ln;
			ELSIF moduleDependency.state=parsed THEN
				IF moduleDependency.imports#NIL THEN
					moduleDependency.state:=sorting;
					moveImports(moduleDependency.imports,compilationList);
				END;
				NEW(module);
				module.name:=moduleDependency.name;
				module.imports:=moduleDependency.imports;
				compilationList.addTail(module);
				moduleDependency.state:=done;
			END;
		END;
		node:=node.next;
	END;
END moveImports;
 8           L    8   #   Syntax10.Scn.Fnt       
VAR
	module:ModuleDependencyPtr;
	node:list.NodePtr;
BEGIN
	node:=dependencyList.next;
	WHILE node#dependencyList DO
		WITH node:ModuleDependencyPtr DO
			IF node.state=parsed THEN
				IF node.imports#NIL THEN
					moveImports(node.imports,compilationList); 
				END;
				NEW(module);
				module.name:=node.name;
				module.imports:=node.imports;
				compilationList.addTail(module);
				node.state:=done;
			END;
		END;
		node:=node.next;
	END;
END sortDependency; 8           ?    -8   #   Syntax10.Scn.Fnt       
VAR
	module:ModulePtr;
	node:list.NodePtr;
BEGIN
	node:=dependencyList.next;
	Log.Str("dependencyList="); Log.Hex(SYSTEM.VAL(LONGINT,dependencyList)); 
	Log.Str("  dependencyList.next="); Log.Hex(SYSTEM.VAL(LONGINT,dependencyList.next)); Log.Ln;
	WHILE node#dependencyList DO
		WITH node:ModuleDependencyPtr DO
			Log.Str("- "); Log.Str(node.name); Log.Int(node.state); Log.Ln;
		END;
		node:=node.next;
	END;
END displayDependency; 8               
    0    8   #   Syntax10.Scn.Fnt         

	Compile the file. If the source generates compilation errors,
	then a viewer is opened, and XE.MarkErrors is called to mark all errors with error
	elements.
	
	Time: O(n) [n=size of source] + compiler
	Space: O(n) [n=size of source] + compiler
	
 8       8   #   Syntax10.Scn.Fnt  V   V  
VAR
	beginOfCompilerLog:LONGINT;
	source:Texts.Text;
	sourceReader:Texts.Reader;
BEGIN
	source:=TextFrames.Text(fileName);
	IF (source=NIL) OR (source.len=0) THEN
		Log.Str(fileName); Log.Str(" not found."); Log.Ln;
	ELSE
		Log.Str("compile "); Log.Str(fileName); Log.Ln;
		FoldElems.ExpandAll(source,0,TRUE);
		beginOfCompilerLog:=Oberon.Log.len;
		Texts.OpenReader(sourceReader,source,0);
		Compiler.Module(sourceReader,"vrs",0,Oberon.Log,error);
		IF error THEN
			callXE(fileName,source,beginOfCompilerLog);
		END;
		FoldElems.CollapseAll(source,{FoldElems.tempLeft});
	END;
END compileModule; 8           3    )8   #   Syntax10.Scn.Fnt         

	If the module source is newer than objct file, or if the symbol files of
	any of the imported modules is newer than the object file, then compile the
	source, otherwise don't.
	
 8       .8   #   Syntax10.Scn.Fnt       
VAR
	fileName:types.FileName;
	fileName2:types.FileName;
	fileName3:types.FileName;
	needCompilation:BOOLEAN;
	node:list.NodePtr;
BEGIN
	COPY(module.name,fileName);
	string.append(fileName,".Mod");
	COPY(module.name,fileName2);
	string.append(fileName2,".Obj");
	needCompilation:=isNewer(fileName,fileName2);
	IF needCompilation THEN
		Log.Str(fileName2); Log.Str(" is older than "); Log.Str(fileName); Log.Ln;
	END;
	node:=module.imports.next;
	WHILE (node#module.imports) & (~needCompilation) DO
		WITH node:ImportPtr DO
			COPY(node.module.name,fileName3);
			string.append(fileName3,".Sym");
			needCompilation:=isNewer(fileName3,fileName2);
			IF needCompilation THEN
				Log.Str(fileName2); Log.Str(" is older than "); Log.Str(fileName3); Log.Ln;
			END;
		END;
		node:=node.next;
	END;
	IF needCompilation THEN
		compileModule(fileName,error);
	ELSE
		Log.Str(fileName); Log.Str(" up to date."); Log.Ln;
	END;
END compileModuleIfNeeded; 8       
    (    R8   #   Syntax10.Scn.Fnt         

	Compile all modules in the compilation list. If compilation of a module fails,
	a viewer with the module is opened, to show the errors.

 8       8   #   Syntax10.Scn.Fnt         
VAR
	error:BOOLEAN;
	node:list.NodePtr;
BEGIN
	node:=compilationList.next;
	error:=FALSE;
	WHILE (node#compilationList) & (~error) DO
		WITH node:ModuleDependencyPtr DO
			compileModuleIfNeeded(node,error);
		END;
		node:=node.next;
	END;
END compileAll; 8       
    (    8   #   Syntax10.Scn.Fnt  T    T   

	Display the list of modules in the compilation list.
	
	Time: O(n)
	Space: O(1)

 8       8   #   Syntax10.Scn.Fnt         
VAR
	node:list.NodePtr;
BEGIN
	node:=compilationList.next;
	WHILE node#compilationList DO
		WITH node:ModuleDependencyPtr DO
			Log.Str(node.name); Log.Ln;
		END;
		node:=node.next;
	END;
END displayAll; 8       
        8   #   Syntax10.Scn.Fnt  K    K   

	Find the dependencies for this module, and compile all needed modules.

 8       8   #   Syntax10.Scn.Fnt       
VAR
	compilationList:CompilationListPtr;
	dependencyList:DependencyListPtr;
	moduleName:Modules.Name;
BEGIN
	COPY(name,moduleName);
	addModuleWithImport(dependencyList,moduleName);
	sortDependency(dependencyList,compilationList);
	compileAll(compilationList);
END makeModule; 8   =    8       8           *    8   #   Syntax10.Scn.Fnt  3   3  
VAR
	parameter:ParameterPtr;
BEGIN
	NEW(compilationList);
	compilationList.init();
	NEW(parameter);
	NEW(parameter.dependencyList);
	parameter.dependencyList.init();
	arguments.forEachName(rememberModule,parameter);
	sortDependency(parameter.dependencyList,compilationList);
END argumentsToCompilationList; 8   
            h8   #   Syntax10.Scn.Fnt  v    v   

	Given a list of modules make looks for all additionally imported
	modules, and compiles all in the correct order.

 8       Y8   #   Syntax10.Scn.Fnt         
VAR
	compilationList:CompilationListPtr;
BEGIN
	argumentsToCompilationList(compilationList);
	compileAll(compilationList);
END make; 8               H8   #   Syntax10.Scn.Fnt         

	Given a list of modules make looks for all additionally imported
	modules, and generates a list of all modules in the correct compilation
	order.

 8       V8   #   Syntax10.Scn.Fnt         
VAR
	compilationList:CompilationListPtr;
BEGIN
	argumentsToCompilationList(compilationList);
	displayAll(compilationList);
END display; 8       ^	  MODULE make; (**)

IMPORT

(*enum: State=(added,parsing,parsed,sorting,done,inexistant) *)
TYPE
	State=SHORTINT;
CONST
	added=0; parsing=1; parsed=2; sorting=3; done=4; inexistant=5;

TYPE

PROCEDURE callXE(fileName:ARRAY OF CHAR; source:Texts.Text; beginOfCompilerLog:LONGINT);
(*
	Remove, if you don't use/like XE.
*)
VAR
	viewer:Viewers.Viewer;
BEGIN
	viewer:=w.openViewer(fileName,"XE.Menu.Text","System.Close !! You need XE.Menu.Text !!",source);
	XE.MarkErrors(viewer.dsc.next(TextFrames.Frame),beginOfCompilerLog);
END callXE;

PROCEDURE addModule*(VAR dependencyList:DependencyListPtr; name:Modules.Name; VAR found:BOOLEAN; VAR module:ModuleDependencyPtr);(**)
PROCEDURE addImport*(VAR dependencyList:DependencyListPtr; VAR importList:ImportListPtr; name:Modules.Name);(**)

PROCEDURE readDependencyFile(VAR dependencyList:DependencyListPtr; dependencyFileName:types.FileName; VAR importList:ImportListPtr; VAR error:BOOLEAN); (**)

PROCEDURE storeDependencyFile(dependencyFileName:types.FileName; importList:ImportListPtr);(**)

PROCEDURE isNewer*(newFile,oldFile:types.FileName):BOOLEAN; (**)

PROCEDURE parseModule*(VAR dependencyList:DependencyListPtr; VAR module:ModuleDependencyPtr);(**)

PROCEDURE addModuleWithImport*(VAR dependencyList:DependencyListPtr; name:Modules.Name);(**)

PROCEDURE moveImports*(importList:ImportListPtr; VAR compilationList:CompilationListPtr);

PROCEDURE sortDependency*(dependencyList:DependencyListPtr; VAR compilationList:CompilationListPtr);

(* PROCEDURE displayDependency(dependencyList:DependencyListPtr); *)

PROCEDURE compileModule*(fileName:types.FileName; VAR error:BOOLEAN);(**)

PROCEDURE compileModuleIfNeeded*(module:ModuleDependencyPtr; VAR error:BOOLEAN);(**)

PROCEDURE compileAll*(compilationList:CompilationListPtr);(**)

PROCEDURE displayAll*(compilationList:CompilationListPtr);(**)

PROCEDURE makeModule*(name:ARRAY OF CHAR);(**)

PROCEDURE rememberModule(parameter:arguments.ParameterPtr);
VAR
	moduleName:Modules.Name;
BEGIN
	WITH parameter:ParameterPtr DO
		COPY(parameter.name^,moduleName);
		arguments.removeExtension(moduleName);
		addModuleWithImport(parameter.dependencyList,moduleName);
	END;
END rememberModule;

PROCEDURE argumentsToCompilationList*(VAR compilationList:CompilationListPtr);
	
PROCEDURE make*;(**)

PROCEDURE display*;(**)

END make.