
  Syntax10.Scn.Fnt      8  FoldElems New       Z 0 StyleElems Alloc   Paragraph       Z 0   Paragraph       Z 0   Paragraph      0   Paragraph      s  ParcElems Alloc          8   
    8   #   Syntax10.Scn.Fnt  !    !   
	SYSTEM,Log,Modules
	,arguments; 8       8   #   Syntax10.Scn.Fnt  *    *   
	Imps=POINTER TO ARRAY OF Modules.Module; 8   r    8   #   Syntax10.Scn.Fnt         
VAR
	i:LONGINT;
	imps:Imps;
	mod:Modules.Module;
	found:BOOLEAN;
BEGIN
	mod:=Modules.modules;
	WHILE (mod#NIL) & (moduleName#mod.name) DO
		mod:=mod.next;
	END;
	RETURN mod;
END findModule;
 8   ,    8   #   Syntax10.Scn.Fnt  N   N  
VAR
	i:LONGINT;
	imps:Imps;
	mod:Modules.Module;
	found:BOOLEAN;
BEGIN
	mod:=Modules.modules;
	WHILE mod#NIL DO
		imps:=SYSTEM.VAL(Imps,mod.imports);
		i:=LEN(imps^);
		found:=FALSE;
		WHILE ~found &(i>1)  DO
			DEC(i);
			found:=imps[i]=module;
		END;
		IF found THEN freeModule(mod.name); END;
		mod:=mod.next;
	END;
END freeAbove; 8   1    8   #   Syntax10.Scn.Fnt  R   R  
VAR
	command:Modules.Command;
	module:Modules.Module;
BEGIN
	arguments.removeExtension(moduleName);
	module:=findModule(moduleName);
	IF module=NIL THEN
		Log.Str(moduleName); Log.Str(" not loaded."); Log.Ln;
	ELSIF module.refcnt>0 THEN
		freeAbove(module);
		IF module.refcnt=0 THEN
			command:=Modules.ThisCommand(module,"expunge");
			IF command#NIL THEN
				command();	(* Should either remove all its handlers, or cause a trap *)
				Modules.Free(moduleName,FALSE);
				Log.Str(moduleName); Log.Str(" unloaded."); Log.Ln;
			ELSE
				Modules.Free(moduleName,FALSE);
				Log.Str(moduleName); Log.Str(" unloaded without expunge."); Log.Ln;
			END;
		ELSE
			Log.Str(moduleName); Log.Str(" still used."); Log.Ln;
		END;
	ELSE
		command:=Modules.ThisCommand(module,"expunge");
		IF command#NIL THEN
			command();	(* Should either remove all its handlers, or cause a trap *)
			Modules.Free(moduleName,FALSE);
			Log.Str(moduleName); Log.Str(" unloaded."); Log.Ln;
		ELSE
			Modules.Free(moduleName,FALSE);
			Log.Str(moduleName); Log.Str(" unloaded without expunge."); Log.Ln;
		END;
	END;
END freeModule; 8   9    8   5    8      Syntax10b.Scn.Fnt          8   w    8         MODULE sys; (*
Commands extending the System module.
Copyright (C) 1996 Claudio Nieder

'm trying to write a procedure which can free a module which still has references to
it, by recursivly trying to free the modules which reference it.
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*)

IMPORT

TYPE

PROCEDURE ^freeModule(moduleName:ARRAY OF CHAR);

PROCEDURE findModule(moduleName:ARRAY OF CHAR):Modules.Module;
PROCEDURE freeAbove(module:Modules.Module);

PROCEDURE freeModule(moduleName:ARRAY OF CHAR);
PROCEDURE freeModule2(parameter:arguments.ParameterPtr);
BEGIN
	freeModule(parameter.name^);
END freeModule2;

PROCEDURE free*;
VAR
	parameter:arguments.ParameterPtr;
BEGIN
	NEW(parameter);
	arguments.forEachName(freeModule2,parameter);
END free;

END sys.
