&  Syntax10.Scn.Fnt      8  FoldElems New  ?  Syntax10.Scn.Fnt       Z   StyleElems Alloc   Paragraph  F     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc            
Tests for some of my other modules.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 8          PopupElems Alloc Tests  #   Syntax10.Scn.Fnt         test.coroutineExample
coroutine.show
____________________________________________________________
test.tcpStart
test.tcpStop
System.Execute netstat | grep "ftp" 
test.complexTest
test.stringAll
     W8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      ^    g    
	SYSTEM
	,Display,Log,Texts
	,arguments,complex,coroutine,earthCoord,log,mathFunctions,socket,string; 8       8   #   Syntax10.Scn.Fnt  _    _   
	connection:socket.ConnectionPtr;
	coroutineArray:ARRAY 4 OF CoroutinePtr;
	testCount:LONGINT; 8   <    8   #   Syntax10.Scn.Fnt       
VAR
	count:INTEGER;
	r,g,b:INTEGER;
	r0,g0,b0:INTEGER;
	this:CoroutinePtr;
	timer:coroutine.TimerPtr;
BEGIN
	this:=self(CoroutinePtr);
	Display.GetColor(this.color,r0,g0,b0);
	r:=r0; g:=g0; b:=b0;
	FOR count:=1 TO this.iterations DO
		r:=(r+this.rStep) MOD 256;
		g:=(g+this.gStep) MOD 256;
		b:=(b+this.bStep) MOD 256;
		Display.SetColor(this.color,r,g,b);
		coroutine.newTimer(timer,this.delay);
		coroutine.wait();
	END;
	Display.SetColor(this.color,r0,g0,b0);
END coroutineProcedure; 8      Syntax10b.Scn.Fnt          8      8   :    8   #   Syntax10.Scn.Fnt  B   B  
TYPE
	Buffer=ARRAY 400 OF CHAR;
VAR
	actual:LONGINT;
	buffer:Buffer;
BEGIN
	socket.read(connection,buffer,SIZE(Buffer)-1,actual);
	Log.Str("Received "); Log.Int(actual); Log.Str(" byte"); Log.Ln;
	IF actual=0 THEN
		socket.disconnect(connection);
	ELSE
		buffer[actual]:=0X;
		Log.Str(buffer); Log.Ln;
	END;
END receiver; 8               8   #   Syntax10.Scn.Fnt  G    G   
BEGIN
	socket.connect(connection,127,0,0,1,21,receiver);
END tcpStart; 8               8   #   Syntax10.Scn.Fnt  3    3   
BEGIN
	socket.disconnect(connection);
END tcpStop; 8   &    78   C   Syntax10.Scn.Fnt  m   Syntax10b.Scn.Fnt             
BEGIN
	INC(testCount);
	IF ~assertion THEN Log.Str("Test"); Log.Int(testCount); Log.Str(" Failed"); Log.Ln; HALT(44); END;
END Assert; 8       8   #   Syntax10.Scn.Fnt       
BEGIN
	Assert(string.match("abcdef","abcdef")=TRUE);
	Assert(string.match("abcdefg","abcdef")=FALSE);
	Assert(string.match("abcde","abcdef")=FALSE);
	Assert(string.match("","")=TRUE);
	Assert(string.match("","a")=FALSE);
	
	Assert(string.match("a","")=FALSE);
	Assert(string.match("a","a")=TRUE);
	Assert(string.match("b","a")=FALSE);
	Assert(string.match("abcdef","abc*")=TRUE);
	Assert(string.match("abcd","abc*")=TRUE);
	
	Assert(string.match("abc","abc*")=TRUE);
	Assert(string.match("ab","abc*")=FALSE);
	Assert(string.match("abd","abc*")=FALSE);
	Assert(string.match("abde","abc*")=FALSE);
	Assert(string.match("","a*")=FALSE);
	
	Assert(string.match("a","a*")=TRUE);
	Assert(string.match("b","a*")=FALSE);
	Assert(string.match("abcdef","")=FALSE);
	Assert(string.match("def","*def")=TRUE);
	Assert(string.match("cdef","*def")=TRUE);
	
	Assert(string.match("ef","*def")=FALSE);
	Assert(string.match("cef","*def")=FALSE);
	Assert(string.match("bcef","*def")=FALSE);
	Assert(string.match("abcdef","a*f")=TRUE);
	Assert(string.match("af","a*f")=TRUE);
	
	Assert(string.match("ab","a*f")=FALSE);
	Assert(string.match("bf","a*f")=FALSE);
	Assert(string.match("abf","a*f")=TRUE);
	Assert(string.match("","a*f")=FALSE);
	Assert(string.match("a","a*f")=FALSE);
	
	Assert(string.match("f","a*f")=FALSE);
	Assert(string.match("abcdef","a**f")=TRUE);
	Assert(string.match("af","a**f")=TRUE);
	Assert(string.match("ab","a**f")=FALSE);
	Assert(string.match("bf","a**f")=FALSE);
	
	Assert(string.match("abf","a**f")=TRUE);
	Assert(string.match("","a**f")=FALSE);
	Assert(string.match("a","a**f")=FALSE);
	Assert(string.match("f","a**f")=FALSE);
	Assert(string.match("abcdefghijklmn","***abc*def*hi**kl**m***")=TRUE);

	Assert(string.match("abdefghijklmn","***abc*def*hi**kl**m***")=FALSE);
	Assert(string.match("abcdfghijklmn","***abc*def*hi**kl**m***")=FALSE);
	Assert(string.match("abcdefghjklmn","***abc*def*hi**kl**m***")=FALSE);
	Assert(string.match("abcdefghijkl","***abc*def*hi**kl**m***")=FALSE);
	Assert(string.match("bcdefghijklmn","***abc*def*hi**kl**m***")=FALSE);

	Assert(string.match("abxyabccdefghijklmn","***abc*def*hi**kl**m***")=TRUE);
	Assert(string.match("abxybcdefghijklmn","***abc*def*hi**kl**m***")=FALSE);

END stringMatch; 8   !    W8   #   Syntax10.Scn.Fnt         
VAR
	a:complex.T;
BEGIN
	a.re:=re;
	a.im:=im;
	Log.Int(re);
	Log.Int(im);
	log.realFix(SHORT(complex.arg(a)),10,3);
	Log.Ln;
END test; 8               U8   #   Syntax10.Scn.Fnt         
BEGIN
	test(0,0);
	test(1,0);
	test(1,1);
	test(0,1);
	test(-1,1);
	test(-1,0);
	test(-1,-1);
	test(0,-1);
	test(1,-1);
END complexTest; 8       	        d8   #   Syntax10.Scn.Fnt  z    z   
BEGIN
	testCount:=0;
	stringMatch;
	Log.Str("Passed all"); Log.Int(testCount); Log.Str(" tests."); Log.Ln;
END stringAll; 8               -8   #   Syntax10.Scn.Fnt         
To test the Arguments module try these:

	Arguments.test
	Arguments.test *
	Arguments.test ^
	Arguments.test @
	Arguments.test hello world ~
	Arguments.test ~
	Arguments.test

 8       8      Syntax10.Scn.Fnt     8  FoldElems New  #   Syntax10.Scn.Fnt  ;    ;    Consider only parameters on the same line as the command.  8        
CONST
	watchLimit=5;
VAR
	arg:arguments.T;
	quit:BOOLEAN;
	watch:SHORTINT;
BEGIN
	arguments.init(arg);
	Log.Str("Called from ");
	CASE arg.type OF
	| arguments.menu: Log.Str(" menu.");
	| arguments.marked: Log.Str(" some viewer, using visibly marked viewer.");
	| arguments.unknown: Log.Str(" some viewer, no visibly marked viewer.");
	| arguments.end: Log.Str(" the twilight zone..");
	ELSE
		Log.Str("Unkown type "); Log.Int(arg.type);
	END;
	Log.Ln;
	Log.Str("name="); Log.Str(arg.name);
	Log.Str(" viewer="); Log.Hex(SYSTEM.VAL(LONGINT,arg.viewer));
	Log.Str(" frame="); Log.Hex(SYSTEM.VAL(LONGINT,arg.frame));
	Log.Str(" text="); Log.Hex(SYSTEM.VAL(LONGINT,arg.text));
	Log.Str(" scanner="); Log.Hex(SYSTEM.VAL(LONGINT,arg.scanner));
	Log.Ln; 
	watch:=0;
	quit:=FALSE;
	REPEAT
		arguments.next(arg);
		IF arg.type=arguments.end THEN
			Log.Str("No more parameter"); Log.Ln;
			quit:=TRUE;
		ELSIF arg.scanner.line>0 THEN (**)
			Log.Str("No more parameter on same line."); Log.Ln;
			quit:=TRUE;
		ELSE
			CASE arg.type OF
			| arguments.parameter:
				Log.Str("Have to scan yourself.");
				Log.Int(arg.scanner.line);
				Log.Int(arg.scanner.class);
				CASE arg.scanner.class OF
				| Texts.Inval: Log.Str(" = invalid: ");
				| Texts.Name: Log.Str(" = name: "); Log.Str(arg.scanner.s);
				| Texts.String: Log.Str(" = string: "); Log.Str(arg.scanner.s);
				| Texts.Int: Log.Str(" = integer: "); Log.Int(arg.scanner.i);
				| Texts.Real: Log.Str(" = real: "); Log.Real(arg.scanner.x);
				| Texts.LongReal: Log.Str(" = long real: "); Log.Real(arg.scanner.y);
				| Texts.Char: Log.Str(" = character: "); Log.Ch(arg.scanner.c); Log.Int(ORD(arg.scanner.c));
				END;
				Log.Ln;
			| arguments.star:
				Log.Str("A marked viewer, viewer="); Log.Hex(SYSTEM.VAL(LONGINT,arg.viewer));
				Log.Str(" text=");  Log.Hex(SYSTEM.VAL(LONGINT,arg.text));
			| arguments.at:
				Log.Str("@ so get the selection using getSelectionText or getSelectionScanner."); ;
			| arguments.arrow:
				Log.Str("^ so scanner was changed. Proceed with next.");
			ELSE
				Log.Str("unknown type="); Log.Int(arg.type);
				quit:=TRUE;
			END;
			Log.Ln;
			INC(watch);
			IF watch>=watchLimit THEN quit:=TRUE; END;
		END;
	UNTIL quit;
END argumentsExample; 8               8   #   Syntax10.Scn.Fnt       
VAR
	from,to:earthCoord.Location;
	loc:ARRAY 8 OF CHAR;
	p:earthCoord.Location;
	pos:earthCoord.LocationD;
BEGIN
	(* my own QTH *)
	earthCoord.setDeg(pos.long,8,43,0); earthCoord.setDeg(pos.lat,47,21,0);
	earthCoord.locator(pos,loc);
	Log.Str("Expected JN47II : "); Log.Str(loc); Log.Ln; 
	earthCoord.swissCoordToLocation(161860,541825,p);
	earthCoord.locationToDegree(p,pos);
	earthCoord.locator(pos,loc);
	Log.Str("Expected JN36IO : "); Log.Str(loc); Log.Ln;
	from.lat:=mathFunctions.degToRad(47.4166); from.long:=mathFunctions.degToRad(9.333);
	to.lat:=mathFunctions.degToRad(46.1666); to.long:=mathFunctions.degToRad(6.0833);
	Log.Str("Expected 283.7 : "); Log.Real(earthCoord.distanz(from,to)); Log.Ln;
END earthCoordTest; 8   
    J  MODULE test; (**)	

IMPORT

TYPE
	Coroutine=RECORD (coroutine.Coroutine)
		color:INTEGER;
		delay:LONGINT;
		rStep,gStep,bStep:INTEGER;
		iterations:INTEGER;
	END;
	CoroutinePtr=POINTER TO Coroutine;

VAR

PROCEDURE coroutineProcedure(self:coroutine.CoroutinePtr);

PROCEDURE coroutineExample*;
VAR
	i:INTEGER;
BEGIN
	FOR i:=0 TO 1 DO
		NEW(coroutineArray[i]); 
		CASE i OF
		| 0:
			coroutineArray[i].color:=0;
			coroutineArray[i].rStep:=16;
			coroutineArray[i].gStep:=0;
			coroutineArray[i].bStep:=0;
		| 1:
			coroutineArray[i].color:=15;
			coroutineArray[i].rStep:=0;
			coroutineArray[i].gStep:=16;
			coroutineArray[i].bStep:=0;
		| 2:
			coroutineArray[i].color:=13;
			coroutineArray[i].rStep:=0;
			coroutineArray[i].gStep:=0;
			coroutineArray[i].bStep:=16;
		END;
		coroutineArray[i].delay:=300*(i+1);
		coroutineArray[i].iterations:=SHORT(LONG(10*1000) DIV coroutineArray[i].delay);
		coroutine.initCoroutine(coroutineArray[i],-10,coroutineProcedure,20000);
	END;
END coroutineExample;

PROCEDURE receiver(VAR connection:socket.ConnectionPtr);

PROCEDURE tcpStart*;

PROCEDURE tcpStop*;

PROCEDURE Assert(assertion:BOOLEAN);

PROCEDURE stringMatch;
	
PROCEDURE test(re,im:INTEGER);

PROCEDURE complexTest*;

PROCEDURE stringAll*;

PROCEDURE argumentsExample*; (**)

PROCEDURE earthCoordTest*;

END test.

