  Syntax10.Scn.Fnt        InfoElems Alloc  #   Syntax10.Scn.Fnt  ?   ?  "Title": Conversions between different color models (RGB, HLS, HSV, YIQ).
"Copyright": 1996, 1997 by Claudio Nieder <claudio@dial.eunet.ch>.

	This module is free software; you can redistribute it and/or modify it under the terms of the GNU
	Library General Public License as published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License along with this library;
	if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 #   Syntax10b.Scn.Fnt           8  FoldElems New  #   Syntax10.Scn.Fnt         
(*
	Translated from the pseudocode version found in
	 J.D. Foley, A. van Dam "Fundamentals of Interactive Computer Graphics",.
*)
BEGIN
	y:=0.30*r+0.59*g+0.11*b;
	i:=0.60*r-0.28*g-0.32*b;
	q:=0.21*r-0.52*g+0.31*b;
END rgbToYIQ;
 8                8   #   Syntax10.Scn.Fnt         
(*
	Translated from the pseudocode version found in
	 J.D. Foley, A. van Dam "Fundamentals of Interactive Computer Graphics".
*)
BEGIN
	r:=0.99*y+0.96*i+0.61*q;
	g:=1.01*y-0.28*i-0.63*q;
	b:=0.98*y-1.09*i+1.70*q;
END yiqToRGB;
 8                
8   #   Syntax10.Scn.Fnt       
(*
	Translated from the pseudocode version found in
	 J.D. Foley, A. van Dam "Fundamentals of Interactive Computer Graphics",
	 and modified, to have h in [0..1) range instead of [0..360).
*)
VAR
	min,max,rc,gc,bc:Float;
BEGIN
	max:=r; IF g>max THEN max:=g; END; IF b>max THEN max:=b; END;
	min:=r; IF g<min THEN min:=g; END; IF b<min THEN min:=b; END;
	v:=max;
	IF max#0.0D0 THEN s:=(max-min)/max ELSE s:=0.0D0; END;
	IF s=0.0D0 THEN
		h:=0.0D0; (* really undefined *)
	ELSE
		rc:=(max-r)/(max-min);
		gc:=(max-g)/(max-min);
		bc:=(max-b)/(max-min);
		IF r=max THEN h:=bc-gc;
		ELSIF g=max THEN h:=2.0D0+rc-bc;
		ELSIF b=max THEN h:=4.0D0+gc-rc;
		END;
		h:=h/6.0D0;
		IF h<0.0D0 THEN h:=h+1.0D0; END;
	END;
END rgbToHSV;
 8                d8   #   Syntax10.Scn.Fnt  z   z  
(*
	Translated from the pseudocode version found in
	 J.D. Foley, A. van Dam "Fundamentals of Interactive Computer Graphics",
	 and modified, to have h in [0..1) range instead of [0..360).
*)
VAR
	i:INTEGER;
	f,p,q,t:Float;
BEGIN
	IF s=0.0D0 THEN	(* ignore h *)
		r:=v;
		g:=v;
		b:=v;
	ELSE
		IF h=1.0D0 THEN h:=0.0D0; END;
		h:=h*6.0D0;
		i:=SHORT(ENTIER(h));
		f:=h-i;
		p:=v*(1.0D0-s);
		q:=v*(1.0D0-s*f);
		t:=v*(1.0D0-s*(1.0D0-f));
		CASE i OF
		| 0 : r:=v; g:=t; b:=p;
		| 1 : r:=q; g:=v; b:=p;
		| 2 : r:=p; g:=v; b:=t;
		| 3 : r:=p; g:=q; b:=v;
		| 4 : r:=t; g:=p; b:=v;
		| 5 : r:=v; g:=p; b:=q;
		END;
	END;
END hsvToRGB;
 8                8   #   Syntax10.Scn.Fnt       
(*
	Translated from the pseudocode version found in
	 J.D. Foley, A. van Dam "Fundamentals of Interactive Computer Graphics",
	 and modified, to have h in [0..1) range instead of [0..360).
*)
VAR
	m1,m2:Float;
	PROCEDURE value(n1,n2,hue:Float):Float;
	(* hue=6*h *)
	VAR
		i:INTEGER;
	BEGIN
		IF hue>=6.0D0 THEN hue:=hue-6.0D0; END;
		IF hue<0.0D0 THEN hue:=hue+6.0; END;
		i:=SHORT(ENTIER(hue));
		CASE i OF
		| 0:  RETURN n1+(n2-n1)*hue;
		| 1,2: RETURN n2;
		| 3: RETURN n1+(n2-n1)*(4.0D0-hue);
		| 4,5: RETURN n1;
		END;
	END value;

BEGIN
	h:=h*6.0D0;
	IF l<=0.5D0 THEN m2:=l*(1.0D0+s) ELSE m2:=l*(1.0D0-s)+s; END;
	m1:=2.0D0*l-m2;
	IF s=0.0D0 THEN (* ignore h *)
		r:=l; g:=l; b:=l;
	ELSE
		r:=value(m1,m2,h+2.0D0);
		g:=value(m1,m2,h);
		b:=value(m1,m2,h-2.0D0);
	END;
END hlsToRGB;
 8                8   #   Syntax10.Scn.Fnt       
(*
	Translated from the pseudocode version found in
	 J.D. Foley, A. van Dam "Fundamentals of Interactive Computer Graphics",
	 and modified, to have h in [0..1) range instead of [0..360).
*)
VAR
	min,max,rc,gc,bc:Float;
BEGIN
	max:=r; IF g>max THEN max:=g; END; IF b>max THEN max:=b; END;
	min:=r; IF g<min THEN min:=g; END; IF b<min THEN min:=b; END;
	l:=(max+min)/2.0D0;
	IF max=min THEN
		s:=0.0D0;
		h:=0.0D0; (* really undefined *)
	ELSE
		IF l<=0.5D0 THEN s:=(max-min)/(max+min) ELSE s:=(max-min)/(2.0D0-max-min); END;
		rc:=(max-r)/(max-min);
		gc:=(max-g)/(max-min);
		bc:=(max-b)/(max-min);
		IF r=max THEN h:=bc-gc
		ELSIF g=max THEN h:=2.0D0+rc-bc
		ELSIF b=max THEN h:=4.0D0+gc-rc;
		END;
		h:=h/6.0D0; IF h<0.0D0 THEN h:=h+1.0D0; END;
	END;
END rgbToHLS;
 8         MODULE colorModels; 

TYPE
	Float=LONGREAL;

PROCEDURE rgbToYIQ*(r,g,b:Float; VAR y,i,q:Float);
PROCEDURE yiqToRGB*(y,i,q:Float; VAR r,g,b:Float);

PROCEDURE rgbToHSV*(r,g,b:Float; VAR h,s,v:Float);
PROCEDURE hsvToRGB*(h,s,v:Float; VAR r,g,b:Float);

PROCEDURE hlsToRGB*(h,l,s:Float; VAR r,g,b:Float);
PROCEDURE rgbToHLS*(r,g,b:Float; VAR h,l,s:Float);

END colorModels.