a  Syntax10.Scn.Fnt  
      InfoElems Alloc  #   Syntax10.Scn.Fnt  E   E  "Title": Computations on dates in the range of 1 March 1900 - 28 February 2100.
"Copyright": 1996, 1997 by Claudio Nieder <claudio@dial.eunet.ch>.

	This module is free software; you can redistribute it and/or modify it under the terms of the GNU
	Library General Public License as published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License along with this library;
	if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
     8  FoldElems New  #   Syntax10.Scn.Fnt         
	refYear=1900;
	(*
		With dayOffset, you can adjust, which day shall get day number 0. 
		dayOffset=0 makes the 1. March 1900 have day 0.
		dayOffset=31 makes the 1. April 1900 have day 0.
	*)
	dayOffset=0; 8   
   Syntax10b.Scn.Fnt  
    ,    +8   #   Syntax10.Scn.Fnt         
BEGIN
	DEC(month,3);
	IF month<0 THEN DEC(year); INC(month,12); END;
	DEC(year,refYear);
	days:=(day-1)+((LONG(year)*1461) DIV 4)+((month*153+2) DIV 5)-dayOffset;
END dateToDays; 8       
    ,    8   #   Syntax10.Scn.Fnt       
BEGIN
	days:=days+dayOffset;
	year:=SHORT((4*days+3) DIV 1461);
	DEC(days,1461*LONG(year) DIV 4);
	INC(year,refYear);
	month:=SHORT((5*days+2) DIV 153);
	day:=SHORT(days-(153*month+2) DIV 5 +1);
	INC(month,3);
	IF month>12 THEN DEC(month,12); INC(year); END;
END daysToDate; 8          MODULE date; 

CONST
	
PROCEDURE dateToDays*(day,month,year:INTEGER; VAR days:LONGINT);

PROCEDURE daysToDate*(days:LONGINT; VAR day,month,year:INTEGER);

END date.