l
  Syntax10.Scn.Fnt         Syntax10b.Scn.Fnt    InfoElems Alloc  #   Syntax10.Scn.Fnt  6   6  "Title": Digital clock and current directory display as element.
"Copyright": 1996, 1997 by Claudio Nieder <claudio@dial.eunet.ch>.

	This module is free software; you can redistribute it and/or modify it under the terms of the GNU
	Library General Public License as published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License along with this library;
	if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   HistoryElems Alloc History #   Syntax10.Scn.Fnt  O    O   "1998-06-27	private@claudio.ch"
Changed background into free memory bar graph

     8  FoldElems New       ParcElems Alloc c%       s       8           8   e    8       8                   8       8           !    
        8       8   ,    8   A    8       8   )    8               +        )        8           8   '    8       8   s    8           +    8      8       
    +    8      8       
    7    8      8           2    8   9    8           #    8               8       8   5    8           0    8       8   #    8   d   8   H    8      8           `    8      8           0    8       8           @    8       8           )    8               8       8            
    8           )    8               8       8                8   9        8       8       8   U    H    ^        J    m                       8               8   E    8                   8       M    8       8       ;    5    8                   8       +    8       8   7    M    Y    8                   8   k    8       8   )    8       8       L        8       `  MODULE dclockElems; 

(*

NOTE:	Elements are identified in texts by the name of the allocation procedure. To avoid problems, every time an incompatible change is made to an element, the name of the allocation procedure shold be changed. Even better, make a new module.
*)

IMPORT
	Display,Files,Fonts,Input,Kernel,Oberon,Printer,TextFrames,TextPrinter,Texts,Unix,Viewers
	,string;

CONST
	usedColor=7;	(* dark red *)
	freeColor=8;	(* dark green *)

TYPE
	Element*=RECORD (Texts.ElemDesc)
	END;
	ElementPtr*=POINTER TO Element;
	Frame=RECORD (Display.FrameDesc)
		col:INTEGER;
		fnt:Fonts.Font;
		dy:INTEGER;
	END;
	FramePtr=POINTER TO Frame;
	TickMsg=RECORD (Display.FrameMsg) END;

VAR
	task:Oberon.Task;
	text:ARRAY 200 OF CHAR;

PROCEDURE put(VAR s:ARRAY OF CHAR; start,digits,value:LONGINT);
VAR
	i:LONGINT;
BEGIN
	INC(start,digits);
	FOR i:=0 TO digits-1 DO
		DEC(start);
		s[start]:=CHR(ORD('0')+value MOD 10);
		value:=value DIV 10;
	END;
END put;

PROCEDURE setText(VAR s:ARRAY OF CHAR);
CONST
	maxCWD=25;
VAR
	d:LONGINT;
	len:LONGINT;
	pwd:ARRAY 256 OF CHAR;
	t:LONGINT;
BEGIN
	s[4]:="-"; s[7]:="-"; s[10]:=" "; s[13]:=":"; s[16]:=":";
	(*
		Note: GetClock doesn't return the century!
	*)
	Oberon.GetClock(t,d);
	put(s,0,4,(d DIV 512));
	put(s,5,2,d DIV 32 MOD 16);
	put(s,8,2,d MOD 32);
	put(s,11,2,t DIV 4096);
	put(s,14,2,t DIV 64 MOD 64);
	put(s,17,2,t MOD 64);
	s[19]:=0X;
	Unix.Getwd(pwd);
	len:=string.length(pwd);
	IF len>maxCWD THEN	(* Directory too long to display fully *)
		string.delete(pwd,0,len-maxCWD+3);
		string.insert(pwd,'...',0);
	END;
	string.append(s,' ');
	string.append(s,pwd);
END setText;

PROCEDURE ticker; (*

	Send a tick message every second.
	
*)
VAR
	msg:TickMsg;
BEGIN
	task.time:=task.time+Input.TimeUnit;
	setText(text);
	Viewers.Broadcast(msg);
END ticker;

PROCEDURE displayWidth*(fnt:Fonts.Font; s:ARRAY OF CHAR):LONGINT;
VAR
	ch: CHAR;
	dx,x,y,w,h:INTEGER;
	i:INTEGER;
	pat:Display.Pattern;
	width:INTEGER;
BEGIN
	width:=0;
	i:=0;
	ch:=s[i];
	WHILE ch#0X DO
		Display.GetChar(fnt.raster,ch,dx,x,y,w,h,pat);
		INC(width,dx);
		INC(i);
		ch:=s[i];
	END;
	RETURN LONG(width)*TextFrames.Unit;
END displayWidth;

PROCEDURE printWidth*(fnt:Fonts.Font; s:ARRAY OF CHAR):LONGINT;
VAR
	ch: CHAR;
	dx,x,y,w,h:LONGINT;
	fno:SHORTINT;
	i:INTEGER;
	width:LONGINT;
BEGIN
	width:=0;
	fno:=TextPrinter.FontNo(fnt);
	i:=0;
	ch:=s[i];
	WHILE ch#0X DO
		TextPrinter.Get(fno,ch,dx,x,y,w,h);
		INC(width,dx);
		INC(i);
		ch:=s[i];
	END;
	RETURN width;
END printWidth;

PROCEDURE displayString*(fnt: Fonts.Font; s:ARRAY OF CHAR; col,x0,y0:INTEGER);
VAR
	ch: CHAR;
	dx,x,y,w,h:INTEGER;
	i:INTEGER;
	pat:Display.Pattern;
BEGIN
	i:=0;
	ch:=s[i];
	WHILE ch#0X DO
		Display.GetChar(fnt.raster,ch,dx,x,y,w,h,pat);
		Display.CopyPattern(col,pat,x0+x,y0+y,Display.paint);
		INC(x0,dx);
		INC(i);
		ch:=s[i];
	END
END displayString;

PROCEDURE printString*(fnt:Fonts.Font; s:ARRAY OF CHAR; x0,y0:INTEGER);
BEGIN
	Printer.String(x0,y0,s,fnt.name)
END printString;

PROCEDURE copy*(source,destination:ElementPtr);(*

	Copy the element data.CopyElem does the basics.
	This code has to copy all additionals fields, and store
	the created copy into the message.

*)
BEGIN
	Texts.CopyElem(source,destination);
END copy;

PROCEDURE prepareDraw*(e:ElementPtr; fnt:Fonts.Font; VAR dy:INTEGER);
BEGIN
	e.W:=displayWidth(fnt,text);
	e.H:=LONG(fnt.height)*TextFrames.Unit;
	dy:=fnt.minY;
	(*IF dy>-2 THEN dy:=-2; END;*)
END prepareDraw;

PROCEDURE drawIt(frame:FramePtr);
VAR
	wFree:INTEGER;
BEGIN
	wFree:=SHORT(((Kernel.Available() DIV 1000)*frame.W) DIV (Kernel.heapSize DIV 1000));
	Display.ReplConst(freeColor,frame.X,frame.Y,frame.W,frame.H,Display.replace);
	Display.ReplConst(usedColor,frame.X,frame.Y,frame.W-wFree,frame.H,Display.replace);
	displayString(frame.fnt,text,frame.col,frame.X,frame.Y+frame.dy);
END drawIt;

PROCEDURE frameHandler(frame:Display.Frame; VAR msg:Display.FrameMsg);
VAR
	vmsg:Viewers.ViewerMsg;
	wFree:INTEGER;
BEGIN
	WITH msg:TickMsg DO
		WITH frame:FramePtr DO
			drawIt(frame);
			IF frame.W#SHORT(displayWidth(frame.fnt,text) DIV TextFrames.Unit) THEN
				frame.W:=SHORT(displayWidth(frame.fnt,text) DIV TextFrames.Unit);
				vmsg.id:=Viewers.suspend;
				Viewers.Broadcast(vmsg);
				vmsg.id:=Viewers.restore;
				Viewers.Broadcast(vmsg);
			END;
		ELSE
		END;
	ELSE
	END;
END frameHandler;

PROCEDURE draw*(e:ElementPtr; pos:LONGINT; fnt:Fonts.Font; col,x0,y0:INTEGER; VAR elementFrame:Display.Frame);
VAR
	beg:LONGINT;
	frame:FramePtr;
	parc:TextFrames.Parc;
	w,h,dy:INTEGER;
BEGIN
	w:=SHORT(e.W DIV TextFrames.Unit);
	h:=SHORT(e.H DIV TextFrames.Unit);
	TextFrames.ParcBefore(Texts.ElemBase(e),pos,parc,beg);
	dy:=SHORT(parc.dsr DIV TextFrames.Unit);
	NEW(frame);
	frame.X:=x0;
	frame.Y:=y0;
	frame.W:=w;
	frame.H:=h;
	frame.handle:=frameHandler;
	frame.col:=col;
	frame.fnt:=fnt;
	frame.dy:=dy;
	drawIt(frame);
	elementFrame:=frame;
END draw;

PROCEDURE preparePrint*(e:ElementPtr; fnt:Fonts.Font; VAR dy:INTEGER);
BEGIN
	e.W:=printWidth(fnt,text);
	e.H:=LONG(fnt.height)*TextPrinter.Unit;
	dy:=SHORT(LONG(fnt.minY)*TextFrames.Unit DIV TextPrinter.Unit);
	IF dy>-2 THEN dy:=-2; END;
END preparePrint;

PROCEDURE print*(e:ElementPtr; pos:LONGINT; fnt:Fonts.Font; col,x0,y0:INTEGER);
VAR
	beg:LONGINT;
	parc:TextFrames.Parc;
BEGIN
	TextFrames.ParcBefore(Texts.ElemBase(e),pos,parc,beg);
	INC(y0,SHORT(parc.dsr DIV TextPrinter.Unit));
	printString(fnt,text,x0,y0);
	e.W:=displayWidth(fnt,text);
END print;

PROCEDURE load*(e:ElementPtr; VAR rider:Files.Rider);(*

	Load element state.

*)
BEGIN
	(* No state, nothing to load. *)
END load;

PROCEDURE store*(e:ElementPtr; VAR rider:Files.Rider);(*

	Store element state.

*)
BEGIN
	(* No state, nothing to load. *)
END store;

PROCEDURE handle(e:Texts.Elem; VAR msg:Texts.ElemMsg); (*

	Handle element messages.

*)
VAR
	newElement:ElementPtr;
BEGIN
	WITH e:ElementPtr DO
		WITH msg:Texts.CopyMsg DO
			(*
				Create a copy of itself upon reception of this message.
			*)
			NEW(newElement);
			copy(e,newElement);
			msg.e:=newElement;
		| msg:Texts.IdentifyMsg DO
			(*
				Return the name of my allocation procedure.
				This is name is stored in texts, so that on loading,
				the procedure can be called to recreate the element.
			*)
			msg.mod:="dclockElems";
			msg.proc:="alloc";
		| msg:Texts.FileMsg DO
			(*
				Just for completeness, although this particular element
				doesn't load and store any data.
			*)
			IF msg.id = Texts.load THEN load(e, msg.r)
			ELSIF msg.id = Texts.store THEN store(e, msg.r)
			END
		| msg:TextFrames.DisplayMsg DO
			IF msg.prepare THEN prepareDraw(e,msg.fnt,msg.Y0);
			ELSE draw(e,msg.pos,msg.fnt,msg.col,msg.X0,msg.Y0,msg.elemFrame);
			END;
		| msg:TextPrinter.PrintMsg DO
			IF msg.prepare THEN preparePrint(e,msg.fnt,msg.Y0);
			ELSE print(e,msg.pos,msg.fnt,msg.col,msg.X0,msg.Y0);
			END;
		ELSE (* some other message *)
		END;
	ELSE (* not my element *)
	END;
END handle;

PROCEDURE open*(e:ElementPtr);
BEGIN
	e.W:=5*TextFrames.mm;
	e.H:=e.W;
	e.handle:=handle;
END open;

PROCEDURE alloc*; (*
	
	This procedure is called when a text is read, that
	contains my element.

*)
VAR
	e:ElementPtr;
BEGIN
	(*
		Just create the element and install its handler.
	*)
	NEW(e);
	e.handle:=handle;
	Texts.new:=e;
END alloc;

PROCEDURE insert*; (*
	
	The command used to insert an element.

*)
VAR
	e:ElementPtr;
	M:TextFrames.InsertElemMsg;
BEGIN
	(*
		Create the element, and send the focus viewer
		an insert message.
	*)
	NEW(e);
	open(e);
	M.e:=e;
	Oberon.FocusViewer.handle(Oberon.FocusViewer,M);
END insert;

PROCEDURE expunge*; (*

	This procedure is called by sys.free, so we get a chance to
	remove things which reference module code

*)
BEGIN
	Oberon.Remove(task);
END expunge;

BEGIN
	(*
		Insert a task which generates a 'tick' message once every second.
	*)
	setText(text);
	NEW(task);
	task.safe:=FALSE;
	task.handle:=ticker;
	task.time:=Input.Time()+Input.TimeUnit;
	Oberon.Install(task);
END dclockElems.