  Syntax10.Scn.Fnt      8  FoldElems New  ?  Syntax10.Scn.Fnt        StyleElems Alloc   Paragraph  @        Paragraph          Paragraph          Paragraph      s  ParcElems Alloc            
Directory related procedures.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
 8   
    8      Syntax10b.Scn.Fnt          8   8    
                            4                    	    
    8                                                                           2    8           1    n8   #   Syntax10.Scn.Fnt  p    p   

	Return file1 is <result> than file2. E.g. if it returns older, this means, that
	file1 is older than file2.

 8       8   _   Syntax10.Scn.Fnt  B   Syntax10b.Scn.Fnt      F                       
BEGIN
	IF fileInfo1.lastModified.t<fileInfo2.lastModified.t THEN RETURN older;
	ELSIF fileInfo1.lastModified.t=fileInfo2.lastModified.t THEN RETURN equal;
	ELSE RETURN newer;
	END;
END compareDate; 8           @    8      8           K    8   x       m           8   3    @  MODULE directory; (**)

IMPORT
	SYSTEM
	,Log,Unix
	,types;
	
(*enum: CompareResult*=(older,equal,newer); *)
TYPE
	CompareResult*=SHORTINT;
CONST
	older*=0; equal*=1; newer*=2;

(*enum: FileType*=(plain,directory); *)
TYPE
	FileType*=SHORTINT;
CONST
	plain*=0; directory*=1;

TYPE
	Time*=RECORD
		t:LONGINT;
	END;
	FileInfo*=RECORD
		name*:types.FileName;
		type*:FileType;
		lastModified*:Time;
	END;
	DirectoryEntryPtr*=POINTER TO DirectoryEntry;
	DirectoryEntry*=RECORD
		name*:types.FileName;
	END;
	DirectoryProcedure*=PROCEDURE(VAR directoryEntry:DirectoryEntryPtr);

PROCEDURE compareDate*(fileInfo1,fileInfo2:FileInfo):CompareResult; (**)

PROCEDURE getFileInfo*(name:types.FileName; VAR fileInfo:FileInfo; VAR done:BOOLEAN);
VAR
	status:Unix.Status;
BEGIN
	Unix.Stat(SYSTEM.ADR(name),status);
	done:=Unix.Done();
	IF done THEN
		fileInfo.name:=name;
		fileInfo.lastModified.t:=status.mtime;
		IF ODD(status.mode DIV 4000H) THEN fileInfo.type:=directory; ELSE fileInfo.type:=plain; END;
	END;
END getFileInfo;

PROCEDURE forAll*(directoryProcedure:DirectoryProcedure; directoryEntry:DirectoryEntryPtr);
TYPE
	Buffer=ARRAY 1000 OF CHAR;
	DirEntry=RECORD
		inode:LONGINT;
		offset:LONGINT;
		recordLength:INTEGER;
		name:types.FileName;
	END;
	DirEntryPtr=POINTER TO DirEntry;
VAR
	buf:Buffer;
	dirName:ARRAY 3 OF CHAR;
	dirPtr:DirEntryPtr;
	done:BOOLEAN;
	fd:LONGINT;
	length:INTEGER;
BEGIN
	dirName:=".";
	fd:=Unix.Open(SYSTEM.ADR(dirName),Unix.rdonly,{});
	done:=Unix.Done();
	ASSERT(done & (fd>=0));
	LOOP
		length:=SHORT(Unix.Getdents(fd,SYSTEM.ADR(buf),SIZE(Buffer)));
		IF length<=0 THEN EXIT; END;
		dirPtr:=SYSTEM.VAL(DirEntryPtr,SYSTEM.ADR(buf));
		WHILE (dirPtr#NIL) & (length>=10) DO
			IF dirPtr.recordLength>0 THEN
				COPY(dirPtr.name,directoryEntry.name);
				Log.Ch(".");
				directoryProcedure(directoryEntry);
				dirPtr:=SYSTEM.VAL(DirEntryPtr,SYSTEM.VAL(LONGINT,dirPtr)+dirPtr.recordLength);
				DEC(length,dirPtr.recordLength);
			ELSE
				length:=0;
			END;
		END;
	END;
	Unix.Close(fd);
	done:=Unix.Done();
END forAll;

PROCEDURE expunge*;
END expunge;

END directory.
