9  Syntax10.Scn.Fnt      8  FoldElems New       Z   StyleElems Alloc   Paragraph  [     Z     Paragraph       Z     Paragraph       Z     Paragraph      s  ParcElems Alloc          8   
    8   \        8       8       8   >   8      8   7    8      8      Syntax10b.Scn.Fnt  
        8   H   8       8       /   8   G    8      8               8   +   Syntax10i.Scn.Fnt  
        
    "    8       8       8   M    8      8               8   x    8       8       8   :    8   W    8               8   +    
        
    G    8       8   K   8       
        8   3    8       8      8       
        8   +    8       8      8               8   ,    8       8      8   3    "  MODULE distribute; (*
Commands for generating my kind of program distribution.
Copyright (C) 1996 Claudio Nieder
This module is free software; you can redistribute it and/or modify it under the terms of the GNU Library General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public License along with this library; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*)

IMPORT
	AsciiCoder,Cmd,Files,Log,TextFrames,Texts
	,arguments,avlString,dataTypes,directory,string,w;

CONST
	copyrightFileName="copyright.PD.Text";
	overviewFileName="claudio.PD.Text";
	readmeFileName="claudio.readme";
	signatureFileName="signature.PD.Text";

TYPE
	DirectoryEntryPtr=POINTER TO DirectoryEntry;
	DirectoryEntry=RECORD (directory.DirectoryEntry)
		root:avlString.TreePtr;
	END;
	ParameterPtr=POINTER TO Parameter;
	Parameter=RECORD (arguments.Parameter)
		root:avlString.TreePtr;
	END;

PROCEDURE addEncoded(VAR text:Texts.Text; fileName:ARRAY OF CHAR):BOOLEAN;
VAR
	file:Files.File;
	ok:BOOLEAN;
	text2:Texts.Text;
	tmp:Files.File;
BEGIN
	tmp:=Files.New("");
	text2:=TextFrames.Text("");
	file:=Files.Old(fileName);
	ok:=file#NIL;
	IF ok THEN
		AsciiCoder.Compress(file,tmp); (* This produces a compressed file out of an uncompressed. *)
		AsciiCoder.Code(tmp,text2); (* This produces an encoded text out of a file. *)
		w.save(text2,0,text2.len);
		w.append(text);
	END;
	RETURN ok
END addEncoded;


PROCEDURE makeDist(parameter:arguments.ParameterPtr);
VAR
	count:LONGINT;
	err:BOOLEAN;
	fileName:dataTypes.FileName;
	hasTool:BOOLEAN;
	modName:dataTypes.FileName;
	ok:BOOLEAN;
	text,text2:Texts.Text;
	toolName:dataTypes.FileName;
BEGIN
	Log.Ln; Log.Str(parameter.name^);
	COPY(parameter.name^,fileName);
	string.append(fileName,".readme.Text");
	Log.Ln; Log.Str(" - "); Log.Str(fileName);
	text:=TextFrames.Text(fileName);
	IF (text=NIL) OR (text.len=0) THEN
		Log.Str(" not found."); Log.Ln;
	ELSE
		Log.Ln; Log.Str(" - "); Log.Str(copyrightFileName);
		text2:=TextFrames.Text(copyrightFileName);
		IF (text2=NIL) OR (text2.len=0) THEN
			Log.Str(" not found."); Log.Ln;
		ELSE
			w.ln; w.ln;
			w.save(text2,0,text2.len);
			w.ln; w.ln;
			w.append(text);
			COPY(parameter.name^,toolName);
			string.append(toolName,".Tool");
			hasTool:=Files.Old(toolName)#NIL;
			COPY(parameter.name^,modName);
			string.append(modName,".Mod");
			w.str("AsciiCoder.DecodeFiles %");
			IF hasTool THEN w.str(" claudio."); w.str(toolName); END;
			w.str(" claudio."); w.str(modName);
			w.str(" ~"); w.ln; w.ln; w.append(text);
			IF hasTool THEN
				Log.Ln; Log.Str(" - "); Log.Str(toolName);
				ok:=addEncoded(text,toolName);
				IF ~ok THEN
					Log.Str(" not found. (???)"); Log.Ln;
				END;
			END;
			Log.Ln; Log.Str(" - "); Log.Str(modName);
			ok:=addEncoded(text,modName);
			IF ~ok THEN
				Log.Str(" not found."); Log.Ln;
			ELSE
				Log.Ln; Log.Str(" - "); Log.Str(signatureFileName);
				text2:=TextFrames.Text(signatureFileName);
				IF (text2=NIL) OR (text2.len=0) THEN
					Log.Str(" not found."); Log.Ln;
				ELSE
					w.ln;
					w.save(text2,0,text2.len);
					w.append(text);
					COPY(parameter.name^,fileName);
					string.append(fileName,".distribution");
					Log.Ln; Log.Str(" + "); Log.Str(fileName);
					w.storeAscii(text,fileName,FALSE,count,err);
					IF err THEN Log.Str(" [unknown character codes found]"); END;
					Log.Int(count);
				END;
			END;
		END;
	END;
	Log.Ln;
END makeDist;

PROCEDURE distribute*; (*

	For each module name supplied takes the files modname.readme.Mod,
	modname.Mod, copyright.PD.Text and signature.Text, encodes modname.Mod
	and creates the ascii file modname.distribution. At the end creates
	claudio.readme out of claudio.PD.Text and signature.Text.
	
	If a modname.Tool exists, it is encoded and added too.

*)
VAR
	count:LONGINT;
	err:BOOLEAN;
	parameter:arguments.ParameterPtr;
	text,text2:Texts.Text;
BEGIN
	NEW(parameter);
	arguments.forEachName(makeDist,parameter);
	Log.Ln; Log.Str(readmeFileName);
	Log.Ln; Log.Str(" - "); Log.Str(overviewFileName);
	text:=TextFrames.Text(overviewFileName);
	IF (text=NIL) OR (text.len=0) THEN
		Log.Str(" not found."); Log.Ln;
	ELSE
		Log.Ln; Log.Str(" - "); Log.Str(signatureFileName);
		text2:=TextFrames.Text(signatureFileName);
		IF text2=NIL THEN
			Log.Str(" not found."); Log.Ln;
		ELSE
			w.ln; w.ln;
			w.save(text2,0,text2.len);
			w.append(text);
			Log.Ln; Log.Str(" + "); Log.Str(readmeFileName);
			w.storeAscii(text,readmeFileName,FALSE,count,err);
			IF err THEN Log.Str(" [unknown character codes found]"); END;
			Log.Int(count); Log.Ln;
		END;
	END;
END distribute;

PROCEDURE filterName(VAR directoryEntry:directory.DirectoryEntryPtr);
VAR
	ch:CHAR;
	i:LONGINT;
	node:avlString.NodePtr;
BEGIN
	ch:=directoryEntry.name[0];
	IF ('a'<=ch) & (ch<='z') THEN
		i:=0;
		REPEAT
			INC(i);
			ch:=CAP(directoryEntry.name[i]);
		UNTIL (ch<'0') OR ('9'<ch) & (ch<'A') OR ('Z'<ch);
		IF (i+4=string.length(directoryEntry.name)) & (string.compareParts(directoryEntry.name,'.Mod',i,0,4)=string.equal) THEN
			directoryEntry.name[i]:=0X;
			NEW(node);
			string.dup(node.key,directoryEntry.name);
			avlString.add(directoryEntry(DirectoryEntryPtr).root,node);
		END;
	END;
END filterName;

PROCEDURE displayMyFiles*;(*

	Display all modules which have the form modulename.Mod, and where
	modulename starts with a lowercase letter.

*)
VAR
	directoryEntry:DirectoryEntryPtr;
BEGIN
	NEW(directoryEntry);
	directoryEntry.root:=NIL;
	directory.forAll(filterName,directoryEntry);
	avlString.dump(directoryEntry.root);
END displayMyFiles;

PROCEDURE filterSourceless(VAR directoryEntry:directory.DirectoryEntryPtr);
VAR
	f:Files.File;
	i:LONGINT;
	len:LONGINT;
	node:avlString.NodePtr;
	extension:ARRAY 5 OF CHAR;
BEGIN
	len:=string.length(directoryEntry.name);
	IF len>4 THEN
		string.copyPart(extension,directoryEntry.name,len-4,4);
		IF (extension=".Obj") OR (extension=".Sym")THEN
			directoryEntry.name[len-3]:="M";
			directoryEntry.name[len-2]:="o";
			directoryEntry.name[len-1]:="d";
			f:=Files.Old(directoryEntry.name);
			directoryEntry.name[len-3]:=extension[1];
			directoryEntry.name[len-2]:=extension[2];
			directoryEntry.name[len-1]:=extension[3];
			IF f=NIL THEN
				NEW(node);
				string.dup(node.key,directoryEntry.name);
				avlString.add(directoryEntry(DirectoryEntryPtr).root,node);
			END;
		END;
	END;
END filterSourceless;

PROCEDURE displayModulesWithoutSource*;(*

	Display all modules which for which a symbol or object file
	exists, but no corresponding source (i.e. .Mod) file..

*)
VAR
	directoryEntry:DirectoryEntryPtr;
BEGIN
	NEW(directoryEntry);
	directoryEntry.root:=NIL;
	directory.forAll(filterSourceless,directoryEntry);
	avlString.dump(directoryEntry.root);
END displayModulesWithoutSource;

PROCEDURE removeEntry(parameter:arguments.ParameterPtr);
BEGIN
	avlString.delete(parameter(ParameterPtr).root,parameter.name);
END removeEntry;

PROCEDURE displayMyFilesExcept*;(*

	Display all modules which have the form modulename.Mod, and where
	modulename starts with a lowercase letter, except those supplied as
	parameter.

*)
VAR
	directoryEntry:DirectoryEntryPtr;
	parameter:ParameterPtr;
BEGIN
	NEW(directoryEntry);
	directoryEntry.root:=NIL;
	directory.forAll(filterName,directoryEntry);
	NEW(parameter);
	parameter.root:=directoryEntry.root;
	arguments.forEachName(removeEntry,parameter);
	avlString.dump(directoryEntry.root);
END displayMyFilesExcept;

PROCEDURE openReadMe*; (*

	Given a module name, opens module.readme.Text.

*)
VAR
	arg:arguments.T;
	dummyRes:INTEGER;
	fileName:dataTypes.FileName;
	valid:BOOLEAN;
BEGIN
	arguments.oneName(arg,valid);
	IF valid THEN
		COPY(arg.scanner.s,fileName);
		string.append(fileName,".readme.Text");
		Cmd.Call("XE.Open",fileName,dummyRes);
	END;
END openReadMe;

PROCEDURE openSource*; (*

	Given a module name, opens module.Mod.

*)
VAR
	arg:arguments.T;
	dummyRes:INTEGER;
	fileName:dataTypes.FileName;
	valid:BOOLEAN;
BEGIN
	arguments.oneName(arg,valid);
	IF valid THEN
		COPY(arg.scanner.s,fileName);
		string.append(fileName,".Mod");
		Cmd.Call("XE.Open",fileName,dummyRes);
	END;
END openSource;

PROCEDURE openTool*; (*

	Given a module name, opens module.Tool.

*)
VAR
	arg:arguments.T;
	dummyRes:INTEGER;
	fileName:dataTypes.FileName;
	valid:BOOLEAN;
BEGIN
	arguments.oneName(arg,valid);
	IF valid THEN
		COPY(arg.scanner.s,fileName);
		string.append(fileName,".Tool");
		Cmd.Call("XE.SysOpen",fileName,dummyRes);
	END;
END openTool;

PROCEDURE expunge*;
END expunge;

END distribute.