u  Syntax10.Scn.Fnt        InfoElems Alloc  #   Syntax10.Scn.Fnt  Y   Y  "Title": Procedures for tranforming between coordinate systems used to identify locations on earth.
"Copyright": 1996, 1997 by Claudio Nieder <claudio@dial.eunet.ch>.

	This module is free software; you can redistribute it and/or modify it under the terms of the GNU
	Library General Public License as published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This module is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License along with this library;
	if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 (    8  FoldElems New     Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt      ,                            	    F                        P                    .  
	Degree*=RECORD (* min, sec in [0..59] range! *)
		deg*,min*,sec*:INTEGER;
	END;
	LocationD*=RECORD (* positive deg = Nord/East,  negative deg = South/West *)
		lat*,long*:Degree;
	END;
	Location*=RECORD (* positive deg = Nord/East,  negative deg = South/West, radians! *)
		lat*,long*:LONGREAL;
	END; 8      Syntax10b.Scn.Fnt      $    8   #   Syntax10.Scn.Fnt  Z    Z   
	
	Converts coordinates as used on some swiss maps to longitude and latitude (radian).
	
 8       @8   #   Syntax10.Scn.Fnt       
CONST
	refLat=46.0+57.0/60.0+8.66/3600.0;
	refLong=7.0+26.0/60.0+22.5/3600.0;
VAR
	latDiff,longDiff:LONGREAL;
	x,y:LONGREAL;	
BEGIN
	y:=Y-600000.0;
	x:=X-200000.0;
	latDiff:=3.23864878D-2*x-2.713538D-9*y*y-4.5044D-16*y*y*x;
	longDiff:=4.7297306D-2*y+7.925715D-9*y*x-4.4271D-16*y*y*y;
	loc.lat:=(latDiff/3600.0+refLat)*MathL.pi/180.0;
	loc.long:=(longDiff/3600.0+refLong)*MathL.pi/180.0;
END swissCoordToLocation;
 8               8   #   Syntax10.Scn.Fnt  +   +  
BEGIN
	w:=w*180.0/MathL.pi;
	deg.deg:=SHORT(ENTIER(w)); w:=(w-deg.deg)*60.0;
	deg.min:=SHORT(ENTIER(w)); w:=(w-deg.min)*60.0;
	deg.sec:=SHORT(ENTIER(w+0.5));
	IF deg.sec>59 THEN deg.sec:=deg.sec-60; INC(deg.min); END;
	IF deg.min>59 THEN deg.min:=deg.min-60; INC(deg.deg); END;
END radianToDegree;
 8           $    y8   #   Syntax10.Scn.Fnt  e    e   
BEGIN
	radianToDegree(loc.lat,locD.lat);
	radianToDegree(loc.long,locD.long);
END locationToDegree;
 8           %    S8   #   Syntax10.Scn.Fnt         

	Given your current location and a target location on the earth, compute
	the direction (azimuth) into which the remote location lies.
	
 8       88   #   Syntax10.Scn.Fnt       
VAR
	az,gamma,delta:LONGREAL;
BEGIN
	gamma:=locFrom.long-locTo.long;
	delta:=mathFunctions.arccos(
	 MathL.sin(locFrom.lat)*MathL.sin(locTo.lat)+MathL.cos(locFrom.lat)*MathL.cos(locTo.lat)*MathL.cos(gamma)
	);
	az:=mathFunctions.arccos(
	 (MathL.sin(locTo.lat)-MathL.sin(locFrom.lat)*MathL.cos(delta)) 
	 /(MathL.cos(locFrom.lat)*MathL.sin(delta))
	);
	IF gamma>=0 THEN az:=2.0*MathL.pi-az; END;
	RETURN az;
END azimuth;
 8           %    m8   #   Syntax10.Scn.Fnt  q    q   

	Given your current location and a target location on the earth, compute
	the distance between the location
	.
 8       8   C   Syntax10.Scn.Fnt     Syntax10b.Scn.Fnt            
VAR
	gamma,delta:LONGREAL;
	a,b,c,d,e:LONGREAL;
BEGIN
	gamma:=locTo.long-locFrom.long;
	a:=MathL.cos(gamma);
	b:=MathL.cos(locFrom.lat);
	c:=MathL.cos(locTo.lat);
	d:=MathL.sin(locFrom.lat);
	e:=MathL.sin(locTo.lat);
(*
	This produces a crash!!
	
	delta:=MathL.cos(gamma)*MathL.cos(locFrom.lat)*MathL.cos(locTo.lat)+MathL.sin(locFrom.lat)*MathL.sin(locTo.lat); 
*)
	delta:=a*b*c+d*e;
	delta:=mathFunctions.arccos(delta);
	RETURN mathFunctions.radToDeg(delta)*111.2;
END distanz;
 8           2    u8   #   Syntax10.Scn.Fnt  i    i   

	Given your position on earth as longitued and latitude compute
	the locator used by radio amateurs.
	
 8       8   #   Syntax10.Scn.Fnt       
VAR
	base:CHAR;
BEGIN
	pos.long.deg:=(pos.long.deg+180) MOD 360;
	locatorText[0]:=CHR(ORD('A')+pos.long.deg DIV 20);
	pos.lat.deg:=(pos.lat.deg+90) MOD 180;
	locatorText[1]:=CHR(ORD('A')+pos.lat.deg DIV 10);
	locatorText[2]:=CHR(ORD('0')+pos.long.deg DIV 2 MOD 10);
	locatorText[3]:=CHR(ORD('0')+pos.lat.deg DIV 1 MOD 10);
	IF ODD(pos.long.deg) THEN base:='M'; ELSE base:='A'; END;
	locatorText[4]:=CHR(ORD(base)+pos.long.min DIV 5);
	locatorText[5]:=CHR(ORD('A')+(pos.lat.min*2+pos.lat.sec DIV 30) DIV 5);
	locatorText[6]:=0X;
END locator;
 8           !    8   #   Syntax10.Scn.Fnt  8    8   
BEGIN
	deg.deg:=d; deg.min:=m; deg.sec:=s;
END setDeg;
 8         MODULE earthCoord; 

IMPORT
	Log,mathFunctions,MathL;

TYPE

PROCEDURE swissCoordToLocation*(X,Y:LONGREAL; VAR loc:Location);(**)
PROCEDURE radianToDegree*(w:LONGREAL; VAR deg:Degree);
PROCEDURE locationToDegree*(loc:Location; VAR locD:LocationD);
PROCEDURE azimuth*(locFrom,locTo:Location):LONGREAL;(**)
PROCEDURE distanz*(locFrom,locTo:Location):LONGREAL;(**)
PROCEDURE locator*(pos:LocationD; VAR locatorText:ARRAY OF CHAR);(**)
PROCEDURE setDeg*(VAR deg:Degree; d,m,s:INTEGER);

END earthCoord.